/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.LambdaFormBuffer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.util.Wrapper;

class LambdaFormEditor {
    final LambdaForm lambdaForm;
    private static final int MIN_CACHE_ARRAY_SIZE = 4;
    private static final int MAX_CACHE_ARRAY_SIZE = 16;

    private LambdaFormEditor(LambdaForm lambdaForm) {
        this.lambdaForm = lambdaForm;
    }

    static LambdaFormEditor lambdaFormEditor(LambdaForm lambdaForm) {
        return new LambdaFormEditor(lambdaForm.uncustomize());
    }

    private LambdaForm getInCache(Transform key) {
        Transform k;
        block5: {
            Transform t;
            Object c;
            block6: {
                block4: {
                    assert (key.get() == null);
                    c = this.lambdaForm.transformCache;
                    k = null;
                    if (!(c instanceof ConcurrentHashMap)) break block4;
                    ConcurrentHashMap m = (ConcurrentHashMap)c;
                    k = (Transform)m.get(key);
                    break block5;
                }
                if (c == null) {
                    return null;
                }
                if (!(c instanceof Transform)) break block6;
                Transform t2 = (Transform)c;
                if (!t2.equals(key)) break block5;
                k = t2;
                break block5;
            }
            Transform[] ta = (Transform[])c;
            for (int i = 0; i < ta.length && (t = ta[i]) != null; ++i) {
                if (!t.equals(key)) continue;
                k = t;
                break;
            }
        }
        assert (k == null || key.equals(k));
        return k != null ? (LambdaForm)k.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LambdaForm putInCache(Transform key, LambdaForm form) {
        key = key.withResult(form);
        int pass = 0;
        while (true) {
            block23: {
                Object c;
                if ((c = this.lambdaForm.transformCache) instanceof ConcurrentHashMap) {
                    ConcurrentHashMap m = (ConcurrentHashMap)c;
                    Transform k = m.putIfAbsent(key, key);
                    if (k == null) {
                        return form;
                    }
                    LambdaForm result = (LambdaForm)k.get();
                    if (result != null) {
                        return result;
                    }
                    if (m.replace(key, k, key)) {
                        return form;
                    }
                } else {
                    assert (pass == 0);
                    LambdaForm lambdaForm = this.lambdaForm;
                    synchronized (lambdaForm) {
                        Transform k;
                        int i;
                        Transform[] ta;
                        c = this.lambdaForm.transformCache;
                        if (c instanceof ConcurrentHashMap) {
                            break block23;
                        }
                        if (c == null) {
                            this.lambdaForm.transformCache = key;
                            return form;
                        }
                        if (c instanceof Transform) {
                            Transform k2 = (Transform)c;
                            if (k2.equals(key)) {
                                LambdaForm result = (LambdaForm)k2.get();
                                if (result == null) {
                                    this.lambdaForm.transformCache = key;
                                    return form;
                                }
                                return result;
                            }
                            if (k2.get() == null) {
                                this.lambdaForm.transformCache = key;
                                return form;
                            }
                            ta = new Transform[4];
                            ta[0] = k2;
                            this.lambdaForm.transformCache = ta;
                        } else {
                            ta = (Transform[])c;
                        }
                        int len = ta.length;
                        int stale = -1;
                        for (i = 0; i < len && (k = ta[i]) != null; ++i) {
                            if (k.equals(key)) {
                                LambdaForm result = (LambdaForm)k.get();
                                if (result == null) {
                                    ta[i] = key;
                                    return form;
                                }
                                return result;
                            }
                            if (stale >= 0 || k.get() != null) continue;
                            stale = i;
                        }
                        if (i >= len && stale < 0) {
                            if (len >= 16) {
                                ConcurrentHashMap<Transform, Transform> m = new ConcurrentHashMap<Transform, Transform>(32);
                                for (Transform k3 : ta) {
                                    m.put(k3, k3);
                                }
                                this.lambdaForm.transformCache = m;
                                break block23;
                            }
                            len = Math.min(len * 2, 16);
                            this.lambdaForm.transformCache = ta = Arrays.copyOf(ta, len);
                        }
                        int idx = stale >= 0 ? stale : i;
                        ta[idx] = key;
                        return form;
                    }
                }
            }
            ++pass;
        }
    }

    private LambdaFormBuffer buffer() {
        return new LambdaFormBuffer(this.lambdaForm);
    }

    private BoundMethodHandle.SpeciesData oldSpeciesData() {
        return BoundMethodHandle.speciesData(this.lambdaForm);
    }

    private BoundMethodHandle.SpeciesData newSpeciesData(LambdaForm.BasicType type) {
        return this.oldSpeciesData().extendWith(type);
    }

    BoundMethodHandle bindArgumentL(BoundMethodHandle mh, int pos, Object value) {
        assert (mh.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType bt = LambdaForm.BasicType.L_TYPE;
        MethodType type2 = this.bindArgumentType(mh, pos, bt);
        LambdaForm form2 = this.bindArgumentForm(1 + pos);
        return mh.copyWithExtendL(type2, form2, value);
    }

    BoundMethodHandle bindArgumentI(BoundMethodHandle mh, int pos, int value) {
        assert (mh.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType bt = LambdaForm.BasicType.I_TYPE;
        MethodType type2 = this.bindArgumentType(mh, pos, bt);
        LambdaForm form2 = this.bindArgumentForm(1 + pos);
        return mh.copyWithExtendI(type2, form2, value);
    }

    BoundMethodHandle bindArgumentJ(BoundMethodHandle mh, int pos, long value) {
        assert (mh.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType bt = LambdaForm.BasicType.J_TYPE;
        MethodType type2 = this.bindArgumentType(mh, pos, bt);
        LambdaForm form2 = this.bindArgumentForm(1 + pos);
        return mh.copyWithExtendJ(type2, form2, value);
    }

    BoundMethodHandle bindArgumentF(BoundMethodHandle mh, int pos, float value) {
        assert (mh.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType bt = LambdaForm.BasicType.F_TYPE;
        MethodType type2 = this.bindArgumentType(mh, pos, bt);
        LambdaForm form2 = this.bindArgumentForm(1 + pos);
        return mh.copyWithExtendF(type2, form2, value);
    }

    BoundMethodHandle bindArgumentD(BoundMethodHandle mh, int pos, double value) {
        assert (mh.speciesData() == this.oldSpeciesData());
        LambdaForm.BasicType bt = LambdaForm.BasicType.D_TYPE;
        MethodType type2 = this.bindArgumentType(mh, pos, bt);
        LambdaForm form2 = this.bindArgumentForm(1 + pos);
        return mh.copyWithExtendD(type2, form2, value);
    }

    private MethodType bindArgumentType(BoundMethodHandle mh, int pos, LambdaForm.BasicType bt) {
        assert (mh.form.uncustomize() == this.lambdaForm);
        assert (mh.form.names[1 + pos].type == bt);
        assert (LambdaForm.BasicType.basicType(mh.type().parameterType(pos)) == bt);
        return mh.type().dropParameterTypes(pos, pos + 1);
    }

    LambdaForm bindArgumentForm(int pos) {
        Transform key = Transform.of((byte)1, pos);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.parameterConstraint(0) == this.newSpeciesData(this.lambdaForm.parameterType(pos)));
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        BoundMethodHandle.SpeciesData oldData = this.oldSpeciesData();
        BoundMethodHandle.SpeciesData newData = this.newSpeciesData(this.lambdaForm.parameterType(pos));
        LambdaForm.Name oldBaseAddress = this.lambdaForm.parameter(0);
        LambdaForm.NamedFunction getter = newData.getterFunction(oldData.fieldCount());
        if (pos != 0) {
            buf.replaceFunctions(oldData.getterFunctions(), newData.getterFunctions(), oldBaseAddress);
            LambdaForm.Name newBaseAddress = oldBaseAddress.withConstraint(newData);
            buf.renameParameter(0, newBaseAddress);
            buf.replaceParameterByNewExpression(pos, new LambdaForm.Name(getter, newBaseAddress));
        } else {
            assert (oldData == BoundMethodHandle.SpeciesData.EMPTY);
            LambdaForm.Name newBaseAddress = new LambdaForm.Name(LambdaForm.BasicType.L_TYPE).withConstraint(newData);
            buf.replaceParameterByNewExpression(0, new LambdaForm.Name(getter, newBaseAddress));
            buf.insertParameter(0, newBaseAddress);
        }
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm addArgumentForm(int pos, LambdaForm.BasicType type) {
        Transform key = Transform.of((byte)2, pos, type.ordinal());
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity + 1);
            assert (form.parameterType(pos) == type);
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        buf.insertParameter(pos, new LambdaForm.Name(type));
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm dupArgumentForm(int srcPos, int dstPos) {
        Transform key = Transform.of((byte)3, srcPos, dstPos);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity - 1);
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        assert (this.lambdaForm.parameter((int)srcPos).constraint == null);
        assert (this.lambdaForm.parameter((int)dstPos).constraint == null);
        buf.replaceParameterByCopy(dstPos, srcPos);
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm spreadArgumentsForm(int pos, Class<?> arrayType, int arrayLength) {
        Transform key;
        LambdaForm form;
        Class<?> elementType = arrayType.getComponentType();
        Class<Object> erasedArrayType = arrayType;
        if (!elementType.isPrimitive()) {
            erasedArrayType = Object[].class;
        }
        LambdaForm.BasicType bt = LambdaForm.BasicType.basicType(elementType);
        int elementTypeKey = bt.ordinal();
        if (bt.basicTypeClass() != elementType && elementType.isPrimitive()) {
            elementTypeKey = LambdaForm.BasicType.TYPE_LIMIT + Wrapper.forPrimitiveType(elementType).ordinal();
        }
        if ((form = this.getInCache(key = Transform.of((byte)4, pos, elementTypeKey, arrayLength))) != null) {
            assert (form.arity == this.lambdaForm.arity - arrayLength + 1);
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        assert (pos <= 255);
        assert (pos + arrayLength <= this.lambdaForm.arity);
        assert (pos > 0);
        LambdaForm.Name spreadParam = new LambdaForm.Name(LambdaForm.BasicType.L_TYPE);
        LambdaForm.Name checkSpread = new LambdaForm.Name(MethodHandleImpl.NF_checkSpreadArgument, spreadParam, arrayLength);
        int exprPos = this.lambdaForm.arity();
        buf.insertExpression(exprPos++, checkSpread);
        MethodHandle aload = MethodHandles.arrayElementGetter(erasedArrayType);
        for (int i = 0; i < arrayLength; ++i) {
            LambdaForm.Name loadArgument = new LambdaForm.Name(aload, spreadParam, i);
            buf.insertExpression(exprPos + i, loadArgument);
            buf.replaceParameterByCopy(pos + i, exprPos + i);
        }
        buf.insertParameter(pos, spreadParam);
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm collectArgumentsForm(int pos, MethodType collectorType) {
        Transform key;
        LambdaForm form;
        byte kind;
        boolean dropResult;
        int collectorArity = collectorType.parameterCount();
        boolean bl = dropResult = collectorType.returnType() == Void.TYPE;
        if (collectorArity == 1 && !dropResult) {
            return this.filterArgumentForm(pos, LambdaForm.BasicType.basicType(collectorType.parameterType(0)));
        }
        byte[] newTypes = LambdaForm.BasicType.basicTypesOrd(collectorType.parameterArray());
        byte by = kind = dropResult ? (byte)9 : 8;
        if (dropResult && collectorArity == 0) {
            pos = 1;
        }
        if ((form = this.getInCache(key = Transform.of(kind, pos, collectorArity, newTypes))) != null) {
            assert (form.arity == this.lambdaForm.arity - (dropResult ? 0 : 1) + collectorArity);
            return form;
        }
        form = this.makeArgumentCombinationForm(pos, collectorType, false, dropResult);
        return this.putInCache(key, form);
    }

    LambdaForm collectArgumentArrayForm(int pos, MethodHandle arrayCollector) {
        MethodType collectorType = arrayCollector.type();
        int collectorArity = collectorType.parameterCount();
        assert (arrayCollector.intrinsicName() == MethodHandleImpl.Intrinsic.NEW_ARRAY);
        Class<?> arrayType = collectorType.returnType();
        Class<?> elementType = arrayType.getComponentType();
        LambdaForm.BasicType argType = LambdaForm.BasicType.basicType(elementType);
        int argTypeKey = argType.ordinal();
        if (argType.basicTypeClass() != elementType) {
            if (!elementType.isPrimitive()) {
                return null;
            }
            argTypeKey = LambdaForm.BasicType.TYPE_LIMIT + Wrapper.forPrimitiveType(elementType).ordinal();
        }
        assert (collectorType.parameterList().equals(Collections.nCopies(collectorArity, elementType)));
        byte kind = 10;
        Transform key = Transform.of(kind, pos, collectorArity, argTypeKey);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity - 1 + collectorArity);
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        assert (pos + 1 <= this.lambdaForm.arity);
        assert (pos > 0);
        LambdaForm.Name[] newParams = new LambdaForm.Name[collectorArity];
        for (int i = 0; i < collectorArity; ++i) {
            newParams[i] = new LambdaForm.Name(pos + i, argType);
        }
        LambdaForm.Name callCombiner = new LambdaForm.Name(arrayCollector, (Object[])newParams);
        int exprPos = this.lambdaForm.arity();
        buf.insertExpression(exprPos, callCombiner);
        int argPos = pos + 1;
        for (LambdaForm.Name newParam : newParams) {
            buf.insertParameter(argPos++, newParam);
        }
        assert (buf.lastIndexOf(callCombiner) == exprPos + newParams.length);
        buf.replaceParameterByCopy(pos, exprPos + newParams.length);
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm filterArgumentForm(int pos, LambdaForm.BasicType newType) {
        Transform key = Transform.of((byte)5, pos, newType.ordinal());
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity);
            assert (form.parameterType(pos) == newType);
            return form;
        }
        LambdaForm.BasicType oldType = this.lambdaForm.parameterType(pos);
        MethodType filterType = MethodType.methodType(oldType.basicTypeClass(), newType.basicTypeClass());
        form = this.makeArgumentCombinationForm(pos, filterType, false, false);
        return this.putInCache(key, form);
    }

    private LambdaForm makeArgumentCombinationForm(int pos, MethodType combinerType, boolean keepArguments, boolean dropResult) {
        LambdaForm.Name[] newParams;
        int resultArity;
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        int combinerArity = combinerType.parameterCount();
        int n = resultArity = dropResult ? 0 : 1;
        assert (pos <= 255);
        assert (pos + resultArity + (keepArguments ? combinerArity : 0) <= this.lambdaForm.arity);
        assert (pos > 0);
        assert (combinerType == combinerType.basicType());
        assert (combinerType.returnType() != Void.TYPE || dropResult);
        BoundMethodHandle.SpeciesData oldData = this.oldSpeciesData();
        BoundMethodHandle.SpeciesData newData = this.newSpeciesData(LambdaForm.BasicType.L_TYPE);
        LambdaForm.Name oldBaseAddress = this.lambdaForm.parameter(0);
        buf.replaceFunctions(oldData.getterFunctions(), newData.getterFunctions(), oldBaseAddress);
        LambdaForm.Name newBaseAddress = oldBaseAddress.withConstraint(newData);
        buf.renameParameter(0, newBaseAddress);
        LambdaForm.Name getCombiner = new LambdaForm.Name(newData.getterFunction(oldData.fieldCount()), newBaseAddress);
        Object[] combinerArgs = new Object[1 + combinerArity];
        combinerArgs[0] = getCombiner;
        if (keepArguments) {
            newParams = new LambdaForm.Name[]{};
            System.arraycopy(this.lambdaForm.names, pos + resultArity, combinerArgs, 1, combinerArity);
        } else {
            newParams = new LambdaForm.Name[combinerArity];
            for (int i = 0; i < newParams.length; ++i) {
                newParams[i] = new LambdaForm.Name(pos + i, LambdaForm.BasicType.basicType(combinerType.parameterType(i)));
            }
            System.arraycopy(newParams, 0, combinerArgs, 1, combinerArity);
        }
        LambdaForm.Name callCombiner = new LambdaForm.Name(combinerType, combinerArgs);
        int exprPos = this.lambdaForm.arity();
        buf.insertExpression(exprPos + 0, getCombiner);
        buf.insertExpression(exprPos + 1, callCombiner);
        int argPos = pos + resultArity;
        for (LambdaForm.Name newParam : newParams) {
            buf.insertParameter(argPos++, newParam);
        }
        assert (buf.lastIndexOf(callCombiner) == exprPos + 1 + newParams.length);
        if (!dropResult) {
            buf.replaceParameterByCopy(pos, exprPos + 1 + newParams.length);
        }
        return buf.endEdit();
    }

    private LambdaForm makeArgumentCombinationForm(int pos, MethodType combinerType, int[] argPositions, boolean keepArguments, boolean dropResult) {
        int i;
        LambdaForm.Name[] newParams;
        int resultArity;
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        int combinerArity = combinerType.parameterCount();
        assert (combinerArity == argPositions.length);
        int n = resultArity = dropResult ? 0 : 1;
        assert (pos <= this.lambdaForm.arity);
        assert (pos > 0);
        assert (combinerType == combinerType.basicType());
        assert (combinerType.returnType() != Void.TYPE || dropResult);
        BoundMethodHandle.SpeciesData oldData = this.oldSpeciesData();
        BoundMethodHandle.SpeciesData newData = this.newSpeciesData(LambdaForm.BasicType.L_TYPE);
        LambdaForm.Name oldBaseAddress = this.lambdaForm.parameter(0);
        buf.replaceFunctions(oldData.getterFunctions(), newData.getterFunctions(), oldBaseAddress);
        LambdaForm.Name newBaseAddress = oldBaseAddress.withConstraint(newData);
        buf.renameParameter(0, newBaseAddress);
        LambdaForm.Name getCombiner = new LambdaForm.Name(newData.getterFunction(oldData.fieldCount()), newBaseAddress);
        Object[] combinerArgs = new Object[1 + combinerArity];
        combinerArgs[0] = getCombiner;
        if (keepArguments) {
            newParams = new LambdaForm.Name[]{};
            for (i = 0; i < combinerArity; ++i) {
                combinerArgs[i + 1] = this.lambdaForm.parameter(1 + argPositions[i]);
                assert (LambdaForm.BasicType.basicType(combinerType.parameterType(i)) == this.lambdaForm.parameterType(1 + argPositions[i]));
            }
        } else {
            newParams = new LambdaForm.Name[combinerArity];
            for (i = 0; i < newParams.length; ++i) {
                newParams[i] = this.lambdaForm.parameter(1 + argPositions[i]);
                assert (LambdaForm.BasicType.basicType(combinerType.parameterType(i)) == this.lambdaForm.parameterType(1 + argPositions[i]));
            }
            System.arraycopy(newParams, 0, combinerArgs, 1, combinerArity);
        }
        LambdaForm.Name callCombiner = new LambdaForm.Name(combinerType, combinerArgs);
        int exprPos = this.lambdaForm.arity();
        buf.insertExpression(exprPos + 0, getCombiner);
        buf.insertExpression(exprPos + 1, callCombiner);
        int argPos = pos + resultArity;
        for (LambdaForm.Name newParam : newParams) {
            buf.insertParameter(argPos++, newParam);
        }
        assert (buf.lastIndexOf(callCombiner) == exprPos + 1 + newParams.length);
        if (!dropResult) {
            buf.replaceParameterByCopy(pos, exprPos + 1 + newParams.length);
        }
        return buf.endEdit();
    }

    LambdaForm filterReturnForm(LambdaForm.BasicType newType, boolean constantZero) {
        LambdaForm.Name callFilter;
        byte kind = constantZero ? (byte)7 : 6;
        Transform key = Transform.of(kind, newType.ordinal());
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity);
            assert (form.returnType() == newType);
            return form;
        }
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        int insPos = this.lambdaForm.names.length;
        if (constantZero) {
            callFilter = newType == LambdaForm.BasicType.V_TYPE ? null : new LambdaForm.Name(LambdaForm.constantZero(newType), new Object[0]);
        } else {
            BoundMethodHandle.SpeciesData oldData = this.oldSpeciesData();
            BoundMethodHandle.SpeciesData newData = this.newSpeciesData(LambdaForm.BasicType.L_TYPE);
            LambdaForm.Name oldBaseAddress = this.lambdaForm.parameter(0);
            buf.replaceFunctions(oldData.getterFunctions(), newData.getterFunctions(), oldBaseAddress);
            LambdaForm.Name newBaseAddress = oldBaseAddress.withConstraint(newData);
            buf.renameParameter(0, newBaseAddress);
            LambdaForm.Name getFilter = new LambdaForm.Name(newData.getterFunction(oldData.fieldCount()), newBaseAddress);
            buf.insertExpression(insPos++, getFilter);
            LambdaForm.BasicType oldType = this.lambdaForm.returnType();
            if (oldType == LambdaForm.BasicType.V_TYPE) {
                MethodType filterType = MethodType.methodType(newType.basicTypeClass());
                callFilter = new LambdaForm.Name(filterType, getFilter);
            } else {
                MethodType filterType = MethodType.methodType(newType.basicTypeClass(), oldType.basicTypeClass());
                callFilter = new LambdaForm.Name(filterType, getFilter, this.lambdaForm.names[this.lambdaForm.result]);
            }
        }
        if (callFilter != null) {
            buf.insertExpression(insPos++, callFilter);
        }
        buf.setResult(callFilter);
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    LambdaForm foldArgumentsForm(int foldPos, boolean dropResult, MethodType combinerType) {
        int combinerArity;
        byte kind = dropResult ? (byte)12 : 11;
        Transform key = Transform.of(kind, foldPos, combinerArity = combinerType.parameterCount());
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity - (kind == 11 ? 1 : 0));
            return form;
        }
        form = this.makeArgumentCombinationForm(foldPos, combinerType, true, dropResult);
        return this.putInCache(key, form);
    }

    LambdaForm foldArgumentsForm(int foldPos, boolean dropResult, MethodType combinerType, int ... argPositions) {
        byte kind = dropResult ? (byte)16 : 15;
        int[] keyArgs = Arrays.copyOf(argPositions, argPositions.length + 1);
        keyArgs[argPositions.length] = foldPos;
        Transform key = Transform.of(kind, keyArgs);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == this.lambdaForm.arity - (kind == 15 ? 1 : 0));
            return form;
        }
        form = this.makeArgumentCombinationForm(foldPos, combinerType, argPositions, true, dropResult);
        return this.putInCache(key, form);
    }

    LambdaForm permuteArgumentsForm(int skip, int[] reorder) {
        int k;
        LambdaForm.Name n2;
        int j;
        int pos;
        assert (skip == 1);
        int length = this.lambdaForm.names.length;
        int outArgs = reorder.length;
        int inTypes = 0;
        boolean nullPerm = true;
        for (int i = 0; i < reorder.length; ++i) {
            int inArg = reorder[i];
            if (inArg != i) {
                nullPerm = false;
            }
            inTypes = Math.max(inTypes, inArg + 1);
        }
        assert (skip + reorder.length == this.lambdaForm.arity);
        if (nullPerm) {
            return this.lambdaForm;
        }
        Transform key = Transform.of((byte)13, reorder);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            assert (form.arity == skip + inTypes) : form;
            return form;
        }
        LambdaForm.BasicType[] types = new LambdaForm.BasicType[inTypes];
        for (int i = 0; i < outArgs; ++i) {
            int inArg = reorder[i];
            types[inArg] = this.lambdaForm.names[skip + i].type;
        }
        assert (skip + outArgs == this.lambdaForm.arity);
        assert (LambdaFormEditor.permutedTypesMatch(reorder, types, this.lambdaForm.names, skip));
        for (pos = 0; pos < outArgs && reorder[pos] == pos; ++pos) {
        }
        LambdaForm.Name[] names2 = new LambdaForm.Name[length - outArgs + inTypes];
        System.arraycopy(this.lambdaForm.names, 0, names2, 0, skip + pos);
        int bodyLength = length - this.lambdaForm.arity;
        System.arraycopy(this.lambdaForm.names, skip + outArgs, names2, skip + inTypes, bodyLength);
        int arity2 = names2.length - bodyLength;
        int result2 = this.lambdaForm.result;
        if (result2 >= 0) {
            result2 = result2 < skip + outArgs ? reorder[result2 - skip] : result2 - outArgs + inTypes;
        }
        for (j = pos; j < outArgs; ++j) {
            LambdaForm.Name n = this.lambdaForm.names[skip + j];
            int i = reorder[j];
            n2 = names2[skip + i];
            if (n2 == null) {
                names2[skip + i] = n2 = new LambdaForm.Name(types[i]);
            } else assert (n2.type == types[i]);
            for (k = arity2; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        for (int i = skip + pos; i < arity2; ++i) {
            if (names2[i] != null) continue;
            names2[i] = LambdaForm.argument(i, types[i - skip]);
        }
        for (j = this.lambdaForm.arity; j < this.lambdaForm.names.length; ++j) {
            LambdaForm.Name n = this.lambdaForm.names[j];
            int i = j - this.lambdaForm.arity + arity2;
            n2 = names2[i];
            if (n == n2) continue;
            for (k = i + 1; k < names2.length; ++k) {
                names2[k] = names2[k].replaceName(n, n2);
            }
        }
        form = new LambdaForm(this.lambdaForm.debugName, arity2, names2, result2);
        return this.putInCache(key, form);
    }

    LambdaForm noteLoopLocalTypesForm(int pos, LambdaForm.BasicType[] localTypes) {
        assert (this.lambdaForm.isLoop(pos));
        int[] desc = LambdaForm.BasicType.basicTypeOrds(localTypes);
        desc = Arrays.copyOf(desc, desc.length + 1);
        desc[desc.length - 1] = pos;
        Transform key = Transform.of((byte)14, desc);
        LambdaForm form = this.getInCache(key);
        if (form != null) {
            return form;
        }
        LambdaForm.Name invokeLoop = this.lambdaForm.names[pos + 1];
        assert (invokeLoop.function == MethodHandleImpl.NF_loop);
        Object[] args = Arrays.copyOf(invokeLoop.arguments, invokeLoop.arguments.length);
        assert (args[0] == null);
        args[0] = localTypes;
        LambdaFormBuffer buf = this.buffer();
        buf.startEdit();
        buf.changeName(pos + 1, new LambdaForm.Name(MethodHandleImpl.NF_loop, args));
        form = buf.endEdit();
        return this.putInCache(key, form);
    }

    static boolean permutedTypesMatch(int[] reorder, LambdaForm.BasicType[] types, LambdaForm.Name[] names, int skip) {
        for (int i = 0; i < reorder.length; ++i) {
            assert (names[skip + i].isParam());
            assert (names[skip + i].type == types[reorder[i]]);
        }
        return true;
    }

    private static final class Transform
    extends SoftReference<LambdaForm> {
        final long packedBytes;
        final byte[] fullBytes;
        private static final byte BIND_ARG = 1;
        private static final byte ADD_ARG = 2;
        private static final byte DUP_ARG = 3;
        private static final byte SPREAD_ARGS = 4;
        private static final byte FILTER_ARG = 5;
        private static final byte FILTER_RETURN = 6;
        private static final byte FILTER_RETURN_TO_ZERO = 7;
        private static final byte COLLECT_ARGS = 8;
        private static final byte COLLECT_ARGS_TO_VOID = 9;
        private static final byte COLLECT_ARGS_TO_ARRAY = 10;
        private static final byte FOLD_ARGS = 11;
        private static final byte FOLD_ARGS_TO_VOID = 12;
        private static final byte PERMUTE_ARGS = 13;
        private static final byte LOCAL_TYPES = 14;
        private static final byte FOLD_SELECT_ARGS = 15;
        private static final byte FOLD_SELECT_ARGS_TO_VOID = 16;
        private static final boolean STRESS_TEST = false;
        private static final int PACKED_BYTE_SIZE = 4;
        private static final int PACKED_BYTE_MASK = 15;
        private static final int PACKED_BYTE_MAX_LENGTH = 16;
        private static final byte[] NO_BYTES = new byte[0];

        private static long packedBytes(byte[] bytes) {
            if (bytes.length > 16) {
                return 0L;
            }
            long pb = 0L;
            int bitset = 0;
            for (int i = 0; i < bytes.length; ++i) {
                int b = bytes[i] & 0xFF;
                bitset |= b;
                pb |= (long)b << i * 4;
            }
            if (!Transform.inRange(bitset)) {
                return 0L;
            }
            return pb;
        }

        private static long packedBytes(int b0, int b1) {
            assert (Transform.inRange(b0 | b1));
            return b0 << 0 | b1 << 4;
        }

        private static long packedBytes(int b0, int b1, int b2) {
            assert (Transform.inRange(b0 | b1 | b2));
            return b0 << 0 | b1 << 4 | b2 << 8;
        }

        private static long packedBytes(int b0, int b1, int b2, int b3) {
            assert (Transform.inRange(b0 | b1 | b2 | b3));
            return b0 << 0 | b1 << 4 | b2 << 8 | b3 << 12;
        }

        private static boolean inRange(int bitset) {
            assert ((bitset & 0xFF) == bitset);
            return (bitset & 0xFFFFFFF0) == 0;
        }

        private static byte[] fullBytes(int ... byteValues) {
            byte[] bytes = new byte[byteValues.length];
            int i = 0;
            for (int bv : byteValues) {
                bytes[i++] = Transform.bval(bv);
            }
            assert (Transform.packedBytes(bytes) == 0L);
            return bytes;
        }

        private Transform(long packedBytes, byte[] fullBytes, LambdaForm result) {
            super(result);
            this.packedBytes = packedBytes;
            this.fullBytes = fullBytes;
        }

        private Transform(long packedBytes) {
            this(packedBytes, null, null);
            assert (packedBytes != 0L);
        }

        private Transform(byte[] fullBytes) {
            this(0L, fullBytes, null);
        }

        private static byte bval(int b) {
            assert ((b & 0xFF) == b);
            return (byte)b;
        }

        static Transform of(byte k, int b1) {
            byte b0 = Transform.bval(k);
            if (Transform.inRange(b0 | b1)) {
                return new Transform(Transform.packedBytes(b0, b1));
            }
            return new Transform(Transform.fullBytes(b0, b1));
        }

        static Transform of(byte b0, int b1, int b2) {
            if (Transform.inRange(b0 | b1 | b2)) {
                return new Transform(Transform.packedBytes(b0, b1, b2));
            }
            return new Transform(Transform.fullBytes(b0, b1, b2));
        }

        static Transform of(byte b0, int b1, int b2, int b3) {
            if (Transform.inRange(b0 | b1 | b2 | b3)) {
                return new Transform(Transform.packedBytes(b0, b1, b2, b3));
            }
            return new Transform(Transform.fullBytes(b0, b1, b2, b3));
        }

        static Transform of(byte kind, int ... b123) {
            return Transform.ofBothArrays(kind, b123, NO_BYTES);
        }

        static Transform of(byte kind, int b1, byte[] b234) {
            return Transform.ofBothArrays(kind, new int[]{b1}, b234);
        }

        static Transform of(byte kind, int b1, int b2, byte[] b345) {
            return Transform.ofBothArrays(kind, new int[]{b1, b2}, b345);
        }

        private static Transform ofBothArrays(byte kind, int[] b123, byte[] b456) {
            byte[] fullBytes = new byte[1 + b123.length + b456.length];
            int i = 0;
            fullBytes[i++] = Transform.bval(kind);
            for (int bv : b123) {
                fullBytes[i++] = Transform.bval(bv);
            }
            for (int bv : b456) {
                fullBytes[i++] = bv;
            }
            long l = Transform.packedBytes(fullBytes);
            if (l != 0L) {
                return new Transform(l);
            }
            return new Transform(fullBytes);
        }

        Transform withResult(LambdaForm result) {
            return new Transform(this.packedBytes, this.fullBytes, result);
        }

        public boolean equals(Object obj) {
            return obj instanceof Transform && this.equals((Transform)obj);
        }

        public boolean equals(Transform that) {
            return this.packedBytes == that.packedBytes && Arrays.equals(this.fullBytes, that.fullBytes);
        }

        public int hashCode() {
            if (this.packedBytes != 0L) {
                assert (this.fullBytes == null);
                return Long.hashCode(this.packedBytes);
            }
            return Arrays.hashCode(this.fullBytes);
        }

        public String toString() {
            LambdaForm result;
            StringBuilder buf = new StringBuilder();
            long bits = this.packedBytes;
            if (bits != 0L) {
                buf.append("(");
                while (bits != 0L) {
                    buf.append(bits & 0xFL);
                    if ((bits >>>= 4) == 0L) continue;
                    buf.append(",");
                }
                buf.append(")");
            }
            if (this.fullBytes != null) {
                buf.append("unpacked");
                buf.append(Arrays.toString(this.fullBytes));
            }
            if ((result = (LambdaForm)this.get()) != null) {
                buf.append(" result=");
                buf.append(result);
            }
            return buf.toString();
        }
    }
}

