/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import jdk.internal.misc.Unsafe;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.reflect.misc.ReflectUtil;

class InvokerBytecodeGenerator {
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String MHI = "java/lang/invoke/MethodHandleImpl";
    private static final String LF = "java/lang/invoke/LambdaForm";
    private static final String LFN = "java/lang/invoke/LambdaForm$Name";
    private static final String CLS = "java/lang/Class";
    private static final String OBJ = "java/lang/Object";
    private static final String OBJARY = "[Ljava/lang/Object;";
    private static final String LOOP_CLAUSES = "java/lang/invoke/MethodHandleImpl$LoopClauses";
    private static final String MHARY2 = "[[Ljava/lang/invoke/MethodHandle;";
    private static final String LF_SIG = "Ljava/lang/invoke/LambdaForm;";
    private static final String LFN_SIG = "Ljava/lang/invoke/LambdaForm$Name;";
    private static final String LL_SIG = "(Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String LLV_SIG = "(Ljava/lang/Object;Ljava/lang/Object;)V";
    private static final String CLASS_PREFIX = "java/lang/invoke/LambdaForm$";
    static final String INVOKER_SUPER_NAME = "java/lang/Object";
    private final String className;
    private final String sourceFile;
    private final LambdaForm lambdaForm;
    private final String invokerName;
    private final MethodType invokerType;
    private int[] localsMap;
    private Class<?>[] localClasses;
    private ClassWriter cw;
    private MethodVisitor mv;
    private static final MemberName.Factory MEMBERNAME_FACTORY = MemberName.getFactory();
    private static final Class<?> HOST_CLASS = LambdaForm.class;
    private static final HashMap<String, Integer> DUMP_CLASS_FILES_COUNTERS;
    private static final File DUMP_CLASS_FILES_DIR;
    private final ArrayList<CpPatch> cpPatches = new ArrayList();
    private int cph = 0;
    static final String LF_HIDDEN_SIG;
    static final String LF_COMPILED_SIG;
    static final String FORCEINLINE_SIG;
    static final String DONTINLINE_SIG;
    static final String INJECTEDPROFILE_SIG;
    private static Class<?>[] STATICALLY_INVOCABLE_PACKAGES;

    private InvokerBytecodeGenerator(LambdaForm lambdaForm, int localsMapSize, String className, String invokerName, MethodType invokerType) {
        int p = invokerName.indexOf(46);
        if (p > -1) {
            className = invokerName.substring(0, p);
            invokerName = invokerName.substring(p + 1);
        }
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            className = InvokerBytecodeGenerator.makeDumpableClassName(className);
        }
        this.className = CLASS_PREFIX + className;
        this.sourceFile = "LambdaForm$" + className;
        this.lambdaForm = lambdaForm;
        this.invokerName = invokerName;
        this.invokerType = invokerType;
        this.localsMap = new int[localsMapSize + 1];
        this.localClasses = new Class[localsMapSize + 1];
    }

    private InvokerBytecodeGenerator(String className, String invokerName, MethodType invokerType) {
        this(null, invokerType.parameterCount(), className, invokerName, invokerType);
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = invokerType.parameterSlotCount() - invokerType.parameterSlotDepth(i);
        }
    }

    private InvokerBytecodeGenerator(String className, LambdaForm form, MethodType invokerType) {
        this(className, form.debugName, form, invokerType);
    }

    InvokerBytecodeGenerator(String className, String invokerName, LambdaForm form, MethodType invokerType) {
        this(form, form.names.length, className, invokerName, invokerType);
        LambdaForm.Name[] names = form.names;
        int index = 0;
        for (int i = 0; i < this.localsMap.length; ++i) {
            this.localsMap[i] = index;
            if (i >= names.length) continue;
            LambdaForm.BasicType type = names[i].type();
            index += type.basicTypeSlots();
        }
    }

    static void maybeDump(final String className, final byte[] classFile) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    try {
                        String dumpName = className;
                        File dumpFile = new File(DUMP_CLASS_FILES_DIR, dumpName + ".class");
                        System.out.println("dump: " + dumpFile);
                        dumpFile.getParentFile().mkdirs();
                        FileOutputStream file = new FileOutputStream(dumpFile);
                        file.write(classFile);
                        file.close();
                        return null;
                    }
                    catch (IOException ex) {
                        throw MethodHandleStatics.newInternalError(ex);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeDumpableClassName(String className) {
        Integer ctr;
        HashMap<String, Integer> hashMap = DUMP_CLASS_FILES_COUNTERS;
        synchronized (hashMap) {
            ctr = DUMP_CLASS_FILES_COUNTERS.get(className);
            if (ctr == null) {
                ctr = 0;
            }
            DUMP_CLASS_FILES_COUNTERS.put(className, ctr + 1);
        }
        String sfx = ctr.toString();
        while (sfx.length() < 3) {
            sfx = "0" + sfx;
        }
        className = className + sfx;
        return className;
    }

    String constantPlaceholder(Object arg) {
        String cpPlaceholder = "CONSTANT_PLACEHOLDER_" + this.cph++;
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            cpPlaceholder = cpPlaceholder + " <<" + InvokerBytecodeGenerator.debugString(arg) + ">>";
        }
        int index = this.cw.newConst(cpPlaceholder);
        this.cpPatches.add(new CpPatch(index, arg));
        return cpPlaceholder;
    }

    Object[] cpPatches(byte[] classFile) {
        int size = InvokerBytecodeGenerator.getConstantPoolSize(classFile);
        Object[] res = new Object[size];
        for (CpPatch p : this.cpPatches) {
            if (p.index >= size) {
                throw new InternalError("in cpool[" + size + "]: " + p + "\n" + Arrays.toString(Arrays.copyOf(classFile, 20)));
            }
            res[p.index] = p.value;
        }
        return res;
    }

    private static String debugString(Object arg) {
        if (arg instanceof MethodHandle) {
            MethodHandle mh = (MethodHandle)arg;
            MemberName member = mh.internalMemberName();
            if (member != null) {
                return member.toString();
            }
            return mh.debugString();
        }
        return arg.toString();
    }

    private static int getConstantPoolSize(byte[] classFile) {
        return (classFile[8] & 0xFF) << 8 | classFile[9] & 0xFF;
    }

    private MemberName loadMethod(byte[] classFile) {
        Class<?> invokerClass = InvokerBytecodeGenerator.loadAndInitializeInvokerClass(classFile, this.cpPatches(classFile));
        return InvokerBytecodeGenerator.resolveInvokerMember(invokerClass, this.invokerName, this.invokerType);
    }

    private static Class<?> loadAndInitializeInvokerClass(byte[] classBytes, Object[] patches) {
        Class invokerClass = MethodHandleStatics.UNSAFE.defineAnonymousClass(HOST_CLASS, classBytes, patches);
        MethodHandleStatics.UNSAFE.ensureClassInitialized(invokerClass);
        return invokerClass;
    }

    private static MemberName resolveInvokerMember(Class<?> invokerClass, String name, MethodType type) {
        MemberName member = new MemberName(invokerClass, name, type, 6);
        try {
            member = MEMBERNAME_FACTORY.resolveOrFail((byte)6, member, HOST_CLASS, ReflectiveOperationException.class);
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        return member;
    }

    private ClassWriter classFilePrologue() {
        boolean NOT_ACC_PUBLIC = false;
        this.cw = new ClassWriter(3);
        this.cw.visit(52, 48, this.className, null, "java/lang/Object", null);
        this.cw.visitSource(this.sourceFile, null);
        return this.cw;
    }

    private void methodPrologue() {
        String invokerDesc = this.invokerType.toMethodDescriptorString();
        this.mv = this.cw.visitMethod(8, this.invokerName, invokerDesc, null, null);
    }

    private void methodEpilogue() {
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    private void emitConst(Object con) {
        short sx;
        short sx2;
        long x;
        if (con == null) {
            this.mv.visitInsn(1);
            return;
        }
        if (con instanceof Integer) {
            this.emitIconstInsn((Integer)con);
            return;
        }
        if (con instanceof Byte) {
            this.emitIconstInsn(((Byte)con).byteValue());
            return;
        }
        if (con instanceof Short) {
            this.emitIconstInsn(((Short)con).shortValue());
            return;
        }
        if (con instanceof Character) {
            this.emitIconstInsn(((Character)con).charValue());
            return;
        }
        if (con instanceof Long && (x = ((Long)con).longValue()) == (long)(sx2 = (short)x)) {
            if (sx2 >= 0 && sx2 <= 1) {
                this.mv.visitInsn(9 + sx2);
            } else {
                this.emitIconstInsn((int)x);
                this.mv.visitInsn(133);
            }
            return;
        }
        if (con instanceof Float && (x = ((Float)con).floatValue()) == (float)(sx = (short)x)) {
            if (sx >= 0 && sx <= 2) {
                this.mv.visitInsn(11 + sx);
            } else {
                this.emitIconstInsn((int)x);
                this.mv.visitInsn(134);
            }
            return;
        }
        if (con instanceof Double && (x = ((Double)con).doubleValue()) == (double)(sx2 = (short)x)) {
            if (sx2 >= 0 && sx2 <= 1) {
                this.mv.visitInsn(14 + sx2);
            } else {
                this.emitIconstInsn((int)x);
                this.mv.visitInsn(135);
            }
            return;
        }
        if (con instanceof Boolean) {
            this.emitIconstInsn((Boolean)con != false ? 1 : 0);
            return;
        }
        this.mv.visitLdcInsn(con);
    }

    private void emitIconstInsn(int cst) {
        if (cst >= -1 && cst <= 5) {
            this.mv.visitInsn(3 + cst);
        } else if (cst >= -128 && cst <= 127) {
            this.mv.visitIntInsn(16, cst);
        } else if (cst >= Short.MIN_VALUE && cst <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, cst);
        } else {
            this.mv.visitLdcInsn(cst);
        }
    }

    private void emitLoadInsn(LambdaForm.BasicType type, int index) {
        int opcode = this.loadInsnOpcode(type);
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private int loadInsnOpcode(LambdaForm.BasicType type) throws InternalError {
        switch (type) {
            case I_TYPE: {
                return 21;
            }
            case J_TYPE: {
                return 22;
            }
            case F_TYPE: {
                return 23;
            }
            case D_TYPE: {
                return 24;
            }
            case L_TYPE: {
                return 25;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)type));
    }

    private void emitAloadInsn(int index) {
        this.emitLoadInsn(LambdaForm.BasicType.L_TYPE, index);
    }

    private void emitStoreInsn(LambdaForm.BasicType type, int index) {
        int opcode = this.storeInsnOpcode(type);
        this.mv.visitVarInsn(opcode, this.localsMap[index]);
    }

    private int storeInsnOpcode(LambdaForm.BasicType type) throws InternalError {
        switch (type) {
            case I_TYPE: {
                return 54;
            }
            case J_TYPE: {
                return 55;
            }
            case F_TYPE: {
                return 56;
            }
            case D_TYPE: {
                return 57;
            }
            case L_TYPE: {
                return 58;
            }
        }
        throw new InternalError("unknown type: " + (Object)((Object)type));
    }

    private void emitAstoreInsn(int index) {
        this.emitStoreInsn(LambdaForm.BasicType.L_TYPE, index);
    }

    private byte arrayTypeCode(Wrapper elementType) {
        switch (elementType) {
            case BOOLEAN: {
                return 4;
            }
            case BYTE: {
                return 8;
            }
            case CHAR: {
                return 5;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case OBJECT: {
                return 0;
            }
        }
        throw new InternalError();
    }

    private int arrayInsnOpcode(byte tcode, int aaop) throws InternalError {
        int xas;
        assert (aaop == 83 || aaop == 50);
        switch (tcode) {
            case 4: {
                xas = 84;
                break;
            }
            case 8: {
                xas = 84;
                break;
            }
            case 5: {
                xas = 85;
                break;
            }
            case 9: {
                xas = 86;
                break;
            }
            case 10: {
                xas = 79;
                break;
            }
            case 11: {
                xas = 80;
                break;
            }
            case 6: {
                xas = 81;
                break;
            }
            case 7: {
                xas = 82;
                break;
            }
            case 0: {
                xas = 83;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return xas - 83 + aaop;
    }

    private void emitBoxing(Wrapper wrapper) {
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = "valueOf";
        String desc = "(" + wrapper.basicTypeChar() + ")L" + owner + ";";
        this.mv.visitMethodInsn(184, owner, name, desc, false);
    }

    private void emitUnboxing(Wrapper wrapper) {
        String owner = "java/lang/" + wrapper.wrapperType().getSimpleName();
        String name = wrapper.primitiveSimpleName() + "Value";
        String desc = "()" + wrapper.basicTypeChar();
        this.emitReferenceCast(wrapper.wrapperType(), null);
        this.mv.visitMethodInsn(182, owner, name, desc, false);
    }

    private void emitImplicitConversion(LambdaForm.BasicType ptype, Class<?> pclass, Object arg) {
        assert (LambdaForm.BasicType.basicType(pclass) == ptype);
        if (pclass == ptype.basicTypeClass() && ptype != LambdaForm.BasicType.L_TYPE) {
            return;
        }
        switch (ptype) {
            case L_TYPE: {
                if (VerifyType.isNullConversion(Object.class, pclass, false)) {
                    if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                        this.emitReferenceCast(Object.class, arg);
                    }
                    return;
                }
                this.emitReferenceCast(pclass, arg);
                return;
            }
            case I_TYPE: {
                if (!VerifyType.isNullConversion(Integer.TYPE, pclass, false)) {
                    this.emitPrimCast(ptype.basicTypeWrapper(), Wrapper.forPrimitiveType(pclass));
                }
                return;
            }
        }
        throw MethodHandleStatics.newInternalError("bad implicit conversion: tc=" + (Object)((Object)ptype) + ": " + pclass);
    }

    private boolean assertStaticType(Class<?> cls, LambdaForm.Name n) {
        int local = n.index();
        Class<?> aclass = this.localClasses[local];
        if (aclass != null && (aclass == cls || cls.isAssignableFrom(aclass))) {
            return true;
        }
        if (aclass == null || aclass.isAssignableFrom(cls)) {
            this.localClasses[local] = cls;
        }
        return false;
    }

    private void emitReferenceCast(Class<?> cls, Object arg) {
        LambdaForm.Name n;
        LambdaForm.Name writeBack = null;
        if (arg instanceof LambdaForm.Name && this.lambdaForm.useCount(n = (LambdaForm.Name)arg) > 1) {
            writeBack = n;
            if (this.assertStaticType(cls, n)) {
                return;
            }
        }
        if (InvokerBytecodeGenerator.isStaticallyNameable(cls)) {
            String sig = InvokerBytecodeGenerator.getInternalName(cls);
            this.mv.visitTypeInsn(192, sig);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(cls));
            this.mv.visitTypeInsn(192, CLS);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(182, CLS, "cast", LL_SIG, false);
            if (Object[].class.isAssignableFrom(cls)) {
                this.mv.visitTypeInsn(192, OBJARY);
            } else if (MethodHandleStatics.PROFILE_LEVEL > 0) {
                this.mv.visitTypeInsn(192, "java/lang/Object");
            }
        }
        if (writeBack != null) {
            this.mv.visitInsn(89);
            this.emitAstoreInsn(writeBack.index());
        }
    }

    private void emitReturnInsn(LambdaForm.BasicType type) {
        int opcode;
        switch (type) {
            case I_TYPE: {
                opcode = 172;
                break;
            }
            case J_TYPE: {
                opcode = 173;
                break;
            }
            case F_TYPE: {
                opcode = 174;
                break;
            }
            case D_TYPE: {
                opcode = 175;
                break;
            }
            case L_TYPE: {
                opcode = 176;
                break;
            }
            case V_TYPE: {
                opcode = 177;
                break;
            }
            default: {
                throw new InternalError("unknown return type: " + (Object)((Object)type));
            }
        }
        this.mv.visitInsn(opcode);
    }

    private static String getInternalName(Class<?> c) {
        if (c == Object.class) {
            return "java/lang/Object";
        }
        if (c == Object[].class) {
            return OBJARY;
        }
        if (c == Class.class) {
            return CLS;
        }
        if (c == MethodHandle.class) {
            return MH;
        }
        assert (VerifyAccess.isTypeVisible(c, Object.class)) : c.getName();
        return c.getName().replace('.', '/');
    }

    private static MemberName resolveFrom(String name, MethodType type, Class<?> holder) {
        MemberName member = new MemberName(holder, name, type, 6);
        MemberName resolvedMember = MemberName.getFactory().resolveOrNull((byte)6, member, holder);
        if (MethodHandleStatics.TRACE_RESOLVE) {
            System.out.println("[LF_RESOLVE] " + holder.getName() + " " + name + " " + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(type)) + (resolvedMember != null ? " (success)" : " (fail)"));
        }
        return resolvedMember;
    }

    private static MemberName lookupPregenerated(LambdaForm form) {
        if (form.customized != null) {
            return null;
        }
        MethodType invokerType = form.methodType();
        String name = form.kind.methodName;
        switch (form.kind) {
            case BOUND_REINVOKER: {
                name = name + "_" + BoundMethodHandle.speciesData(form).fieldSignature();
                return InvokerBytecodeGenerator.resolveFrom(name, invokerType, DelegatingMethodHandle.Holder.class);
            }
            case DELEGATE: {
                return InvokerBytecodeGenerator.resolveFrom(name, invokerType, DelegatingMethodHandle.Holder.class);
            }
            case ZERO: 
            case IDENTITY: {
                name = name + "_" + form.returnType().basicTypeChar();
                return InvokerBytecodeGenerator.resolveFrom(name, invokerType, LambdaForm.Holder.class);
            }
            case EXACT_INVOKER: 
            case EXACT_LINKER: 
            case GENERIC_INVOKER: 
            case GENERIC_LINKER: {
                return InvokerBytecodeGenerator.resolveFrom(name, invokerType.basicType(), Invokers.Holder.class);
            }
            case GET_OBJECT: 
            case GET_BOOLEAN: 
            case GET_BYTE: 
            case GET_CHAR: 
            case GET_SHORT: 
            case GET_INT: 
            case GET_LONG: 
            case GET_FLOAT: 
            case GET_DOUBLE: 
            case PUT_OBJECT: 
            case PUT_BOOLEAN: 
            case PUT_BYTE: 
            case PUT_CHAR: 
            case PUT_SHORT: 
            case PUT_INT: 
            case PUT_LONG: 
            case PUT_FLOAT: 
            case PUT_DOUBLE: 
            case DIRECT_INVOKE_INTERFACE: 
            case DIRECT_INVOKE_SPECIAL: 
            case DIRECT_INVOKE_STATIC: 
            case DIRECT_INVOKE_STATIC_INIT: 
            case DIRECT_INVOKE_VIRTUAL: {
                return InvokerBytecodeGenerator.resolveFrom(name, invokerType, DirectMethodHandle.Holder.class);
            }
        }
        return null;
    }

    static MemberName generateCustomizedCode(LambdaForm form, MethodType invokerType) {
        MemberName pregenerated = InvokerBytecodeGenerator.lookupPregenerated(form);
        if (pregenerated != null) {
            return pregenerated;
        }
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("MH", form, invokerType);
        return g.loadMethod(g.generateCustomizedCodeBytes());
    }

    private boolean checkActualReceiver() {
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(25, this.localsMap[0]);
        this.mv.visitMethodInsn(184, MHI, "assertSame", LLV_SIG, false);
        return true;
    }

    static String className(String cn) {
        assert (InvokerBytecodeGenerator.checkClassName(cn)) : "Class not found: " + cn;
        return cn;
    }

    static boolean checkClassName(String cn) {
        Type tp = Type.getType(cn);
        if (tp.getSort() != 10) {
            return false;
        }
        try {
            Class<?> c = Class.forName(tp.getClassName(), false, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private byte[] generateCustomizedCodeBytes() {
        this.classFilePrologue();
        this.addMethod();
        this.bogusMethod(this.lambdaForm);
        byte[] classFile = this.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    void setClassWriter(ClassWriter cw) {
        this.cw = cw;
    }

    void addMethod() {
        this.methodPrologue();
        this.mv.visitAnnotation(LF_HIDDEN_SIG, true);
        this.mv.visitAnnotation(LF_COMPILED_SIG, true);
        if (this.lambdaForm.forceInline) {
            this.mv.visitAnnotation(FORCEINLINE_SIG, true);
        } else {
            this.mv.visitAnnotation(DONTINLINE_SIG, true);
        }
        this.constantPlaceholder(this.lambdaForm);
        if (this.lambdaForm.customized != null) {
            this.mv.visitLdcInsn(this.constantPlaceholder(this.lambdaForm.customized));
            this.mv.visitTypeInsn(192, MH);
            assert (this.checkActualReceiver());
            this.mv.visitVarInsn(58, this.localsMap[0]);
        }
        LambdaForm.Name onStack = null;
        block13: for (int i = this.lambdaForm.arity; i < this.lambdaForm.names.length; ++i) {
            MemberName member;
            LambdaForm.Name name = this.lambdaForm.names[i];
            this.emitStoreResult(onStack);
            onStack = name;
            MethodHandleImpl.Intrinsic intr = name.function.intrinsicName();
            switch (intr) {
                case SELECT_ALTERNATIVE: {
                    assert (this.lambdaForm.isSelectAlternative(i));
                    if (MethodHandleStatics.PROFILE_GWT) {
                        assert (name.arguments[0] instanceof LambdaForm.Name && ((LambdaForm.Name)name.arguments[0]).refersTo(MethodHandleImpl.class, "profileBoolean"));
                        this.mv.visitAnnotation(INJECTEDPROFILE_SIG, true);
                    }
                    onStack = this.emitSelectAlternative(name, this.lambdaForm.names[i + 1]);
                    ++i;
                    continue block13;
                }
                case GUARD_WITH_CATCH: {
                    assert (this.lambdaForm.isGuardWithCatch(i));
                    onStack = this.emitGuardWithCatch(i);
                    i += 2;
                    continue block13;
                }
                case TRY_FINALLY: {
                    assert (this.lambdaForm.isTryFinally(i));
                    onStack = this.emitTryFinally(i);
                    i += 2;
                    continue block13;
                }
                case LOOP: {
                    assert (this.lambdaForm.isLoop(i));
                    onStack = this.emitLoop(i);
                    i += 2;
                    continue block13;
                }
                case NEW_ARRAY: {
                    Class<?> rtype = name.function.methodType().returnType();
                    if (!InvokerBytecodeGenerator.isStaticallyNameable(rtype)) break;
                    this.emitNewArray(name);
                    continue block13;
                }
                case ARRAY_LOAD: {
                    this.emitArrayLoad(name);
                    continue block13;
                }
                case ARRAY_STORE: {
                    this.emitArrayStore(name);
                    continue block13;
                }
                case ARRAY_LENGTH: {
                    this.emitArrayLength(name);
                    continue block13;
                }
                case IDENTITY: {
                    assert (name.arguments.length == 1);
                    this.emitPushArguments(name, 0);
                    continue block13;
                }
                case ZERO: {
                    assert (name.arguments.length == 0);
                    this.emitConst(name.type.basicTypeWrapper().zero());
                    continue block13;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw MethodHandleStatics.newInternalError("Unknown intrinsic: " + (Object)((Object)intr));
                }
            }
            if (InvokerBytecodeGenerator.isStaticallyInvocable(member = name.function.member())) {
                this.emitStaticInvoke(member, name);
                continue;
            }
            this.emitInvoke(name);
        }
        this.emitReturn(onStack);
        this.methodEpilogue();
    }

    private byte[] toByteArray() {
        try {
            return this.cw.toByteArray();
        }
        catch (RuntimeException e) {
            throw new BytecodeGenerationException(e);
        }
    }

    void emitArrayLoad(LambdaForm.Name name) {
        this.emitArrayOp(name, 50);
    }

    void emitArrayStore(LambdaForm.Name name) {
        this.emitArrayOp(name, 83);
    }

    void emitArrayLength(LambdaForm.Name name) {
        this.emitArrayOp(name, 190);
    }

    void emitArrayOp(LambdaForm.Name name, int arrayOpcode) {
        assert (arrayOpcode == 50 || arrayOpcode == 83 || arrayOpcode == 190);
        Class<?> elementType = name.function.methodType().parameterType(0).getComponentType();
        assert (elementType != null);
        this.emitPushArguments(name, 0);
        if (arrayOpcode != 190 && elementType.isPrimitive()) {
            Wrapper w = Wrapper.forPrimitiveType(elementType);
            arrayOpcode = this.arrayInsnOpcode(this.arrayTypeCode(w), arrayOpcode);
        }
        this.mv.visitInsn(arrayOpcode);
    }

    void emitInvoke(LambdaForm.Name name) {
        assert (!name.isLinkerMethodInvoke());
        MethodHandle target = name.function.resolvedHandle();
        assert (target != null) : name.exprString();
        this.mv.visitLdcInsn(this.constantPlaceholder(target));
        this.emitReferenceCast(MethodHandle.class, target);
        this.emitPushArguments(name, 0);
        MethodType type = name.function.methodType();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString(), false);
    }

    static boolean isStaticallyInvocable(LambdaForm.NamedFunction[] functions) {
        for (LambdaForm.NamedFunction nf : functions) {
            if (InvokerBytecodeGenerator.isStaticallyInvocable(nf.member())) continue;
            return false;
        }
        return true;
    }

    static boolean isStaticallyInvocable(LambdaForm.Name name) {
        return InvokerBytecodeGenerator.isStaticallyInvocable(name.function.member());
    }

    static boolean isStaticallyInvocable(MemberName member) {
        if (member == null) {
            return false;
        }
        if (member.isConstructor()) {
            return false;
        }
        Class<?> cls = member.getDeclaringClass();
        if (cls.isArray() || cls.isPrimitive()) {
            return false;
        }
        if (cls.isAnonymousClass() || cls.isLocalClass()) {
            return false;
        }
        if (cls.getClassLoader() != MethodHandle.class.getClassLoader()) {
            return false;
        }
        if (ReflectUtil.isVMAnonymousClass(cls)) {
            return false;
        }
        MethodType mtype = member.getMethodOrFieldType();
        if (!InvokerBytecodeGenerator.isStaticallyNameable(mtype.returnType())) {
            return false;
        }
        for (Class<?> ptype : mtype.parameterArray()) {
            if (InvokerBytecodeGenerator.isStaticallyNameable(ptype)) continue;
            return false;
        }
        if (!member.isPrivate() && VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        return member.isPublic() && InvokerBytecodeGenerator.isStaticallyNameable(cls);
    }

    static boolean isStaticallyNameable(Class<?> cls) {
        if (cls == Object.class) {
            return true;
        }
        while (cls.isArray()) {
            cls = cls.getComponentType();
        }
        if (cls.isPrimitive()) {
            return true;
        }
        if (ReflectUtil.isVMAnonymousClass(cls)) {
            return false;
        }
        if (cls.getClassLoader() != Object.class.getClassLoader()) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, cls)) {
            return true;
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            return false;
        }
        for (Class<?> pkgcls : STATICALLY_INVOCABLE_PACKAGES) {
            if (!VerifyAccess.isSamePackage(pkgcls, cls)) continue;
            return true;
        }
        return false;
    }

    void emitStaticInvoke(LambdaForm.Name name) {
        this.emitStaticInvoke(name.function.member(), name);
    }

    void emitStaticInvoke(MemberName member, LambdaForm.Name name) {
        assert (member.equals(name.function.member()));
        Class<?> defc = member.getDeclaringClass();
        String cname = InvokerBytecodeGenerator.getInternalName(defc);
        String mname = member.getName();
        byte refKind = member.getReferenceKind();
        if (refKind == 7) {
            assert (member.canBeStaticallyBound()) : member;
            refKind = 5;
        }
        assert (!member.getDeclaringClass().isInterface() || refKind != 5);
        this.emitPushArguments(name, 0);
        if (member.isMethod()) {
            String mtype = member.getMethodType().toMethodDescriptorString();
            this.mv.visitMethodInsn(this.refKindOpcode(refKind), cname, mname, mtype, member.getDeclaringClass().isInterface());
        } else {
            String mtype = MethodType.toFieldDescriptorString(member.getFieldType());
            this.mv.visitFieldInsn(this.refKindOpcode(refKind), cname, mname, mtype);
        }
        if (name.type == LambdaForm.BasicType.L_TYPE) {
            Class<?> rtype = member.getInvocationType().returnType();
            assert (!rtype.isPrimitive());
            if (rtype != Object.class && !rtype.isInterface()) {
                this.assertStaticType(rtype, name);
            }
        }
    }

    void emitNewArray(LambdaForm.Name name) throws InternalError {
        Class<?> rtype = name.function.methodType().returnType();
        if (name.arguments.length == 0) {
            Object emptyArray;
            try {
                emptyArray = name.function.resolvedHandle().invoke();
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            assert (Array.getLength(emptyArray) == 0);
            assert (emptyArray.getClass() == rtype);
            this.mv.visitLdcInsn(this.constantPlaceholder(emptyArray));
            this.emitReferenceCast(rtype, emptyArray);
            return;
        }
        Class<?> arrayElementType = rtype.getComponentType();
        assert (arrayElementType != null);
        this.emitIconstInsn(name.arguments.length);
        int xas = 83;
        if (!arrayElementType.isPrimitive()) {
            this.mv.visitTypeInsn(189, InvokerBytecodeGenerator.getInternalName(arrayElementType));
        } else {
            byte tc = this.arrayTypeCode(Wrapper.forPrimitiveType(arrayElementType));
            xas = this.arrayInsnOpcode(tc, xas);
            this.mv.visitIntInsn(188, tc);
        }
        for (int i = 0; i < name.arguments.length; ++i) {
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitPushArgument(name, i);
            this.mv.visitInsn(xas);
        }
        this.assertStaticType(rtype, name);
    }

    int refKindOpcode(byte refKind) {
        switch (refKind) {
            case 5: {
                return 182;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 183;
            }
            case 9: {
                return 185;
            }
            case 1: {
                return 180;
            }
            case 3: {
                return 181;
            }
            case 2: {
                return 178;
            }
            case 4: {
                return 179;
            }
        }
        throw new InternalError("refKind=" + refKind);
    }

    private LambdaForm.Name emitSelectAlternative(LambdaForm.Name selectAlternativeName, LambdaForm.Name invokeBasicName) {
        assert (InvokerBytecodeGenerator.isStaticallyInvocable(invokeBasicName));
        LambdaForm.Name receiver = (LambdaForm.Name)invokeBasicName.arguments[0];
        Label L_fallback = new Label();
        Label L_done = new Label();
        this.emitPushArgument(selectAlternativeName, 0);
        this.mv.visitJumpInsn(153, L_fallback);
        Class[] preForkClasses = (Class[])this.localClasses.clone();
        this.emitPushArgument(selectAlternativeName, 1);
        this.emitAstoreInsn(receiver.index());
        this.emitStaticInvoke(invokeBasicName);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_fallback);
        System.arraycopy(preForkClasses, 0, this.localClasses, 0, preForkClasses.length);
        this.emitPushArgument(selectAlternativeName, 2);
        this.emitAstoreInsn(receiver.index());
        this.emitStaticInvoke(invokeBasicName);
        this.mv.visitLabel(L_done);
        System.arraycopy(preForkClasses, 0, this.localClasses, 0, preForkClasses.length);
        return invokeBasicName;
    }

    private LambdaForm.Name emitGuardWithCatch(int pos) {
        LambdaForm.Name args = this.lambdaForm.names[pos];
        LambdaForm.Name invoker = this.lambdaForm.names[pos + 1];
        LambdaForm.Name result = this.lambdaForm.names[pos + 2];
        Label L_startBlock = new Label();
        Label L_endBlock = new Label();
        Label L_handler = new Label();
        Label L_done = new Label();
        Class<?> returnType = result.function.resolvedHandle().type().returnType();
        MethodType type = args.function.resolvedHandle().type().dropParameterTypes(0, 1).changeReturnType(returnType);
        this.mv.visitTryCatchBlock(L_startBlock, L_endBlock, L_handler, "java/lang/Throwable");
        this.mv.visitLabel(L_startBlock);
        this.emitPushArgument(invoker, 0);
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString(), false);
        this.mv.visitLabel(L_endBlock);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_handler);
        this.mv.visitInsn(89);
        this.emitPushArgument(invoker, 1);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, CLS, "isInstance", "(Ljava/lang/Object;)Z", false);
        Label L_rethrow = new Label();
        this.mv.visitJumpInsn(153, L_rethrow);
        this.emitPushArgument(invoker, 2);
        this.mv.visitInsn(95);
        this.emitPushArguments(args, 1);
        MethodType catcherType = type.insertParameterTypes(0, Throwable.class);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", catcherType.basicType().toMethodDescriptorString(), false);
        this.mv.visitJumpInsn(167, L_done);
        this.mv.visitLabel(L_rethrow);
        this.mv.visitInsn(191);
        this.mv.visitLabel(L_done);
        return result;
    }

    private LambdaForm.Name emitTryFinally(int pos) {
        LambdaForm.Name args = this.lambdaForm.names[pos];
        LambdaForm.Name invoker = this.lambdaForm.names[pos + 1];
        LambdaForm.Name result = this.lambdaForm.names[pos + 2];
        Label lFrom = new Label();
        Label lTo = new Label();
        Label lCatch = new Label();
        Label lDone = new Label();
        Class<?> returnType = result.function.resolvedHandle().type().returnType();
        boolean isNonVoid = returnType != Void.TYPE;
        MethodType type = args.function.resolvedHandle().type().dropParameterTypes(0, 1).changeReturnType(returnType);
        MethodType cleanupType = type.insertParameterTypes(0, Throwable.class);
        if (isNonVoid) {
            cleanupType = cleanupType.insertParameterTypes(1, returnType);
        }
        String cleanupDesc = cleanupType.basicType().toMethodDescriptorString();
        this.mv.visitTryCatchBlock(lFrom, lTo, lCatch, "java/lang/Throwable");
        this.mv.visitLabel(lFrom);
        this.emitPushArgument(invoker, 0);
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.basicType().toMethodDescriptorString(), false);
        this.mv.visitLabel(lTo);
        this.emitPushArgument(invoker, 1);
        if (isNonVoid) {
            this.mv.visitInsn(95);
        }
        this.mv.visitInsn(1);
        if (isNonVoid) {
            this.mv.visitInsn(95);
        }
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", cleanupDesc, false);
        this.mv.visitJumpInsn(167, lDone);
        this.mv.visitLabel(lCatch);
        this.mv.visitInsn(89);
        this.emitPushArgument(invoker, 1);
        this.mv.visitInsn(95);
        if (isNonVoid) {
            this.emitZero(LambdaForm.BasicType.basicType(returnType));
        }
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", cleanupDesc, false);
        if (isNonVoid) {
            this.mv.visitInsn(87);
        }
        this.mv.visitInsn(191);
        this.mv.visitLabel(lDone);
        return result;
    }

    private LambdaForm.Name emitLoop(int pos) {
        int c;
        LambdaForm.Name args = this.lambdaForm.names[pos];
        LambdaForm.Name invoker = this.lambdaForm.names[pos + 1];
        LambdaForm.Name result = this.lambdaForm.names[pos + 2];
        LambdaForm.BasicType[] loopClauseTypes = (LambdaForm.BasicType[])invoker.arguments[0];
        Class[] loopLocalStateTypes = (Class[])Stream.of(loopClauseTypes).filter(bt -> bt != LambdaForm.BasicType.V_TYPE).map(LambdaForm.BasicType::basicTypeClass).toArray(Class[]::new);
        Class[] localTypes = new Class[loopLocalStateTypes.length + 1];
        localTypes[0] = MethodHandleImpl.LoopClauses.class;
        System.arraycopy(loopLocalStateTypes, 0, localTypes, 1, loopLocalStateTypes.length);
        int clauseDataIndex = this.extendLocalsMap(localTypes);
        int firstLoopStateIndex = clauseDataIndex + 1;
        Class<?> returnType = result.function.resolvedHandle().type().returnType();
        MethodType loopType = args.function.resolvedHandle().type().dropParameterTypes(0, 1).changeReturnType(returnType);
        MethodType loopHandleType = loopType.insertParameterTypes(0, loopLocalStateTypes);
        MethodType predType = loopHandleType.changeReturnType(Boolean.TYPE);
        MethodType finiType = loopHandleType;
        int nClauses = loopClauseTypes.length;
        boolean inits = true;
        int steps = 2;
        int preds = 3;
        int finis = 4;
        Label lLoop = new Label();
        Label lDone = new Label();
        this.emitPushArgument(MethodHandleImpl.LoopClauses.class, invoker.arguments[1]);
        this.mv.visitFieldInsn(180, LOOP_CLAUSES, "clauses", MHARY2);
        this.emitAstoreInsn(clauseDataIndex);
        int state = 0;
        for (c = 0; c < nClauses; ++c) {
            MethodType cInitType = loopType.changeReturnType(loopClauseTypes[c].basicTypeClass());
            this.emitLoopHandleInvoke(invoker, 1, c, args, false, cInitType, loopLocalStateTypes, clauseDataIndex, firstLoopStateIndex);
            if (cInitType.returnType() == Void.TYPE) continue;
            this.emitStoreInsn(LambdaForm.BasicType.basicType(cInitType.returnType()), firstLoopStateIndex + state);
            ++state;
        }
        this.mv.visitLabel(lLoop);
        state = 0;
        for (c = 0; c < nClauses; ++c) {
            Label lNext = new Label();
            MethodType stepType = loopHandleType.changeReturnType(loopClauseTypes[c].basicTypeClass());
            boolean isVoid = stepType.returnType() == Void.TYPE;
            this.emitLoopHandleInvoke(invoker, 2, c, args, true, stepType, loopLocalStateTypes, clauseDataIndex, firstLoopStateIndex);
            if (!isVoid) {
                this.emitStoreInsn(LambdaForm.BasicType.basicType(stepType.returnType()), firstLoopStateIndex + state);
                ++state;
            }
            this.emitLoopHandleInvoke(invoker, 3, c, args, true, predType, loopLocalStateTypes, clauseDataIndex, firstLoopStateIndex);
            this.mv.visitJumpInsn(154, lNext);
            this.emitLoopHandleInvoke(invoker, 4, c, args, true, finiType, loopLocalStateTypes, clauseDataIndex, firstLoopStateIndex);
            this.mv.visitJumpInsn(167, lDone);
            this.mv.visitLabel(lNext);
        }
        this.mv.visitJumpInsn(167, lLoop);
        this.mv.visitLabel(lDone);
        return result;
    }

    private int extendLocalsMap(Class<?>[] types) {
        int firstSlot = this.localsMap.length - 1;
        this.localsMap = Arrays.copyOf(this.localsMap, this.localsMap.length + types.length);
        this.localClasses = Arrays.copyOf(this.localClasses, this.localClasses.length + types.length);
        System.arraycopy(types, 0, this.localClasses, firstSlot, types.length);
        int index = this.localsMap[firstSlot - 1] + 1;
        int lastSlots = 0;
        for (int i = 0; i < types.length; ++i) {
            this.localsMap[firstSlot + i] = index;
            lastSlots = LambdaForm.BasicType.basicType(this.localClasses[firstSlot + i]).basicTypeSlots();
            index += lastSlots;
        }
        this.localsMap[this.localsMap.length - 1] = index - lastSlots;
        return firstSlot;
    }

    private void emitLoopHandleInvoke(LambdaForm.Name holder, int handles, int clause, LambdaForm.Name args, boolean pushLocalState, MethodType type, Class<?>[] loopLocalStateTypes, int clauseDataSlot, int firstLoopStateSlot) {
        this.emitPushClauseArray(clauseDataSlot, handles);
        this.emitIconstInsn(clause);
        this.mv.visitInsn(50);
        if (pushLocalState) {
            for (int s = 0; s < loopLocalStateTypes.length; ++s) {
                this.emitLoadInsn(LambdaForm.BasicType.basicType(loopLocalStateTypes[s]), firstLoopStateSlot + s);
            }
        }
        this.emitPushArguments(args, 1);
        this.mv.visitMethodInsn(182, MH, "invokeBasic", type.toMethodDescriptorString(), false);
    }

    private void emitPushClauseArray(int clauseDataSlot, int which) {
        this.emitAloadInsn(clauseDataSlot);
        this.emitIconstInsn(which - 1);
        this.mv.visitInsn(50);
    }

    private void emitZero(LambdaForm.BasicType type) {
        switch (type) {
            case I_TYPE: {
                this.mv.visitInsn(3);
                break;
            }
            case J_TYPE: {
                this.mv.visitInsn(9);
                break;
            }
            case F_TYPE: {
                this.mv.visitInsn(11);
                break;
            }
            case D_TYPE: {
                this.mv.visitInsn(14);
                break;
            }
            case L_TYPE: {
                this.mv.visitInsn(1);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)type));
            }
        }
    }

    private void emitPushArguments(LambdaForm.Name args, int start) {
        MethodType type = args.function.methodType();
        for (int i = start; i < args.arguments.length; ++i) {
            this.emitPushArgument(type.parameterType(i), args.arguments[i]);
        }
    }

    private void emitPushArgument(LambdaForm.Name name, int paramIndex) {
        Object arg = name.arguments[paramIndex];
        Class<?> ptype = name.function.methodType().parameterType(paramIndex);
        this.emitPushArgument(ptype, arg);
    }

    private void emitPushArgument(Class<?> ptype, Object arg) {
        LambdaForm.BasicType bptype = LambdaForm.BasicType.basicType(ptype);
        if (arg instanceof LambdaForm.Name) {
            LambdaForm.Name n = (LambdaForm.Name)arg;
            this.emitLoadInsn(n.type, n.index());
            this.emitImplicitConversion(n.type, ptype, n);
        } else if ((arg == null || arg instanceof String) && bptype == LambdaForm.BasicType.L_TYPE) {
            this.emitConst(arg);
        } else if (Wrapper.isWrapperType(arg.getClass()) && bptype != LambdaForm.BasicType.L_TYPE) {
            this.emitConst(arg);
        } else {
            this.mv.visitLdcInsn(this.constantPlaceholder(arg));
            this.emitImplicitConversion(LambdaForm.BasicType.L_TYPE, ptype, arg);
        }
    }

    private void emitStoreResult(LambdaForm.Name name) {
        if (name != null && name.type != LambdaForm.BasicType.V_TYPE) {
            this.emitStoreInsn(name.type, name.index());
        }
    }

    private void emitReturn(LambdaForm.Name onStack) {
        Class<?> rclass = this.invokerType.returnType();
        LambdaForm.BasicType rtype = this.lambdaForm.returnType();
        assert (rtype == LambdaForm.BasicType.basicType(rclass));
        if (rtype == LambdaForm.BasicType.V_TYPE) {
            this.mv.visitInsn(177);
        } else {
            LambdaForm.Name rn = this.lambdaForm.names[this.lambdaForm.result];
            if (rn != onStack) {
                this.emitLoadInsn(rtype, this.lambdaForm.result);
            }
            this.emitImplicitConversion(rtype, rclass, rn);
            this.emitReturnInsn(rtype);
        }
    }

    private void emitPrimCast(Wrapper from, Wrapper to) {
        if (from == to) {
            return;
        }
        if (from.isSubwordOrInt()) {
            this.emitI2X(to);
        } else if (to.isSubwordOrInt()) {
            this.emitX2I(from);
            if (to.bitWidth() < 32) {
                this.emitI2X(to);
            }
        } else {
            boolean error = false;
            block0 : switch (from) {
                case LONG: {
                    switch (to) {
                        case FLOAT: {
                            this.mv.visitInsn(137);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(138);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case FLOAT: {
                    switch (to) {
                        case LONG: {
                            this.mv.visitInsn(140);
                            break block0;
                        }
                        case DOUBLE: {
                            this.mv.visitInsn(141);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case DOUBLE: {
                    switch (to) {
                        case LONG: {
                            this.mv.visitInsn(143);
                            break block0;
                        }
                        case FLOAT: {
                            this.mv.visitInsn(144);
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                default: {
                    error = true;
                }
            }
            if (error) {
                throw new IllegalStateException("unhandled prim cast: " + (Object)((Object)from) + "2" + (Object)((Object)to));
            }
        }
    }

    private void emitI2X(Wrapper type) {
        switch (type) {
            case BYTE: {
                this.mv.visitInsn(145);
                break;
            }
            case SHORT: {
                this.mv.visitInsn(147);
                break;
            }
            case CHAR: {
                this.mv.visitInsn(146);
                break;
            }
            case INT: {
                break;
            }
            case LONG: {
                this.mv.visitInsn(133);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(134);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(135);
                break;
            }
            case BOOLEAN: {
                this.mv.visitInsn(4);
                this.mv.visitInsn(126);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)type));
            }
        }
    }

    private void emitX2I(Wrapper type) {
        switch (type) {
            case LONG: {
                this.mv.visitInsn(136);
                break;
            }
            case FLOAT: {
                this.mv.visitInsn(139);
                break;
            }
            case DOUBLE: {
                this.mv.visitInsn(142);
                break;
            }
            default: {
                throw new InternalError("unknown type: " + (Object)((Object)type));
            }
        }
    }

    static MemberName generateLambdaFormInterpreterEntryPoint(MethodType mt) {
        assert (LambdaForm.isValidSignature(LambdaForm.basicTypeSignature(mt)));
        String name = "interpret_" + LambdaForm.BasicType.basicTypeChar(mt.returnType());
        MethodType type = mt;
        type = type.changeParameterType(0, MethodHandle.class);
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("LFI", name, type);
        return g.loadMethod(g.generateLambdaFormInterpreterEntryPointBytes());
    }

    private byte[] generateLambdaFormInterpreterEntryPointBytes() {
        this.classFilePrologue();
        this.methodPrologue();
        this.mv.visitAnnotation(LF_HIDDEN_SIG, true);
        this.mv.visitAnnotation(DONTINLINE_SIG, true);
        this.emitIconstInsn(this.invokerType.parameterCount());
        this.mv.visitTypeInsn(189, "java/lang/Object");
        for (int i = 0; i < this.invokerType.parameterCount(); ++i) {
            Class<?> ptype = this.invokerType.parameterType(i);
            this.mv.visitInsn(89);
            this.emitIconstInsn(i);
            this.emitLoadInsn(LambdaForm.BasicType.basicType(ptype), i);
            if (ptype.isPrimitive()) {
                this.emitBoxing(Wrapper.forPrimitiveType(ptype));
            }
            this.mv.visitInsn(83);
        }
        this.emitAloadInsn(0);
        this.mv.visitFieldInsn(180, MH, "form", LF_SIG);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, LF, "interpretWithArguments", "([Ljava/lang/Object;)Ljava/lang/Object;", false);
        Class<?> rtype = this.invokerType.returnType();
        if (rtype.isPrimitive() && rtype != Void.TYPE) {
            this.emitUnboxing(Wrapper.forPrimitiveType(rtype));
        }
        this.emitReturnInsn(LambdaForm.BasicType.basicType(rtype));
        this.methodEpilogue();
        this.bogusMethod(this.invokerType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    static MemberName generateNamedFunctionInvoker(MethodTypeForm typeForm) {
        MethodType invokerType = LambdaForm.NamedFunction.INVOKER_METHOD_TYPE;
        String invokerName = "invoke_" + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(typeForm.erasedType()));
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator("NFI", invokerName, invokerType);
        return g.loadMethod(g.generateNamedFunctionInvokerImpl(typeForm));
    }

    private byte[] generateNamedFunctionInvokerImpl(MethodTypeForm typeForm) {
        MethodType dstType = typeForm.erasedType();
        this.classFilePrologue();
        this.methodPrologue();
        this.mv.visitAnnotation(LF_HIDDEN_SIG, true);
        this.mv.visitAnnotation(FORCEINLINE_SIG, true);
        this.emitAloadInsn(0);
        for (int i = 0; i < dstType.parameterCount(); ++i) {
            this.emitAloadInsn(1);
            this.emitIconstInsn(i);
            this.mv.visitInsn(50);
            Class<?> dptype = dstType.parameterType(i);
            if (!dptype.isPrimitive()) continue;
            Wrapper dstWrapper = Wrapper.forBasicType(dptype);
            Wrapper srcWrapper = dstWrapper.isSubwordOrInt() ? Wrapper.INT : dstWrapper;
            this.emitUnboxing(srcWrapper);
            this.emitPrimCast(srcWrapper, dstWrapper);
        }
        String targetDesc = dstType.basicType().toMethodDescriptorString();
        this.mv.visitMethodInsn(182, MH, "invokeBasic", targetDesc, false);
        Class<?> rtype = dstType.returnType();
        if (rtype != Void.TYPE && rtype.isPrimitive()) {
            Wrapper srcWrapper = Wrapper.forBasicType(rtype);
            Wrapper dstWrapper = srcWrapper.isSubwordOrInt() ? Wrapper.INT : srcWrapper;
            this.emitPrimCast(srcWrapper, dstWrapper);
            this.emitBoxing(dstWrapper);
        }
        if (rtype == Void.TYPE) {
            this.mv.visitInsn(1);
        }
        this.emitReturnInsn(LambdaForm.BasicType.L_TYPE);
        this.methodEpilogue();
        this.bogusMethod(dstType);
        byte[] classFile = this.cw.toByteArray();
        InvokerBytecodeGenerator.maybeDump(this.className, classFile);
        return classFile;
    }

    private void bogusMethod(Object ... os) {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            this.mv = this.cw.visitMethod(8, "dummy", "()V", null, null);
            for (Object o : os) {
                this.mv.visitLdcInsn(o.toString());
                this.mv.visitInsn(87);
            }
            this.mv.visitInsn(177);
            this.mv.visitMaxs(0, 0);
            this.mv.visitEnd();
        }
    }

    static {
        if (MethodHandleStatics.DUMP_CLASS_FILES) {
            DUMP_CLASS_FILES_COUNTERS = new HashMap();
            try {
                File dumpDir = new File("DUMP_CLASS_FILES");
                if (!dumpDir.exists()) {
                    dumpDir.mkdirs();
                }
                DUMP_CLASS_FILES_DIR = dumpDir;
                System.out.println("Dumping class files to " + DUMP_CLASS_FILES_DIR + "/...");
            }
            catch (Exception e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        } else {
            DUMP_CLASS_FILES_COUNTERS = null;
            DUMP_CLASS_FILES_DIR = null;
        }
        LF_HIDDEN_SIG = InvokerBytecodeGenerator.className("Ljava/lang/invoke/LambdaForm$Hidden;");
        LF_COMPILED_SIG = InvokerBytecodeGenerator.className("Ljava/lang/invoke/LambdaForm$Compiled;");
        FORCEINLINE_SIG = InvokerBytecodeGenerator.className("Ljdk/internal/vm/annotation/ForceInline;");
        DONTINLINE_SIG = InvokerBytecodeGenerator.className("Ljdk/internal/vm/annotation/DontInline;");
        INJECTEDPROFILE_SIG = InvokerBytecodeGenerator.className("Ljava/lang/invoke/InjectedProfile;");
        STATICALLY_INVOCABLE_PACKAGES = new Class[]{Object.class, Arrays.class, Unsafe.class};
    }

    static final class BytecodeGenerationException
    extends RuntimeException {
        BytecodeGenerationException(Exception cause) {
            super(cause);
        }
    }

    class CpPatch {
        final int index;
        final Object value;

        CpPatch(int index, Object value) {
            this.index = index;
            this.value = value;
        }

        public String toString() {
            return "CpPatch/index=" + this.index + ",value=" + this.value;
        }
    }
}

