/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import jdk.internal.org.objectweb.asm.ClassWriter;
import sun.invoke.util.Wrapper;

class GenerateJLIClassesHelper {
    GenerateJLIClassesHelper() {
    }

    static byte[] generateBasicFormsClassBytes(String className) {
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        HashSet<String> dedupSet = new HashSet<String>();
        for (LambdaForm.BasicType type : LambdaForm.BasicType.values()) {
            LambdaForm zero = LambdaForm.zeroForm(type);
            String name = zero.kind.defaultLambdaName + "_" + zero.returnType().basicTypeChar();
            if (dedupSet.add(name)) {
                names.add(name);
                forms.add(zero);
            }
            LambdaForm identity = LambdaForm.identityForm(type);
            name = identity.kind.defaultLambdaName + "_" + identity.returnType().basicTypeChar();
            if (!dedupSet.add(name)) continue;
            names.add(name);
            forms.add(identity);
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateDirectMethodHandleHolderClassBytes(String className, MethodType[] methodTypes, int[] types) {
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < methodTypes.length; ++i) {
            LambdaForm form = DirectMethodHandle.makePreparedLambdaForm(methodTypes[i], types[i]);
            forms.add(form);
            names.add(form.kind.defaultLambdaName);
        }
        for (Wrapper wrapper : Wrapper.values()) {
            if (wrapper == Wrapper.VOID) continue;
            for (byte b = 0; b < 6; b = (byte)(b + 1)) {
                int ftype = DirectMethodHandle.ftypeKind(wrapper.primitiveType());
                LambdaForm form = DirectMethodHandle.makePreparedFieldLambdaForm(b, false, ftype);
                if (form.kind != LambdaForm.Kind.GENERIC) {
                    forms.add(form);
                    names.add(form.kind.defaultLambdaName);
                }
                form = DirectMethodHandle.makePreparedFieldLambdaForm(b, true, ftype);
                if (form.kind == LambdaForm.Kind.GENERIC) continue;
                forms.add(form);
                names.add(form.kind.defaultLambdaName);
            }
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateDelegatingMethodHandleHolderClassBytes(String className, MethodType[] methodTypes) {
        HashSet<MethodType> dedupSet = new HashSet<MethodType>();
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < methodTypes.length; ++i) {
            if (!dedupSet.add(methodTypes[i])) continue;
            LambdaForm reinvoker = GenerateJLIClassesHelper.makeReinvokerFor(methodTypes[i]);
            forms.add(reinvoker);
            String speciesSig = BoundMethodHandle.speciesData(reinvoker).fieldSignature();
            assert (speciesSig.equals("L"));
            names.add(reinvoker.kind.defaultLambdaName + "_" + speciesSig);
            LambdaForm delegate = GenerateJLIClassesHelper.makeDelegateFor(methodTypes[i]);
            forms.add(delegate);
            names.add(delegate.kind.defaultLambdaName);
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateInvokersHolderClassBytes(String className, MethodType[] methodTypes) {
        HashSet<MethodType> dedupSet = new HashSet<MethodType>();
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        int[] types = new int[]{10, 11, 12, 13};
        for (int i = 0; i < methodTypes.length; ++i) {
            if (!dedupSet.add(methodTypes[i])) continue;
            for (int type : types) {
                LambdaForm invokerForm = Invokers.invokeHandleForm(methodTypes[i], false, type);
                forms.add(invokerForm);
                names.add(invokerForm.kind.defaultLambdaName);
            }
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    private static byte[] generateCodeBytesForLFs(String className, String[] names, LambdaForm[] forms) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 50, className, null, "java/lang/Object", null);
        cw.visitSource(className.substring(className.lastIndexOf(47) + 1), null);
        for (int i = 0; i < forms.length; ++i) {
            GenerateJLIClassesHelper.addMethod(className, names[i], forms[i], forms[i].methodType(), cw);
        }
        return cw.toByteArray();
    }

    private static void addMethod(String className, String methodName, LambdaForm form, MethodType type, ClassWriter cw) {
        InvokerBytecodeGenerator g = new InvokerBytecodeGenerator(className, methodName, form, type);
        g.setClassWriter(cw);
        g.addMethod();
    }

    private static LambdaForm makeReinvokerFor(MethodType type) {
        MethodHandle emptyHandle = MethodHandles.empty(type);
        return DelegatingMethodHandle.makeReinvokerForm(emptyHandle, 7, BoundMethodHandle.speciesData_L(), BoundMethodHandle.speciesData_L().getterFunction(0));
    }

    private static LambdaForm makeDelegateFor(MethodType type) {
        MethodHandle handle = MethodHandles.empty(type);
        return DelegatingMethodHandle.makeReinvokerForm(handle, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
    }

    static Map.Entry<String, byte[]> generateConcreteBMHClassBytes(String types) {
        for (char c : types.toCharArray()) {
            if ("LIJFD".indexOf(c) >= 0) continue;
            throw new IllegalArgumentException("All characters must correspond to a basic field type: LIJFD");
        }
        String shortTypes = LambdaForm.shortenSignature(types);
        String className = BoundMethodHandle.Factory.speciesInternalClassName(shortTypes);
        return Map.entry(className, BoundMethodHandle.Factory.generateConcreteBMHClassBytes(shortTypes, types, className));
    }
}

