/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import jdk.internal.misc.Unsafe;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class DirectMethodHandle
extends MethodHandle {
    final MemberName member;
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    static final byte AF_GETFIELD = 0;
    static final byte AF_PUTFIELD = 1;
    static final byte AF_GETSTATIC = 2;
    static final byte AF_PUTSTATIC = 3;
    static final byte AF_GETSTATIC_INIT = 4;
    static final byte AF_PUTSTATIC_INIT = 5;
    static final byte AF_LIMIT = 6;
    static final int FT_LAST_WRAPPER = 9;
    static final int FT_UNCHECKED_REF = Wrapper.OBJECT.ordinal();
    static final int FT_CHECKED_REF = 10;
    static final int FT_LIMIT = 11;
    @Stable
    private static final LambdaForm[] ACCESSOR_FORMS = new LambdaForm[DirectMethodHandle.afIndex((byte)6, false, 0)];
    private static final Wrapper[] ALL_WRAPPERS = Wrapper.values();
    static final LambdaForm.NamedFunction NF_internalMemberName;
    static final LambdaForm.NamedFunction NF_internalMemberNameEnsureInit;
    static final LambdaForm.NamedFunction NF_ensureInitialized;
    static final LambdaForm.NamedFunction NF_fieldOffset;
    static final LambdaForm.NamedFunction NF_checkBase;
    static final LambdaForm.NamedFunction NF_staticBase;
    static final LambdaForm.NamedFunction NF_staticOffset;
    static final LambdaForm.NamedFunction NF_checkCast;
    static final LambdaForm.NamedFunction NF_allocateInstance;
    static final LambdaForm.NamedFunction NF_constructorMethod;
    static final LambdaForm.NamedFunction NF_UNSAFE;

    private DirectMethodHandle(MethodType mtype, LambdaForm form, MemberName member) {
        super(mtype, form);
        if (!member.isResolved()) {
            throw new InternalError();
        }
        if (member.getDeclaringClass().isInterface() && member.isMethod() && !member.isAbstract()) {
            MemberName m = new MemberName(Object.class, member.getName(), member.getMethodType(), member.getReferenceKind());
            m = MemberName.getFactory().resolveOrNull(m.getReferenceKind(), m, null);
            if (m != null && m.isPublic()) {
                assert (member.getReferenceKind() == m.getReferenceKind());
                member = m;
            }
        }
        this.member = member;
    }

    static DirectMethodHandle make(byte refKind, Class<?> receiver, MemberName member) {
        MethodType mtype = member.getMethodOrFieldType();
        if (!member.isStatic()) {
            if (!member.getDeclaringClass().isAssignableFrom(receiver) || member.isConstructor()) {
                throw new InternalError(member.toString());
            }
            mtype = mtype.insertParameterTypes(0, receiver);
        }
        if (!member.isField()) {
            if (refKind == 7) {
                member = member.asSpecial();
                LambdaForm lform = DirectMethodHandle.preparedLambdaForm(member);
                return new Special(mtype, lform, member);
            }
            LambdaForm lform = DirectMethodHandle.preparedLambdaForm(member);
            return new DirectMethodHandle(mtype, lform, member);
        }
        LambdaForm lform = DirectMethodHandle.preparedFieldLambdaForm(member);
        if (member.isStatic()) {
            long offset = MethodHandleNatives.staticFieldOffset(member);
            Object base = MethodHandleNatives.staticFieldBase(member);
            return new StaticAccessor(mtype, lform, member, base, offset);
        }
        long offset = MethodHandleNatives.objectFieldOffset(member);
        assert (offset == (long)((int)offset));
        return new Accessor(mtype, lform, member, (int)offset);
    }

    static DirectMethodHandle make(Class<?> receiver, MemberName member) {
        byte refKind = member.getReferenceKind();
        if (refKind == 7) {
            refKind = 5;
        }
        return DirectMethodHandle.make(refKind, receiver, member);
    }

    static DirectMethodHandle make(MemberName member) {
        if (member.isConstructor()) {
            return DirectMethodHandle.makeAllocator(member);
        }
        return DirectMethodHandle.make(member.getDeclaringClass(), member);
    }

    private static DirectMethodHandle makeAllocator(MemberName ctor) {
        assert (ctor.isConstructor() && ctor.getName().equals("<init>"));
        Class<?> instanceClass = ctor.getDeclaringClass();
        ctor = ctor.asConstructor();
        assert (ctor.isConstructor() && ctor.getReferenceKind() == 8) : ctor;
        MethodType mtype = ctor.getMethodType().changeReturnType(instanceClass);
        LambdaForm lform = DirectMethodHandle.preparedLambdaForm(ctor);
        MemberName init = ctor.asSpecial();
        assert (init.getMethodType().returnType() == Void.TYPE);
        return new Constructor(mtype, lform, ctor, init, instanceClass);
    }

    @Override
    BoundMethodHandle rebind() {
        return BoundMethodHandle.makeReinvoker(this);
    }

    @Override
    MethodHandle copyWith(MethodType mt, LambdaForm lf) {
        assert (this.getClass() == DirectMethodHandle.class);
        return new DirectMethodHandle(mt, lf, this.member);
    }

    @Override
    String internalProperties() {
        return "\n& DMH.MN=" + this.internalMemberName();
    }

    @Override
    @ForceInline
    MemberName internalMemberName() {
        return this.member;
    }

    private static LambdaForm preparedLambdaForm(MemberName m) {
        int which;
        assert (m.isInvocable()) : m;
        MethodType mtype = m.getInvocationType().basicType();
        assert (!m.isMethodHandleInvoke()) : m;
        switch (m.getReferenceKind()) {
            case 5: {
                which = 0;
                break;
            }
            case 6: {
                which = 1;
                break;
            }
            case 7: {
                which = 2;
                break;
            }
            case 9: {
                which = 4;
                break;
            }
            case 8: {
                which = 3;
                break;
            }
            default: {
                throw new InternalError(m.toString());
            }
        }
        if (which == 1 && DirectMethodHandle.shouldBeInitialized(m)) {
            DirectMethodHandle.preparedLambdaForm(mtype, which);
            which = 5;
        }
        LambdaForm lform = DirectMethodHandle.preparedLambdaForm(mtype, which);
        DirectMethodHandle.maybeCompile(lform, m);
        assert (lform.methodType().dropParameterTypes(0, 1).equals((Object)m.getInvocationType().basicType())) : Arrays.asList(m, m.getInvocationType().basicType(), lform, lform.methodType());
        return lform;
    }

    private static LambdaForm preparedLambdaForm(MethodType mtype, int which) {
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        lform = DirectMethodHandle.makePreparedLambdaForm(mtype, which);
        return mtype.form().setCachedLambdaForm(which, lform);
    }

    static LambdaForm makePreparedLambdaForm(MethodType mtype, int which) {
        int ARG_LIMIT;
        LambdaForm.Kind kind;
        String linkerName;
        boolean needsInit = which == 5;
        boolean doesAlloc = which == 3;
        switch (which) {
            case 0: {
                linkerName = "linkToVirtual";
                kind = LambdaForm.Kind.DIRECT_INVOKE_VIRTUAL;
                break;
            }
            case 1: {
                linkerName = "linkToStatic";
                kind = LambdaForm.Kind.DIRECT_INVOKE_STATIC;
                break;
            }
            case 5: {
                linkerName = "linkToStatic";
                kind = LambdaForm.Kind.DIRECT_INVOKE_STATIC_INIT;
                break;
            }
            case 2: {
                linkerName = "linkToSpecial";
                kind = LambdaForm.Kind.DIRECT_INVOKE_SPECIAL;
                break;
            }
            case 4: {
                linkerName = "linkToInterface";
                kind = LambdaForm.Kind.DIRECT_INVOKE_INTERFACE;
                break;
            }
            case 3: {
                linkerName = "linkToSpecial";
                kind = LambdaForm.Kind.DIRECT_NEW_INVOKE_SPECIAL;
                break;
            }
            default: {
                throw new InternalError("which=" + which);
            }
        }
        MethodType mtypeWithArg = mtype.appendParameterTypes(MemberName.class);
        if (doesAlloc) {
            mtypeWithArg = mtypeWithArg.insertParameterTypes(0, Object.class).changeReturnType(Void.TYPE);
        }
        MemberName linker = new MemberName(MethodHandle.class, linkerName, mtypeWithArg, 6);
        try {
            linker = IMPL_NAMES.resolveOrFail((byte)6, linker, null, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        boolean DMH_THIS = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int NEW_OBJ = doesAlloc ? nameCursor++ : -1;
        int GET_MEMBER = nameCursor++;
        int LINKER_CALL = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        assert (names.length == nameCursor);
        if (doesAlloc) {
            names[NEW_OBJ] = new LambdaForm.Name(NF_allocateInstance, names[0]);
            names[GET_MEMBER] = new LambdaForm.Name(NF_constructorMethod, names[0]);
        } else {
            names[GET_MEMBER] = needsInit ? new LambdaForm.Name(NF_internalMemberNameEnsureInit, names[0]) : new LambdaForm.Name(NF_internalMemberName, names[0]);
        }
        assert (DirectMethodHandle.findDirectMethodHandle(names[GET_MEMBER]) == names[0]);
        Object[] outArgs = Arrays.copyOfRange(names, 1, GET_MEMBER + 1, Object[].class);
        assert (outArgs[outArgs.length - 1] == names[GET_MEMBER]);
        int result = -2;
        if (doesAlloc) {
            assert (outArgs[outArgs.length - 2] == names[NEW_OBJ]);
            System.arraycopy(outArgs, 0, outArgs, 1, outArgs.length - 2);
            outArgs[0] = names[NEW_OBJ];
            result = NEW_OBJ;
        }
        names[LINKER_CALL] = new LambdaForm.Name(linker, outArgs);
        String lambdaName = kind.defaultLambdaName + "_" + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(mtype));
        LambdaForm lform = new LambdaForm(lambdaName, ARG_LIMIT, names, result, kind);
        lform.compileToBytecode();
        return lform;
    }

    static Object findDirectMethodHandle(LambdaForm.Name name) {
        if (name.function == NF_internalMemberName || name.function == NF_internalMemberNameEnsureInit || name.function == NF_constructorMethod) {
            assert (name.arguments.length == 1);
            return name.arguments[0];
        }
        return null;
    }

    private static void maybeCompile(LambdaForm lform, MemberName m) {
        if (lform.vmentry == null && VerifyAccess.isSamePackage(m.getDeclaringClass(), MethodHandle.class)) {
            lform.compileToBytecode();
        }
    }

    @ForceInline
    static Object internalMemberName(Object mh) {
        return ((DirectMethodHandle)mh).member;
    }

    static Object internalMemberNameEnsureInit(Object mh) {
        DirectMethodHandle dmh = (DirectMethodHandle)mh;
        dmh.ensureInitialized();
        return dmh.member;
    }

    static boolean shouldBeInitialized(MemberName member) {
        switch (member.getReferenceKind()) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        Class<?> cls = member.getDeclaringClass();
        if (cls == ValueConversions.class || cls == MethodHandleImpl.class || cls == Invokers.class) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, cls) || VerifyAccess.isSamePackage(ValueConversions.class, cls)) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(cls)) {
                MethodHandleStatics.UNSAFE.ensureClassInitialized(cls);
            }
            return false;
        }
        return MethodHandleStatics.UNSAFE.shouldBeInitialized(cls);
    }

    private void ensureInitialized() {
        if (DirectMethodHandle.checkInitialized(this.member)) {
            if (this.member.isField()) {
                this.updateForm(DirectMethodHandle.preparedFieldLambdaForm(this.member));
            } else {
                this.updateForm(DirectMethodHandle.preparedLambdaForm(this.member));
            }
        }
    }

    private static boolean checkInitialized(MemberName member) {
        Class<?> defc = member.getDeclaringClass();
        WeakReference ref = (WeakReference)EnsureInitialized.INSTANCE.get(defc);
        if (ref == null) {
            return true;
        }
        Thread clinitThread = (Thread)ref.get();
        if (clinitThread == Thread.currentThread()) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(defc)) {
                return false;
            }
        } else {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(defc);
        }
        assert (!MethodHandleStatics.UNSAFE.shouldBeInitialized(defc));
        EnsureInitialized.INSTANCE.remove(defc);
        return true;
    }

    static void ensureInitialized(Object mh) {
        ((DirectMethodHandle)mh).ensureInitialized();
    }

    static Object constructorMethod(Object mh) {
        Constructor dmh = (Constructor)mh;
        return dmh.initMethod;
    }

    static Object allocateInstance(Object mh) throws InstantiationException {
        Constructor dmh = (Constructor)mh;
        return MethodHandleStatics.UNSAFE.allocateInstance(dmh.instanceClass);
    }

    @ForceInline
    static long fieldOffset(Object accessorObj) {
        return ((Accessor)accessorObj).fieldOffset;
    }

    @ForceInline
    static Object checkBase(Object obj) {
        return Objects.requireNonNull(obj);
    }

    @ForceInline
    static Object nullCheck(Object obj) {
        return Objects.requireNonNull(obj);
    }

    @ForceInline
    static Object staticBase(Object accessorObj) {
        return ((StaticAccessor)accessorObj).staticBase;
    }

    @ForceInline
    static long staticOffset(Object accessorObj) {
        return ((StaticAccessor)accessorObj).staticOffset;
    }

    @ForceInline
    static Object checkCast(Object mh, Object obj) {
        return ((DirectMethodHandle)mh).checkCast(obj);
    }

    Object checkCast(Object obj) {
        return this.member.getReturnType().cast(obj);
    }

    private static int afIndex(byte formOp, boolean isVolatile, int ftypeKind) {
        return formOp * 11 * 2 + (isVolatile ? 11 : 0) + ftypeKind;
    }

    static int ftypeKind(Class<?> ftype) {
        if (ftype.isPrimitive()) {
            return Wrapper.forPrimitiveType(ftype).ordinal();
        }
        if (VerifyType.isNullReferenceConversion(Object.class, ftype)) {
            return FT_UNCHECKED_REF;
        }
        return 10;
    }

    private static LambdaForm preparedFieldLambdaForm(MemberName m) {
        byte formOp;
        Class<?> ftype = m.getFieldType();
        boolean isVolatile = m.isVolatile();
        switch (m.getReferenceKind()) {
            case 1: {
                formOp = 0;
                break;
            }
            case 3: {
                formOp = 1;
                break;
            }
            case 2: {
                formOp = 2;
                break;
            }
            case 4: {
                formOp = 3;
                break;
            }
            default: {
                throw new InternalError(m.toString());
            }
        }
        if (DirectMethodHandle.shouldBeInitialized(m)) {
            DirectMethodHandle.preparedFieldLambdaForm(formOp, isVolatile, ftype);
            formOp = (byte)(formOp + 2);
        }
        LambdaForm lform = DirectMethodHandle.preparedFieldLambdaForm(formOp, isVolatile, ftype);
        DirectMethodHandle.maybeCompile(lform, m);
        assert (lform.methodType().dropParameterTypes(0, 1).equals((Object)m.getInvocationType().basicType())) : Arrays.asList(m, m.getInvocationType().basicType(), lform, lform.methodType());
        return lform;
    }

    private static LambdaForm preparedFieldLambdaForm(byte formOp, boolean isVolatile, Class<?> ftype) {
        int ftypeKind = DirectMethodHandle.ftypeKind(ftype);
        int afIndex = DirectMethodHandle.afIndex(formOp, isVolatile, ftypeKind);
        LambdaForm lform = ACCESSOR_FORMS[afIndex];
        if (lform != null) {
            return lform;
        }
        DirectMethodHandle.ACCESSOR_FORMS[afIndex] = lform = DirectMethodHandle.makePreparedFieldLambdaForm(formOp, isVolatile, ftypeKind);
        return lform;
    }

    private static LambdaForm.Kind getFieldKind(boolean isGetter, boolean isVolatile, Wrapper wrapper) {
        if (isGetter) {
            if (isVolatile) {
                switch (wrapper) {
                    case BOOLEAN: {
                        return LambdaForm.Kind.GET_BOOLEAN_VOLATILE;
                    }
                    case BYTE: {
                        return LambdaForm.Kind.GET_BYTE_VOLATILE;
                    }
                    case SHORT: {
                        return LambdaForm.Kind.GET_SHORT_VOLATILE;
                    }
                    case CHAR: {
                        return LambdaForm.Kind.GET_CHAR_VOLATILE;
                    }
                    case INT: {
                        return LambdaForm.Kind.GET_INT_VOLATILE;
                    }
                    case LONG: {
                        return LambdaForm.Kind.GET_LONG_VOLATILE;
                    }
                    case FLOAT: {
                        return LambdaForm.Kind.GET_FLOAT_VOLATILE;
                    }
                    case DOUBLE: {
                        return LambdaForm.Kind.GET_DOUBLE_VOLATILE;
                    }
                    case OBJECT: {
                        return LambdaForm.Kind.GET_OBJECT_VOLATILE;
                    }
                }
            } else {
                switch (wrapper) {
                    case BOOLEAN: {
                        return LambdaForm.Kind.GET_BOOLEAN;
                    }
                    case BYTE: {
                        return LambdaForm.Kind.GET_BYTE;
                    }
                    case SHORT: {
                        return LambdaForm.Kind.GET_SHORT;
                    }
                    case CHAR: {
                        return LambdaForm.Kind.GET_CHAR;
                    }
                    case INT: {
                        return LambdaForm.Kind.GET_INT;
                    }
                    case LONG: {
                        return LambdaForm.Kind.GET_LONG;
                    }
                    case FLOAT: {
                        return LambdaForm.Kind.GET_FLOAT;
                    }
                    case DOUBLE: {
                        return LambdaForm.Kind.GET_DOUBLE;
                    }
                    case OBJECT: {
                        return LambdaForm.Kind.GET_OBJECT;
                    }
                }
            }
        } else if (isVolatile) {
            switch (wrapper) {
                case BOOLEAN: {
                    return LambdaForm.Kind.PUT_BOOLEAN_VOLATILE;
                }
                case BYTE: {
                    return LambdaForm.Kind.PUT_BYTE_VOLATILE;
                }
                case SHORT: {
                    return LambdaForm.Kind.PUT_SHORT_VOLATILE;
                }
                case CHAR: {
                    return LambdaForm.Kind.PUT_CHAR_VOLATILE;
                }
                case INT: {
                    return LambdaForm.Kind.PUT_INT_VOLATILE;
                }
                case LONG: {
                    return LambdaForm.Kind.PUT_LONG_VOLATILE;
                }
                case FLOAT: {
                    return LambdaForm.Kind.PUT_FLOAT_VOLATILE;
                }
                case DOUBLE: {
                    return LambdaForm.Kind.PUT_DOUBLE_VOLATILE;
                }
                case OBJECT: {
                    return LambdaForm.Kind.PUT_OBJECT_VOLATILE;
                }
            }
        } else {
            switch (wrapper) {
                case BOOLEAN: {
                    return LambdaForm.Kind.PUT_BOOLEAN;
                }
                case BYTE: {
                    return LambdaForm.Kind.PUT_BYTE;
                }
                case SHORT: {
                    return LambdaForm.Kind.PUT_SHORT;
                }
                case CHAR: {
                    return LambdaForm.Kind.PUT_CHAR;
                }
                case INT: {
                    return LambdaForm.Kind.PUT_INT;
                }
                case LONG: {
                    return LambdaForm.Kind.PUT_LONG;
                }
                case FLOAT: {
                    return LambdaForm.Kind.PUT_FLOAT;
                }
                case DOUBLE: {
                    return LambdaForm.Kind.PUT_DOUBLE;
                }
                case OBJECT: {
                    return LambdaForm.Kind.PUT_OBJECT;
                }
            }
        }
        throw new AssertionError((Object)"Invalid arguments");
    }

    static LambdaForm makePreparedFieldLambdaForm(byte formOp, boolean isVolatile, int ftypeKind) {
        boolean isGetter = (formOp & 1) == 0;
        boolean isStatic = formOp >= 2;
        boolean needsInit = formOp >= 4;
        boolean needsCast = ftypeKind == 10;
        Wrapper fw = needsCast ? Wrapper.OBJECT : ALL_WRAPPERS[ftypeKind];
        Class<?> ft = fw.primitiveType();
        assert (DirectMethodHandle.ftypeKind(needsCast ? String.class : ft) == ftypeKind);
        LambdaForm.Kind kind = DirectMethodHandle.getFieldKind(isGetter, isVolatile, fw);
        MethodType linkerType = isGetter ? MethodType.methodType(ft, Object.class, Long.TYPE) : MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, ft);
        MemberName linker = new MemberName(Unsafe.class, kind.methodName, linkerType, 5);
        try {
            linker = IMPL_NAMES.resolveOrFail((byte)5, linker, null, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        MethodType mtype = isGetter ? MethodType.methodType(ft) : MethodType.methodType(Void.TYPE, ft);
        mtype = mtype.basicType();
        if (!isStatic) {
            mtype = mtype.insertParameterTypes(0, Object.class);
        }
        boolean DMH_THIS = false;
        boolean ARG_BASE = true;
        int ARG_LIMIT = 1 + mtype.parameterCount();
        int OBJ_BASE = isStatic ? -1 : 1;
        int SET_VALUE = isGetter ? -1 : ARG_LIMIT - 1;
        int nameCursor = ARG_LIMIT;
        int F_HOLDER = isStatic ? nameCursor++ : -1;
        int F_OFFSET = nameCursor++;
        int OBJ_CHECK = OBJ_BASE >= 0 ? nameCursor++ : -1;
        int U_HOLDER = nameCursor++;
        int INIT_BAR = needsInit ? nameCursor++ : -1;
        int PRE_CAST = needsCast && !isGetter ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        int POST_CAST = needsCast && isGetter ? nameCursor++ : -1;
        int RESULT = nameCursor - 1;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        if (needsInit) {
            names[INIT_BAR] = new LambdaForm.Name(NF_ensureInitialized, names[0]);
        }
        if (needsCast && !isGetter) {
            names[PRE_CAST] = new LambdaForm.Name(NF_checkCast, names[0], names[SET_VALUE]);
        }
        Object[] outArgs = new Object[1 + linkerType.parameterCount()];
        assert (outArgs.length == (isGetter ? 3 : 4));
        names[U_HOLDER] = new LambdaForm.Name(NF_UNSAFE, new Object[0]);
        outArgs[0] = names[U_HOLDER];
        if (isStatic) {
            names[F_HOLDER] = new LambdaForm.Name(NF_staticBase, names[0]);
            outArgs[1] = names[F_HOLDER];
            names[F_OFFSET] = new LambdaForm.Name(NF_staticOffset, names[0]);
            outArgs[2] = names[F_OFFSET];
        } else {
            names[OBJ_CHECK] = new LambdaForm.Name(NF_checkBase, names[OBJ_BASE]);
            outArgs[1] = names[OBJ_CHECK];
            names[F_OFFSET] = new LambdaForm.Name(NF_fieldOffset, names[0]);
            outArgs[2] = names[F_OFFSET];
        }
        if (!isGetter) {
            outArgs[3] = needsCast ? names[PRE_CAST] : names[SET_VALUE];
        }
        for (Object a : outArgs) {
            assert (a != null);
        }
        names[LINKER_CALL] = new LambdaForm.Name(linker, outArgs);
        if (needsCast && isGetter) {
            names[POST_CAST] = new LambdaForm.Name(NF_checkCast, names[0], names[LINKER_CALL]);
        }
        for (LambdaForm.Name n : names) {
            assert (n != null);
        }
        StringBuilder nameBuilder = new StringBuilder(kind.methodName);
        if (isStatic) {
            nameBuilder.append("Static");
        } else {
            nameBuilder.append("Field");
        }
        if (needsCast) {
            nameBuilder.append("Cast");
        }
        if (needsInit) {
            nameBuilder.append("Init");
        }
        if (needsCast || needsInit) {
            return new LambdaForm(nameBuilder.toString(), ARG_LIMIT, names, RESULT);
        }
        return new LambdaForm(nameBuilder.toString(), ARG_LIMIT, names, RESULT, kind);
    }

    static {
        try {
            NF_internalMemberName = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("internalMemberName", Object.class));
            LambdaForm.NamedFunction[] nfs = new LambdaForm.NamedFunction[]{NF_internalMemberName, NF_internalMemberNameEnsureInit = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("internalMemberNameEnsureInit", Object.class)), NF_ensureInitialized = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("ensureInitialized", Object.class)), NF_fieldOffset = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("fieldOffset", Object.class)), NF_checkBase = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("checkBase", Object.class)), NF_staticBase = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("staticBase", Object.class)), NF_staticOffset = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("staticOffset", Object.class)), NF_checkCast = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("checkCast", Object.class, Object.class)), NF_allocateInstance = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("allocateInstance", Object.class)), NF_constructorMethod = new LambdaForm.NamedFunction(DirectMethodHandle.class.getDeclaredMethod("constructorMethod", Object.class)), NF_UNSAFE = new LambdaForm.NamedFunction(new MemberName(MethodHandleStatics.class.getDeclaredField("UNSAFE")))};
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(nfs));
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        MethodHandleStatics.UNSAFE.ensureClassInitialized(Holder.class);
    }

    final class Holder {
        Holder() {
        }
    }

    static class StaticAccessor
    extends DirectMethodHandle {
        private final Class<?> fieldType;
        private final Object staticBase;
        private final long staticOffset;

        private StaticAccessor(MethodType mtype, LambdaForm form, MemberName member, Object staticBase, long staticOffset) {
            super(mtype, form, member);
            this.fieldType = member.getFieldType();
            this.staticBase = staticBase;
            this.staticOffset = staticOffset;
        }

        @Override
        Object checkCast(Object obj) {
            return this.fieldType.cast(obj);
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new StaticAccessor(mt, lf, this.member, this.staticBase, this.staticOffset);
        }
    }

    static class Accessor
    extends DirectMethodHandle {
        final Class<?> fieldType;
        final int fieldOffset;

        private Accessor(MethodType mtype, LambdaForm form, MemberName member, int fieldOffset) {
            super(mtype, form, member);
            this.fieldType = member.getFieldType();
            this.fieldOffset = fieldOffset;
        }

        @Override
        Object checkCast(Object obj) {
            return this.fieldType.cast(obj);
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Accessor(mt, lf, this.member, this.fieldOffset);
        }
    }

    static class Constructor
    extends DirectMethodHandle {
        final MemberName initMethod;
        final Class<?> instanceClass;

        private Constructor(MethodType mtype, LambdaForm form, MemberName constructor, MemberName initMethod, Class<?> instanceClass) {
            super(mtype, form, constructor);
            this.initMethod = initMethod;
            this.instanceClass = instanceClass;
            assert (initMethod.isResolved());
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Constructor(mt, lf, this.member, this.initMethod, this.instanceClass);
        }
    }

    static class Special
    extends DirectMethodHandle {
        private Special(MethodType mtype, LambdaForm form, MemberName member) {
            super(mtype, form, member);
        }

        @Override
        boolean isInvokeSpecial() {
            return true;
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Special(mt, lf, this.member);
        }
    }

    private static class EnsureInitialized
    extends ClassValue<WeakReference<Thread>> {
        static final EnsureInitialized INSTANCE = new EnsureInitialized();

        private EnsureInitialized() {
        }

        @Override
        protected WeakReference<Thread> computeValue(Class<?> type) {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(type);
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(type)) {
                return new WeakReference<Thread>(Thread.currentThread());
            }
            return null;
        }
    }
}

