/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class VersionProps {
    private static final String launcher_name = "java";
    private static final String java_version = "9-ea";
    private static final String java_runtime_name = "Java(TM) SE Runtime Environment";
    private static final String java_runtime_version = "9-ea+154";
    private static final String VERSION_NUMBER = "9";
    private static final String VERSION_BUILD = "154";
    private static final String VERSION_PRE = "ea";
    private static final String VERSION_OPT = "";

    VersionProps() {
    }

    public static void init() {
        System.setProperty("java.version", java_version);
        System.setProperty("java.runtime.version", java_runtime_version);
        System.setProperty("java.runtime.name", java_runtime_name);
    }

    private static int parseVersionNumber(String version, int prevIndex, int index) {
        if (index - prevIndex > 1 && Character.digit(version.charAt(prevIndex), 10) <= 0) {
            throw new IllegalArgumentException("Leading zeros not supported (" + version.substring(prevIndex, index) + ")");
        }
        return Integer.parseInt(version, prevIndex, index, 10);
    }

    static List<Integer> parseVersionNumbers(String version) {
        ArrayList<Integer> verNumbers = new ArrayList<Integer>(4);
        int prevIndex = 0;
        int index = version.indexOf(46);
        while (index > 0) {
            verNumbers.add(VersionProps.parseVersionNumber(version, prevIndex, index));
            prevIndex = index + 1;
            index = version.indexOf(46, prevIndex);
        }
        verNumbers.add(VersionProps.parseVersionNumber(version, prevIndex, version.length()));
        if ((Integer)verNumbers.get(0) == 0 || (Integer)verNumbers.get(verNumbers.size() - 1) == 0) {
            throw new IllegalArgumentException("Leading/trailing zeros not supported (" + verNumbers + ")");
        }
        return verNumbers;
    }

    static List<Integer> versionNumbers() {
        return VersionProps.parseVersionNumbers(VERSION_NUMBER);
    }

    static Optional<String> pre() {
        return VersionProps.optionalOf(VERSION_PRE);
    }

    static Optional<Integer> build() {
        return VERSION_BUILD.isEmpty() ? Optional.empty() : Optional.of(Integer.parseInt(VERSION_BUILD));
    }

    static Optional<String> optional() {
        return VersionProps.optionalOf(VERSION_OPT);
    }

    private static Optional<String> optionalOf(String value) {
        if (!value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static void print(boolean err) {
        VersionProps.print(err, false);
    }

    public static void println(boolean err) {
        VersionProps.print(err, true);
    }

    private static void print(boolean err, boolean newln) {
        boolean isHeadless = false;
        PrintStream ps = err ? System.err : System.out;
        String headless = System.getProperty("java.awt.headless");
        if (headless != null && headless.equalsIgnoreCase("true")) {
            isHeadless = true;
        }
        if (err) {
            ps.println("java version \"9-ea\"");
        } else {
            ps.println("java 9-ea");
        }
        String jdk_debug_level = System.getProperty("jdk.debug", "release");
        jdk_debug_level = "release".equals(jdk_debug_level) ? VERSION_OPT : jdk_debug_level + " ";
        ps.print("Java(TM) SE Runtime Environment (" + jdk_debug_level + "build " + java_runtime_version);
        ps.println(')');
        String java_vm_name = System.getProperty("java.vm.name");
        String java_vm_version = System.getProperty("java.vm.version");
        String java_vm_info = System.getProperty("java.vm.info");
        ps.println(java_vm_name + " (" + jdk_debug_level + "build " + java_vm_version + ", " + java_vm_info + ")");
    }

    static {
        VersionProps.init();
    }
}

