/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Layer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Module;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.logger.LazyLoggers;
import jdk.internal.logger.LocalizedLoggerWrapper;
import jdk.internal.logger.LoggerFinderLoader;
import jdk.internal.misc.JavaLangAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleBootstrap;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.ConstantPool;
import jdk.internal.reflect.Reflection;
import sun.nio.ch.Interruptible;
import sun.reflect.annotation.AnnotationType;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static volatile SecurityManager security;
    private static volatile Console cons;
    private static Properties props;
    private static String lineSeparator;
    private static Layer bootLayer;

    private static native void registerNatives();

    private System() {
    }

    public static void setIn(InputStream in) {
        System.checkIO();
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        System.checkIO();
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        System.checkIO();
        System.setErr0(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Console console() {
        Console c = cons;
        if (c != null) return c;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            c = cons;
            if (c != null) return c;
            cons = c = SharedSecrets.getJavaIOAccess().console();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return c;
        }
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static void checkIO() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    public static void setSecurityManager(SecurityManager s) {
        if (s != null) {
            try {
                s.checkPackageAccess("java.lang");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.setSecurityManager0(s);
    }

    private static synchronized void setSecurityManager0(final SecurityManager s) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (s != null && s.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    s.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = s;
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    @HotSpotIntrinsicCandidate
    public static native long currentTimeMillis();

    @HotSpotIntrinsicCandidate
    public static native long nanoTime();

    @HotSpotIntrinsicCandidate
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    @HotSpotIntrinsicCandidate
    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return props;
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void setProperties(Properties props) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (props == null) {
            props = new Properties();
            System.initProperties(props);
        }
        System.props = props;
    }

    public static String getProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.setProperty(key, value);
    }

    public static String clearProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.remove(key);
    }

    private static void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (key.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static String getenv(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv." + name));
        }
        return ProcessEnvironment.getenv(name);
    }

    public static Map<String, String> getenv() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    @CallerSensitive
    public static Logger getLogger(String name) {
        Objects.requireNonNull(name);
        Class<?> caller = Reflection.getCallerClass();
        return LazyLoggers.getLogger((String)name, (Module)caller.getModule());
    }

    @CallerSensitive
    public static Logger getLogger(String name, ResourceBundle bundle) {
        ResourceBundle rb = Objects.requireNonNull(bundle);
        Objects.requireNonNull(name);
        Class<?> caller = Reflection.getCallerClass();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            PrivilegedAction<Logger> pa = () -> LoggerFinder.accessProvider().getLocalizedLogger(name, rb, caller.getModule());
            return AccessController.doPrivileged(pa, null, LoggerFinder.LOGGERFINDER_PERMISSION);
        }
        return LoggerFinder.accessProvider().getLocalizedLogger(name, rb, caller.getModule());
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated(since="1.2", forRemoval=true)
    public static void runFinalizersOnExit(boolean value) {
        Runtime.runFinalizersOnExit(value);
    }

    @CallerSensitive
    public static void load(String filename) {
        Runtime.getRuntime().load0(Reflection.getCallerClass(), filename);
    }

    @CallerSensitive
    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary0(Reflection.getCallerClass(), libname);
    }

    public static native String mapLibraryName(String var0);

    private static PrintStream newPrintStream(FileOutputStream fos, String enc) {
        if (enc != null) {
            try {
                return new PrintStream(new BufferedOutputStream(fos, 128), true, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new PrintStream(new BufferedOutputStream(fos, 128), true);
    }

    private static void initPhase1() {
        props = new Properties();
        System.initProperties(props);
        VM.saveAndRemoveProperties((Properties)props);
        lineSeparator = props.getProperty("line.separator");
        VersionProps.init();
        FileInputStream fdIn = new FileInputStream(FileDescriptor.in);
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fdIn));
        System.setOut0(System.newPrintStream(fdOut, props.getProperty("sun.stdout.encoding")));
        System.setErr0(System.newPrintStream(fdErr, props.getProperty("sun.stderr.encoding")));
        System.loadLibrary("zip");
        Terminator.setup();
        VM.initializeOSEnvironment();
        Thread current = Thread.currentThread();
        current.getThreadGroup().add(current);
        System.setJavaLangAccess();
        VM.initLevel(1);
    }

    private static void initPhase2() {
        bootLayer = ModuleBootstrap.boot();
        VM.initLevel(2);
    }

    private static void initPhase3() {
        MethodHandles.publicLookup();
        String cn = System.getProperty("java.security.manager");
        if (cn != null) {
            if (cn.isEmpty() || "default".equals(cn)) {
                System.setSecurityManager(new SecurityManager());
            } else {
                try {
                    Class<?> c = Class.forName(cn, false, ClassLoader.getBuiltinAppClassLoader());
                    Constructor<?> ctor = c.getConstructor(new Class[0]);
                    if (!(SecurityManager.class.isAssignableFrom(c) && Modifier.isPublic(c.getModifiers()) && Modifier.isPublic(ctor.getModifiers()))) {
                        throw new Error("Could not create SecurityManager: " + ctor.toString());
                    }
                    ctor.setAccessible(true);
                    SecurityManager sm = (SecurityManager)ctor.newInstance(new Object[0]);
                    System.setSecurityManager(sm);
                }
                catch (Exception e) {
                    throw new Error("Could not create SecurityManager", e);
                }
            }
        }
        VM.initLevel(3);
        ClassLoader scl = ClassLoader.initSystemClassLoader();
        Thread.currentThread().setContextClassLoader(scl);
        VM.initLevel(4);
    }

    private static void setJavaLangAccess() {
        SharedSecrets.setJavaLangAccess((JavaLangAccess)new JavaLangAccess(){

            public Method getMethodOrNull(Class<?> klass, String name, Class<?> ... parameterTypes) {
                return klass.getMethodOrNull(name, parameterTypes);
            }

            public ConstantPool getConstantPool(Class<?> klass) {
                return klass.getConstantPool();
            }

            public boolean casAnnotationType(Class<?> klass, AnnotationType oldType, AnnotationType newType) {
                return klass.casAnnotationType(oldType, newType);
            }

            public AnnotationType getAnnotationType(Class<?> klass) {
                return klass.getAnnotationType();
            }

            public Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap(Class<?> klass) {
                return klass.getDeclaredAnnotationMap();
            }

            public byte[] getRawClassAnnotations(Class<?> klass) {
                return klass.getRawAnnotations();
            }

            public byte[] getRawClassTypeAnnotations(Class<?> klass) {
                return klass.getRawTypeAnnotations();
            }

            public byte[] getRawExecutableTypeAnnotations(Executable executable) {
                return Class.getExecutableTypeAnnotationBytes(executable);
            }

            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> klass) {
                return (Enum[])klass.getEnumConstantsShared();
            }

            public void blockedOn(Thread t, Interruptible b) {
                t.blockedOn(b);
            }

            public void registerShutdownHook(int slot, boolean registerShutdownInProgress, Runnable hook) {
                Shutdown.add(slot, registerShutdownInProgress, hook);
            }

            public String newStringUnsafe(char[] chars) {
                return new String(chars, true);
            }

            public Thread newThreadWithAcc(Runnable target, AccessControlContext acc) {
                return new Thread(target, acc);
            }

            public void invokeFinalize(Object o) throws Throwable {
                o.finalize();
            }

            public Layer getBootLayer() {
                return bootLayer;
            }

            public ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap(ClassLoader cl) {
                return cl.createOrGetClassLoaderValueMap();
            }

            public Class<?> findBootstrapClassOrNull(ClassLoader cl, String name) {
                return cl.findBootstrapClassOrNull(name);
            }

            public URL findResource(ClassLoader cl, String mn, String name) throws IOException {
                return cl.findResource(mn, name);
            }

            public Stream<Package> packages(ClassLoader cl) {
                return cl.packages();
            }

            public Package definePackage(ClassLoader cl, String name, Module module) {
                return cl.definePackage(name, module);
            }

            public String fastUUID(long lsb, long msb) {
                return Long.fastUUID(lsb, msb);
            }
        });
    }

    static {
        System.registerNatives();
        in = null;
        out = null;
        err = null;
    }

    public static abstract class LoggerFinder {
        static final RuntimePermission LOGGERFINDER_PERMISSION = new RuntimePermission("loggerFinder");
        private static volatile LoggerFinder service;

        protected LoggerFinder() {
            this(LoggerFinder.checkPermission());
        }

        private LoggerFinder(Void unused) {
        }

        private static Void checkPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(LOGGERFINDER_PERMISSION);
            }
            return null;
        }

        public abstract Logger getLogger(String var1, Module var2);

        public Logger getLocalizedLogger(String name, ResourceBundle bundle, Module module) {
            return new LocalizedLoggerWrapper<Logger>(this.getLogger(name, module), bundle);
        }

        public static LoggerFinder getLoggerFinder() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(LOGGERFINDER_PERMISSION);
            }
            return LoggerFinder.accessProvider();
        }

        static LoggerFinder accessProvider() {
            if (service == null) {
                PrivilegedAction<LoggerFinder> pa = () -> LoggerFinderLoader.getLoggerFinder();
                service = AccessController.doPrivileged(pa, null, LOGGERFINDER_PERMISSION);
            }
            return service;
        }
    }

    public static interface Logger {
        public String getName();

        public boolean isLoggable(Level var1);

        default public void log(Level level, String msg) {
            this.log(level, (ResourceBundle)null, msg, (Object[])null);
        }

        default public void log(Level level, Supplier<String> msgSupplier) {
            Objects.requireNonNull(msgSupplier);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, (ResourceBundle)null, msgSupplier.get(), (Object[])null);
            }
        }

        default public void log(Level level, Object obj) {
            Objects.requireNonNull(obj);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, (ResourceBundle)null, obj.toString(), (Object[])null);
            }
        }

        default public void log(Level level, String msg, Throwable thrown) {
            this.log(level, null, msg, thrown);
        }

        default public void log(Level level, Supplier<String> msgSupplier, Throwable thrown) {
            Objects.requireNonNull(msgSupplier);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, null, msgSupplier.get(), thrown);
            }
        }

        default public void log(Level level, String format, Object ... params) {
            this.log(level, null, format, params);
        }

        public void log(Level var1, ResourceBundle var2, String var3, Throwable var4);

        public void log(Level var1, ResourceBundle var2, String var3, Object ... var4);

        public static enum Level {
            ALL(Integer.MIN_VALUE),
            TRACE(400),
            DEBUG(500),
            INFO(800),
            WARNING(900),
            ERROR(1000),
            OFF(Integer.MAX_VALUE);

            private final int severity;

            private Level(int severity) {
                this.severity = severity;
            }

            public final String getName() {
                return this.name();
            }

            public final int getSeverity() {
                return this.severity;
            }
        }
    }
}

