/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import jdk.internal.HotSpotIntrinsicCandidate;

final class StringUTF16 {
    static final int HI_BYTE_SHIFT;
    static final int LO_BYTE_SHIFT;
    static final int MAX_LENGTH = 0x3FFFFFFF;

    StringUTF16() {
    }

    public static byte[] newBytesFor(int len) {
        if (len < 0) {
            throw new NegativeArraySizeException();
        }
        if (len > 0x3FFFFFFF) {
            throw new OutOfMemoryError("UTF16 String size is " + len + ", should be less than " + 0x3FFFFFFF);
        }
        return new byte[len << 1];
    }

    @HotSpotIntrinsicCandidate
    public static void putChar(byte[] val, int index, int c) {
        index <<= 1;
        val[index++] = (byte)(c >> HI_BYTE_SHIFT);
        val[index] = (byte)(c >> LO_BYTE_SHIFT);
    }

    @HotSpotIntrinsicCandidate
    public static char getChar(byte[] val, int index) {
        index <<= 1;
        return (char)((val[index++] & 0xFF) << HI_BYTE_SHIFT | (val[index] & 0xFF) << LO_BYTE_SHIFT);
    }

    public static char charAt(byte[] value, int index) {
        if (index < 0 || index >= value.length >> 1) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return StringUTF16.getChar(value, index);
    }

    public static int length(byte[] value) {
        return value.length >> 1;
    }

    public static int codePointAt(byte[] value, int index, int end) {
        char c2;
        char c1 = StringUTF16.getChar(value, index);
        if (Character.isHighSurrogate(c1) && ++index < end && Character.isLowSurrogate(c2 = StringUTF16.getChar(value, index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public static int codePointBefore(byte[] value, int index) {
        char c1;
        char c2;
        if (Character.isLowSurrogate(c2 = StringUTF16.getChar(value, --index)) && index > 0 && Character.isHighSurrogate(c1 = StringUTF16.getChar(value, --index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c2;
    }

    public static int codePointCount(byte[] value, int beginIndex, int endIndex) {
        int count = endIndex - beginIndex;
        int i = beginIndex;
        while (i < endIndex) {
            if (!Character.isHighSurrogate(StringUTF16.getChar(value, i++)) || i >= endIndex || !Character.isLowSurrogate(StringUTF16.getChar(value, i))) continue;
            --count;
            ++i;
        }
        return count;
    }

    public static char[] toChars(byte[] value) {
        char[] dst = new char[value.length >> 1];
        StringUTF16.getChars(value, 0, dst.length, dst, 0);
        return dst;
    }

    @HotSpotIntrinsicCandidate
    public static byte[] toBytes(char[] value, int off, int len) {
        byte[] val = StringUTF16.newBytesFor(len);
        for (int i = 0; i < len; ++i) {
            StringUTF16.putChar(val, i, value[off]);
            ++off;
        }
        return val;
    }

    public static byte[] compress(char[] val, int off, int len) {
        byte[] ret = new byte[len];
        if (StringUTF16.compress(val, off, ret, 0, len) == len) {
            return ret;
        }
        return null;
    }

    public static byte[] compress(byte[] val, int off, int len) {
        byte[] ret = new byte[len];
        if (StringUTF16.compress(val, off, ret, 0, len) == len) {
            return ret;
        }
        return null;
    }

    @HotSpotIntrinsicCandidate
    public static int compress(char[] src, int srcOff, byte[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            char c = src[srcOff];
            if (c > '\u00ff') {
                len = 0;
                break;
            }
            dst[dstOff] = (byte)c;
            ++srcOff;
            ++dstOff;
        }
        return len;
    }

    @HotSpotIntrinsicCandidate
    public static int compress(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        String.checkBoundsOffCount(srcOff << 1, len << 1, src.length);
        for (int i = 0; i < len; ++i) {
            char c = StringUTF16.getChar(src, srcOff);
            if (c > '\u00ff') {
                len = 0;
                break;
            }
            dst[dstOff] = (byte)c;
            ++srcOff;
            ++dstOff;
        }
        return len;
    }

    public static byte[] toBytes(int[] val, int index, int len) {
        int end = index + len;
        int n = len;
        for (int i = index; i < end; ++i) {
            int cp = val[i];
            if (Character.isBmpCodePoint(cp)) continue;
            if (Character.isValidCodePoint(cp)) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(cp));
        }
        byte[] buf = StringUTF16.newBytesFor(n);
        int i = index;
        int j = 0;
        while (i < end) {
            int cp = val[i];
            if (Character.isBmpCodePoint(cp)) {
                StringUTF16.putChar(buf, j, cp);
            } else {
                StringUTF16.putChar(buf, j++, Character.highSurrogate(cp));
                StringUTF16.putChar(buf, j, Character.lowSurrogate(cp));
            }
            ++i;
            ++j;
        }
        return buf;
    }

    public static byte[] toBytes(char c) {
        byte[] result = new byte[2];
        StringUTF16.putChar(result, 0, c);
        return result;
    }

    @HotSpotIntrinsicCandidate
    public static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < srcEnd) {
            String.checkBoundsOffCount(srcBegin << 1, srcEnd - srcBegin << 1, value.length);
        }
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[dstBegin++] = StringUTF16.getChar(value, i);
        }
    }

    public static void getBytes(byte[] value, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        srcEnd <<= 1;
        for (int i = (srcBegin <<= 1) + (1 >> LO_BYTE_SHIFT); i < srcEnd; i += 2) {
            dst[dstBegin++] = value[i];
        }
    }

    @HotSpotIntrinsicCandidate
    public static boolean equals(byte[] value, byte[] other) {
        if (value.length == other.length) {
            int len = value.length >> 1;
            for (int i = 0; i < len; ++i) {
                if (StringUTF16.getChar(value, i) == StringUTF16.getChar(other, i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @HotSpotIntrinsicCandidate
    public static int compareTo(byte[] value, byte[] other) {
        int len1 = StringUTF16.length(value);
        int len2 = StringUTF16.length(other);
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringUTF16.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @HotSpotIntrinsicCandidate
    public static int compareToLatin1(byte[] value, byte[] other) {
        return -StringLatin1.compareToUTF16(other, value);
    }

    public static int compareToCI(byte[] value, byte[] other) {
        int len1 = StringUTF16.length(value);
        int len2 = StringUTF16.length(other);
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringUTF16.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compareToCI_Latin1(byte[] value, byte[] other) {
        return -StringLatin1.compareToCI_UTF16(other, value);
    }

    public static int hashCode(byte[] value) {
        int h = 0;
        int length = value.length >> 1;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + StringUTF16.getChar(value, i);
        }
        return h;
    }

    public static int indexOf(byte[] value, int ch, int fromIndex) {
        int max = value.length >> 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        if (ch < 65536) {
            return StringUTF16.indexOfChar(value, ch, fromIndex, max);
        }
        return StringUTF16.indexOfSupplementary(value, ch, fromIndex, max);
    }

    @HotSpotIntrinsicCandidate
    public static int indexOf(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length == 0) {
            return -1;
        }
        return StringUTF16.indexOf(value, StringUTF16.length(value), str, StringUTF16.length(str), 0);
    }

    @HotSpotIntrinsicCandidate
    public static int indexOf(byte[] value, int valueCount, byte[] str, int strCount, int fromIndex) {
        char first = StringUTF16.getChar(str, 0);
        int max = valueCount - strCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (StringUTF16.getChar(value, i) != first) {
                while (++i <= max && StringUTF16.getChar(value, i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + strCount - 1;
            int k = 1;
            while (j < end && StringUTF16.getChar(value, j) == StringUTF16.getChar(str, k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @HotSpotIntrinsicCandidate
    public static int indexOfLatin1(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(value, StringUTF16.length(value), str, str.length, 0);
    }

    @HotSpotIntrinsicCandidate
    public static int indexOfLatin1(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        char first = (char)(tgt[0] & 0xFF);
        int max = srcCount - tgtCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (StringUTF16.getChar(src, i) != first) {
                while (++i <= max && StringUTF16.getChar(src, i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + tgtCount - 1;
            int k = 1;
            while (j < end && StringUTF16.getChar(src, j) == (tgt[k] & 0xFF)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @HotSpotIntrinsicCandidate
    private static int indexOfChar(byte[] value, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (StringUTF16.getChar(value, i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfSupplementary(byte[] value, int ch, int fromIndex, int max) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = fromIndex; i < max - 1; ++i) {
                if (StringUTF16.getChar(value, i) != hi || StringUTF16.getChar(value, i + 1) != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        int start;
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        char strLastChar = StringUTF16.getChar(tgt, strLastIndex);
        block0: while (true) {
            if (i >= min && StringUTF16.getChar(src, i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if (StringUTF16.getChar(src, j--) == StringUTF16.getChar(tgt, k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(byte[] value, int ch, int fromIndex) {
        if (ch < 65536) {
            for (int i = Math.min(fromIndex, (value.length >> 1) - 1); i >= 0; --i) {
                if (StringUTF16.getChar(value, i) != ch) continue;
                return i;
            }
            return -1;
        }
        return StringUTF16.lastIndexOfSupplementary(value, ch, fromIndex);
    }

    private static int lastIndexOfSupplementary(byte[] value, int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = Math.min(fromIndex, (value.length >> 1) - 2); i >= 0; --i) {
                if (StringUTF16.getChar(value, i) != hi || StringUTF16.getChar(value, i + 1) != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public static String replace(byte[] value, char oldChar, char newChar) {
        int len = value.length >> 1;
        int i = -1;
        while (++i < len && StringUTF16.getChar(value, i) != oldChar) {
        }
        if (i < len) {
            byte[] val;
            byte[] buf = new byte[value.length];
            for (int j = 0; j < i; ++j) {
                StringUTF16.putChar(buf, j, StringUTF16.getChar(value, j));
            }
            while (i < len) {
                char c = StringUTF16.getChar(value, i);
                StringUTF16.putChar(buf, i, c == oldChar ? newChar : c);
                ++i;
            }
            if (String.COMPACT_STRINGS && !StringLatin1.canEncode(oldChar) && StringLatin1.canEncode(newChar) && (val = StringUTF16.compress(buf, 0, len)) != null) {
                return new String(val, 0);
            }
            return new String(buf, 1);
        }
        return null;
    }

    public static boolean regionMatchesCI(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        int last = toffset + len;
        while (toffset < last) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = StringUTF16.getChar(value, toffset++)) == (c2 = StringUTF16.getChar(other, ooffset++)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesCI_Latin1(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        return StringLatin1.regionMatchesCI_UTF16(other, ooffset, value, toffset, len);
    }

    public static String toLowerCase(String str, byte[] value, Locale locale) {
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean hasSurr = false;
        int len = value.length >> 1;
        for (first = 0; first < len; ++first) {
            char cp = StringUTF16.getChar(value, first);
            if (Character.isSurrogate(cp)) {
                hasSurr = true;
                break;
            }
            if (cp != Character.toLowerCase((int)cp)) break;
        }
        if (first == len) {
            return str;
        }
        byte[] result = new byte[value.length];
        System.arraycopy(value, 0, result, 0, first << 1);
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringUTF16.toLowerCaseEx(str, value, result, first, locale, true);
        }
        if (hasSurr) {
            return StringUTF16.toLowerCaseEx(str, value, result, first, locale, false);
        }
        int bits = 0;
        for (int i = first; i < len; ++i) {
            int cp = StringUTF16.getChar(value, i);
            if (cp == 931 || Character.isSurrogate((char)cp)) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, false);
            }
            if (cp == 304) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, true);
            }
            if (!Character.isBmpCodePoint(cp = Character.toLowerCase(cp))) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, false);
            }
            bits |= cp;
            StringUTF16.putChar(result, i, cp);
        }
        if (bits > 255) {
            return new String(result, 1);
        }
        return StringUTF16.newString(result, 0, len);
    }

    private static String toLowerCaseEx(String str, byte[] value, byte[] result, int first, Locale locale, boolean localeDependent) {
        int srcCount;
        int resultOffset = first;
        int length = value.length >> 1;
        for (int i = first; i < length; i += srcCount) {
            int lowerChar;
            int srcChar = StringUTF16.getChar(value, i);
            srcCount = 1;
            if (Character.isSurrogate((char)srcChar)) {
                srcChar = StringUTF16.codePointAt(value, i, length);
                srcCount = Character.charCount(srcChar);
            }
            if (Character.isBmpCodePoint(lowerChar = localeDependent || srcChar == 931 || srcChar == 304 ? ConditionalSpecialCasing.toLowerCaseEx(str, i, locale) : Character.toLowerCase(srcChar))) {
                StringUTF16.putChar(result, resultOffset++, lowerChar);
                continue;
            }
            char[] lowerCharArray = lowerChar == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(str, i, locale) : Character.toChars(lowerChar);
            int mapLen = lowerCharArray.length;
            if (mapLen > srcCount) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - srcCount);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, lowerCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String toUpperCase(String str, byte[] value, Locale locale) {
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean hasSurr = false;
        int len = value.length >> 1;
        for (first = 0; first < len; ++first) {
            char cp = StringUTF16.getChar(value, first);
            if (Character.isSurrogate(cp)) {
                hasSurr = true;
                break;
            }
            if (cp != Character.toUpperCaseEx(cp)) break;
        }
        if (first == len) {
            return str;
        }
        byte[] result = new byte[value.length];
        System.arraycopy(value, 0, result, 0, first << 1);
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringUTF16.toUpperCaseEx(str, value, result, first, locale, true);
        }
        if (hasSurr) {
            return StringUTF16.toUpperCaseEx(str, value, result, first, locale, false);
        }
        int bits = 0;
        for (int i = first; i < len; ++i) {
            int cp = StringUTF16.getChar(value, i);
            if (Character.isSurrogate((char)cp)) {
                return StringUTF16.toUpperCaseEx(str, value, result, i, locale, false);
            }
            if (!Character.isBmpCodePoint(cp = Character.toUpperCaseEx(cp))) {
                return StringUTF16.toUpperCaseEx(str, value, result, i, locale, false);
            }
            bits |= cp;
            StringUTF16.putChar(result, i, cp);
        }
        if (bits > 255) {
            return new String(result, 1);
        }
        return StringUTF16.newString(result, 0, len);
    }

    private static String toUpperCaseEx(String str, byte[] value, byte[] result, int first, Locale locale, boolean localeDependent) {
        int srcCount;
        int resultOffset = first;
        int length = value.length >> 1;
        for (int i = first; i < length; i += srcCount) {
            int upperChar;
            int srcChar = StringUTF16.getChar(value, i);
            srcCount = 1;
            if (Character.isSurrogate((char)srcChar)) {
                srcChar = StringUTF16.codePointAt(value, i, length);
                srcCount = Character.charCount(srcChar);
            }
            if (Character.isBmpCodePoint(upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(str, i, locale) : Character.toUpperCaseEx(srcChar))) {
                StringUTF16.putChar(result, resultOffset++, upperChar);
                continue;
            }
            char[] upperCharArray = upperChar == -1 ? (localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(str, i, locale) : Character.toUpperCaseCharArray(srcChar)) : Character.toChars(upperChar);
            int mapLen = upperCharArray.length;
            if (mapLen > srcCount) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - srcCount);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, upperCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String trim(byte[] value) {
        int st;
        int length;
        int len = length = value.length >> 1;
        for (st = 0; st < len && StringUTF16.getChar(value, st) <= ' '; ++st) {
        }
        while (st < len && StringUTF16.getChar(value, len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < length ? new String(Arrays.copyOfRange(value, st << 1, len << 1), 1) : null;
    }

    public static void putChars(byte[] val, int index, char[] str, int off, int end) {
        while (off < end) {
            StringUTF16.putChar(val, index++, str[off++]);
        }
    }

    public static String newString(byte[] val, int index, int len) {
        byte[] buf;
        if (String.COMPACT_STRINGS && (buf = StringUTF16.compress(val, index, len)) != null) {
            return new String(buf, 0);
        }
        int last = index + len;
        return new String(Arrays.copyOfRange(val, index << 1, last << 1), 1);
    }

    public static void fillNull(byte[] val, int index, int end) {
        Arrays.fill(val, index << 1, end << 1, (byte)0);
    }

    public static void putCharSB(byte[] val, int index, int c) {
        String.checkIndex(index, val.length >> 1);
        StringUTF16.putChar(val, index, c);
    }

    public static void putCharsSB(byte[] val, int index, char[] ca, int off, int end) {
        String.checkOffset(index + end - off, val.length >> 1);
        StringUTF16.putChars(val, index, ca, off, end);
    }

    public static void putCharsSB(byte[] val, int index, CharSequence s, int off, int end) {
        String.checkOffset(index + end - off, val.length >> 1);
        for (int i = off; i < end; ++i) {
            StringUTF16.putChar(val, index++, s.charAt(i));
        }
    }

    public static int codePointAtSB(byte[] val, int index, int end) {
        String.checkOffset(end, val.length >> 1);
        return StringUTF16.codePointAt(val, index, end);
    }

    public static int codePointBeforeSB(byte[] val, int index) {
        String.checkOffset(index, val.length >> 1);
        return StringUTF16.codePointBefore(val, index);
    }

    public static int codePointCountSB(byte[] val, int beginIndex, int endIndex) {
        String.checkOffset(endIndex, val.length >> 1);
        return StringUTF16.codePointCount(val, beginIndex, endIndex);
    }

    private static native boolean isBigEndian();

    static {
        if (StringUTF16.isBigEndian()) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
    }

    static class CodePointsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CodePointsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length >> 1, acs);
        }

        CodePointsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int midOneLess;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (Character.isLowSurrogate(StringUTF16.charAt(this.array, mid)) && Character.isHighSurrogate(StringUTF16.charAt(this.array, midOneLess = mid - 1))) {
                if (lo >= midOneLess) {
                    return null;
                }
                this.index = midOneLess;
                return new CodePointsSpliterator(this.array, lo, this.index, this.cs);
            }
            this.index = mid;
            return new CodePointsSpliterator(this.array, lo, this.index, this.cs);
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >> 1 >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                while ((i = CodePointsSpliterator.advance(a, i, hi, action)) < hi) {
                }
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                this.index = CodePointsSpliterator.advance(this.array, this.index, this.fence, action);
                return true;
            }
            return false;
        }

        private static int advance(byte[] a, int i, int hi, IntConsumer action) {
            char c2;
            int c1;
            int cp = c1 = StringUTF16.charAt(a, i++);
            if (Character.isHighSurrogate((char)c1) && i < hi && Character.isLowSurrogate(c2 = StringUTF16.charAt(a, i))) {
                ++i;
                cp = Character.toCodePoint((char)c1, c2);
            }
            action.accept(cp);
            return i;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length >> 1, acs);
        }

        CharsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                charsSpliterator = null;
            } else {
                this.index = mid;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, lo, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >> 1 >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(StringUTF16.charAt(a, i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            if ((i = this.index++) >= 0 && i < this.fence) {
                action.accept(StringUTF16.charAt(this.array, i));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

