/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import jdk.internal.HotSpotIntrinsicCandidate;

final class StringLatin1 {
    StringLatin1() {
    }

    public static char charAt(byte[] value, int index) {
        if (index < 0 || index >= value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return (char)(value[index] & 0xFF);
    }

    public static boolean canEncode(int cp) {
        return cp >>> 8 == 0;
    }

    public static int length(byte[] value) {
        return value.length;
    }

    public static int codePointAt(byte[] value, int index, int end) {
        return value[index] & 0xFF;
    }

    public static int codePointBefore(byte[] value, int index) {
        return value[index - 1] & 0xFF;
    }

    public static int codePointCount(byte[] value, int beginIndex, int endIndex) {
        return endIndex - beginIndex;
    }

    public static char[] toChars(byte[] value) {
        char[] dst = new char[value.length];
        StringLatin1.inflate(value, 0, dst, 0, value.length);
        return dst;
    }

    public static byte[] inflate(byte[] value, int off, int len) {
        byte[] ret = StringUTF16.newBytesFor(len);
        StringLatin1.inflate(value, off, ret, 0, len);
        return ret;
    }

    public static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        StringLatin1.inflate(value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public static void getBytes(byte[] value, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        System.arraycopy(value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @HotSpotIntrinsicCandidate
    public static boolean equals(byte[] value, byte[] other) {
        if (value.length == other.length) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @HotSpotIntrinsicCandidate
    public static int compareTo(byte[] value, byte[] other) {
        int len1 = value.length;
        int len2 = other.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            if (value[k] == other[k]) continue;
            return StringLatin1.getChar(value, k) - StringLatin1.getChar(other, k);
        }
        return len1 - len2;
    }

    @HotSpotIntrinsicCandidate
    public static int compareToUTF16(byte[] value, byte[] other) {
        int len1 = StringLatin1.length(value);
        int len2 = StringUTF16.length(other);
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringLatin1.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compareToCI(byte[] value, byte[] other) {
        int len1 = value.length;
        int len2 = other.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1;
            if (value[k] == other[k] || (c1 = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(value, k))) == (c2 = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(other, k))) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compareToCI_UTF16(byte[] value, byte[] other) {
        int len1 = StringLatin1.length(value);
        int len2 = StringUTF16.length(other);
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringLatin1.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int hashCode(byte[] value) {
        int h = 0;
        for (byte v : value) {
            h = 31 * h + (v & 0xFF);
        }
        return h;
    }

    public static int indexOf(byte[] value, int ch, int fromIndex) {
        if (!StringLatin1.canEncode(ch)) {
            return -1;
        }
        int max = value.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        byte c = (byte)ch;
        for (int i = fromIndex; i < max; ++i) {
            if (value[i] != c) continue;
            return i;
        }
        return -1;
    }

    @HotSpotIntrinsicCandidate
    public static int indexOf(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length == 0) {
            return -1;
        }
        return StringLatin1.indexOf(value, value.length, str, str.length, 0);
    }

    @HotSpotIntrinsicCandidate
    public static int indexOf(byte[] value, int valueCount, byte[] str, int strCount, int fromIndex) {
        byte first = str[0];
        int max = valueCount - strCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (value[i] != first) {
                while (++i <= max && value[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + strCount - 1;
            int k = 1;
            while (j < end && value[j] == str[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        int start;
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        char strLastChar = (char)(tgt[strLastIndex] & 0xFF);
        block0: while (true) {
            if (i >= min && (src[i] & 0xFF) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if ((src[j--] & 0xFF) == (tgt[k--] & 0xFF)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(byte[] value, int ch, int fromIndex) {
        if (!StringLatin1.canEncode(ch)) {
            return -1;
        }
        for (int off = Math.min(fromIndex, value.length - 1); off >= 0; --off) {
            if (value[off] != (byte)ch) continue;
            return off;
        }
        return -1;
    }

    public static String replace(byte[] value, char oldChar, char newChar) {
        if (StringLatin1.canEncode(oldChar)) {
            int len = value.length;
            int i = -1;
            while (++i < len && value[i] != (byte)oldChar) {
            }
            if (i < len) {
                if (StringLatin1.canEncode(newChar)) {
                    byte[] buf = new byte[len];
                    for (int j = 0; j < i; ++j) {
                        buf[j] = value[j];
                    }
                    while (i < len) {
                        byte c = value[i];
                        buf[i] = c == (byte)oldChar ? (byte)newChar : c;
                        ++i;
                    }
                    return new String(buf, 0);
                }
                byte[] buf = StringUTF16.newBytesFor(len);
                StringLatin1.inflate(value, 0, buf, 0, i);
                while (i < len) {
                    char c = (char)(value[i] & 0xFF);
                    StringUTF16.putChar(buf, i, c == oldChar ? newChar : c);
                    ++i;
                }
                return new String(buf, 1);
            }
        }
        return null;
    }

    public static boolean regionMatchesCI(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        int last = toffset + len;
        while (toffset < last) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = (char)(value[toffset++] & 0xFF)) == (c2 = (char)(other[ooffset++] & 0xFF)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesCI_UTF16(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        int last = toffset + len;
        while (toffset < last) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = (char)(value[toffset++] & 0xFF)) == (c2 = StringUTF16.getChar(other, ooffset++)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String str, byte[] value, Locale locale) {
        int cp;
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        int len = value.length;
        for (first = 0; first < len && (cp = value[first] & 0xFF) == Character.toLowerCase(cp); ++first) {
        }
        if (first == len) {
            return str;
        }
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringLatin1.toLowerCaseEx(str, value, first, locale, true);
        }
        byte[] result = new byte[len];
        System.arraycopy(value, 0, result, 0, first);
        for (int i = first; i < len; ++i) {
            int cp2 = value[i] & 0xFF;
            if (!StringLatin1.canEncode(cp2 = Character.toLowerCase(cp2))) {
                return StringLatin1.toLowerCaseEx(str, value, first, locale, false);
            }
            result[i] = (byte)cp2;
        }
        return new String(result, 0);
    }

    private static String toLowerCaseEx(String str, byte[] value, int first, Locale locale, boolean localeDependent) {
        int i;
        byte[] result = StringUTF16.newBytesFor(value.length);
        int resultOffset = 0;
        for (i = 0; i < first; ++i) {
            StringUTF16.putChar(result, resultOffset++, value[i] & 0xFF);
        }
        for (i = first; i < value.length; ++i) {
            int srcChar = value[i] & 0xFF;
            int lowerChar = localeDependent ? ConditionalSpecialCasing.toLowerCaseEx(str, i, locale) : Character.toLowerCase(srcChar);
            if (Character.isBmpCodePoint(lowerChar)) {
                StringUTF16.putChar(result, resultOffset++, lowerChar);
                continue;
            }
            char[] lowerCharArray = lowerChar == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(str, i, locale) : Character.toChars(lowerChar);
            int mapLen = lowerCharArray.length;
            if (mapLen > 1) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - 1);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, lowerCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String toUpperCase(String str, byte[] value, Locale locale) {
        int cp;
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        int len = value.length;
        for (first = 0; first < len && (cp = value[first] & 0xFF) == Character.toUpperCaseEx(cp); ++first) {
        }
        if (first == len) {
            return str;
        }
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringLatin1.toUpperCaseEx(str, value, first, locale, true);
        }
        byte[] result = new byte[len];
        System.arraycopy(value, 0, result, 0, first);
        for (int i = first; i < len; ++i) {
            int cp2 = value[i] & 0xFF;
            if (!StringLatin1.canEncode(cp2 = Character.toUpperCaseEx(cp2))) {
                return StringLatin1.toUpperCaseEx(str, value, first, locale, false);
            }
            result[i] = (byte)cp2;
        }
        return new String(result, 0);
    }

    private static String toUpperCaseEx(String str, byte[] value, int first, Locale locale, boolean localeDependent) {
        int i;
        byte[] result = StringUTF16.newBytesFor(value.length);
        int resultOffset = 0;
        for (i = 0; i < first; ++i) {
            StringUTF16.putChar(result, resultOffset++, value[i] & 0xFF);
        }
        for (i = first; i < value.length; ++i) {
            int srcChar = value[i] & 0xFF;
            int upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(str, i, locale) : Character.toUpperCaseEx(srcChar);
            if (Character.isBmpCodePoint(upperChar)) {
                StringUTF16.putChar(result, resultOffset++, upperChar);
                continue;
            }
            char[] upperCharArray = upperChar == -1 ? (localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(str, i, locale) : Character.toUpperCaseCharArray(srcChar)) : Character.toChars(upperChar);
            int mapLen = upperCharArray.length;
            if (mapLen > 1) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - 1);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, upperCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String trim(byte[] value) {
        int st;
        int len = value.length;
        for (st = 0; st < len && (value[st] & 0xFF) <= 32; ++st) {
        }
        while (st < len && (value[len - 1] & 0xFF) <= 32) {
            --len;
        }
        return st > 0 || len < value.length ? StringLatin1.newString(value, st, len - st) : null;
    }

    public static void putChar(byte[] val, int index, int c) {
        val[index] = (byte)c;
    }

    public static char getChar(byte[] val, int index) {
        return (char)(val[index] & 0xFF);
    }

    public static byte[] toBytes(int[] val, int off, int len) {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            int cp;
            if (!StringLatin1.canEncode(cp = val[off++])) {
                return null;
            }
            ret[i] = (byte)cp;
        }
        return ret;
    }

    public static byte[] toBytes(char c) {
        return new byte[]{(byte)c};
    }

    public static String newString(byte[] val, int index, int len) {
        return new String(Arrays.copyOfRange(val, index, index + len), 0);
    }

    public static void fillNull(byte[] val, int index, int end) {
        Arrays.fill(val, index, end, (byte)0);
    }

    @HotSpotIntrinsicCandidate
    public static void inflate(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff++] = (char)(src[srcOff++] & 0xFF);
        }
    }

    @HotSpotIntrinsicCandidate
    public static void inflate(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        String.checkBoundsOffCount(dstOff << 1, len << 1, dst.length);
        for (int i = 0; i < len; ++i) {
            StringUTF16.putChar(dst, dstOff++, src[srcOff++] & 0xFF);
        }
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length, acs);
        }

        CharsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                charsSpliterator = null;
            } else {
                this.index = mid;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, lo, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i] & 0xFF);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++] & 0xFF);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

