/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

final class StringConcatHelper {
    private StringConcatHelper() {
    }

    private static int checkOverflow(int len) {
        if (len < 0) {
            throw new OutOfMemoryError("Overflow: String length out of range");
        }
        return len;
    }

    static int mixLen(int current, boolean value) {
        return StringConcatHelper.checkOverflow(current + (value ? 4 : 5));
    }

    static int mixLen(int current, byte value) {
        return StringConcatHelper.mixLen(current, (int)value);
    }

    static int mixLen(int current, char value) {
        return StringConcatHelper.checkOverflow(current + 1);
    }

    static int mixLen(int current, short value) {
        return StringConcatHelper.mixLen(current, (int)value);
    }

    static int mixLen(int current, int value) {
        return StringConcatHelper.checkOverflow(current + Integer.stringSize(value));
    }

    static int mixLen(int current, long value) {
        return StringConcatHelper.checkOverflow(current + Long.stringSize(value));
    }

    static int mixLen(int current, String value) {
        return StringConcatHelper.checkOverflow(current + value.length());
    }

    static byte mixCoder(byte current, char value) {
        return (byte)(current | (StringLatin1.canEncode(value) ? (byte)0 : 1));
    }

    static byte mixCoder(byte current, String value) {
        return (byte)(current | value.coder());
    }

    static byte mixCoder(byte current, boolean value) {
        return current;
    }

    static byte mixCoder(byte current, byte value) {
        return current;
    }

    static byte mixCoder(byte current, short value) {
        return current;
    }

    static byte mixCoder(byte current, int value) {
        return current;
    }

    static byte mixCoder(byte current, long value) {
        return current;
    }

    static int prepend(int index, byte[] buf, byte coder, boolean value) {
        if (coder == 0) {
            if (value) {
                buf[--index] = 101;
                buf[--index] = 117;
                buf[--index] = 114;
                buf[--index] = 116;
            } else {
                buf[--index] = 101;
                buf[--index] = 115;
                buf[--index] = 108;
                buf[--index] = 97;
                buf[--index] = 102;
            }
        } else if (value) {
            StringUTF16.putChar(buf, --index, 101);
            StringUTF16.putChar(buf, --index, 117);
            StringUTF16.putChar(buf, --index, 114);
            StringUTF16.putChar(buf, --index, 116);
        } else {
            StringUTF16.putChar(buf, --index, 101);
            StringUTF16.putChar(buf, --index, 115);
            StringUTF16.putChar(buf, --index, 108);
            StringUTF16.putChar(buf, --index, 97);
            StringUTF16.putChar(buf, --index, 102);
        }
        return index;
    }

    static int prepend(int index, byte[] buf, byte coder, byte value) {
        return StringConcatHelper.prepend(index, buf, coder, (int)value);
    }

    static int prepend(int index, byte[] buf, byte coder, char value) {
        if (coder == 0) {
            buf[--index] = (byte)(value & 0xFF);
        } else {
            StringUTF16.putChar(buf, --index, value);
        }
        return index;
    }

    static int prepend(int index, byte[] buf, byte coder, short value) {
        return StringConcatHelper.prepend(index, buf, coder, (int)value);
    }

    static int prepend(int index, byte[] buf, byte coder, int value) {
        if (coder == 0) {
            return Integer.getChars(value, index, buf);
        }
        return Integer.getCharsUTF16(value, index, buf);
    }

    static int prepend(int index, byte[] buf, byte coder, long value) {
        if (coder == 0) {
            return Long.getChars(value, index, buf);
        }
        return Long.getCharsUTF16(value, index, buf);
    }

    static int prepend(int index, byte[] buf, byte coder, String value) {
        value.getBytes(buf, index -= value.length(), coder);
        return index;
    }

    static String newString(byte[] buf, int index, byte coder) {
        if (index != 0) {
            throw new InternalError("Storage is not completely initialized, " + index + " bytes left");
        }
        return new String(buf, coder);
    }

    static byte initialCoder() {
        return String.COMPACT_STRINGS ? (byte)0 : 1;
    }
}

