/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import jdk.internal.HotSpotIntrinsicCandidate;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static final ThreadLocal<SoftReference<StringDecoder>> decoder = new ThreadLocal();
    private static final ThreadLocal<SoftReference<StringEncoder>> encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static <T> T deref(ThreadLocal<SoftReference<T>> tl) {
        SoftReference<T> sr = tl.get();
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    private static <T> void set(ThreadLocal<SoftReference<T>> tl, T ob) {
        tl.set(new SoftReference<T>(ob));
    }

    private static byte[] safeTrim(byte[] ba, int len, boolean isTrusted) {
        if (len == ba.length && (isTrusted || System.getSecurityManager() == null)) {
            return ba;
        }
        return Arrays.copyOf(ba, len);
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private static Charset lookupCharset(String csn) {
        if (Charset.isSupported(csn)) {
            try {
                return Charset.forName(csn);
            }
            catch (UnsupportedCharsetException x) {
                throw new Error(x);
            }
        }
        return null;
    }

    private static void warnUnsupportedCharset(String csn) {
        if (warnUnsupportedCharset) {
            StringCoding.err("WARNING: Default charset " + csn + " not supported, using ISO-8859-1 instead\n");
            warnUnsupportedCharset = false;
        }
    }

    @HotSpotIntrinsicCandidate
    public static boolean hasNegatives(byte[] ba, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (ba[i] >= 0) continue;
            return true;
        }
        return false;
    }

    static Result decode(String charsetName, byte[] ba, int off, int len) throws UnsupportedEncodingException {
        String csn;
        StringDecoder sd = (StringDecoder)StringCoding.deref(decoder);
        String string = csn = charsetName == null ? "ISO-8859-1" : charsetName;
        if (sd == null || !csn.equals(sd.requestedCharsetName()) && !csn.equals(sd.charsetName())) {
            sd = null;
            try {
                Charset cs = StringCoding.lookupCharset(csn);
                if (cs != null) {
                    sd = cs == StandardCharsets.UTF_8 ? new StringDecoderUTF8(cs, csn) : (cs == StandardCharsets.ISO_8859_1 ? new StringDecoder8859_1(cs, csn) : new StringDecoder(cs, csn));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (sd == null) {
                throw new UnsupportedEncodingException(csn);
            }
            StringCoding.set(decoder, sd);
        }
        return sd.decode(ba, off, len);
    }

    static Result decode(Charset cs, byte[] ba, int off, int len) {
        if (cs == StandardCharsets.UTF_8) {
            return StringDecoderUTF8.decode(ba, off, len, new Result());
        }
        CharsetDecoder cd = cs.newDecoder();
        if (cs == StandardCharsets.ISO_8859_1 || cd instanceof ArrayDecoder && ((ArrayDecoder)((Object)cd)).isASCIICompatible() && !StringCoding.hasNegatives(ba, off, len)) {
            if (String.COMPACT_STRINGS) {
                return new Result().with(Arrays.copyOfRange(ba, off, off + len), (byte)0);
            }
            return new Result().with(StringLatin1.inflate(ba, off, len), (byte)1);
        }
        int en = StringCoding.scale(len, cd.maxCharsPerByte());
        if (len == 0) {
            return new Result().with();
        }
        if (System.getSecurityManager() != null && cs.getClass().getClassLoader0() != null) {
            ba = Arrays.copyOfRange(ba, off, off + len);
            off = 0;
        }
        cd.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        char[] ca = new char[en];
        if (cd instanceof ArrayDecoder) {
            int clen = ((ArrayDecoder)((Object)cd)).decode(ba, off, len, ca);
            return new Result().with(ca, 0, clen);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return new Result().with(ca, 0, cb.position());
    }

    static Result decode(byte[] ba, int off, int len) {
        String csn = Charset.defaultCharset().name();
        try {
            return StringCoding.decode(csn, ba, off, len);
        }
        catch (UnsupportedEncodingException x) {
            StringCoding.warnUnsupportedCharset(csn);
            try {
                return StringCoding.decode("ISO-8859-1", ba, off, len);
            }
            catch (UnsupportedEncodingException x2) {
                StringCoding.err("ISO-8859-1 charset not available: " + x2.toString() + "\n");
                System.exit(1);
                return null;
            }
        }
    }

    @HotSpotIntrinsicCandidate
    private static int implEncodeISOArray(byte[] sa, int sp, byte[] da, int dp, int len) {
        char c;
        int i;
        for (i = 0; i < len && (c = StringUTF16.getChar(sa, sp++)) <= '\u00ff'; ++i) {
            da[dp++] = (byte)c;
        }
        return i;
    }

    static byte[] encode8859_1(byte coder, byte[] val) {
        if (coder == 0) {
            return Arrays.copyOf(val, val.length);
        }
        int len = val.length >> 1;
        byte[] dst = new byte[len];
        int dp = 0;
        int sp = 0;
        int sl = len;
        while (sp < sl) {
            char c;
            int ret = StringCoding.implEncodeISOArray(val, sp, dst, dp, len);
            sp += ret;
            dp += ret;
            if (ret == len) continue;
            if (Character.isHighSurrogate(c = StringUTF16.getChar(val, sp++)) && sp < sl && Character.isLowSurrogate(StringUTF16.getChar(val, sp))) {
                ++sp;
            }
            dst[dp++] = 63;
            len = sl - sp;
        }
        if (dp == dst.length) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    static byte[] encodeASCII(byte coder, byte[] val) {
        if (coder == 0) {
            byte[] dst = new byte[val.length];
            for (int i = 0; i < val.length; ++i) {
                dst[i] = val[i] < 0 ? 63 : val[i];
            }
            return dst;
        }
        int len = val.length >> 1;
        byte[] dst = new byte[len];
        int dp = 0;
        for (int i = 0; i < len; ++i) {
            char c = StringUTF16.getChar(val, i);
            if (c < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (Character.isHighSurrogate(c) && i + 1 < len && Character.isLowSurrogate(StringUTF16.getChar(val, i + 1))) {
                ++i;
            }
            dst[dp++] = 63;
        }
        if (len == dp) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    static byte[] encodeUTF8(byte coder, byte[] val) {
        byte[] dst;
        int dp = 0;
        if (coder == 0) {
            dst = new byte[val.length << 1];
            for (int sp = 0; sp < val.length; ++sp) {
                byte c = val[sp];
                if (c < 0) {
                    dst[dp++] = (byte)(0xC0 | (c & 0xFF) >> 6);
                    dst[dp++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                dst[dp++] = c;
            }
        } else {
            char c;
            int sp;
            int sl = val.length >> 1;
            dst = new byte[sl * 3];
            for (sp = 0; sp < sl && (c = StringUTF16.getChar(val, sp)) < '\u0080'; ++sp) {
                dst[dp++] = (byte)c;
            }
            while (sp < sl) {
                if ((c = StringUTF16.getChar(val, sp++)) < '\u0080') {
                    dst[dp++] = (byte)c;
                    continue;
                }
                if (c < '\u0800') {
                    dst[dp++] = (byte)(0xC0 | c >> 6);
                    dst[dp++] = (byte)(0x80 | c & 0x3F);
                    continue;
                }
                if (Character.isSurrogate(c)) {
                    char c2;
                    int uc = -1;
                    if (Character.isHighSurrogate(c) && sp < sl && Character.isLowSurrogate(c2 = StringUTF16.getChar(val, sp))) {
                        uc = Character.toCodePoint(c, c2);
                    }
                    if (uc < 0) {
                        dst[dp++] = 63;
                        continue;
                    }
                    dst[dp++] = (byte)(0xF0 | uc >> 18);
                    dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    dst[dp++] = (byte)(0x80 | uc & 0x3F);
                    ++sp;
                    continue;
                }
                dst[dp++] = (byte)(0xE0 | c >> 12);
                dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
            }
        }
        if (dp == dst.length) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    static byte[] encode(String charsetName, byte coder, byte[] val) throws UnsupportedEncodingException {
        String csn;
        StringEncoder se = (StringEncoder)StringCoding.deref(encoder);
        String string = csn = charsetName == null ? "ISO-8859-1" : charsetName;
        if (se == null || !csn.equals(se.requestedCharsetName()) && !csn.equals(se.charsetName())) {
            se = null;
            try {
                Charset cs = StringCoding.lookupCharset(csn);
                if (cs != null) {
                    if (cs == StandardCharsets.UTF_8) {
                        return StringCoding.encodeUTF8(coder, val);
                    }
                    if (cs == StandardCharsets.ISO_8859_1) {
                        return StringCoding.encode8859_1(coder, val);
                    }
                    if (cs == StandardCharsets.US_ASCII) {
                        return StringCoding.encodeASCII(coder, val);
                    }
                    se = new StringEncoder(cs, csn);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            if (se == null) {
                throw new UnsupportedEncodingException(csn);
            }
            StringCoding.set(encoder, se);
        }
        return se.encode(coder, val);
    }

    static byte[] encode(Charset cs, byte coder, byte[] val) {
        if (cs == StandardCharsets.UTF_8) {
            return StringCoding.encodeUTF8(coder, val);
        }
        if (cs == StandardCharsets.ISO_8859_1) {
            return StringCoding.encode8859_1(coder, val);
        }
        if (cs == StandardCharsets.US_ASCII) {
            return StringCoding.encodeASCII(coder, val);
        }
        CharsetEncoder ce = cs.newEncoder();
        if (coder == 0 && ce instanceof ArrayEncoder && ((ArrayEncoder)((Object)ce)).isASCIICompatible() && !StringCoding.hasNegatives(val, 0, val.length)) {
            return Arrays.copyOf(val, val.length);
        }
        int len = val.length >> coder;
        int en = StringCoding.scale(len, ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        if (len == 0) {
            return ba;
        }
        boolean isTrusted = System.getSecurityManager() == null || cs.getClass().getClassLoader0() == null;
        ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (ce instanceof ArrayEncoder) {
            int blen;
            if (!isTrusted) {
                val = Arrays.copyOf(val, val.length);
            }
            int n = blen = coder == 0 ? ((ArrayEncoder)((Object)ce)).encodeFromLatin1(val, 0, len, ba) : ((ArrayEncoder)((Object)ce)).encodeFromUTF16(val, 0, len, ba);
            if (blen != -1) {
                return StringCoding.safeTrim(ba, blen, isTrusted);
            }
        }
        char[] ca = coder == 0 ? StringLatin1.toChars(val) : StringUTF16.toChars(val);
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca, 0, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return StringCoding.safeTrim(ba, bb.position(), isTrusted);
    }

    static byte[] encode(byte coder, byte[] val) {
        String csn = Charset.defaultCharset().name();
        try {
            return StringCoding.encode(csn, coder, val);
        }
        catch (UnsupportedEncodingException x) {
            StringCoding.warnUnsupportedCharset(csn);
            try {
                return StringCoding.encode("ISO-8859-1", coder, val);
            }
            catch (UnsupportedEncodingException x2) {
                StringCoding.err("ISO-8859-1 charset not available: " + x2.toString() + "\n");
                System.exit(1);
                return null;
            }
        }
    }

    private static native void err(String var0);

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final boolean isASCIICompatible;
        private final String requestedCharsetName;
        private final boolean isTrusted;

        private StringEncoder(Charset cs, String rcn) {
            this.requestedCharsetName = rcn;
            this.cs = cs;
            this.ce = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = cs.getClass().getClassLoader0() == null;
            this.isASCIICompatible = this.ce instanceof ArrayEncoder && ((ArrayEncoder)((Object)this.ce)).isASCIICompatible();
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(byte coder, byte[] val) {
            if (coder == 0 && this.isASCIICompatible && !StringCoding.hasNegatives(val, 0, val.length)) {
                return Arrays.copyOf(val, val.length);
            }
            int len = val.length >> coder;
            int en = StringCoding.scale(len, this.ce.maxBytesPerChar());
            byte[] ba = new byte[en];
            if (len == 0) {
                return ba;
            }
            if (this.ce instanceof ArrayEncoder) {
                int blen;
                if (!this.isTrusted) {
                    val = Arrays.copyOf(val, val.length);
                }
                int n = blen = coder == 0 ? ((ArrayEncoder)((Object)this.ce)).encodeFromLatin1(val, 0, len, ba) : ((ArrayEncoder)((Object)this.ce)).encodeFromUTF16(val, 0, len, ba);
                if (blen != -1) {
                    return StringCoding.safeTrim(ba, blen, this.isTrusted);
                }
            }
            char[] ca = coder == 0 ? StringLatin1.toChars(val) : StringUTF16.toChars(val);
            this.ce.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba);
            CharBuffer cb = CharBuffer.wrap(ca, 0, len);
            try {
                CoderResult cr = this.ce.encode(cb, bb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.ce.flush(bb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
            return StringCoding.safeTrim(ba, bb.position(), this.isTrusted);
        }
    }

    private static class StringDecoder8859_1
    extends StringDecoder {
        StringDecoder8859_1(Charset cs, String rcn) {
            super(cs, rcn);
        }

        @Override
        Result decode(byte[] ba, int off, int len) {
            if (String.COMPACT_STRINGS) {
                return this.result.with(Arrays.copyOfRange(ba, off, off + len), (byte)0);
            }
            return this.result.with(StringLatin1.inflate(ba, off, len), (byte)1);
        }
    }

    static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final boolean isASCIICompatible;
        private final CharsetDecoder cd;
        protected final Result result;

        StringDecoder(Charset cs, String rcn) {
            this.requestedCharsetName = rcn;
            this.cs = cs;
            this.cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.result = new Result();
            this.isASCIICompatible = this.cd instanceof ArrayDecoder && ((ArrayDecoder)((Object)this.cd)).isASCIICompatible();
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        Result decode(byte[] ba, int off, int len) {
            if (len == 0) {
                return this.result.with();
            }
            if (this.isASCIICompatible && !StringCoding.hasNegatives(ba, off, len)) {
                if (String.COMPACT_STRINGS) {
                    return this.result.with(Arrays.copyOfRange(ba, off, off + len), (byte)0);
                }
                return this.result.with(StringLatin1.inflate(ba, off, len), (byte)1);
            }
            int en = StringCoding.scale(len, this.cd.maxCharsPerByte());
            char[] ca = new char[en];
            if (this.cd instanceof ArrayDecoder) {
                int clen = ((ArrayDecoder)((Object)this.cd)).decode(ba, off, len, ca);
                return this.result.with(ca, 0, clen);
            }
            this.cd.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
            CharBuffer cb = CharBuffer.wrap(ca);
            try {
                CoderResult cr = this.cd.decode(bb, cb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.cd.flush(cb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
            return this.result.with(ca, 0, cb.position());
        }
    }

    static class Result {
        byte[] value;
        byte coder;

        Result() {
        }

        Result with() {
            this.coder = String.COMPACT_STRINGS ? (byte)0 : 1;
            this.value = new byte[0];
            return this;
        }

        Result with(char[] val, int off, int len) {
            byte[] bs;
            if (String.COMPACT_STRINGS && (bs = StringUTF16.compress(val, off, len)) != null) {
                this.value = bs;
                this.coder = 0;
                return this;
            }
            this.coder = 1;
            this.value = StringUTF16.toBytes(val, off, len);
            return this;
        }

        Result with(byte[] val, byte coder) {
            this.coder = coder;
            this.value = val;
            return this;
        }
    }
}

