/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    @Stable
    private final byte[] value;
    private final byte coder;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    static final boolean COMPACT_STRINGS = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    static final byte LATIN1 = 0;
    static final byte UTF16 = 1;

    public String() {
        this.value = "".value;
        this.coder = "".coder;
    }

    @HotSpotIntrinsicCandidate
    public String(String original) {
        this.value = original.value;
        this.coder = original.coder;
        this.hash = original.hash;
    }

    public String(char[] value) {
        this(value, 0, value.length, null);
    }

    public String(char[] value, int offset, int count) {
        this(value, offset, count, String.rangeCheck(value, offset, count));
    }

    private static Void rangeCheck(char[] value, int offset, int count) {
        String.checkBoundsOffCount(offset, count, value.length);
        return null;
    }

    public String(int[] codePoints, int offset, int count) {
        byte[] val;
        String.checkBoundsOffCount(offset, count, codePoints.length);
        if (count == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (val = StringLatin1.toBytes(codePoints, offset, count)) != null) {
            this.coder = 0;
            this.value = val;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(codePoints, offset, count);
    }

    @Deprecated(since="1.1")
    public String(byte[] ascii, int hibyte, int offset, int count) {
        String.checkBoundsOffCount(offset, count, ascii.length);
        if (count == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (byte)hibyte == 0) {
            this.value = Arrays.copyOfRange(ascii, offset, offset + count);
            this.coder = 0;
        } else {
            hibyte <<= 8;
            byte[] val = StringUTF16.newBytesFor(count);
            for (int i = 0; i < count; ++i) {
                StringUTF16.putChar(val, i, hibyte | ascii[offset++] & 0xFF);
            }
            this.value = val;
            this.coder = 1;
        }
    }

    @Deprecated(since="1.1")
    public String(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBoundsOffCount(offset, length, bytes.length);
        StringCoding.Result ret = StringCoding.decode(charsetName, bytes, offset, length);
        this.value = ret.value;
        this.coder = ret.coder;
    }

    public String(byte[] bytes, int offset, int length, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBoundsOffCount(offset, length, bytes.length);
        StringCoding.Result ret = StringCoding.decode(charset, bytes, offset, length);
        this.value = ret.value;
        this.coder = ret.coder;
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public String(byte[] bytes, Charset charset) {
        this(bytes, 0, bytes.length, charset);
    }

    public String(byte[] bytes, int offset, int length) {
        String.checkBoundsOffCount(offset, length, bytes.length);
        StringCoding.Result ret = StringCoding.decode(bytes, offset, length);
        this.value = ret.value;
        this.coder = ret.coder;
    }

    public String(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public String(StringBuffer buffer) {
        this(buffer.toString());
    }

    public String(StringBuilder builder) {
        this(builder, null);
    }

    String(char[] val, boolean share) {
        this(val, 0, val.length, null);
    }

    @Override
    public int length() {
        return this.value.length >> this.coder();
    }

    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public char charAt(int index) {
        if (this.isLatin1()) {
            return StringLatin1.charAt(this.value, index);
        }
        return StringUTF16.charAt(this.value, index);
    }

    public int codePointAt(int index) {
        if (this.isLatin1()) {
            String.checkIndex(index, this.value.length);
            return this.value[index] & 0xFF;
        }
        int length = this.value.length >> 1;
        String.checkIndex(index, length);
        return StringUTF16.codePointAt(this.value, index, length);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.isLatin1()) {
            return this.value[i] & 0xFF;
        }
        return StringUTF16.codePointBefore(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isLatin1()) {
            return endIndex - beginIndex;
        }
        return StringUTF16.codePointCount(this.value, beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, index, codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        String.checkBoundsBeginEnd(srcBegin, srcEnd, this.length());
        String.checkBoundsOffCount(dstBegin, srcEnd - srcBegin, dst.length);
        if (this.isLatin1()) {
            StringLatin1.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        } else {
            StringUTF16.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        }
    }

    @Deprecated(since="1.1")
    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        String.checkBoundsBeginEnd(srcBegin, srcEnd, this.length());
        Objects.requireNonNull(dst);
        String.checkBoundsOffCount(dstBegin, srcEnd - srcBegin, dst.length);
        if (this.isLatin1()) {
            StringLatin1.getBytes(this.value, srcBegin, srcEnd, dst, dstBegin);
        } else {
            StringUTF16.getBytes(this.value, srcBegin, srcEnd, dst, dstBegin);
        }
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charsetName, this.coder(), this.value);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charset, this.coder(), this.value);
    }

    public byte[] getBytes() {
        return StringCoding.encode(this.coder(), this.value);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String aString = (String)anObject;
            if (this.coder() == aString.coder()) {
                return this.isLatin1() ? StringLatin1.equals(this.value, aString.value) : StringUTF16.equals(this.value, aString.value);
            }
        }
        return false;
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.contentEquals((CharSequence)sb);
    }

    private boolean nonSyncContentEquals(AbstractStringBuilder sb) {
        int len = this.length();
        if (len != sb.length()) {
            return false;
        }
        byte[] v1 = this.value;
        byte[] v2 = sb.getValue();
        if (this.coder() == sb.getCoder()) {
            int n = v1.length;
            for (int i = 0; i < n; ++i) {
                if (v1[i] == v2[i]) continue;
                return false;
            }
        } else {
            if (!this.isLatin1()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if ((char)(v1[i] & 0xFF) == StringUTF16.getChar(v2, i)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(CharSequence cs) {
        if (cs instanceof AbstractStringBuilder) {
            if (cs instanceof StringBuffer) {
                CharSequence charSequence = cs;
                synchronized (charSequence) {
                    return this.nonSyncContentEquals((AbstractStringBuilder)cs);
                }
            }
            return this.nonSyncContentEquals((AbstractStringBuilder)cs);
        }
        if (cs instanceof String) {
            return this.equals(cs);
        }
        int n = cs.length();
        if (n != this.length()) {
            return false;
        }
        byte[] val = this.value;
        if (this.isLatin1()) {
            for (int i = 0; i < n; ++i) {
                if ((val[i] & 0xFF) == cs.charAt(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (StringUTF16.getChar(val, i) == cs.charAt(i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.length() == this.length() && this.regionMatches(true, 0, anotherString, 0, this.length());
    }

    @Override
    public int compareTo(String anotherString) {
        byte[] v1 = this.value;
        byte[] v2 = anotherString.value;
        if (this.coder() == anotherString.coder()) {
            return this.isLatin1() ? StringLatin1.compareTo(v1, v2) : StringUTF16.compareTo(v1, v2);
        }
        return this.isLatin1() ? StringLatin1.compareToUTF16(v1, v2) : StringUTF16.compareToLatin1(v1, v2);
    }

    public int compareToIgnoreCase(String str) {
        return CASE_INSENSITIVE_ORDER.compare(this, str);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        byte[] tv = this.value;
        byte[] ov = other.value;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        if (this.coder() == other.coder()) {
            if (!this.isLatin1() && len > 0) {
                toffset <<= 1;
                ooffset <<= 1;
                len <<= 1;
            }
            while (len-- > 0) {
                if (tv[toffset++] == ov[ooffset++]) continue;
                return false;
            }
        } else if (this.coder() == 0) {
            while (len-- > 0) {
                if (StringLatin1.getChar(tv, toffset++) == StringUTF16.getChar(ov, ooffset++)) continue;
                return false;
            }
        } else {
            while (len-- > 0) {
                if (StringUTF16.getChar(tv, toffset++) == StringLatin1.getChar(ov, ooffset++)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        if (!ignoreCase) {
            return this.regionMatches(toffset, other, ooffset, len);
        }
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        byte[] tv = this.value;
        byte[] ov = other.value;
        if (this.coder() == other.coder()) {
            return this.isLatin1() ? StringLatin1.regionMatchesCI(tv, toffset, ov, ooffset, len) : StringUTF16.regionMatchesCI(tv, toffset, ov, ooffset, len);
        }
        return this.isLatin1() ? StringLatin1.regionMatchesCI_UTF16(tv, toffset, ov, ooffset, len) : StringUTF16.regionMatchesCI_Latin1(tv, toffset, ov, ooffset, len);
    }

    public boolean startsWith(String prefix, int toffset) {
        if (toffset < 0 || toffset > this.length() - prefix.length()) {
            return false;
        }
        byte[] ta = this.value;
        byte[] pa = prefix.value;
        int po = 0;
        int pc = pa.length;
        if (this.coder() == prefix.coder()) {
            int to;
            int n = to = this.isLatin1() ? toffset : toffset << 1;
            while (po < pc) {
                if (ta[to++] == pa[po++]) continue;
                return false;
            }
        } else {
            if (this.isLatin1()) {
                return false;
            }
            while (po < pc) {
                if (StringUTF16.getChar(ta, toffset++) == (pa[po++] & 0xFF)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.value.length > 0) {
            h = this.isLatin1() ? StringLatin1.hashCode(this.value) : StringUTF16.hashCode(this.value);
            this.hash = h;
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.isLatin1() ? StringLatin1.indexOf(this.value, ch, fromIndex) : StringUTF16.indexOf(this.value, ch, fromIndex);
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        return this.isLatin1() ? StringLatin1.lastIndexOf(this.value, ch, fromIndex) : StringUTF16.lastIndexOf(this.value, ch, fromIndex);
    }

    public int indexOf(String str) {
        if (this.coder() == str.coder()) {
            return this.isLatin1() ? StringLatin1.indexOf(this.value, str.value) : StringUTF16.indexOf(this.value, str.value);
        }
        if (this.coder() == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(this.value, str.value);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, this.coder(), this.length(), str, fromIndex);
    }

    static int indexOf(byte[] src, byte srcCoder, int srcCount, String tgtStr, int fromIndex) {
        byte[] tgt = tgtStr.value;
        byte tgtCoder = tgtStr.coder();
        int tgtCount = tgtStr.length();
        if (fromIndex >= srcCount) {
            return tgtCount == 0 ? srcCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (tgtCount == 0) {
            return fromIndex;
        }
        if (srcCoder == tgtCoder) {
            return srcCoder == 0 ? StringLatin1.indexOf(src, srcCount, tgt, tgtCount, fromIndex) : StringUTF16.indexOf(src, srcCount, tgt, tgtCount, fromIndex);
        }
        if (srcCoder == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(src, srcCount, tgt, tgtCount, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.length());
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, this.coder(), this.length(), str, fromIndex);
    }

    static int lastIndexOf(byte[] src, byte srcCoder, int srcCount, String tgtStr, int fromIndex) {
        int start;
        byte[] tgt = tgtStr.value;
        byte tgtCoder = tgtStr.coder();
        int tgtCount = tgtStr.length();
        int rightIndex = srcCount - tgtCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (tgtCount == 0) {
            return fromIndex;
        }
        if (srcCoder == tgtCoder) {
            return srcCoder == 0 ? StringLatin1.lastIndexOf(src, srcCount, tgt, tgtCount, fromIndex) : StringUTF16.lastIndexOf(src, srcCount, tgt, tgtCount, fromIndex);
        }
        if (srcCoder == 0) {
            return -1;
        }
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        char strLastChar = (char)(tgt[strLastIndex] & 0xFF);
        block0: while (true) {
            if (i >= min && StringUTF16.getChar(src, i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if (StringUTF16.getChar(src, j--) == (tgt[k--] & 0xFF)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public String substring(int beginIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        int subLen = this.length() - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        if (beginIndex == 0) {
            return this;
        }
        return this.isLatin1() ? StringLatin1.newString(this.value, beginIndex, subLen) : StringUTF16.newString(this.value, beginIndex, subLen);
    }

    public String substring(int beginIndex, int endIndex) {
        int length = this.length();
        String.checkBoundsBeginEnd(beginIndex, endIndex, length);
        int subLen = endIndex - beginIndex;
        if (beginIndex == 0 && endIndex == length) {
            return this;
        }
        return this.isLatin1() ? StringLatin1.newString(this.value, beginIndex, subLen) : StringUTF16.newString(this.value, beginIndex, subLen);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String concat(String str) {
        int olen = str.length();
        if (olen == 0) {
            return this;
        }
        if (this.coder() == str.coder()) {
            byte[] val = this.value;
            byte[] oval = str.value;
            int len = val.length + oval.length;
            byte[] buf = Arrays.copyOf(val, len);
            System.arraycopy(oval, 0, buf, val.length, oval.length);
            return new String(buf, this.coder);
        }
        int len = this.length();
        byte[] buf = StringUTF16.newBytesFor(len + olen);
        this.getBytes(buf, 0, (byte)1);
        str.getBytes(buf, len, (byte)1);
        return new String(buf, 1);
    }

    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            String ret;
            String string = ret = this.isLatin1() ? StringLatin1.replace(this.value, oldChar, newChar) : StringUTF16.replace(this.value, oldChar, newChar);
            if (ret != null) {
                return ret;
            }
        }
        return this;
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) >= 0;
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public String replace(CharSequence target, CharSequence replacement) {
        String tgtStr = target.toString();
        String replStr = replacement.toString();
        int j = this.indexOf(tgtStr);
        if (j < 0) {
            return this;
        }
        int tgtLen = tgtStr.length();
        int tgtLen1 = Math.max(tgtLen, 1);
        int thisLen = this.length();
        int newLenHint = thisLen - tgtLen + replStr.length();
        if (newLenHint < 0) {
            throw new OutOfMemoryError();
        }
        StringBuilder sb = new StringBuilder(newLenHint);
        int i = 0;
        do {
            sb.append(this, i, j).append(replStr);
            i = j + tgtLen;
        } while (j < thisLen && (j = this.indexOf(tgtStr, j + tgtLen1)) > 0);
        return sb.append(this, i, thisLen).toString();
    }

    public String[] split(String regex, int limit) {
        char ch = '\u0000';
        if ((regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            boolean limited = limit > 0;
            ArrayList<String> list = new ArrayList<String>();
            while ((next = this.indexOf(ch, off)) != -1) {
                if (!limited || list.size() < limit - 1) {
                    list.add(this.substring(off, next));
                    off = next + 1;
                    continue;
                }
                int last = this.length();
                list.add(this.substring(off, last));
                off = last;
                break;
            }
            if (off == 0) {
                return new String[]{this};
            }
            if (!limited || list.size() < limit) {
                list.add(this.substring(off, this.length()));
            }
            if (limit == 0) {
                for (resultSize = list.size(); resultSize > 0 && ((String)list.get(resultSize - 1)).length() == 0; --resultSize) {
                }
            }
            String[] result = new String[resultSize];
            return list.subList(0, resultSize).toArray(result);
        }
        return Pattern.compile(regex).split(this, limit);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence cs : elements) {
            joiner.add(cs);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public String toLowerCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toLowerCase(this, this.value, locale) : StringUTF16.toLowerCase(this, this.value, locale);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toUpperCase(this, this.value, locale) : StringUTF16.toUpperCase(this, this.value, locale);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        String ret = this.isLatin1() ? StringLatin1.trim(this.value) : StringUTF16.trim(this.value);
        return ret == null ? this : ret;
    }

    @Override
    public String toString() {
        return this;
    }

    @Override
    public IntStream chars() {
        return StreamSupport.intStream(this.isLatin1() ? new StringLatin1.CharsSpliterator(this.value, 1024) : new StringUTF16.CharsSpliterator(this.value, 1024), false);
    }

    @Override
    public IntStream codePoints() {
        return StreamSupport.intStream(this.isLatin1() ? new StringLatin1.CharsSpliterator(this.value, 1024) : new StringUTF16.CodePointsSpliterator(this.value, 1024), false);
    }

    public char[] toCharArray() {
        return this.isLatin1() ? StringLatin1.toChars(this.value) : StringUTF16.toChars(this.value);
    }

    public static String format(String format, Object ... args) {
        return new Formatter().format(format, args).toString();
    }

    public static String format(Locale l, String format, Object ... args) {
        return new Formatter(l).format(format, args).toString();
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        if (COMPACT_STRINGS && StringLatin1.canEncode(c)) {
            return new String(StringLatin1.toBytes(c), 0);
        }
        return new String(StringUTF16.toBytes(c), 1);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    void getBytes(byte[] dst, int dstBegin, byte coder) {
        if (this.coder() == coder) {
            System.arraycopy(this.value, 0, dst, dstBegin << coder, this.value.length);
        } else {
            StringLatin1.inflate(this.value, 0, dst, dstBegin, this.value.length);
        }
    }

    String(char[] value, int off, int len, Void sig) {
        byte[] val;
        if (len == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (val = StringUTF16.compress(value, off, len)) != null) {
            this.value = val;
            this.coder = 0;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(value, off, len);
    }

    String(AbstractStringBuilder asb, Void sig) {
        byte[] val = asb.getValue();
        int length = asb.length();
        if (asb.isLatin1()) {
            this.coder = 0;
            this.value = Arrays.copyOfRange(val, 0, length);
        } else {
            byte[] buf;
            if (COMPACT_STRINGS && (buf = StringUTF16.compress(val, 0, length)) != null) {
                this.coder = 0;
                this.value = buf;
                return;
            }
            this.coder = 1;
            this.value = Arrays.copyOfRange(val, 0, length << 1);
        }
    }

    String(byte[] value, byte coder) {
        this.value = value;
        this.coder = coder;
    }

    byte coder() {
        return COMPACT_STRINGS ? this.coder : (byte)1;
    }

    private boolean isLatin1() {
        return COMPACT_STRINGS && this.coder == 0;
    }

    static void checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new StringIndexOutOfBoundsException("index " + index);
        }
    }

    static void checkOffset(int offset, int length) {
        if (offset < 0 || offset > length) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ",length " + length);
        }
    }

    static void checkBoundsOffCount(int offset, int count, int length) {
        if (offset < 0 || count < 0 || offset > length - count) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", count " + count + ", length " + length);
        }
    }

    private static void checkBoundsBeginEnd(int begin, int end, int length) {
        if (begin < 0 || begin > end || end > length) {
            throw new StringIndexOutOfBoundsException("begin " + begin + ", end " + end + ", length " + length);
        }
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            byte[] v1 = s1.value;
            byte[] v2 = s2.value;
            if (s1.coder() == s2.coder()) {
                return s1.isLatin1() ? StringLatin1.compareToCI(v1, v2) : StringUTF16.compareToCI(v1, v2);
            }
            return s1.isLatin1() ? StringLatin1.compareToCI_UTF16(v1, v2) : StringUTF16.compareToCI_Latin1(v1, v2);
        }

        private Object readResolve() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }
}

