/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.reflect.MethodAccessor;
import sun.security.action.GetPropertyAction;

final class StackStreamFactory {
    private static final Set<Class<?>> stackWalkImplClasses = StackStreamFactory.init();
    private static final int SMALL_BATCH = 8;
    private static final int BATCH_SIZE = 32;
    private static final int LARGE_BATCH_SIZE = 256;
    private static final int MIN_BATCH_SIZE = 8;
    private static final int DEFAULT_MODE = 0;
    private static final int FILL_CLASS_REFS_ONLY = 2;
    private static final int GET_CALLER_CLASS = 4;
    private static final int SHOW_HIDDEN_FRAMES = 32;
    private static final int FILL_LIVE_STACK_FRAMES = 256;
    static final boolean isDebug = "true".equals(GetPropertyAction.privilegedGetProperty("stackwalk.debug"));

    private StackStreamFactory() {
    }

    static <T> StackFrameTraverser<T> makeStackTraverser(StackWalker walker, Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        if (walker.hasLocalsOperandsOption()) {
            return new LiveStackInfoTraverser<T>(walker, function);
        }
        return new StackFrameTraverser<T>(walker, function);
    }

    static CallerClassFinder makeCallerFinder(StackWalker walker) {
        return new CallerClassFinder(walker);
    }

    private static native boolean checkStackWalkModes();

    private static Set<Class<?>> init() {
        if (!StackStreamFactory.checkStackWalkModes()) {
            throw new InternalError("StackWalker mode values do not match with JVM");
        }
        HashSet classes = new HashSet();
        classes.add(StackWalker.class);
        classes.add(StackStreamFactory.class);
        classes.add(AbstractStackWalker.class);
        return classes;
    }

    private static boolean filterStackWalkImpl(Class<?> c) {
        return stackWalkImplClasses.contains(c) || c.getName().startsWith("java.util.stream.");
    }

    private static boolean isMethodHandleFrame(Class<?> c) {
        return c.getName().startsWith("java.lang.invoke.");
    }

    private static boolean isReflectionFrame(Class<?> c) {
        if (c.getName().startsWith("jdk.internal.reflect") && !MethodAccessor.class.isAssignableFrom(c)) {
            throw new InternalError("Not jdk.internal.reflect.MethodAccessor: " + c.toString());
        }
        return c == Method.class || MethodAccessor.class.isAssignableFrom(c) || c.getName().startsWith("java.lang.invoke.LambdaForm");
    }

    static abstract class FrameBuffer<F> {
        static final int START_POS = 2;
        int currentBatchSize;
        int origin;
        int fence;

        FrameBuffer(int initialBatchSize) {
            if (initialBatchSize < 8) {
                throw new IllegalArgumentException(initialBatchSize + " < minimum batch size: " + 8);
            }
            this.origin = 2;
            this.fence = 0;
            this.currentBatchSize = initialBatchSize;
        }

        abstract F[] frames();

        abstract void resize(int var1, int var2);

        abstract Class<?> at(int var1);

        int startIndex() {
            return 2;
        }

        F nextStackFrame() {
            throw new InternalError("should not reach here");
        }

        final int curBatchFrameCount() {
            return this.currentBatchSize - 2;
        }

        final boolean isEmpty() {
            return this.origin >= this.fence || this.origin == 2 && this.fence == 0;
        }

        final void freeze() {
            this.origin = 0;
            this.fence = 0;
        }

        final boolean isActive() {
            return this.origin > 0 && (this.fence == 0 || this.origin < this.fence || this.fence == this.currentBatchSize);
        }

        final Class<?> next() {
            if (this.isEmpty()) {
                throw new NoSuchElementException("origin=" + this.origin + " fence=" + this.fence);
            }
            Class<?> c = this.at(this.origin);
            ++this.origin;
            if (isDebug) {
                int index = this.origin - 1;
                System.out.format("  next frame at %d: %s (origin %d fence %d)%n", index, Objects.toString(c), index, this.fence);
            }
            return c;
        }

        final Class<?> get() {
            if (this.isEmpty()) {
                throw new NoSuchElementException("origin=" + this.origin + " fence=" + this.fence);
            }
            return this.at(this.origin);
        }

        final int getIndex() {
            return this.origin;
        }

        final void setBatch(int depth, int startIndex, int endIndex) {
            if (startIndex <= 0 || endIndex <= 0) {
                throw new IllegalArgumentException("startIndex=" + startIndex + " endIndex=" + endIndex);
            }
            this.origin = startIndex;
            this.fence = endIndex;
            if (depth == 0 && this.fence > 0) {
                for (int i = 2; i < this.fence; ++i) {
                    Class<?> c = this.at(i);
                    if (isDebug) {
                        System.err.format("  frame %d: %s%n", i, c);
                    }
                    if (!StackStreamFactory.filterStackWalkImpl(c)) break;
                    ++this.origin;
                }
            }
        }

        final void check(int skipFrames) {
            int index = skipFrames + 2;
            if (this.origin != index) {
                throw new IllegalStateException("origin " + this.origin + " != " + index);
            }
        }
    }

    static final class LiveStackInfoTraverser<T>
    extends StackFrameTraverser<T> {
        LiveStackInfoTraverser(StackWalker walker, Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
            super(walker, function, 0);
        }

        @Override
        protected void initFrameBuffer() {
            this.frameBuffer = new LiveStackFrameBuffer(this.getNextBatchSize());
        }

        static {
            stackWalkImplClasses.add(LiveStackInfoTraverser.class);
        }

        final class LiveStackFrameBuffer
        extends FrameBuffer<LiveStackFrameInfo> {
            private LiveStackFrameInfo[] stackFrames;

            LiveStackFrameBuffer(int initialBatchSize) {
                super(initialBatchSize);
                this.stackFrames = new LiveStackFrameInfo[initialBatchSize];
                for (int i = 2; i < initialBatchSize; ++i) {
                    this.stackFrames[i] = new LiveStackFrameInfo(LiveStackInfoTraverser.this.walker);
                }
            }

            LiveStackFrameInfo[] frames() {
                return this.stackFrames;
            }

            @Override
            void resize(int startIndex, int elements) {
                if (!this.isActive()) {
                    throw new IllegalStateException("inactive frame buffer can't be resized");
                }
                assert (startIndex == 2) : "bad start index " + startIndex + " expected " + 2;
                int size = startIndex + elements;
                if (this.stackFrames.length < size) {
                    LiveStackFrameInfo[] newFrames = new LiveStackFrameInfo[size];
                    System.arraycopy(this.stackFrames, 0, newFrames, 0, startIndex);
                    this.stackFrames = newFrames;
                }
                for (int i = this.startIndex(); i < size; ++i) {
                    this.stackFrames[i] = new LiveStackFrameInfo(LiveStackInfoTraverser.this.walker);
                }
                this.currentBatchSize = size;
            }

            @Override
            LiveStackFrameInfo nextStackFrame() {
                if (this.isEmpty()) {
                    throw new NoSuchElementException("origin=" + this.origin + " fence=" + this.fence);
                }
                LiveStackFrameInfo frame = this.stackFrames[this.origin];
                ++this.origin;
                return frame;
            }

            @Override
            final Class<?> at(int index) {
                return this.stackFrames[index].declaringClass();
            }
        }
    }

    static final class CallerClassFinder
    extends AbstractStackWalker<Integer, Class<?>> {
        private Class<?> caller;

        CallerClassFinder(StackWalker walker) {
            super(walker, 6);
        }

        Class<?> findCaller() {
            this.walk();
            return this.caller;
        }

        @Override
        protected Integer consumeFrames() {
            this.checkState(WalkerState.OPEN);
            int n = 0;
            Class[] frames = new Class[2];
            while (n < 2 && (this.caller = this.nextFrame()) != null) {
                if (StackStreamFactory.isMethodHandleFrame(this.caller) || StackStreamFactory.isReflectionFrame(this.caller)) continue;
                frames[n++] = this.caller;
            }
            if (frames[1] == null) {
                throw new IllegalStateException("no caller frame");
            }
            return n;
        }

        @Override
        protected void initFrameBuffer() {
            this.frameBuffer = new ClassBuffer(this.getNextBatchSize());
        }

        @Override
        protected int batchSize(int lastBatchFrameCount) {
            return 8;
        }

        @Override
        protected int getNextBatchSize() {
            return 8;
        }

        static {
            stackWalkImplClasses.add(CallerClassFinder.class);
        }

        final class ClassBuffer
        extends FrameBuffer<Class<?>> {
            Class<?>[] classes;

            ClassBuffer(int batchSize) {
                super(batchSize);
                this.classes = new Class[batchSize];
            }

            Class<?>[] frames() {
                return this.classes;
            }

            @Override
            final Class<?> at(int index) {
                return this.classes[index];
            }

            @Override
            void resize(int startIndex, int elements) {
                if (!this.isActive()) {
                    throw new IllegalStateException("inactive frame buffer can't be resized");
                }
                assert (startIndex == 2) : "bad start index " + startIndex + " expected " + 2;
                int size = startIndex + elements;
                if (this.classes.length < size) {
                    Class<?>[] prev = this.classes;
                    this.classes = new Class[size];
                    System.arraycopy(prev, 0, this.classes, 0, startIndex);
                }
                this.currentBatchSize = size;
            }
        }
    }

    static class StackFrameTraverser<T>
    extends AbstractStackWalker<T, StackFrameInfo>
    implements Spliterator<StackWalker.StackFrame> {
        private static final int CHARACTERISTICS = 1040;
        final Function<? super Stream<StackWalker.StackFrame>, ? extends T> function;

        StackFrameTraverser(StackWalker walker, Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
            this(walker, function, 0);
        }

        StackFrameTraverser(StackWalker walker, Function<? super Stream<StackWalker.StackFrame>, ? extends T> function, int mode) {
            super(walker, mode);
            this.function = function;
        }

        StackWalker.StackFrame nextStackFrame() {
            if (!this.hasNext()) {
                return null;
            }
            StackFrameInfo frame = (StackFrameInfo)this.frameBuffer.nextStackFrame();
            ++this.depth;
            return frame;
        }

        @Override
        protected T consumeFrames() {
            this.checkState(WalkerState.OPEN);
            Stream<StackWalker.StackFrame> stream = StreamSupport.stream(this, false);
            if (this.function != null) {
                return this.function.apply(stream);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected void initFrameBuffer() {
            this.frameBuffer = new StackFrameBuffer(this.getNextBatchSize());
        }

        @Override
        protected int batchSize(int lastBatchFrameCount) {
            if (lastBatchFrameCount == 0) {
                int initialBatchSize = Math.max(this.walker.estimateDepth(), 8);
                return Math.min(initialBatchSize, 256);
            }
            if (lastBatchFrameCount > 32) {
                return lastBatchFrameCount;
            }
            return Math.min(lastBatchFrameCount * 2, 32);
        }

        @Override
        public Spliterator<StackWalker.StackFrame> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return this.maxDepth;
        }

        @Override
        public int characteristics() {
            return 1040;
        }

        @Override
        public void forEachRemaining(Consumer<? super StackWalker.StackFrame> action) {
            StackWalker.StackFrame frame;
            this.checkState(WalkerState.OPEN);
            for (int n = 0; n < this.maxDepth && (frame = this.nextStackFrame()) != null; ++n) {
                action.accept(frame);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super StackWalker.StackFrame> action) {
            this.checkState(WalkerState.OPEN);
            int index = this.frameBuffer.getIndex();
            if (this.hasNext()) {
                StackWalker.StackFrame frame = this.nextStackFrame();
                action.accept(frame);
                if (isDebug) {
                    System.err.println("tryAdvance: " + index + " " + frame);
                }
                return true;
            }
            if (isDebug) {
                System.err.println("tryAdvance: " + index + " NO element");
            }
            return false;
        }

        static {
            stackWalkImplClasses.add(StackFrameTraverser.class);
        }

        final class StackFrameBuffer
        extends FrameBuffer<StackFrameInfo> {
            private StackFrameInfo[] stackFrames;

            StackFrameBuffer(int initialBatchSize) {
                super(initialBatchSize);
                this.stackFrames = new StackFrameInfo[initialBatchSize];
                for (int i = 2; i < initialBatchSize; ++i) {
                    this.stackFrames[i] = new StackFrameInfo(StackFrameTraverser.this.walker);
                }
            }

            StackFrameInfo[] frames() {
                return this.stackFrames;
            }

            @Override
            void resize(int startIndex, int elements) {
                if (!this.isActive()) {
                    throw new IllegalStateException("inactive frame buffer can't be resized");
                }
                assert (startIndex == 2) : "bad start index " + startIndex + " expected " + 2;
                int size = startIndex + elements;
                if (this.stackFrames.length < size) {
                    StackFrameInfo[] newFrames = new StackFrameInfo[size];
                    System.arraycopy(this.stackFrames, 0, newFrames, 0, startIndex);
                    this.stackFrames = newFrames;
                }
                for (int i = startIndex; i < size; ++i) {
                    this.stackFrames[i] = new StackFrameInfo(StackFrameTraverser.this.walker);
                }
                this.currentBatchSize = size;
            }

            @Override
            StackFrameInfo nextStackFrame() {
                if (this.isEmpty()) {
                    throw new NoSuchElementException("origin=" + this.origin + " fence=" + this.fence);
                }
                StackFrameInfo frame = this.stackFrames[this.origin];
                ++this.origin;
                return frame;
            }

            @Override
            final Class<?> at(int index) {
                return this.stackFrames[index].declaringClass();
            }
        }
    }

    static abstract class AbstractStackWalker<R, T> {
        protected final StackWalker walker;
        protected final Thread thread = Thread.currentThread();
        protected final int maxDepth;
        protected final long mode;
        protected int depth;
        protected FrameBuffer<? extends T> frameBuffer;
        protected long anchor;

        protected AbstractStackWalker(StackWalker walker, int mode) {
            this(walker, mode, Integer.MAX_VALUE);
        }

        protected AbstractStackWalker(StackWalker walker, int mode, int maxDepth) {
            this.mode = this.toStackWalkMode(walker, mode);
            this.walker = walker;
            this.maxDepth = maxDepth;
            this.depth = 0;
        }

        private int toStackWalkMode(StackWalker walker, int mode) {
            int newMode = mode;
            if (walker.hasOption(StackWalker.Option.SHOW_HIDDEN_FRAMES) && (mode & 2) != 2) {
                newMode |= 0x20;
            }
            if (walker.hasLocalsOperandsOption()) {
                newMode |= 0x100;
            }
            return newMode;
        }

        protected abstract R consumeFrames();

        protected abstract void initFrameBuffer();

        protected abstract int batchSize(int var1);

        protected int getNextBatchSize() {
            int lastBatchSize = this.depth == 0 ? 0 : this.frameBuffer.curBatchFrameCount();
            int nextBatchSize = this.batchSize(lastBatchSize);
            if (isDebug) {
                System.err.println("last batch size = " + lastBatchSize + " next batch size = " + nextBatchSize);
            }
            return nextBatchSize >= 8 ? nextBatchSize : 8;
        }

        final void checkState(WalkerState state) {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Invalid thread walking this stack stream: " + Thread.currentThread().getName() + " " + this.thread.getName());
            }
            switch (state) {
                case NEW: {
                    if (this.anchor == 0L) break;
                    throw new IllegalStateException("This stack stream is being reused.");
                }
                case OPEN: {
                    if (this.anchor != 0L && this.anchor != -1L) break;
                    throw new IllegalStateException("This stack stream is not valid for walking.");
                }
                case CLOSED: {
                    if (this.anchor == -1L) break;
                    throw new IllegalStateException("This stack stream is not closed.");
                }
            }
        }

        private void close() {
            this.anchor = -1L;
        }

        final R walk() {
            this.checkState(WalkerState.NEW);
            try {
                R r = this.beginStackWalk();
                return r;
            }
            finally {
                this.close();
            }
        }

        private boolean skipReflectionFrames() {
            return !this.walker.hasOption(StackWalker.Option.SHOW_REFLECT_FRAMES) && !this.walker.hasOption(StackWalker.Option.SHOW_HIDDEN_FRAMES);
        }

        final Class<?> peekFrame() {
            while (this.frameBuffer.isActive() && this.depth < this.maxDepth) {
                if (this.frameBuffer.isEmpty()) {
                    this.getNextBatch();
                    continue;
                }
                Class<?> c = this.frameBuffer.get();
                if (this.skipReflectionFrames() && StackStreamFactory.isReflectionFrame(c)) {
                    if (isDebug) {
                        System.err.println("  skip: frame " + this.frameBuffer.getIndex() + " " + c);
                    }
                    this.frameBuffer.next();
                    ++this.depth;
                    continue;
                }
                return c;
            }
            return null;
        }

        private Object doStackWalk(long anchor, int skipFrames, int batchSize, int bufStartIndex, int bufEndIndex) {
            this.checkState(WalkerState.NEW);
            this.frameBuffer.check(skipFrames);
            if (isDebug) {
                System.err.format("doStackWalk: skip %d start %d end %d%n", skipFrames, bufStartIndex, bufEndIndex);
            }
            this.anchor = anchor;
            this.frameBuffer.setBatch(this.depth, bufStartIndex, bufEndIndex);
            return this.consumeFrames();
        }

        private int getNextBatch() {
            int nextBatchSize = Math.min(this.maxDepth - this.depth, this.getNextBatchSize());
            if (!this.frameBuffer.isActive() || nextBatchSize <= 0) {
                if (isDebug) {
                    System.out.format("  more stack walk done%n", new Object[0]);
                }
                this.frameBuffer.freeze();
                return 0;
            }
            return this.fetchStackFrames(nextBatchSize);
        }

        final Class<?> nextFrame() {
            if (!this.hasNext()) {
                return null;
            }
            Class<?> c = this.frameBuffer.next();
            ++this.depth;
            return c;
        }

        final boolean hasNext() {
            return this.peekFrame() != null;
        }

        private R beginStackWalk() {
            this.initFrameBuffer();
            return this.callStackWalk(this.mode, 0, this.frameBuffer.curBatchFrameCount(), this.frameBuffer.startIndex(), this.frameBuffer.frames());
        }

        private int fetchStackFrames(int batchSize) {
            int numFrames;
            int startIndex = this.frameBuffer.startIndex();
            this.frameBuffer.resize(startIndex, batchSize);
            int endIndex = this.fetchStackFrames(this.mode, this.anchor, batchSize, startIndex, this.frameBuffer.frames());
            if (isDebug) {
                System.out.format("  more stack walk requesting %d got %d to %d frames%n", batchSize, this.frameBuffer.startIndex(), endIndex);
            }
            if ((numFrames = endIndex - startIndex) == 0) {
                this.frameBuffer.freeze();
            } else {
                this.frameBuffer.setBatch(this.depth, startIndex, endIndex);
            }
            return numFrames;
        }

        private native R callStackWalk(long var1, int var3, int var4, int var5, T[] var6);

        private native int fetchStackFrames(long var1, long var3, int var5, int var6, T[] var7);
    }

    static enum WalkerState {
        NEW,
        OPEN,
        CLOSED;

    }
}

