/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jdk.internal.misc.JavaLangInvokeAccess;
import jdk.internal.misc.SharedSecrets;

class StackFrameInfo
implements StackWalker.StackFrame {
    private static final JavaLangInvokeAccess JLIA = SharedSecrets.getJavaLangInvokeAccess();
    private final StackWalker walker;
    private final Class<?> declaringClass;
    private final Object memberName;
    private final short bci;
    private volatile StackTraceElement ste;

    StackFrameInfo(StackWalker walker) {
        this.walker = walker;
        this.declaringClass = null;
        this.bci = (short)-1;
        this.memberName = JLIA.newMemberName();
    }

    Class<?> declaringClass() {
        return this.declaringClass;
    }

    @Override
    public String getClassName() {
        return this.declaringClass.getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        this.walker.ensureAccessEnabled(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        return this.declaringClass;
    }

    @Override
    public String getMethodName() {
        return JLIA.getName(this.memberName);
    }

    @Override
    public int getByteCodeIndex() {
        if (this.isNativeMethod()) {
            return -1;
        }
        return this.bci;
    }

    @Override
    public String getFileName() {
        return this.toStackTraceElement().getFileName();
    }

    @Override
    public int getLineNumber() {
        if (this.isNativeMethod()) {
            return -2;
        }
        return this.toStackTraceElement().getLineNumber();
    }

    @Override
    public boolean isNativeMethod() {
        return JLIA.isNative(this.memberName);
    }

    public String toString() {
        return this.toStackTraceElement().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StackTraceElement toStackTraceElement() {
        StackTraceElement s = this.ste;
        if (s == null) {
            StackFrameInfo stackFrameInfo = this;
            synchronized (stackFrameInfo) {
                s = this.ste;
                if (s == null) {
                    this.ste = s = StackTraceElement.of(this);
                }
            }
        }
        return s;
    }
}

