/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jdk.internal.HotSpotIntrinsicCandidate;

public final class Short
extends Number
implements Comparable<Short> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class<Short> TYPE = Class.getPrimitiveClass("short");
    private final short value;
    public static final int SIZE = 16;
    public static final int BYTES = 2;
    private static final long serialVersionUID = 7515723908773894738L;

    public static String toString(short s) {
        return Integer.toString(s, 10);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + s + "\" Radix:" + radix);
        }
        return (short)i;
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return Short.parseShort(s, radix);
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return Short.valueOf(s, 10);
    }

    @HotSpotIntrinsicCandidate
    public static Short valueOf(short s) {
        int offset = 128;
        short sAsInt = s;
        if (sAsInt >= -128 && sAsInt <= 127) {
            return ShortCache.cache[sAsInt + 128];
        }
        return new Short(s);
    }

    public static Short decode(String nm) throws NumberFormatException {
        int i = Integer.decode(nm);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value " + i + " out of range from input " + nm);
        }
        return (short)i;
    }

    @Deprecated(since="9")
    public Short(short value) {
        this.value = value;
    }

    @Deprecated(since="9")
    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    @HotSpotIntrinsicCandidate
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Short.hashCode(this.value);
    }

    public static int hashCode(short value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Short) {
            return this.value == (Short)obj;
        }
        return false;
    }

    @Override
    public int compareTo(Short anotherShort) {
        return Short.compare(this.value, anotherShort.value);
    }

    public static int compare(short x, short y) {
        return x - y;
    }

    public static int compareUnsigned(short x, short y) {
        return Short.toUnsignedInt(x) - Short.toUnsignedInt(y);
    }

    @HotSpotIntrinsicCandidate
    public static short reverseBytes(short i) {
        return (short)((i & 0xFF00) >> 8 | i << 8);
    }

    public static int toUnsignedInt(short x) {
        return x & 0xFFFF;
    }

    public static long toUnsignedLong(short x) {
        return (long)x & 0xFFFFL;
    }

    private static class ShortCache {
        static final Short[] cache = new Short[256];

        private ShortCache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                ShortCache.cache[i] = new Short((short)(i - 128));
            }
        }
    }
}

