/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class Runtime {
    private static final Runtime currentRuntime = new Runtime();
    private static Version version;

    public static Runtime getRuntime() {
        return currentRuntime;
    }

    private Runtime() {
    }

    public void exit(int status) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExit(status);
        }
        Shutdown.exit(status);
    }

    public void addShutdownHook(Thread hook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        ApplicationShutdownHooks.add(hook);
    }

    public boolean removeShutdownHook(Thread hook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("shutdownHooks"));
        }
        return ApplicationShutdownHooks.remove(hook);
    }

    public void halt(int status) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkExit(status);
        }
        Shutdown.halt(status);
    }

    @Deprecated(since="1.2", forRemoval=true)
    public static void runFinalizersOnExit(boolean value) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkExit(0);
            }
            catch (SecurityException e) {
                throw new SecurityException("runFinalizersOnExit");
            }
        }
        Shutdown.setRunFinalizersOnExit(value);
    }

    public Process exec(String command) throws IOException {
        return this.exec(command, null, null);
    }

    public Process exec(String command, String[] envp) throws IOException {
        return this.exec(command, envp, null);
    }

    public Process exec(String command, String[] envp, File dir) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        return this.exec(cmdarray, envp, dir);
    }

    public Process exec(String[] cmdarray) throws IOException {
        return this.exec(cmdarray, null, null);
    }

    public Process exec(String[] cmdarray, String[] envp) throws IOException {
        return this.exec(cmdarray, envp, null);
    }

    public Process exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return new ProcessBuilder(cmdarray).environment(envp).directory(dir).start();
    }

    public native int availableProcessors();

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();

    public native void gc();

    private static native void runFinalization0();

    public void runFinalization() {
        Runtime.runFinalization0();
    }

    @Deprecated(since="9", forRemoval=true)
    public void traceInstructions(boolean on) {
    }

    @Deprecated(since="9", forRemoval=true)
    public void traceMethodCalls(boolean on) {
    }

    @CallerSensitive
    public void load(String filename) {
        this.load0(Reflection.getCallerClass(), filename);
    }

    synchronized void load0(Class<?> fromClass, String filename) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkLink(filename);
        }
        if (!new File(filename).isAbsolute()) {
            throw new UnsatisfiedLinkError("Expecting an absolute path of the library: " + filename);
        }
        ClassLoader.loadLibrary(fromClass, filename, true);
    }

    @CallerSensitive
    public void loadLibrary(String libname) {
        this.loadLibrary0(Reflection.getCallerClass(), libname);
    }

    synchronized void loadLibrary0(Class<?> fromClass, String libname) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkLink(libname);
        }
        if (libname.indexOf(File.separatorChar) != -1) {
            throw new UnsatisfiedLinkError("Directory separator should not appear in library name: " + libname);
        }
        ClassLoader.loadLibrary(fromClass, libname, false);
    }

    @Deprecated(since="1.1", forRemoval=true)
    public InputStream getLocalizedInputStream(InputStream in) {
        return in;
    }

    @Deprecated(since="1.1", forRemoval=true)
    public OutputStream getLocalizedOutputStream(OutputStream out) {
        return out;
    }

    public static Version version() {
        if (version == null) {
            version = new Version(VersionProps.versionNumbers(), VersionProps.pre(), VersionProps.build(), VersionProps.optional());
        }
        return version;
    }

    private static class VersionPattern {
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "^(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?$";
        static final Pattern VSTR_PATTERN = Pattern.compile("^(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?$");
        static final String VNUM_GROUP = "VNUM";
        static final String PRE_GROUP = "PRE";
        static final String PLUS_GROUP = "PLUS";
        static final String BUILD_GROUP = "BUILD";
        static final String OPT_GROUP = "OPT";

        private VersionPattern() {
        }
    }

    public static class Version
    implements Comparable<Version> {
        private final List<Integer> version;
        private final Optional<String> pre;
        private final Optional<Integer> build;
        private final Optional<String> optional;

        Version(List<Integer> version, Optional<String> pre, Optional<Integer> build, Optional<String> optional) {
            this.version = Collections.unmodifiableList(version);
            this.pre = pre;
            this.build = build;
            this.optional = optional;
        }

        public static Version parse(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            if (Version.isSimpleNumber(s)) {
                return new Version(List.of(Integer.valueOf(Integer.parseInt(s))), Optional.empty(), Optional.empty(), Optional.empty());
            }
            Matcher m = VersionPattern.VSTR_PATTERN.matcher(s);
            if (!m.matches()) {
                throw new IllegalArgumentException("Invalid version string: '" + s + "'");
            }
            ArrayList<Integer> version = new ArrayList<Integer>();
            for (String i : m.group("VNUM").split("\\.")) {
                version.add(Integer.parseInt(i));
            }
            Optional<String> pre = Optional.ofNullable(m.group("PRE"));
            String b = m.group("BUILD");
            Optional<Integer> build = b == null ? Optional.empty() : Optional.of(Integer.parseInt(b));
            Optional<String> optional = Optional.ofNullable(m.group("OPT"));
            if (m.group("PLUS") != null && !build.isPresent()) {
                if (optional.isPresent()) {
                    if (pre.isPresent()) {
                        throw new IllegalArgumentException("'+' found with pre-release and optional components:'" + s + "'");
                    }
                } else {
                    throw new IllegalArgumentException("'+' found with neither build or optional components: '" + s + "'");
                }
            }
            return new Version(version, pre, build, optional);
        }

        private static boolean isSimpleNumber(String s) {
            for (int i = 0; i < s.length(); ++i) {
                char lowerBound;
                char c = s.charAt(i);
                char c2 = lowerBound = i > 0 ? (char)'0' : '1';
                if (c >= lowerBound && c <= '9') continue;
                return false;
            }
            return true;
        }

        public int major() {
            return this.version.get(0);
        }

        public int minor() {
            return this.version.size() > 1 ? this.version.get(1) : 0;
        }

        public int security() {
            return this.version.size() > 2 ? this.version.get(2) : 0;
        }

        public List<Integer> version() {
            return this.version;
        }

        public Optional<String> pre() {
            return this.pre;
        }

        public Optional<Integer> build() {
            return this.build;
        }

        public Optional<String> optional() {
            return this.optional;
        }

        @Override
        public int compareTo(Version ob) {
            return this.compare(ob, false);
        }

        public int compareToIgnoreOptional(Version ob) {
            return this.compare(ob, true);
        }

        private int compare(Version ob, boolean ignoreOpt) {
            if (ob == null) {
                throw new NullPointerException("Invalid argument");
            }
            int ret = this.compareVersion(ob);
            if (ret != 0) {
                return ret;
            }
            ret = this.comparePre(ob);
            if (ret != 0) {
                return ret;
            }
            ret = this.compareBuild(ob);
            if (ret != 0) {
                return ret;
            }
            if (!ignoreOpt) {
                return this.compareOptional(ob);
            }
            return 0;
        }

        private int compareVersion(Version ob) {
            int size = this.version.size();
            int oSize = ob.version().size();
            int min = Math.min(size, oSize);
            for (int i = 0; i < min; ++i) {
                Integer oVal;
                Integer val = this.version.get(i);
                if (val == (oVal = ob.version().get(i))) continue;
                return val - oVal;
            }
            if (size != oSize) {
                return size - oSize;
            }
            return 0;
        }

        private int comparePre(Version ob) {
            Optional<String> oPre = ob.pre();
            if (!this.pre.isPresent()) {
                if (oPre.isPresent()) {
                    return 1;
                }
            } else {
                if (!oPre.isPresent()) {
                    return -1;
                }
                String val = this.pre.get();
                String oVal = oPre.get();
                if (val.matches("\\d+")) {
                    return oVal.matches("\\d+") ? new BigInteger(val).compareTo(new BigInteger(oVal)) : -1;
                }
                return oVal.matches("\\d+") ? 1 : val.compareTo(oVal);
            }
            return 0;
        }

        private int compareBuild(Version ob) {
            Optional<Integer> oBuild = ob.build();
            if (oBuild.isPresent()) {
                return this.build.isPresent() ? this.build.get().compareTo(oBuild.get()) : 1;
            }
            if (this.build.isPresent()) {
                return -1;
            }
            return 0;
        }

        private int compareOptional(Version ob) {
            Optional<String> oOpt = ob.optional();
            if (!this.optional.isPresent()) {
                if (oOpt.isPresent()) {
                    return -1;
                }
            } else {
                if (!oOpt.isPresent()) {
                    return 1;
                }
                return this.optional.get().compareTo(oOpt.get());
            }
            return 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.version.stream().map(Object::toString).collect(Collectors.joining(".")));
            this.pre.ifPresent(v -> sb.append("-").append((String)v));
            if (this.build.isPresent()) {
                sb.append("+").append(this.build.get());
                if (this.optional.isPresent()) {
                    sb.append("-").append(this.optional.get());
                }
            } else if (this.optional.isPresent()) {
                sb.append(this.pre.isPresent() ? "-" : "+-");
                sb.append(this.optional.get());
            }
            return sb.toString();
        }

        public boolean equals(Object ob) {
            boolean ret = this.equalsIgnoreOptional(ob);
            if (!ret) {
                return false;
            }
            Version that = (Version)ob;
            return this.optional().equals(that.optional());
        }

        public boolean equalsIgnoreOptional(Object ob) {
            if (this == ob) {
                return true;
            }
            if (!(ob instanceof Version)) {
                return false;
            }
            Version that = (Version)ob;
            return this.version().equals(that.version()) && this.pre().equals(that.pre()) && this.build().equals(that.build());
        }

        public int hashCode() {
            int h = 1;
            int p = 17;
            h = p * h + this.version.hashCode();
            h = p * h + this.pre.hashCode();
            h = p * h + this.build.hashCode();
            h = p * h + this.optional.hashCode();
            return h;
        }
    }
}

