/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.internal.misc.JavaIOFileDescriptorAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.ref.CleanerFactory;

final class ProcessImpl
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    static final boolean SUPPORTS_NORMAL_TERMINATION = false;
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_LEGACY = 2;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t'}};
    private final long handle;
    private final ProcessHandle processHandle;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = ProcessImpl.getStillActive();

    private static FileOutputStream newFileOutputStream(File f, boolean append) throws IOException {
        if (append) {
            String path = f.getPath();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkWrite(path);
            }
            long handle = ProcessImpl.openForAtomicAppend(path);
            final FileDescriptor fd = new FileDescriptor();
            fdAccess.setHandle(fd, handle);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fd);
                }
            });
        }
        return new FileOutputStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] cmdarray, Map<String, String> environment, String dir, ProcessBuilder.Redirect[] redirects, boolean redirectErrorStream) throws IOException {
        String envblock = ProcessEnvironment.toEnvironmentBlock(environment);
        FileInputStream f0 = null;
        FileOutputStream f1 = null;
        FileOutputStream f2 = null;
        try {
            long[] stdHandles;
            if (redirects == null) {
                stdHandles = new long[]{-1L, -1L, -1L};
            } else {
                stdHandles = new long[3];
                if (redirects[0] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[0] = -1L;
                } else if (redirects[0] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[0] = fdAccess.getHandle(FileDescriptor.in);
                } else if (redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[0] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd());
                } else {
                    f0 = new FileInputStream(redirects[0].file());
                    stdHandles[0] = fdAccess.getHandle(f0.getFD());
                }
                if (redirects[1] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[1] = -1L;
                } else if (redirects[1] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[1] = fdAccess.getHandle(FileDescriptor.out);
                } else if (redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[1] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd());
                } else {
                    f1 = ProcessImpl.newFileOutputStream(redirects[1].file(), redirects[1].append());
                    stdHandles[1] = fdAccess.getHandle(f1.getFD());
                }
                if (redirects[2] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[2] = -1L;
                } else if (redirects[2] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[2] = fdAccess.getHandle(FileDescriptor.err);
                } else if (redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[2] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd());
                } else {
                    f2 = ProcessImpl.newFileOutputStream(redirects[2].file(), redirects[2].append());
                    stdHandles[2] = fdAccess.getHandle(f2.getFD());
                }
            }
            ProcessImpl p = new ProcessImpl(cmdarray, envblock, dir, stdHandles, redirectErrorStream);
            if (redirects != null) {
                if (stdHandles[0] >= 0L && redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd(), stdHandles[0]);
                }
                if (stdHandles[1] >= 0L && redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd(), stdHandles[1]);
                }
                if (stdHandles[2] >= 0L && redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd(), stdHandles[2]);
                }
            }
            ProcessImpl processImpl = p;
            return processImpl;
        }
        finally {
            try {
                if (f0 != null) {
                    f0.close();
                }
            }
            finally {
                try {
                    if (f1 != null) {
                        f1.close();
                    }
                }
                finally {
                    if (f2 != null) {
                        f2.close();
                    }
                }
            }
        }
    }

    private static String[] getTokensFromCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>(8);
        Matcher regexMatcher = LazyPattern.PATTERN.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    private static String createCommandLine(int verificationType, String executablePath, String[] cmd) {
        StringBuilder cmdbuf = new StringBuilder(80);
        cmdbuf.append(executablePath);
        for (int i = 1; i < cmd.length; ++i) {
            cmdbuf.append(' ');
            String s = cmd[i];
            if (ProcessImpl.needsEscaping(verificationType, s)) {
                cmdbuf.append('\"').append(s);
                if (verificationType != 0 && s.endsWith("\\")) {
                    cmdbuf.append('\\');
                }
                cmdbuf.append('\"');
                continue;
            }
            cmdbuf.append(s);
        }
        return cmdbuf.toString();
    }

    private static boolean isQuoted(boolean noQuotesInside, String arg, String errorMessage) {
        int lastPos = arg.length() - 1;
        if (lastPos >= 1 && arg.charAt(0) == '\"' && arg.charAt(lastPos) == '\"') {
            if (noQuotesInside && arg.indexOf(34, 1) != lastPos) {
                throw new IllegalArgumentException(errorMessage);
            }
            return true;
        }
        if (noQuotesInside && arg.indexOf(34) >= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return false;
    }

    private static boolean needsEscaping(int verificationType, String arg) {
        boolean argIsQuoted = ProcessImpl.isQuoted(verificationType == 0, arg, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!argIsQuoted) {
            char[] testEscape = ESCAPE_VERIFICATION[verificationType];
            for (int i = 0; i < testEscape.length; ++i) {
                if (arg.indexOf(testEscape[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String path) throws IOException {
        boolean pathIsQuoted = ProcessImpl.isQuoted(true, path, "Executable name has embedded quote, split the arguments");
        File fileToRun = new File(pathIsQuoted ? path.substring(1, path.length() - 1) : path);
        return fileToRun.getPath();
    }

    private boolean isShellFile(String executablePath) {
        String upPath = executablePath.toUpperCase();
        return upPath.endsWith(".CMD") || upPath.endsWith(".BAT");
    }

    private String quoteString(String arg) {
        StringBuilder argbuf = new StringBuilder(arg.length() + 2);
        return argbuf.append('\"').append(arg).append('\"').toString();
    }

    private ProcessImpl(String[] cmd, String envblock, String path, final long[] stdHandles, boolean redirectErrorStream) throws IOException {
        String cmdstr;
        String executablePath;
        SecurityManager security = System.getSecurityManager();
        boolean allowAmbiguousCommands = false;
        if (security == null) {
            allowAmbiguousCommands = true;
            String value = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
            if (value != null) {
                boolean bl = allowAmbiguousCommands = !"false".equalsIgnoreCase(value);
            }
        }
        if (allowAmbiguousCommands) {
            executablePath = new File(cmd[0]).getPath();
            if (ProcessImpl.needsEscaping(2, executablePath)) {
                executablePath = this.quoteString(executablePath);
            }
            cmdstr = ProcessImpl.createCommandLine(2, executablePath, cmd);
        } else {
            block8: {
                try {
                    executablePath = ProcessImpl.getExecutablePath(cmd[0]);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder join = new StringBuilder();
                    for (String s : cmd) {
                        join.append(s).append(' ');
                    }
                    cmd = ProcessImpl.getTokensFromCommand(join.toString());
                    executablePath = ProcessImpl.getExecutablePath(cmd[0]);
                    if (security == null) break block8;
                    security.checkExec(executablePath);
                }
            }
            cmdstr = ProcessImpl.createCommandLine(this.isShellFile(executablePath) ? 0 : 1, this.quoteString(executablePath), cmd);
        }
        long local_handle = this.handle = ProcessImpl.create(cmdstr, envblock, path, stdHandles, redirectErrorStream);
        CleanerFactory.cleaner().register(this, () -> ProcessImpl.closeHandle(local_handle));
        this.processHandle = ProcessHandleImpl.getInternal(ProcessImpl.getProcessId0(this.handle));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (stdHandles[0] == -1L) {
                    ProcessImpl.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    FileDescriptor stdin_fd = new FileDescriptor();
                    fdAccess.setHandle(stdin_fd, stdHandles[0]);
                    ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(stdin_fd));
                }
                if (stdHandles[1] == -1L) {
                    ProcessImpl.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stdout_fd = new FileDescriptor();
                    fdAccess.setHandle(stdout_fd, stdHandles[1]);
                    ProcessImpl.this.stdout_stream = new BufferedInputStream(new Process.PipeInputStream(stdout_fd));
                }
                if (stdHandles[2] == -1L) {
                    ProcessImpl.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stderr_fd = new FileDescriptor();
                    fdAccess.setHandle(stderr_fd, stdHandles[2]);
                    ProcessImpl.this.stderr_stream = new Process.PipeInputStream(stderr_fd);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int exitCode = ProcessImpl.getExitCodeProcess(this.handle);
        if (exitCode == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return exitCode;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        if (ProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + remainingNanos;
        do {
            long msTimeout = TimeUnit.NANOSECONDS.toMillis(remainingNanos + 999999L);
            ProcessImpl.waitForTimeoutInterruptibly(this.handle, msTimeout);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (ProcessImpl.getExitCodeProcess(this.handle) == STILL_ACTIVE) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return ProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE;
    }

    private static native void waitForTimeoutInterruptibly(long var0, long var2);

    @Override
    public void destroy() {
        ProcessImpl.terminateProcess(this.handle);
    }

    @Override
    public CompletableFuture<Process> onExit() {
        return ProcessHandleImpl.completion(this.getPid(), false).handleAsync((exitStatus, unusedThrowable) -> this);
    }

    @Override
    public ProcessHandle toHandle() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        return this.processHandle;
    }

    @Override
    public boolean supportsNormalTermination() {
        return false;
    }

    @Override
    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    private static native void terminateProcess(long var0);

    @Override
    public long getPid() {
        return this.processHandle.getPid();
    }

    private static native int getProcessId0(long var0);

    @Override
    public boolean isAlive() {
        return ProcessImpl.isProcessAlive(this.handle);
    }

    private static native boolean isProcessAlive(long var0);

    public String toString() {
        int exitCode = ProcessImpl.getExitCodeProcess(this.handle);
        return "Process[pid=" + this.getPid() + ", exitValue=" + (exitCode == STILL_ACTIVE ? "\"not exited\"" : Integer.valueOf(exitCode)) + "]";
    }

    private static synchronized native long create(String var0, String var1, String var2, long[] var3, boolean var4) throws IOException;

    private static native long openForAtomicAppend(String var0) throws IOException;

    private static native boolean closeHandle(long var0);

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

