/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public abstract class Process {
    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public abstract InputStream getErrorStream();

    public abstract int waitFor() throws InterruptedException;

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime = System.nanoTime();
        long rem = unit.toNanos(timeout);
        while (true) {
            try {
                this.exitValue();
                return true;
            }
            catch (IllegalThreadStateException ex) {
                if (rem <= 0L) continue;
                Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(rem) + 1L, 100L));
                if ((rem = unit.toNanos(timeout) - (System.nanoTime() - startTime)) > 0L) continue;
                return false;
            }
            break;
        }
    }

    public abstract int exitValue();

    public abstract void destroy();

    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    public boolean supportsNormalTermination() {
        throw new UnsupportedOperationException(this.getClass() + ".supportsNormalTermination() not supported");
    }

    public boolean isAlive() {
        try {
            this.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public long getPid() {
        return this.toHandle().getPid();
    }

    public CompletableFuture<Process> onExit() {
        return CompletableFuture.supplyAsync(this::waitForInternal);
    }

    private Process waitForInternal() {
        boolean interrupted = false;
        while (true) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        Process.this.waitFor();
                        return true;
                    }

                    @Override
                    public boolean isReleasable() {
                        return !Process.this.isAlive();
                    }
                });
            }
            catch (InterruptedException x) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public ProcessHandle toHandle() {
        throw new UnsupportedOperationException(this.getClass() + ".toHandle() not supported");
    }

    public ProcessHandle.Info info() {
        return this.toHandle().info();
    }

    public Stream<ProcessHandle> children() {
        return this.toHandle().children();
    }

    public Stream<ProcessHandle> descendants() {
        return this.toHandle().descendants();
    }

    static class PipeInputStream
    extends FileInputStream {
        PipeInputStream(FileDescriptor fd) {
            super(fd);
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }
}

