/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.module.Configuration;
import java.lang.module.ModuleReference;
import java.lang.reflect.Module;
import java.net.URI;

class NamedPackage {
    private final String name;
    private final Module module;

    NamedPackage(String pn, Module module) {
        if (pn.isEmpty() && module.isNamed()) {
            throw new InternalError("unnamed package in  " + module);
        }
        this.name = pn.intern();
        this.module = module;
    }

    String packageName() {
        return this.name;
    }

    Module module() {
        return this.module;
    }

    URI location() {
        if (this.module.isNamed() && this.module.getLayer() != null) {
            Configuration cf = this.module.getLayer().configuration();
            ModuleReference mref = cf.findModule(this.module.getName()).get().reference();
            return mref.location().orElse(null);
        }
        return null;
    }

    static Package toPackage(String name, Module module) {
        return new Package(name, module);
    }
}

