/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

final class LiveStackFrameInfo
extends StackFrameInfo
implements LiveStackFrame {
    private static Object[] EMPTY_ARRAY = new Object[0];
    private Object[] monitors = EMPTY_ARRAY;
    private Object[] locals = EMPTY_ARRAY;
    private Object[] operands = EMPTY_ARRAY;

    LiveStackFrameInfo(StackWalker walker) {
        super(walker);
    }

    @Override
    public Object[] getMonitors() {
        return this.monitors;
    }

    @Override
    public Object[] getLocals() {
        return this.locals;
    }

    @Override
    public Object[] getStack() {
        return this.operands;
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(boolean value) {
        return new BooleanPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(int value) {
        return new IntPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(short value) {
        return new ShortPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(char value) {
        return new CharPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(byte value) {
        return new BytePrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(long value) {
        return new LongPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(float value) {
        return new FloatPrimitive(value);
    }

    static LiveStackFrame.PrimitiveValue asPrimitive(double value) {
        return new DoublePrimitive(value);
    }

    private static class DoublePrimitive
    extends LiveStackFrame.PrimitiveValue {
        final double value;

        DoublePrimitive(double value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'D';
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FloatPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final float value;

        FloatPrimitive(float value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'F';
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LongPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final long value;

        LongPrimitive(long value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'J';
        }

        @Override
        public long longValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BytePrimitive
    extends LiveStackFrame.PrimitiveValue {
        final byte value;

        BytePrimitive(byte value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'B';
        }

        @Override
        public byte byteValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CharPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final char value;

        CharPrimitive(char value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'C';
        }

        @Override
        public char charValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class BooleanPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final boolean value;

        BooleanPrimitive(boolean value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'Z';
        }

        @Override
        public boolean booleanValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ShortPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final short value;

        ShortPrimitive(short value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'S';
        }

        @Override
        public short shortValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class IntPrimitive
    extends LiveStackFrame.PrimitiveValue {
        final int value;

        IntPrimitive(int value) {
            this.value = value;
        }

        @Override
        public char type() {
            return 'I';
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

