/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class FdLibm {
    private static final double INFINITY = Double.POSITIVE_INFINITY;

    private FdLibm() {
        throw new UnsupportedOperationException("No FdLibm instances for you.");
    }

    private static int __LO(double x) {
        long transducer = Double.doubleToRawLongBits(x);
        return (int)transducer;
    }

    private static double __LO(double x, int low) {
        long transX = Double.doubleToRawLongBits(x);
        return Double.longBitsToDouble(transX & 0xFFFFFFFF00000000L | (long)low & 0xFFFFFFFFL);
    }

    private static int __HI(double x) {
        long transducer = Double.doubleToRawLongBits(x);
        return (int)(transducer >> 32);
    }

    private static double __HI(double x, int high) {
        long transX = Double.doubleToRawLongBits(x);
        return Double.longBitsToDouble(transX & 0xFFFFFFFFL | (long)high << 32);
    }

    static class Exp {
        private static final double one = 1.0;
        private static final double[] half = new double[]{0.5, -0.5};
        private static final double huge = 1.0E300;
        private static final double twom1000 = 9.332636185032189E-302;
        private static final double o_threshold = 709.782712893384;
        private static final double u_threshold = -745.1332191019411;
        private static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
        private static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
        private static final double invln2 = 1.4426950408889634;
        private static final double P1 = 0.16666666666666602;
        private static final double P2 = -0.0027777777777015593;
        private static final double P3 = 6.613756321437934E-5;
        private static final double P4 = -1.6533902205465252E-6;
        private static final double P5 = 4.1381367970572385E-8;

        Exp() {
        }

        public static strictfp double compute(double x) {
            double t;
            double hi = 0.0;
            double lo = 0.0;
            int k = 0;
            int hx = FdLibm.__HI(x);
            int xsb = hx >> 31 & 1;
            if ((hx &= Integer.MAX_VALUE) >= 1082535490) {
                if (hx >= 0x7FF00000) {
                    if ((hx & 0xFFFFF | FdLibm.__LO(x)) != 0) {
                        return x + x;
                    }
                    return xsb == 0 ? x : 0.0;
                }
                if (x > 709.782712893384) {
                    return Double.POSITIVE_INFINITY;
                }
                if (x < -745.1332191019411) {
                    return 0.0;
                }
            }
            if (hx > 1071001154) {
                if (hx < 1072734898) {
                    hi = x - ln2HI[xsb];
                    lo = ln2LO[xsb];
                    k = 1 - xsb - xsb;
                } else {
                    k = (int)(1.4426950408889634 * x + half[xsb]);
                    t = k;
                    hi = x - t * ln2HI[0];
                    lo = t * ln2LO[0];
                }
                x = hi - lo;
            } else if (hx < 0x3E300000) {
                if (1.0E300 + x > 1.0) {
                    return 1.0 + x;
                }
            } else {
                k = 0;
            }
            t = x * x;
            double c = x - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
            if (k == 0) {
                return 1.0 - (x * c / (c - 2.0) - x);
            }
            double y = 1.0 - (lo - x * c / (2.0 - c) - hi);
            if (k >= -1021) {
                y = FdLibm.__HI(y, FdLibm.__HI(y) + (k << 20));
                return y;
            }
            y = FdLibm.__HI(y, FdLibm.__HI(y) + (k + 1000 << 20));
            return y * 9.332636185032189E-302;
        }
    }

    public static class Pow {
        public static strictfp double compute(double x, double y) {
            double p_l;
            double r;
            int k;
            int j;
            double t2;
            double t1;
            double v;
            double u;
            double w;
            double t;
            if (y == 0.0) {
                return 1.0;
            }
            if (Double.isNaN(x) || Double.isNaN(y)) {
                return x + y;
            }
            double y_abs = Math.abs(y);
            double x_abs = Math.abs(x);
            if (y == 2.0) {
                return x * x;
            }
            if (y == 0.5) {
                if (x >= -1.7976931348623157E308) {
                    return Math.sqrt(x + 0.0);
                }
            } else {
                if (y_abs == 1.0) {
                    return y == 1.0 ? x : 1.0 / x;
                }
                if (y_abs == Double.POSITIVE_INFINITY) {
                    if (x_abs == 1.0) {
                        return y - y;
                    }
                    if (x_abs > 1.0) {
                        return y >= 0.0 ? y : 0.0;
                    }
                    return y < 0.0 ? -y : 0.0;
                }
            }
            int hx = FdLibm.__HI(x);
            int ix = hx & Integer.MAX_VALUE;
            int y_is_int = 0;
            if (hx < 0) {
                long y_abs_as_long;
                if (y_abs >= 9.007199254740992E15) {
                    y_is_int = 2;
                } else if (y_abs >= 1.0 && (double)(y_abs_as_long = (long)y_abs) == y_abs) {
                    y_is_int = 2 - (int)(y_abs_as_long & 1L);
                }
            }
            if (x_abs == 0.0 || x_abs == Double.POSITIVE_INFINITY || x_abs == 1.0) {
                double z = x_abs;
                if (y < 0.0) {
                    z = 1.0 / z;
                }
                if (hx < 0) {
                    if ((ix - 0x3FF00000 | y_is_int) == 0) {
                        z = (z - z) / (z - z);
                    } else if (y_is_int == 1) {
                        z = -1.0 * z;
                    }
                }
                return z;
            }
            int n = (hx >> 31) + 1;
            if ((n | y_is_int) == 0) {
                return (x - x) / (x - x);
            }
            double s = 1.0;
            if ((n | y_is_int - 1) == 0) {
                s = -1.0;
            }
            if (y_abs > 2.1474856959999995E9) {
                double INV_LN2 = 1.4426950408889634;
                double INV_LN2_H = 1.442695f;
                double INV_LN2_L = 1.9259629911266175E-8;
                if (x_abs < 0.9999995231628418) {
                    return y < 0.0 ? s * Double.POSITIVE_INFINITY : s * 0.0;
                }
                if (x_abs > 1.0000009536743162) {
                    return y > 0.0 ? s * Double.POSITIVE_INFINITY : s * 0.0;
                }
                t = x_abs - 1.0;
                w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
                u = (double)1.442695f * t;
                v = t * 1.9259629911266175E-8 - w * 1.4426950408889634;
                t1 = u + v;
                t1 = FdLibm.__LO(t1, 0);
                t2 = v - (t1 - u);
            } else {
                double ss;
                double CP = 0.9617966939259756;
                double CP_H = 0.9617967009544373;
                double CP_L = -7.028461650952758E-9;
                n = 0;
                if (ix < 0x100000) {
                    n -= 53;
                    ix = FdLibm.__HI(x_abs *= 9.007199254740992E15);
                }
                n += (ix >> 20) - 1023;
                j = ix & 0xFFFFF;
                ix = j | 0x3FF00000;
                if (j <= 235662) {
                    k = 0;
                } else if (j < 767610) {
                    k = 1;
                } else {
                    k = 0;
                    ++n;
                    ix -= 0x100000;
                }
                x_abs = FdLibm.__HI(x_abs, ix);
                double[] BP = new double[]{1.0, 1.5};
                double[] DP_H = new double[]{0.0, 0.5849624872207642};
                double[] DP_L = new double[]{0.0, 1.350039202129749E-8};
                double L1 = 0.5999999999999946;
                double L2 = 0.4285714285785502;
                double L3 = 0.33333332981837743;
                double L4 = 0.272728123808534;
                double L5 = 0.23066074577556175;
                double L6 = 0.20697501780033842;
                u = x_abs - BP[k];
                v = 1.0 / (x_abs + BP[k]);
                double s_h = ss = u * v;
                s_h = FdLibm.__LO(s_h, 0);
                double t_h = 0.0;
                t_h = FdLibm.__HI(t_h, (ix >> 1 | 0x20000000) + 524288 + (k << 18));
                double t_l = x_abs - (t_h - BP[k]);
                double s_l = v * (u - s_h * t_h - s_h * t_l);
                double s2 = ss * ss;
                r = s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
                s2 = s_h * s_h;
                t_h = 3.0 + s2 + (r += s_l * (s_h + ss));
                t_h = FdLibm.__LO(t_h, 0);
                t_l = r - (t_h - 3.0 - s2);
                u = s_h * t_h;
                v = s_l * t_h + t_l * ss;
                double p_h = u + v;
                p_h = FdLibm.__LO(p_h, 0);
                p_l = v - (p_h - u);
                double z_h = 0.9617967009544373 * p_h;
                double z_l = -7.028461650952758E-9 * p_h + p_l * 0.9617966939259756 + DP_L[k];
                t = n;
                t1 = z_h + z_l + DP_H[k] + t;
                t1 = FdLibm.__LO(t1, 0);
                t2 = z_l - (t1 - t - DP_H[k] - z_h);
            }
            double y1 = y;
            y1 = FdLibm.__LO(y1, 0);
            p_l = (y - y1) * t1 + y * t2;
            double p_h = y1 * t1;
            double z = p_l + p_h;
            j = FdLibm.__HI(z);
            int i = FdLibm.__LO(z);
            if (j >= 0x40900000) {
                if ((j - 0x40900000 | i) != 0) {
                    return s * Double.POSITIVE_INFINITY;
                }
                double OVT = 8.008566259537294E-17;
                if (p_l + 8.008566259537294E-17 > z - p_h) {
                    return s * Double.POSITIVE_INFINITY;
                }
            } else if ((j & Integer.MAX_VALUE) >= 1083231232) {
                if ((j - -1064252416 | i) != 0) {
                    return s * 0.0;
                }
                if (p_l <= z - p_h) {
                    return s * 0.0;
                }
            }
            double P1 = 0.16666666666666602;
            double P2 = -0.0027777777777015593;
            double P3 = 6.613756321437934E-5;
            double P4 = -1.6533902205465252E-6;
            double P5 = 4.1381367970572385E-8;
            double LG2 = 0.6931471805599453;
            double LG2_H = 0.6931471824645996;
            double LG2_L = -1.904654299957768E-9;
            i = j & Integer.MAX_VALUE;
            k = (i >> 20) - 1023;
            n = 0;
            if (i > 1071644672) {
                n = j + (0x100000 >> k + 1);
                k = ((n & Integer.MAX_VALUE) >> 20) - 1023;
                t = 0.0;
                t = FdLibm.__HI(t, n & ~(1048575 >> k));
                n = (n & 0xFFFFF | 0x100000) >> 20 - k;
                if (j < 0) {
                    n = -n;
                }
                p_h -= t;
            }
            t = p_l + p_h;
            t = FdLibm.__LO(t, 0);
            u = t * 0.6931471824645996;
            v = (p_l - (t - p_h)) * 0.6931471805599453 + t * -1.904654299957768E-9;
            z = u + v;
            w = v - (z - u);
            t = z * z;
            t1 = z - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
            r = z * t1 / (t1 - 2.0) - (w + z * w);
            z = 1.0 - (r - z);
            j = FdLibm.__HI(z);
            if ((j += n << 20) >> 20 <= 0) {
                z = Math.scalb(z, n);
            } else {
                int z_hi = FdLibm.__HI(z);
                z = FdLibm.__HI(z, z_hi += n << 20);
            }
            return s * z;
        }
    }

    public static class Hypot {
        public static final double TWO_MINUS_600 = 2.409919865102884E-181;
        public static final double TWO_PLUS_600 = 4.149515568880993E180;

        public static strictfp double compute(double x, double y) {
            double w;
            double t1;
            int hb;
            double a = Math.abs(x);
            double b = Math.abs(y);
            if (!Double.isFinite(a) || !Double.isFinite(b)) {
                if (a == Double.POSITIVE_INFINITY || b == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                return a + b;
            }
            if (b > a) {
                double tmp = a;
                a = b;
                b = tmp;
            }
            assert (a >= b);
            int ha = FdLibm.__HI(a);
            if (ha - (hb = FdLibm.__HI(b)) > 0x3C00000) {
                return a + b;
            }
            int k = 0;
            if (a > 3.2733937296446915E150) {
                ha -= 629145600;
                hb -= 629145600;
                a *= 2.409919865102884E-181;
                b *= 2.409919865102884E-181;
                k += 600;
            }
            if (b < 3.054936363499605E-151) {
                if (b < Double.MIN_NORMAL) {
                    if (b == 0.0) {
                        return a;
                    }
                    t1 = 4.49423283715579E307;
                    b *= t1;
                    a *= t1;
                    k -= 1022;
                } else {
                    ha += 629145600;
                    hb += 629145600;
                    a *= 4.149515568880993E180;
                    b *= 4.149515568880993E180;
                    k -= 600;
                }
            }
            if ((w = a - b) > b) {
                t1 = 0.0;
                t1 = FdLibm.__HI(t1, ha);
                double t2 = a - t1;
                w = Math.sqrt(t1 * t1 - (b * -b - t2 * (a + t1)));
            } else {
                a += a;
                double y1 = 0.0;
                y1 = FdLibm.__HI(y1, hb);
                double y2 = b - y1;
                t1 = 0.0;
                t1 = FdLibm.__HI(t1, ha + 0x100000);
                double t2 = a - t1;
                w = Math.sqrt(t1 * y1 - (w * -w - (t1 * y2 + t2 * b)));
            }
            if (k != 0) {
                return Math.powerOfTwoD(k) * w;
            }
            return w;
        }
    }

    public static class Cbrt {
        private static final int B1 = 715094163;
        private static final int B2 = 696219795;
        private static final double C = 0.5428571428571428;
        private static final double D = -0.7053061224489796;
        private static final double E = 1.4142857142857144;
        private static final double F = 1.6071428571428572;
        private static final double G = 0.35714285714285715;

        public static strictfp double compute(double x) {
            double t = 0.0;
            if (x == 0.0 || !Double.isFinite(x)) {
                return x;
            }
            double sign = x < 0.0 ? -1.0 : 1.0;
            if ((x = Math.abs(x)) < Double.MIN_NORMAL) {
                t = 1.8014398509481984E16;
                t *= x;
                t = FdLibm.__HI(t, FdLibm.__HI(t) / 3 + 696219795);
            } else {
                int hx = FdLibm.__HI(x);
                t = FdLibm.__HI(t, hx / 3 + 715094163);
            }
            double r = t * t / x;
            double s = 0.5428571428571428 + r * t;
            t *= 0.35714285714285715 + 1.6071428571428572 / (s + 1.4142857142857144 + -0.7053061224489796 / s);
            t = FdLibm.__LO(t, 0);
            t = FdLibm.__HI(t, FdLibm.__HI(t) + 1);
            s = t * t;
            r = x / s;
            double w = t + t;
            r = (r - t) / (w + r);
            t += t * r;
            return sign * t;
        }
    }
}

