/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Module;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import jdk.internal.HotSpotIntrinsicCandidate;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ResourceHelper;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.ConstantPool;
import jdk.internal.reflect.Reflection;
import jdk.internal.reflect.ReflectionFactory;
import jdk.internal.vm.annotation.ForceInline;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private volatile transient Constructor<T> cachedConstructor;
    private volatile transient Class<?> newInstanceCallerCache;
    private transient String name;
    private transient Module module;
    private final ClassLoader classLoader;
    private transient String packageName;
    private final Class<?> componentType;
    private static ProtectionDomain allPermDomain;
    private volatile transient SoftReference<ReflectionData<T>> reflectionData;
    private volatile transient int classRedefinedCount;
    private volatile transient ClassRepository genericInfo;
    private static final Class<?>[] EMPTY_CLASS_ARRAY;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static ReflectionFactory reflectionFactory;
    private volatile transient T[] enumConstants;
    private volatile transient Map<String, T> enumConstantDirectory;
    private volatile transient AnnotationData annotationData;
    private volatile transient AnnotationType annotationType;
    transient ClassValue.ClassValueMap classValueMap;

    private static native void registerNatives();

    private Class(ClassLoader loader, Class<?> arrayComponentType) {
        this.classLoader = loader;
        this.componentType = arrayComponentType;
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public String toGenericString() {
        if (this.isPrimitive()) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        Class<?> component = this;
        int arrayDepth = 0;
        if (this.isArray()) {
            do {
                ++arrayDepth;
            } while ((component = component.getComponentType()).isArray());
            sb.append(component.getName());
        } else {
            int modifiers = this.getModifiers() & Modifier.classModifiers();
            if (modifiers != 0) {
                sb.append(Modifier.toString(modifiers));
                sb.append(' ');
            }
            if (this.isAnnotation()) {
                sb.append('@');
            }
            if (this.isInterface()) {
                sb.append("interface");
            } else if (this.isEnum()) {
                sb.append("enum");
            } else {
                sb.append("class");
            }
            sb.append(' ');
            sb.append(this.getName());
        }
        TypeVariable<Class<?>>[] typeparms = component.getTypeParameters();
        if (typeparms.length > 0) {
            StringJoiner sj = new StringJoiner(",", "<", ">");
            for (TypeVariable<Class<?>> typeparm : typeparms) {
                sj.add(typeparm.getTypeName());
            }
            sb.append(sj.toString());
        }
        for (int i = 0; i < arrayDepth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    @CallerSensitive
    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> caller = Reflection.getCallerClass();
        return Class.forName0(className, true, ClassLoader.getClassLoader(caller), caller);
    }

    @CallerSensitive
    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> caller = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader ccl;
            caller = Reflection.getCallerClass();
            if (VM.isSystemDomainLoader(loader) && !VM.isSystemDomainLoader(ccl = ClassLoader.getClassLoader(caller))) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
        }
        return Class.forName0(name, initialize, loader, caller);
    }

    private static native Class<?> forName0(String var0, boolean var1, ClassLoader var2, Class<?> var3) throws ClassNotFoundException;

    @CallerSensitive
    public static Class<?> forName(Module module, String name) {
        SecurityManager sm;
        Objects.requireNonNull(module);
        Objects.requireNonNull(name);
        Class<?> caller = Reflection.getCallerClass();
        if (caller != null && caller.getModule() != module && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        PrivilegedAction<ClassLoader> pa = module::getClassLoader;
        ClassLoader cl = AccessController.doPrivileged(pa);
        if (cl != null) {
            return cl.loadClass(module, name);
        }
        return BootLoader.loadClass((Module)module, (String)name);
    }

    @CallerSensitive
    @Deprecated(since="9")
    public T newInstance() throws InstantiationException, IllegalAccessException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), false);
        }
        if (this.cachedConstructor == null) {
            if (this == Class.class) {
                throw new IllegalAccessException("Can not call newInstance() on the Class for java.lang.Class");
            }
            try {
                Class[] empty = new Class[]{};
                final Constructor<T> c = Class.getReflectionFactory().copyConstructor(this.getConstructor0(empty, 1));
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        c.setAccessible(true);
                        return null;
                    }
                });
                this.cachedConstructor = c;
            }
            catch (NoSuchMethodException e) {
                throw (InstantiationException)new InstantiationException(this.getName()).initCause(e);
            }
        }
        Constructor<T> tmpConstructor = this.cachedConstructor;
        Class<?> caller = Reflection.getCallerClass();
        if (this.newInstanceCallerCache != caller) {
            int modifiers = tmpConstructor.getModifiers();
            Reflection.ensureMemberAccess(caller, this, this, modifiers);
            this.newInstanceCallerCache = caller;
        }
        try {
            return tmpConstructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            Unsafe.getUnsafe().throwException(e.getTargetException());
            return null;
        }
    }

    @HotSpotIntrinsicCandidate
    public native boolean isInstance(Object var1);

    @HotSpotIntrinsicCandidate
    public native boolean isAssignableFrom(Class<?> var1);

    @HotSpotIntrinsicCandidate
    public native boolean isInterface();

    @HotSpotIntrinsicCandidate
    public native boolean isArray();

    @HotSpotIntrinsicCandidate
    public native boolean isPrimitive();

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            this.name = name = this.getName0();
        }
        return name;
    }

    private native String getName0();

    @CallerSensitive
    @ForceInline
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(cl, Reflection.getCallerClass());
        }
        return cl;
    }

    ClassLoader getClassLoader0() {
        return this.classLoader;
    }

    public Module getModule() {
        return this.module;
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        ClassRepository info = this.getGenericInfo();
        if (info != null) {
            return info.getTypeParameters();
        }
        return new TypeVariable[0];
    }

    @HotSpotIntrinsicCandidate
    public native Class<? super T> getSuperclass();

    public Type getGenericSuperclass() {
        ClassRepository info = this.getGenericInfo();
        if (info == null) {
            return this.getSuperclass();
        }
        if (this.isInterface()) {
            return null;
        }
        return info.getSuperclass();
    }

    public Package getPackage() {
        if (this.isPrimitive() || this.isArray()) {
            return null;
        }
        ClassLoader cl = this.getClassLoader0();
        return cl != null ? cl.definePackage(this) : BootLoader.definePackage(this);
    }

    public String getPackageName() {
        String pn = this.packageName;
        if (pn == null && !this.isArray() && !this.isPrimitive()) {
            String cn = this.getName();
            int dot = cn.lastIndexOf(46);
            this.packageName = pn = dot != -1 ? cn.substring(0, dot).intern() : "";
        }
        return pn;
    }

    public Class<?>[] getInterfaces() {
        return this.getInterfaces(true);
    }

    private Class<?>[] getInterfaces(boolean cloneArray) {
        ReflectionData<T> rd = this.reflectionData();
        if (rd == null) {
            return this.getInterfaces0();
        }
        Class<?>[] interfaces = rd.interfaces;
        if (interfaces == null) {
            rd.interfaces = interfaces = this.getInterfaces0();
        }
        return cloneArray ? (Class[])interfaces.clone() : interfaces;
    }

    private native Class<?>[] getInterfaces0();

    public Type[] getGenericInterfaces() {
        ClassRepository info = this.getGenericInfo();
        return info == null ? this.getInterfaces() : info.getSuperInterfaces();
    }

    public Class<?> getComponentType() {
        if (this.isArray()) {
            return this.componentType;
        }
        return null;
    }

    @HotSpotIntrinsicCandidate
    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    @CallerSensitive
    public Method getEnclosingMethod() throws SecurityException {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isMethod()) {
            return null;
        }
        MethodRepository typeInfo = MethodRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Class<?> returnType = Class.toClass(typeInfo.getReturnType());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Object[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        Class<?> enclosingCandidate = enclosingInfo.getEnclosingClass();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            super.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        Method[] candidates = super.privateGetDeclaredMethods(false);
        ReflectionFactory fact = Class.getReflectionFactory();
        for (Method m : candidates) {
            if (!m.getName().equals(enclosingInfo.getName()) || !Class.arrayContentsEq(parameterClasses, fact.getExecutableSharedParameterTypes(m)) || !m.getReturnType().equals(returnType)) continue;
            return fact.copyMethod(m);
        }
        throw new InternalError("Enclosing method not found");
    }

    private native Object[] getEnclosingMethod0();

    private EnclosingMethodInfo getEnclosingMethodInfo() {
        Object[] enclosingInfo = this.getEnclosingMethod0();
        if (enclosingInfo == null) {
            return null;
        }
        return new EnclosingMethodInfo(enclosingInfo);
    }

    private static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            return Array.newInstance(Class.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
        }
        return (Class)o;
    }

    @CallerSensitive
    public Constructor<?> getEnclosingConstructor() throws SecurityException {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isConstructor()) {
            return null;
        }
        ConstructorRepository typeInfo = ConstructorRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Object[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        Class<?> enclosingCandidate = enclosingInfo.getEnclosingClass();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            super.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        Constructor<?>[] candidates = super.privateGetDeclaredConstructors(false);
        ReflectionFactory fact = Class.getReflectionFactory();
        for (Constructor<?> c : candidates) {
            if (!Class.arrayContentsEq(parameterClasses, fact.getExecutableSharedParameterTypes(c))) continue;
            return fact.copyConstructor(c);
        }
        throw new InternalError("Enclosing constructor not found");
    }

    @CallerSensitive
    public Class<?> getDeclaringClass() throws SecurityException {
        SecurityManager sm;
        Class<?> candidate = this.getDeclaringClass0();
        if (candidate != null && (sm = System.getSecurityManager()) != null) {
            super.checkPackageAccess(sm, ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return candidate;
    }

    private native Class<?> getDeclaringClass0();

    @CallerSensitive
    public Class<?> getEnclosingClass() throws SecurityException {
        SecurityManager sm;
        Class<?> enclosingCandidate;
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            enclosingCandidate = this.getDeclaringClass0();
        } else {
            Class<?> enclosingClass = enclosingInfo.getEnclosingClass();
            if (enclosingClass == this || enclosingClass == null) {
                throw new InternalError("Malformed enclosing method information");
            }
            enclosingCandidate = enclosingClass;
        }
        if (enclosingCandidate != null && (sm = System.getSecurityManager()) != null) {
            super.checkPackageAccess(sm, ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return enclosingCandidate;
    }

    public String getSimpleName() {
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String simpleName = this.getSimpleBinaryName();
        if (simpleName == null) {
            simpleName = this.getName();
            return simpleName.substring(simpleName.lastIndexOf(46) + 1);
        }
        return simpleName;
    }

    @Override
    public String getTypeName() {
        if (this.isArray()) {
            try {
                Class<?> cl = this;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getName();
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String canonicalName = this.getComponentType().getCanonicalName();
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return this.getName();
        }
        String enclosingName = enclosingClass.getCanonicalName();
        if (enclosingName == null) {
            return null;
        }
        return enclosingName + "." + this.getSimpleName();
    }

    public boolean isAnonymousClass() {
        return !this.isArray() && this.isLocalOrAnonymousClass() && this.getSimpleBinaryName0() == null;
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && (this.isArray() || this.getSimpleBinaryName0() != null);
    }

    public boolean isMemberClass() {
        return !this.isLocalOrAnonymousClass() && this.getDeclaringClass0() != null;
    }

    private String getSimpleBinaryName() {
        if (this.isTopLevelClass()) {
            return null;
        }
        String name = this.getSimpleBinaryName0();
        if (name == null) {
            return "";
        }
        return name;
    }

    private native String getSimpleBinaryName0();

    private boolean isTopLevelClass() {
        return !this.isLocalOrAnonymousClass() && this.getDeclaringClass0() == null;
    }

    private boolean isLocalOrAnonymousClass() {
        return this.hasEnclosingMethodInfo();
    }

    private boolean hasEnclosingMethodInfo() {
        Object[] enclosingInfo = this.getEnclosingMethod0();
        if (enclosingInfo != null) {
            EnclosingMethodInfo.validate(enclosingInfo);
            return true;
        }
        return false;
    }

    @CallerSensitive
    public Class<?>[] getClasses() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), false);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class<?>[] run() {
                ArrayList list = new ArrayList();
                for (Class currentClass = Class.this; currentClass != null; currentClass = currentClass.getSuperclass()) {
                    for (Class<?> m : currentClass.getDeclaredClasses()) {
                        if (!Modifier.isPublic(m.getModifiers())) continue;
                        list.add(m);
                    }
                }
                return list.toArray(new Class[0]);
            }
        });
    }

    @CallerSensitive
    public Field[] getFields() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        return Class.copyFields(this.privateGetPublicFields(null));
    }

    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        return Class.copyMethods(this.privateGetPublicMethods());
    }

    @CallerSensitive
    public Constructor<?>[] getConstructors() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        return Class.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    @CallerSensitive
    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        Field field;
        Objects.requireNonNull(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        if ((field = this.getField0(name)) == null) {
            throw new NoSuchFieldException(name);
        }
        return Class.getReflectionFactory().copyField(field);
    }

    @CallerSensitive
    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method;
        Objects.requireNonNull(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        if ((method = this.getMethod0(name, parameterTypes)) == null) {
            throw new NoSuchMethodException(this.methodToString(name, parameterTypes));
        }
        return Class.getReflectionFactory().copyMethod(method);
    }

    Method getMethodOrNull(String name, Class<?> ... parameterTypes) {
        Objects.requireNonNull(name);
        Method method = this.getMethod0(name, parameterTypes);
        return method == null ? null : Class.getReflectionFactory().copyMethod(method);
    }

    @CallerSensitive
    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 0, Reflection.getCallerClass(), true);
        }
        return Class.getReflectionFactory().copyConstructor(this.getConstructor0(parameterTypes, 0));
    }

    @CallerSensitive
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), false);
        }
        return this.getDeclaredClasses0();
    }

    @CallerSensitive
    public Field[] getDeclaredFields() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        return Class.copyFields(this.privateGetDeclaredFields(false));
    }

    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        return Class.copyMethods(this.privateGetDeclaredMethods(false));
    }

    @CallerSensitive
    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        return Class.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    @CallerSensitive
    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        Field field;
        Objects.requireNonNull(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        if ((field = Class.searchFields(this.privateGetDeclaredFields(false), name)) == null) {
            throw new NoSuchFieldException(name);
        }
        return Class.getReflectionFactory().copyField(field);
    }

    @CallerSensitive
    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method;
        Objects.requireNonNull(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        if ((method = Class.searchMethods(this.privateGetDeclaredMethods(false), name, parameterTypes)) == null) {
            throw new NoSuchMethodException(this.methodToString(name, parameterTypes));
        }
        return Class.getReflectionFactory().copyMethod(method);
    }

    @CallerSensitive
    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.checkMemberAccess(sm, 1, Reflection.getCallerClass(), true);
        }
        return Class.getReflectionFactory().copyConstructor(this.getConstructor0(parameterTypes, 1));
    }

    @CallerSensitive
    public InputStream getResourceAsStream(String name) {
        name = this.resolveName(name);
        Module module = this.getModule();
        if (module.isNamed()) {
            String pn;
            Set<String> packages;
            Module caller;
            if (!ResourceHelper.isSimpleResource((String)name) && (caller = Reflection.getCallerClass().getModule()) != module && (packages = module.getDescriptor().packages()).contains(pn = ResourceHelper.getPackageName((String)name)) && !module.isOpen(pn, caller)) {
                return null;
            }
            String mn = module.getName();
            ClassLoader cl = this.getClassLoader0();
            try {
                if (cl == null) {
                    return BootLoader.findResourceAsStream(mn, name);
                }
                if (cl instanceof BuiltinClassLoader) {
                    return ((BuiltinClassLoader)cl).findResourceAsStream(mn, name);
                }
                URL url = cl.findResource(mn, name);
                return url != null ? url.openStream() : null;
            }
            catch (IOException | SecurityException e) {
                return null;
            }
        }
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return cl.getResourceAsStream(name);
    }

    @CallerSensitive
    public URL getResource(String name) {
        name = this.resolveName(name);
        Module module = this.getModule();
        if (module.isNamed()) {
            String pn;
            Set<String> packages;
            Module caller;
            if (!ResourceHelper.isSimpleResource((String)name) && (caller = Reflection.getCallerClass().getModule()) != module && (packages = module.getDescriptor().packages()).contains(pn = ResourceHelper.getPackageName((String)name)) && !module.isOpen(pn, caller)) {
                return null;
            }
            String mn = this.getModule().getName();
            ClassLoader cl = this.getClassLoader0();
            try {
                if (cl == null) {
                    return BootLoader.findResource(mn, name);
                }
                return cl.findResource(mn, name);
            }
            catch (IOException ioe) {
                return null;
            }
        }
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResource(name);
        }
        return cl.getResource(name);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((pd = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions perms = new Permissions();
                perms.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, perms);
            }
            pd = allPermDomain;
        }
        return pd;
    }

    private native ProtectionDomain getProtectionDomain0();

    static native Class<?> getPrimitiveClass(String var0);

    private void checkMemberAccess(SecurityManager sm, int which, Class<?> caller, boolean checkProxyInterfaces) {
        ClassLoader cl;
        ClassLoader ccl = caller.getClassLoader0();
        if (which != 0 && ccl != (cl = this.getClassLoader0())) {
            sm.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
        }
        this.checkPackageAccess(sm, ccl, checkProxyInterfaces);
    }

    private void checkPackageAccess(SecurityManager sm, ClassLoader ccl, boolean checkProxyInterfaces) {
        String pkg;
        ClassLoader cl = this.getClassLoader0();
        if (ReflectUtil.needsPackageAccessCheck(ccl, cl) && (pkg = this.getPackageName()) != null && !pkg.isEmpty() && (!Proxy.isProxyClass(this) || ReflectUtil.isNonPublicProxyClass(this))) {
            sm.checkPackageAccess(pkg);
        }
        if (checkProxyInterfaces && Proxy.isProxyClass(this)) {
            ReflectUtil.checkProxyPackageAccess(ccl, this.getInterfaces());
        }
    }

    private String resolveName(String name) {
        if (!name.startsWith("/")) {
            Class<?> c = this;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getPackageName();
            if (baseName != null && !baseName.isEmpty()) {
                name = baseName.replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    private ReflectionData<T> reflectionData() {
        ReflectionData<T> rd;
        SoftReference<ReflectionData<T>> reflectionData = this.reflectionData;
        int classRedefinedCount = this.classRedefinedCount;
        if (reflectionData != null && (rd = reflectionData.get()) != null && rd.redefinedCount == classRedefinedCount) {
            return rd;
        }
        return this.newReflectionData(reflectionData, classRedefinedCount);
    }

    private ReflectionData<T> newReflectionData(SoftReference<ReflectionData<T>> oldReflectionData, int classRedefinedCount) {
        ReflectionData rd;
        do {
            if (Atomic.casReflectionData(this, oldReflectionData, new SoftReference(rd = new ReflectionData(classRedefinedCount)))) {
                return rd;
            }
            oldReflectionData = this.reflectionData;
            classRedefinedCount = this.classRedefinedCount;
        } while (oldReflectionData == null || (rd = oldReflectionData.get()) == null || rd.redefinedCount != classRedefinedCount);
        return rd;
    }

    private native String getGenericSignature0();

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    private ClassRepository getGenericInfo() {
        ClassRepository genericInfo = this.genericInfo;
        if (genericInfo == null) {
            String signature = this.getGenericSignature0();
            genericInfo = signature == null ? ClassRepository.NONE : ClassRepository.make(signature, this.getFactory());
            this.genericInfo = genericInfo;
        }
        return genericInfo != ClassRepository.NONE ? genericInfo : null;
    }

    native byte[] getRawAnnotations();

    native byte[] getRawTypeAnnotations();

    static byte[] getExecutableTypeAnnotationBytes(Executable ex) {
        return Class.getReflectionFactory().getExecutableTypeAnnotationBytes(ex);
    }

    native ConstantPool getConstantPool();

    private Field[] privateGetDeclaredFields(boolean publicOnly) {
        Field[] res;
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Field[] fieldArray = res = publicOnly ? rd.declaredPublicFields : rd.declaredFields;
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterFields(this, this.getDeclaredFields0(publicOnly));
        if (rd != null) {
            if (publicOnly) {
                rd.declaredPublicFields = res;
            } else {
                rd.declaredFields = res;
            }
        }
        return res;
    }

    private Field[] privateGetPublicFields(Set<Class<?>> traversedInterfaces) {
        Class<T> c;
        Field[] res;
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null && (res = rd.publicFields) != null) {
            return res;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (traversedInterfaces == null) {
            traversedInterfaces = new HashSet();
        }
        Field[] tmp = this.privateGetDeclaredFields(true);
        Class.addAll(fields, tmp);
        for (Class<?> c2 : this.getInterfaces()) {
            if (traversedInterfaces.contains(c2)) continue;
            traversedInterfaces.add(c2);
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null) {
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        res = new Field[fields.size()];
        fields.toArray(res);
        if (rd != null) {
            rd.publicFields = res;
        }
        return res;
    }

    private static void addAll(Collection<Field> c, Field[] o) {
        for (Field f : o) {
            c.add(f);
        }
    }

    private Constructor<T>[] privateGetDeclaredConstructors(boolean publicOnly) {
        Constructor<T>[] res;
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Constructor<T>[] constructorArray = res = publicOnly ? rd.publicConstructors : rd.declaredConstructors;
            if (res != null) {
                return res;
            }
        }
        if (this.isInterface()) {
            Constructor[] temporaryRes = new Constructor[]{};
            res = temporaryRes;
        } else {
            res = this.getDeclaredConstructors0(publicOnly);
        }
        if (rd != null) {
            if (publicOnly) {
                rd.publicConstructors = res;
            } else {
                rd.declaredConstructors = res;
            }
        }
        return res;
    }

    private Method[] privateGetDeclaredMethods(boolean publicOnly) {
        Method[] res;
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Method[] methodArray = res = publicOnly ? rd.declaredPublicMethods : rd.declaredMethods;
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterMethods(this, this.getDeclaredMethods0(publicOnly));
        if (rd != null) {
            if (publicOnly) {
                rd.declaredPublicMethods = res;
            } else {
                rd.declaredMethods = res;
            }
        }
        return res;
    }

    private Method[] privateGetPublicMethods() {
        Method[] res;
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null && (res = rd.publicMethods) != null) {
            return res;
        }
        PublicMethods pms = new PublicMethods();
        for (Method m : this.privateGetDeclaredMethods(true)) {
            pms.merge(m);
        }
        Class<T> sc = this.getSuperclass();
        if (sc != null) {
            for (Method m : super.privateGetPublicMethods()) {
                pms.merge(m);
            }
        }
        for (Class<?> intf : this.getInterfaces(false)) {
            for (Method m : super.privateGetPublicMethods()) {
                if (Modifier.isStatic(m.getModifiers())) continue;
                pms.merge(m);
            }
        }
        res = pms.toArray();
        if (rd != null) {
            rd.publicMethods = res;
        }
        return res;
    }

    private static Field searchFields(Field[] fields, String name) {
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private Field getField0(String name) {
        Class<T> c;
        Class<?>[] interfaces;
        Field res = Class.searchFields(this.privateGetDeclaredFields(true), name);
        if (res != null) {
            return res;
        }
        for (Class<?> c2 : interfaces = this.getInterfaces(false)) {
            res = super.getField0(name);
            if (res == null) continue;
            return res;
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null && (res = super.getField0(name)) != null) {
            return res;
        }
        return null;
    }

    private static Method searchMethods(Method[] methods, String name, Class<?>[] parameterTypes) {
        ReflectionFactory fact = Class.getReflectionFactory();
        Method res = null;
        for (Method m : methods) {
            if (!m.getName().equals(name) || !Class.arrayContentsEq(parameterTypes, fact.getExecutableSharedParameterTypes(m)) || res != null && (res.getReturnType() == m.getReturnType() || !res.getReturnType().isAssignableFrom(m.getReturnType()))) continue;
            res = m;
        }
        return res;
    }

    private Method getMethod0(String name, Class<?>[] parameterTypes) {
        PublicMethods.MethodList res = this.getMethodsRecursive(name, parameterTypes == null ? EMPTY_CLASS_ARRAY : parameterTypes, true);
        return res == null ? null : res.getMostSpecific();
    }

    private PublicMethods.MethodList getMethodsRecursive(String name, Class<?>[] parameterTypes, boolean includeStatic) {
        Method[] methods = this.privateGetDeclaredMethods(true);
        PublicMethods.MethodList res = PublicMethods.MethodList.filter(methods, name, parameterTypes, includeStatic);
        if (res != null) {
            return res;
        }
        Class<T> sc = this.getSuperclass();
        if (sc != null) {
            res = super.getMethodsRecursive(name, parameterTypes, includeStatic);
        }
        for (Class<?> intf : this.getInterfaces(false)) {
            res = PublicMethods.MethodList.merge(res, super.getMethodsRecursive(name, parameterTypes, false));
        }
        return res;
    }

    private Constructor<T> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        Constructor<T>[] constructors;
        ReflectionFactory fact = Class.getReflectionFactory();
        for (Constructor<T> constructor : constructors = this.privateGetDeclaredConstructors(which == 0)) {
            if (!Class.arrayContentsEq(parameterTypes, fact.getExecutableSharedParameterTypes(constructor))) continue;
            return constructor;
        }
        throw new NoSuchMethodException(this.methodToString("<init>", parameterTypes));
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static Field[] copyFields(Field[] arg) {
        Field[] out = new Field[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyField(arg[i]);
        }
        return out;
    }

    private static Method[] copyMethods(Method[] arg) {
        Method[] out = new Method[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyMethod(arg[i]);
        }
        return out;
    }

    private static <U> Constructor<U>[] copyConstructors(Constructor<U>[] arg) {
        Constructor[] out = (Constructor[])arg.clone();
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < out.length; ++i) {
            out[i] = fact.copyConstructor(out[i]);
        }
        return out;
    }

    private native Field[] getDeclaredFields0(boolean var1);

    private native Method[] getDeclaredMethods0(boolean var1);

    private native Constructor<T>[] getDeclaredConstructors0(boolean var1);

    private native Class<?>[] getDeclaredClasses0();

    private String methodToString(String name, Class<?>[] argTypes) {
        StringJoiner sj = new StringJoiner(", ", this.getName() + "." + name + "(", ")");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c = argTypes[i];
                sj.add(c == null ? "null" : c.getName());
            }
        }
        return sj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader loader = this.getClassLoader0();
        if (loader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        Object object = loader.assertionLock;
        synchronized (object) {
            if (loader.classAssertionStatus != null) {
                return loader.desiredAssertionStatus(this.getName());
            }
        }
        return Class.desiredAssertionStatus0(this);
    }

    private static native boolean desiredAssertionStatus0(Class<?> var0);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        Object[] constants = this.enumConstants;
        if (constants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                final Method values = this.getMethod("values", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        values.setAccessible(true);
                        return null;
                    }
                });
                Object[] temporaryConstants = (Object[])values.invoke(null, new Object[0]);
                constants = temporaryConstants;
                this.enumConstants = temporaryConstants;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                return null;
            }
        }
        return constants;
    }

    Map<String, T> enumConstantDirectory() {
        Map<String, T> directory = this.enumConstantDirectory;
        if (directory == null) {
            T[] universe = this.getEnumConstantsShared();
            if (universe == null) {
                throw new IllegalArgumentException(this.getName() + " is not an enum type");
            }
            directory = new HashMap<String, T>(2 * universe.length);
            for (T constant : universe) {
                directory.put(((Enum)constant).name(), constant);
            }
            this.enumConstantDirectory = directory;
        }
        return directory;
    }

    @HotSpotIntrinsicCandidate
    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (A)this.annotationData().annotations.get(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return GenericDeclaration.super.isAnnotationPresent(annotationClass);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        AnnotationData annotationData = this.annotationData();
        return AnnotationSupport.getAssociatedAnnotations(annotationData.declaredAnnotations, (Class)this, annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return AnnotationParser.toArray(this.annotationData().annotations);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (A)this.annotationData().declaredAnnotations.get(annotationClass);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotationData().declaredAnnotations, annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.annotationData().declaredAnnotations);
    }

    private AnnotationData annotationData() {
        int classRedefinedCount;
        AnnotationData newAnnotationData;
        AnnotationData annotationData;
        do {
            annotationData = this.annotationData;
            classRedefinedCount = this.classRedefinedCount;
            if (annotationData == null || annotationData.redefinedCount != classRedefinedCount) continue;
            return annotationData;
        } while (!Atomic.casAnnotationData(this, annotationData, newAnnotationData = this.createAnnotationData(classRedefinedCount)));
        return newAnnotationData;
    }

    private AnnotationData createAnnotationData(int classRedefinedCount) {
        Map<Class<? extends Annotation>, Annotation> declaredAnnotations = AnnotationParser.parseAnnotations(this.getRawAnnotations(), this.getConstantPool(), this);
        Class<T> superClass = this.getSuperclass();
        Map<Class<? extends Annotation>, Annotation> annotations = null;
        if (superClass != null) {
            Map<Class<? extends Annotation>, Annotation> superAnnotations = super.annotationData().annotations;
            for (Map.Entry<Class<? extends Annotation>, Annotation> e : superAnnotations.entrySet()) {
                Class<? extends Annotation> annotationClass = e.getKey();
                if (!AnnotationType.getInstance(annotationClass).isInherited()) continue;
                if (annotations == null) {
                    annotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>((Math.max(declaredAnnotations.size(), Math.min(12, declaredAnnotations.size() + superAnnotations.size())) * 4 + 2) / 3);
                }
                annotations.put(annotationClass, e.getValue());
            }
        }
        if (annotations == null) {
            annotations = declaredAnnotations;
        } else {
            annotations.putAll(declaredAnnotations);
        }
        return new AnnotationData(annotations, declaredAnnotations, classRedefinedCount);
    }

    boolean casAnnotationType(AnnotationType oldType, AnnotationType newType) {
        return Atomic.casAnnotationType(this, oldType, newType);
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap() {
        return this.annotationData().declaredAnnotations;
    }

    public AnnotatedType getAnnotatedSuperclass() {
        if (this == Object.class || this.isInterface() || this.isArray() || this.isPrimitive() || this == Void.TYPE) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedSuperclass(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    public AnnotatedType[] getAnnotatedInterfaces() {
        return TypeAnnotationParser.buildAnnotatedInterfaces(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    static {
        Class.registerNatives();
        EMPTY_CLASS_ARRAY = new Class[0];
        serialPersistentFields = new ObjectStreamField[0];
    }

    private static class AnnotationData {
        final Map<Class<? extends Annotation>, Annotation> annotations;
        final Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
        final int redefinedCount;

        AnnotationData(Map<Class<? extends Annotation>, Annotation> annotations, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, int redefinedCount) {
            this.annotations = annotations;
            this.declaredAnnotations = declaredAnnotations;
            this.redefinedCount = redefinedCount;
        }
    }

    private static class ReflectionData<T> {
        volatile Field[] declaredFields;
        volatile Field[] publicFields;
        volatile Method[] declaredMethods;
        volatile Method[] publicMethods;
        volatile Constructor<T>[] declaredConstructors;
        volatile Constructor<T>[] publicConstructors;
        volatile Field[] declaredPublicFields;
        volatile Method[] declaredPublicMethods;
        volatile Class<?>[] interfaces;
        final int redefinedCount;

        ReflectionData(int redefinedCount) {
            this.redefinedCount = redefinedCount;
        }
    }

    private static class Atomic {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private static final long reflectionDataOffset;
        private static final long annotationTypeOffset;
        private static final long annotationDataOffset;

        private Atomic() {
        }

        private static long objectFieldOffset(Field[] fields, String fieldName) {
            Field field = Class.searchFields(fields, fieldName);
            if (field == null) {
                throw new Error("No " + fieldName + " field found in java.lang.Class");
            }
            return unsafe.objectFieldOffset(field);
        }

        static <T> boolean casReflectionData(Class<?> clazz, SoftReference<ReflectionData<T>> oldData, SoftReference<ReflectionData<T>> newData) {
            return unsafe.compareAndSwapObject(clazz, reflectionDataOffset, oldData, newData);
        }

        static <T> boolean casAnnotationType(Class<?> clazz, AnnotationType oldType, AnnotationType newType) {
            return unsafe.compareAndSwapObject(clazz, annotationTypeOffset, oldType, newType);
        }

        static <T> boolean casAnnotationData(Class<?> clazz, AnnotationData oldData, AnnotationData newData) {
            return unsafe.compareAndSwapObject(clazz, annotationDataOffset, oldData, newData);
        }

        static {
            Field[] fields = ((Class)Class.class).getDeclaredFields0(false);
            reflectionDataOffset = Atomic.objectFieldOffset(fields, "reflectionData");
            annotationTypeOffset = Atomic.objectFieldOffset(fields, "annotationType");
            annotationDataOffset = Atomic.objectFieldOffset(fields, "annotationData");
        }
    }

    private static final class EnclosingMethodInfo {
        private final Class<?> enclosingClass;
        private final String name;
        private final String descriptor;

        static void validate(Object[] enclosingInfo) {
            if (enclosingInfo.length != 3) {
                throw new InternalError("Malformed enclosing method information");
            }
            try {
                Class enclosingClass = (Class)enclosingInfo[0];
                assert (enclosingClass != null);
                String name = (String)enclosingInfo[1];
                String descriptor = (String)enclosingInfo[2];
                assert (name != null && descriptor != null || name == descriptor);
            }
            catch (ClassCastException cce) {
                throw new InternalError("Invalid type in enclosing method information", cce);
            }
        }

        EnclosingMethodInfo(Object[] enclosingInfo) {
            EnclosingMethodInfo.validate(enclosingInfo);
            this.enclosingClass = (Class)enclosingInfo[0];
            this.name = (String)enclosingInfo[1];
            this.descriptor = (String)enclosingInfo[2];
        }

        boolean isPartial() {
            return this.enclosingClass == null || this.name == null || this.descriptor == null;
        }

        boolean isConstructor() {
            return !this.isPartial() && "<init>".equals(this.name);
        }

        boolean isMethod() {
            return !this.isPartial() && !this.isConstructor() && !"<clinit>".equals(this.name);
        }

        Class<?> getEnclosingClass() {
            return this.enclosingClass;
        }

        String getName() {
            return this.name;
        }

        String getDescriptor() {
            return this.descriptor;
        }
    }
}

