/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SequenceInputStream
extends InputStream {
    Enumeration<? extends InputStream> e;
    InputStream in;

    public SequenceInputStream(Enumeration<? extends InputStream> e) {
        this.e = e;
        this.peekNextStream();
    }

    public SequenceInputStream(InputStream s1, InputStream s2) {
        Vector<InputStream> v = new Vector<InputStream>(2);
        v.addElement(s1);
        v.addElement(s2);
        this.e = v.elements();
        this.peekNextStream();
    }

    final void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.peekNextStream();
    }

    private void peekNextStream() {
        if (this.e.hasMoreElements()) {
            this.in = this.e.nextElement();
            if (this.in == null) {
                throw new NullPointerException();
            }
        } else {
            this.in = null;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int c = this.in.read();
            if (c != -1) {
                return c;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            int n;
            if ((n = this.in.read(b, off, len)) > 0) {
                return n;
            }
            this.nextStream();
        } while (this.in != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        do {
            this.nextStream();
        } while (this.in != null);
    }
}

