/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import jdk.internal.misc.JavaIORandomAccessFileAccess;
import jdk.internal.misc.SharedSecrets;
import sun.nio.ch.FileChannelImpl;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private volatile FileChannel channel;
    private boolean rw;
    private final String path;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;
    private static final int O_TEMPORARY = 16;

    public RandomAccessFile(String name, String mode) throws FileNotFoundException {
        this(name != null ? new File(name) : null, mode);
    }

    public RandomAccessFile(File file, String mode) throws FileNotFoundException {
        this(file, mode, false);
    }

    private RandomAccessFile(File file, String mode, boolean openAndDelete) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        int imode = -1;
        if (mode.equals("r")) {
            imode = 1;
        } else if (mode.startsWith("rw")) {
            imode = 2;
            this.rw = true;
            if (mode.length() > 2) {
                imode = mode.equals("rws") ? (imode |= 4) : (mode.equals("rwd") ? (imode |= 8) : -1);
            }
        }
        if (openAndDelete) {
            imode |= 0x10;
        }
        if (imode < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + mode + "\" must be one of \"r\", \"rw\", \"rws\", or \"rwd\"");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkRead(name);
            if (this.rw) {
                security.checkWrite(name);
            }
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.path = name;
        this.open(name, imode);
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileChannel getChannel() {
        FileChannel fc = this.channel;
        if (fc == null) {
            RandomAccessFile randomAccessFile = this;
            synchronized (randomAccessFile) {
                fc = this.channel;
                if (fc == null) {
                    this.channel = fc = FileChannelImpl.open((FileDescriptor)this.fd, (String)this.path, (boolean)true, (boolean)this.rw, (Object)this);
                    if (this.closed.get()) {
                        try {
                            fc.close();
                        }
                        catch (IOException ioe) {
                            throw new InternalError(ioe);
                        }
                    }
                }
            }
        }
        return fc;
    }

    private native void open0(String var1, int var2) throws FileNotFoundException;

    private void open(String name, int mode) throws FileNotFoundException {
        this.open0(name, mode);
    }

    public int read() throws IOException {
        return this.read0();
    }

    private native int read0() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] b, int off, int len) throws IOException {
        return this.readBytes(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.readBytes(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        int n = 0;
        do {
            if ((count = this.read(b, off + n, len - n)) >= 0) continue;
            throw new EOFException();
        } while ((n += count) < len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        long len;
        if (n <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = pos + (long)n;
        if (newpos > (len = this.length())) {
            newpos = len;
        }
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    @Override
    public void write(int b) throws IOException {
        this.write0(b);
    }

    private native void write0(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public native long getFilePointer() throws IOException;

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Negative seek offset");
        }
        this.seek0(pos);
    }

    private native void seek0(long var1) throws IOException;

    public native long length() throws IOException;

    public native void setLength(long var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        FileChannel fc = this.channel;
        if (fc != null) {
            fc.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                RandomAccessFile.this.close0();
            }
        });
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    @Override
    public final short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public final char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    @Override
    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    @Override
    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        block4: while (!eol) {
            c = this.read();
            switch (c) {
                case -1: 
                case 10: {
                    eol = true;
                    continue block4;
                }
                case 13: {
                    eol = true;
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(cur);
                    continue block4;
                }
            }
            input.append((char)c);
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        byte[] b = new byte[len];
        s.getBytes(0, len, b, 0);
        this.writeBytes(b, 0, len);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int clen = s.length();
        int blen = 2 * clen;
        byte[] b = new byte[blen];
        char[] c = new char[clen];
        s.getChars(0, clen, c, 0);
        int j = 0;
        for (int i = 0; i < clen; ++i) {
            b[j++] = (byte)(c[i] >>> 8);
            b[j++] = (byte)(c[i] >>> 0);
        }
        this.writeBytes(b, 0, blen);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        DataOutputStream.writeUTF(str, this);
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    static {
        RandomAccessFile.initIDs();
        SharedSecrets.setJavaIORandomAccessFileAccess((JavaIORandomAccessFileAccess)new JavaIORandomAccessFileAccess(){

            public RandomAccessFile openAndDelete(File file, String mode) throws IOException {
                return new RandomAccessFile(file, mode, true);
            }
        });
    }
}

