/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ObjectStreamConstants;
import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface ObjectInputFilter {
    public Status checkInput(FilterInfo var1);

    public static final class Config {
        private static final Object serialFilterLock = new Object();
        private static final System.Logger configLog;
        private static final String SERIAL_FILTER_PROPNAME = "jdk.serialFilter";
        private static final ObjectInputFilter configuredFilter;
        private static ObjectInputFilter serialFilter;

        private Config() {
        }

        static void filterLog(System.Logger.Level level, String msg, Object ... args) {
            if (configLog != null) {
                configLog.log(level, msg, args);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectInputFilter getSerialFilter() {
            Object object = serialFilterLock;
            synchronized (object) {
                return serialFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setSerialFilter(ObjectInputFilter filter) {
            Objects.requireNonNull(filter, "filter");
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ObjectStreamConstants.SERIAL_FILTER_PERMISSION);
            }
            Object object = serialFilterLock;
            synchronized (object) {
                if (serialFilter != null) {
                    throw new IllegalStateException("Serial filter can only be set once");
                }
                serialFilter = filter;
            }
        }

        public static ObjectInputFilter createFilter(String pattern) {
            Objects.requireNonNull(pattern, "pattern");
            return Global.createFilter(pattern);
        }

        static {
            configuredFilter = AccessController.doPrivileged(() -> {
                String props = System.getProperty(SERIAL_FILTER_PROPNAME);
                if (props == null) {
                    props = Security.getProperty(SERIAL_FILTER_PROPNAME);
                }
                if (props != null) {
                    System.Logger log = System.getLogger("java.io.serialization");
                    log.log(System.Logger.Level.INFO, "Creating serialization filter from {0}", props);
                    try {
                        return Config.createFilter(props);
                    }
                    catch (RuntimeException re) {
                        log.log(System.Logger.Level.ERROR, "Error configuring filter: {0}", (Throwable)re);
                    }
                }
                return null;
            });
            configLog = configuredFilter != null ? System.getLogger("java.io.serialization") : null;
            serialFilter = configuredFilter;
        }

        static final class Global
        implements ObjectInputFilter {
            private final String pattern;
            private final List<Function<Class<?>, Status>> filters;
            private long maxStreamBytes;
            private long maxDepth;
            private long maxReferences;
            private long maxArrayLength;

            static ObjectInputFilter createFilter(String pattern) {
                try {
                    return new Global(pattern);
                }
                catch (UnsupportedOperationException uoe) {
                    return null;
                }
            }

            private Global(String pattern) {
                boolean hasLimits = false;
                this.pattern = pattern;
                this.maxArrayLength = Long.MAX_VALUE;
                this.maxDepth = Long.MAX_VALUE;
                this.maxReferences = Long.MAX_VALUE;
                this.maxStreamBytes = Long.MAX_VALUE;
                String[] patterns = pattern.split(";");
                this.filters = new ArrayList(patterns.length);
                for (int i = 0; i < patterns.length; ++i) {
                    Function<Class, Status> patternFilter;
                    String p = patterns[i];
                    int nameLen = p.length();
                    if (nameLen == 0) continue;
                    if (this.parseLimit(p)) {
                        hasLimits = true;
                        continue;
                    }
                    boolean negate = p.charAt(0) == '!';
                    int poffset = negate ? 1 : 0;
                    int slash = p.indexOf(47, poffset);
                    if (slash == poffset) {
                        throw new IllegalArgumentException("module name is missing in: \"" + pattern + "\"");
                    }
                    String moduleName = slash >= 0 ? p.substring(poffset, slash) : null;
                    int n = poffset = slash >= 0 ? slash + 1 : poffset;
                    if (p.endsWith("*")) {
                        if (p.endsWith(".*")) {
                            String pkg = p.substring(poffset, nameLen - 1);
                            if (pkg.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            patternFilter = negate ? c -> Global.matchesPackage(c, pkg) ? Status.REJECTED : Status.UNDECIDED : c -> Global.matchesPackage(c, pkg) ? Status.ALLOWED : Status.UNDECIDED;
                        } else if (p.endsWith(".**")) {
                            String pkgs = p.substring(poffset, nameLen - 2);
                            if (pkgs.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + pattern + "\"");
                            }
                            patternFilter = negate ? c -> c.getName().startsWith(pkgs) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().startsWith(pkgs) ? Status.ALLOWED : Status.UNDECIDED;
                        } else {
                            String className = p.substring(poffset, nameLen - 1);
                            patternFilter = negate ? c -> c.getName().startsWith(className) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().startsWith(className) ? Status.ALLOWED : Status.UNDECIDED;
                        }
                    } else {
                        String name = p.substring(poffset);
                        if (name.isEmpty()) {
                            throw new IllegalArgumentException("class or package missing in: \"" + pattern + "\"");
                        }
                        patternFilter = negate ? c -> c.getName().equals(name) ? Status.REJECTED : Status.UNDECIDED : c -> c.getName().equals(name) ? Status.ALLOWED : Status.UNDECIDED;
                    }
                    if (moduleName == null) {
                        this.filters.add(patternFilter);
                        continue;
                    }
                    this.filters.add(c -> moduleName.equals(c.getModule().getName()) ? (Status)((Object)((Object)patternFilter.apply((Class)c))) : Status.UNDECIDED);
                }
                if (this.filters.isEmpty() && !hasLimits) {
                    throw new UnsupportedOperationException("no non-empty patterns");
                }
            }

            private boolean parseLimit(String pattern) {
                int eqNdx = pattern.indexOf(61);
                if (eqNdx < 0) {
                    return false;
                }
                String valueString = pattern.substring(eqNdx + 1);
                if (pattern.startsWith("maxdepth=")) {
                    this.maxDepth = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxarray=")) {
                    this.maxArrayLength = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxrefs=")) {
                    this.maxReferences = Global.parseValue(valueString);
                } else if (pattern.startsWith("maxbytes=")) {
                    this.maxStreamBytes = Global.parseValue(valueString);
                } else {
                    throw new IllegalArgumentException("unknown limit: " + pattern.substring(0, eqNdx));
                }
                return true;
            }

            private static long parseValue(String string) throws IllegalArgumentException {
                long value = Long.parseLong(string);
                if (value < 0L) {
                    throw new IllegalArgumentException("negative limit: " + string);
                }
                return value;
            }

            @Override
            public Status checkInput(FilterInfo filterInfo) {
                if (filterInfo.references() < 0L || filterInfo.depth() < 0L || filterInfo.streamBytes() < 0L || filterInfo.references() > this.maxReferences || filterInfo.depth() > this.maxDepth || filterInfo.streamBytes() > this.maxStreamBytes) {
                    return Status.REJECTED;
                }
                Class<?> clazz = filterInfo.serialClass();
                if (clazz != null) {
                    if (clazz.isArray()) {
                        if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > this.maxArrayLength) {
                            return Status.REJECTED;
                        }
                        while ((clazz = clazz.getComponentType()).isArray()) {
                        }
                    }
                    if (clazz.isPrimitive()) {
                        return Status.UNDECIDED;
                    }
                    Class<?> cl = clazz;
                    Optional<Status> status = this.filters.stream().map(f -> (Status)((Object)((Object)f.apply(cl)))).filter(p -> p != Status.UNDECIDED).findFirst();
                    return status.orElse(Status.UNDECIDED);
                }
                return Status.UNDECIDED;
            }

            private static boolean matchesPackage(Class<?> c, String pkg) {
                String n = c.getName();
                return n.startsWith(pkg) && n.lastIndexOf(46) == pkg.length() - 1;
            }

            public String toString() {
                return this.pattern;
            }
        }
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }

    public static interface FilterInfo {
        public Class<?> serialClass();

        public long arrayLength();

        public long depth();

        public long references();

        public long streamBytes();
    }
}

