/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class FilterOutputStream
extends OutputStream {
    protected OutputStream out;
    private boolean closed;

    public FilterOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Throwable flushException = null;
        try {
            this.flush();
        }
        catch (Throwable e) {
            flushException = e;
            throw e;
        }
        finally {
            if (flushException == null) {
                this.out.close();
            } else {
                try {
                    this.out.close();
                }
                catch (Throwable closeException) {
                    if (flushException instanceof ThreadDeath && !(closeException instanceof ThreadDeath)) {
                        flushException.addSuppressed(closeException);
                        throw (ThreadDeath)flushException;
                    }
                    if (flushException != closeException) {
                        closeException.addSuppressed(flushException);
                    }
                    throw closeException;
                }
            }
        }
    }
}

