/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.List;
import jdk.internal.misc.JavaIOFileDescriptorAccess;
import jdk.internal.misc.SharedSecrets;

public final class FileDescriptor {
    private int fd = -1;
    private long handle = -1L;
    private Closeable parent;
    private List<Closeable> otherParents;
    private boolean closed;
    private boolean append;
    public static final FileDescriptor in;
    public static final FileDescriptor out;
    public static final FileDescriptor err;

    public boolean valid() {
        return this.handle != -1L || this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    private static native long set(int var0);

    private static FileDescriptor standardStream(int fd) {
        FileDescriptor desc = new FileDescriptor();
        desc.handle = FileDescriptor.set(fd);
        return desc;
    }

    synchronized void attach(Closeable c) {
        if (this.parent == null) {
            this.parent = c;
        } else if (this.otherParents == null) {
            this.otherParents = new ArrayList<Closeable>();
            this.otherParents.add(this.parent);
            this.otherParents.add(c);
        } else {
            this.otherParents.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeAll(Closeable releaser) throws IOException {
        block24: {
            if (!this.closed) {
                this.closed = true;
                IOException ioe = null;
                try (Closeable closeable = releaser;){
                    if (this.otherParents != null) {
                        for (Closeable referent : this.otherParents) {
                            try {
                                referent.close();
                            }
                            catch (IOException x) {
                                if (ioe == null) {
                                    ioe = x;
                                    continue;
                                }
                                ioe.addSuppressed(x);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    if (ioe != null) {
                        ex.addSuppressed(ioe);
                    }
                    ioe = ex;
                }
                finally {
                    if (ioe == null) break block24;
                    throw ioe;
                }
            }
        }
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess((JavaIOFileDescriptorAccess)new JavaIOFileDescriptorAccess(){

            public void set(FileDescriptor obj, int fd) {
                obj.fd = fd;
            }

            public int get(FileDescriptor obj) {
                return obj.fd;
            }

            public void setAppend(FileDescriptor obj, boolean append) {
                obj.append = append;
            }

            public boolean getAppend(FileDescriptor obj) {
                return obj.append;
            }

            public void setHandle(FileDescriptor obj, long handle) {
                obj.handle = handle;
            }

            public long getHandle(FileDescriptor obj) {
                return obj.handle;
            }
        });
        in = FileDescriptor.standardStream(0);
        out = FileDescriptor.standardStream(1);
        err = FileDescriptor.standardStream(2);
    }
}

