/*
 * Copyright (c) 2019 - 2020 Geode-solutions
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#pragma once

#include <genepi/common.h>
#include <genepi/signature/function_signature.h>

namespace genepi
{
    class FunctionDefiner
    {
    public:
        template < typename ReturnType, typename... Args >
        FunctionDefiner( std::string name,
            ReturnType ( *function )( Args... ),
            std::string bounded_name = std::string{} )
        {
            using Signature = FunctionSignature< decltype( function ),
                std::nullptr_t, ReturnType, Args... >;
            if( bounded_name.empty() )
            {
                bounded_name = std::move( name );
            }
            register_function( std::move( bounded_name ),
                Signature::add_method( function ), &Signature::instance() );
        }

        template < typename ReturnType, typename... Args >
        struct Overloaded
        {
            Overloaded( std::string name,
                ReturnType ( *function )( Args... ),
                std::string bounded_name )
            {
                FunctionDefiner{ std::move( name ), function,
                    std::move( bounded_name ) };
            }
        };
    };

} // namespace genepi
