# SIMM Valuation Demo

## Introduction and Background

See our documentation regarding the SIMM valuation and agreement on a distributed ledger
 
.. TODO: main_doc_site_link

This demo allows you to trade swaps - a type of financial product - with another counterparty. Once several swaps have been traded, the demo shows how a process can be run in order to generate what is known as the Standard Initial Margin. This is a payment made from one counterparty to the other so that in the event of a default (ie non payment of the overall value of the contract), the receiving counterparty has received sufficient cash to purchase replacement contracts in the market (hopefully preventing a domino effect associated with the global financial crisis of 2007 and 2008)

This demo does not, however, include real SIMM valuation code but a stub for the OpenGamma set of libraries (see below), so please do not base any financial decisions on results generated by this demo.

## Preparation / Building

You will need to build the core Corda component libraries and ensure they have been installed into your local maven repository.  Do this by following the instructions if you haven't done this already. 

.. TODO: Link Instructions when finalised 

Once they are available, you will need to run (in the directory containing the samples repo)

     ./gradle deployNodes
     
 which will compile all of the demos in this project, create the web framework and generate test nodes for this demonstration
 

## Startup

This demo is best run via the command line and a web browser, although it can be run via IntelliJ for debugging purposes.

Change directory to `simm-valuation-demo/build/nodes` and execute the `runnodes` script.  This will start four nodes - a notary node and three bank nodes. Wait until the message TODO: _when logging output changes completed_ appears and then all of the nodes will be ready for interaction.

## Interacting

The demo shows a simple web front end with both a trade entry and a portfolio  view. The simple portfolio view is filtered by the counterparty selected.

Start by browsing [here](http://localhost:10005/web/simmvaluationdemo/) . This is the home page for Bank A (as determined in the top right corner). In the dropdown titled "Select a counterparty", choose the party you wish to transact with, in our case "Bank B". Click the "Create New Trade" function in the top menu bar. Choose any convention for the swap (the top one - EUR fixed 1Y EURIBOR 3M - works well). Feel free to amend any of the new deal parameters. Lastly, click the Submit bar to send your completed trade to the other counterparty. Once you are taken to the "view-trade" page, then that trade has been sent across the network to the other node, signed and sent back and then signed by your node, committing it to the Corda ledger. At this stage, you can optionally verify that the trade exists on the other node by visiting [Bank B's node](http://localhost:10007/web/simmvaluationdemo/). Additionally, you can confirm that these trades are not visible from  [Bank C's node](http://localhost:10009/web/simmvaluationdemo/).

Once the portfolio has some trades, you can start the valuation and agreement flow. Do this by clicking the "Agree Valuations" tab and then the "Start Calculations" button. The flow will execute and then the web page will demonstrate a simulation of the agreement as it proceeds. Eventually, the flow will complete with the Initial Margin figures being agreed by and then signed by both nodes. For more details on exactly what is happening here, please see the link in the Introduction and Background section. 

Please note that any URL text after `simmvaluationdemo` should not be bookmarked or navigated directly to as they are only for aesthetics. 

### Shutting down

The script to start the nodes has been written such that when you press a key in the window the script is running, the nodes will close down. 

## SIMM Library Licensing

This demo was built in partnership with OpenGamma and used their SIMM library. However, due to licensing constraints we cannot distribute their library with this code. For this reason, we have stubbed out the relevant parts and replaced it with a very simplistic template that returns fake (but correctly structured) data. However, if you wish to use a realistic library, then please do get in touch with OpenGamma directly for access to their libraries and we will be happy to demonstrate how to replace the stub code. 


## Troubleshooting

| Error | Fix |
|-------|------ |
| Could not find net.corda.(...):(...):0.6-SNAPSHOT | The corda libraries have not been installed into your local maven directory. View the instructions for doing this in the core corda repository |
| Execution failed for task ':simm-valuation-demo:buildWeb' : A problem occurred starting process 'command 'ng'' | You need to have `node packet manager` installed in order to build out some of the web resources. This is not a necessary step as we include pre-built web resources but if you do modify the web source, you will need to rebuild this area |

.. TODO: expand upon how the the web site is built
 




