/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.Serializable;
import sandbox.java.util.AbstractSet;
import sandbox.java.util.Collection;
import sandbox.java.util.Comparator;
import sandbox.java.util.Iterator;
import sandbox.java.util.Map;
import sandbox.java.util.NavigableMap;
import sandbox.java.util.NavigableSet;
import sandbox.java.util.Set;
import sandbox.java.util.SortedSet;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.ConcurrentNavigableMap;
import sandbox.java.util.concurrent.ConcurrentSkipListMap;
import sandbox.sun.misc.Unsafe;

public class ConcurrentSkipListSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentNavigableMap<E, Object> m;
    private static final Unsafe UNSAFE;
    private static final long mapOffset;

    public ConcurrentSkipListSet() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.<init>:()V");
        this.m = new ConcurrentSkipListMap<E, Object>();
    }

    public ConcurrentSkipListSet(Comparator<? super E> comparator) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.<init>:(Ljava/util/Comparator;)V");
        this.m = new ConcurrentSkipListMap<E, Object>(comparator);
    }

    public ConcurrentSkipListSet(Collection<? extends E> collection) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.<init>:()V");
        this.m = new ConcurrentSkipListMap<E, Object>();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.addAll:(Ljava/util/Collection;)Z");
        this.addAll(collection);
    }

    public ConcurrentSkipListSet(SortedSet<E> sortedSet) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/SortedSet.comparator:()Ljava/util/Comparator;");
        Comparator<E> comparator = sortedSet.comparator();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.<init>:(Ljava/util/Comparator;)V");
        this.m = new ConcurrentSkipListMap<E, Object>(comparator);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.addAll:(Ljava/util/Collection;)Z");
        this.addAll(sortedSet);
    }

    ConcurrentSkipListSet(ConcurrentNavigableMap<E, Object> concurrentNavigableMap) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractSet.<init>:()V");
        this.m = concurrentNavigableMap;
    }

    public ConcurrentSkipListSet<E> clone() {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.clone:()Ljava/lang/Object;");
            ConcurrentSkipListSet concurrentSkipListSet = (ConcurrentSkipListSet)super.clone();
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.<init>:(Ljava/util/SortedMap;)V");
            ConcurrentSkipListMap<E, Object> concurrentSkipListMap = new ConcurrentSkipListMap<E, Object>(this.m);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.setMap:(Ljava/util/concurrent/ConcurrentNavigableMap;)V");
            concurrentSkipListSet.setMap(concurrentSkipListMap);
            return concurrentSkipListSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/InternalError");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/InternalError.<init>:()V");
            InternalError internalError = new InternalError();
            RuntimeCostAccounter.recordThrow();
            throw internalError;
        }
    }

    @Override
    public int size() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.size:()I");
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.isEmpty:()Z");
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.containsKey:(Ljava/lang/Object;)Z");
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        Object object = this.m.putIfAbsent(e, Boolean.TRUE);
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.remove:(Ljava/lang/Object;Ljava/lang/Object;)Z");
        return this.m.remove(object, Boolean.TRUE);
    }

    @Override
    public void clear() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.clear:()V");
        this.m.clear();
    }

    @Override
    public Iterator<E> iterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.navigableKeySet:()Ljava/util/NavigableSet;");
        NavigableSet<E> navigableSet = this.m.navigableKeySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.iterator:()Ljava/util/Iterator;");
        return navigableSet.iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.descendingKeySet:()Ljava/util/NavigableSet;");
        NavigableSet<E> navigableSet = this.m.descendingKeySet();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/NavigableSet.iterator:()Ljava/util/Iterator;");
        return navigableSet.iterator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        RuntimeCostAccounter.recordJump();
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof Set;
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            return false;
        }
        Collection collection = (Collection)object;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.containsAll:(Ljava/util/Collection;)Z");
            boolean bl2 = this.containsAll(collection);
            RuntimeCostAccounter.recordJump();
            if (!bl2) return false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.containsAll:(Ljava/util/Collection;)Z");
            boolean bl3 = collection.containsAll(this);
            RuntimeCostAccounter.recordJump();
            if (!bl3) return false;
            boolean bl4 = true;
            RuntimeCostAccounter.recordJump();
            return bl4;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collection.iterator:()Ljava/util/Iterator;");
        Iterator<?> iterator = collection.iterator();
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
            boolean bl2 = iterator.hasNext();
            RuntimeCostAccounter.recordJump();
            if (!bl2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
            Object obj = iterator.next();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.remove:(Ljava/lang/Object;)Z");
            boolean bl3 = this.remove(obj);
            RuntimeCostAccounter.recordJump();
            if (bl3) {
                bl = true;
            }
            RuntimeCostAccounter.recordJump();
        }
        return bl;
    }

    @Override
    public E lower(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.lowerKey:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.m.lowerKey(e);
    }

    @Override
    public E floor(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.floorKey:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.m.floorKey(e);
    }

    @Override
    public E ceiling(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.ceilingKey:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.m.ceilingKey(e);
    }

    @Override
    public E higher(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.higherKey:(Ljava/lang/Object;)Ljava/lang/Object;");
        return this.m.higherKey(e);
    }

    @Override
    public E pollFirst() {
        E e;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.pollFirstEntry:()Ljava/util/Map$Entry;");
        Map.Entry entry = this.m.pollFirstEntry();
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            e = (E)entry.getKey();
        }
        return e;
    }

    @Override
    public E pollLast() {
        E e;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.pollLastEntry:()Ljava/util/Map$Entry;");
        Map.Entry entry = this.m.pollLastEntry();
        RuntimeCostAccounter.recordJump();
        if (entry == null) {
            e = null;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
            e = (E)entry.getKey();
        }
        return e;
    }

    @Override
    public Comparator<? super E> comparator() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.comparator:()Ljava/util/Comparator;");
        return this.m.comparator();
    }

    @Override
    public E first() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.firstKey:()Ljava/lang/Object;");
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.lastKey:()Ljava/lang/Object;");
        return (E)this.m.lastKey();
    }

    @Override
    public NavigableSet<E> subSet(E e, boolean bl, E e2, boolean bl2) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.subMap:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/concurrent/ConcurrentNavigableMap;");
        NavigableMap navigableMap = this.m.subMap((Object)e, bl, (Object)e2, bl2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.<init>:(Ljava/util/concurrent/ConcurrentNavigableMap;)V");
        return new ConcurrentSkipListSet<E>(navigableMap);
    }

    @Override
    public NavigableSet<E> headSet(E e, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.headMap:(Ljava/lang/Object;Z)Ljava/util/concurrent/ConcurrentNavigableMap;");
        NavigableMap navigableMap = this.m.headMap((Object)e, bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.<init>:(Ljava/util/concurrent/ConcurrentNavigableMap;)V");
        return new ConcurrentSkipListSet<E>(navigableMap);
    }

    @Override
    public NavigableSet<E> tailSet(E e, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.tailMap:(Ljava/lang/Object;Z)Ljava/util/concurrent/ConcurrentNavigableMap;");
        NavigableMap navigableMap = this.m.tailMap((Object)e, bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.<init>:(Ljava/util/concurrent/ConcurrentNavigableMap;)V");
        return new ConcurrentSkipListSet<E>(navigableMap);
    }

    @Override
    public NavigableSet<E> subSet(E e, E e2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.subSet:(Ljava/lang/Object;ZLjava/lang/Object;Z)Ljava/util/NavigableSet;");
        return this.subSet(e, true, e2, false);
    }

    @Override
    public NavigableSet<E> headSet(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.headSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
        return this.headSet(e, false);
    }

    @Override
    public NavigableSet<E> tailSet(E e) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.tailSet:(Ljava/lang/Object;Z)Ljava/util/NavigableSet;");
        return this.tailSet(e, true);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentSkipListSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentNavigableMap.descendingMap:()Ljava/util/concurrent/ConcurrentNavigableMap;");
        NavigableMap navigableMap = this.m.descendingMap();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListSet.<init>:(Ljava/util/concurrent/ConcurrentNavigableMap;)V");
        return new ConcurrentSkipListSet<E>(navigableMap);
    }

    @Override
    public Spliterator<E> spliterator() {
        boolean bl = this.m instanceof ConcurrentSkipListMap;
        RuntimeCostAccounter.recordJump();
        if (bl) {
            ConcurrentSkipListMap concurrentSkipListMap = (ConcurrentSkipListMap)this.m;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap.keySpliterator:()Ljava/util/concurrent/ConcurrentSkipListMap$KeySpliterator;");
            return concurrentSkipListMap.keySpliterator();
        }
        ConcurrentSkipListMap.SubMap subMap = (ConcurrentSkipListMap.SubMap)this.m;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentSkipListMap$SubMap.keyIterator:()Ljava/util/Iterator;");
        return (Spliterator)((Object)subMap.keyIterator());
    }

    private void setMap(ConcurrentNavigableMap<E, Object> concurrentNavigableMap) {
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putObjectVolatile:(Ljava/lang/Object;JLjava/lang/Object;)V");
        UNSAFE.putObjectVolatile((Object)this, mapOffset, concurrentNavigableMap);
    }

    static {
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<ConcurrentSkipListSet> clazz = ConcurrentSkipListSet.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("m");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            mapOffset = UNSAFE.objectFieldOffset(field);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }
}

