/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;

public class LongSummaryStatistics
implements LongConsumer,
IntConsumer {
    private long count;
    private long sum;
    private long min;
    private long max;

    public LongSummaryStatistics() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
    }

    @Override
    public void accept(int n) {
        long l = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.accept:(J)V");
        this.accept(l);
    }

    @Override
    public void accept(long l) {
        ++this.count;
        this.sum += l;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        this.min = Math.min(this.min, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(JJ)J");
        this.max = Math.max(this.max, l);
    }

    public void combine(LongSummaryStatistics longSummaryStatistics) {
        this.count += longSummaryStatistics.count;
        this.sum += longSummaryStatistics.sum;
        long l = longSummaryStatistics.min;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        this.min = Math.min(this.min, l);
        long l2 = longSummaryStatistics.max;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(JJ)J");
        this.max = Math.max(this.max, l2);
    }

    public final long getCount() {
        return this.count;
    }

    public final long getSum() {
        return this.sum;
    }

    public final long getMin() {
        return this.min;
    }

    public final long getMax() {
        return this.max;
    }

    public final double getAverage() {
        double d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getCount:()J");
        long l = this.getCount() - 0L;
        long l2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
        RuntimeCostAccounter.recordJump();
        if (l2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getSum:()J");
            double d2 = this.getSum();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getCount:()J");
            d = d2 / (double)this.getCount();
            RuntimeCostAccounter.recordJump();
        } else {
            d = 0.0;
        }
        return d;
    }

    public String toString() {
        RuntimeCostAccounter.recordArrayAllocation((int)6, (int)8);
        Object[] objectArray = new Object[6];
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
        Class<?> clazz = this.getClass();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getSimpleName:()Ljava/lang/String;");
        objectArray[0] = clazz.getSimpleName();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getCount:()J");
        long l = this.getCount();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[1] = l;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getSum:()J");
        long l2 = this.getSum();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[2] = l2;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getMin:()J");
        long l3 = this.getMin();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[3] = l3;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getAverage:()D");
        double d = this.getAverage();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.valueOf:(D)Ljava/lang/Double;");
        objectArray[4] = d;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LongSummaryStatistics.getMax:()J");
        long l4 = this.getMax();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
        objectArray[5] = l4;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.format:(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;");
        return String.format("%s{count=%d, sum=%d, min=%d, average=%f, max=%d}", objectArray);
    }
}

