/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.Reader;
import sandbox.java.io.UncheckedIOException;
import sandbox.java.util.Iterator;
import sandbox.java.util.NoSuchElementException;
import sandbox.java.util.Spliterator;
import sandbox.java.util.Spliterators;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamSupport;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar;
    private int readAheadLimit;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReader(Reader reader, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.<init>:(Ljava/lang/Object;)V");
        super(reader);
        this.markedChar = -1;
        this.readAheadLimit = 0;
        this.skipLF = false;
        this.markedSkipLF = false;
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Buffer size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.in = reader;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        this.cb = new char[n2];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReader(Reader reader) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.<init>:(Ljava/io/Reader;I)V");
        this(reader, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        RuntimeCostAccounter.recordJump();
        if (this.markedChar <= -1) {
            n2 = 0;
            RuntimeCostAccounter.recordJump();
        } else {
            n = this.nextChar - this.markedChar;
            RuntimeCostAccounter.recordJump();
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                int n3 = this.cb.length;
                RuntimeCostAccounter.recordJump();
                if (this.readAheadLimit <= n3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                    this.markedChar = 0;
                    n2 = n;
                    RuntimeCostAccounter.recordJump();
                } else {
                    int n4 = this.readAheadLimit;
                    RuntimeCostAccounter.recordArrayAllocation((int)n4, (int)2);
                    char[] cArray = new char[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                    this.cb = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                this.nextChar = this.nChars = n;
            }
        }
        do {
            int n5 = this.cb.length - n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
            n = this.in.read(this.cb, n2, n5);
            RuntimeCostAccounter.recordJump();
        } while (n == 0);
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
                    this.fill();
                    RuntimeCostAccounter.recordJump();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (!this.skipLF) break;
                this.skipLF = false;
                char c = this.cb[this.nextChar];
                RuntimeCostAccounter.recordJump();
                if (c != '\n') break;
                ++this.nextChar;
                RuntimeCostAccounter.recordJump();
            }
            return this.cb[this.nextChar++];
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.nextChar >= this.nChars) {
            int n3 = this.cb.length;
            RuntimeCostAccounter.recordJump();
            if (n2 >= n3) {
                RuntimeCostAccounter.recordJump();
                if (this.markedChar <= -1) {
                    RuntimeCostAccounter.recordJump();
                    if (!this.skipLF) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.read:([CII)I");
                        return this.in.read(cArray, n, n2);
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
            this.fill();
        }
        RuntimeCostAccounter.recordJump();
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        RuntimeCostAccounter.recordJump();
        if (this.skipLF) {
            this.skipLF = false;
            char c = this.cb[this.nextChar];
            RuntimeCostAccounter.recordJump();
            if (c == '\n') {
                ++this.nextChar;
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
                    this.fill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
        int n4 = Math.min(n2, this.nChars - this.nextChar);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(this.cb, this.nextChar, cArray, n, n4);
        this.nextChar += n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            block10: {
                block9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
                    this.ensureOpen();
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block9;
                    int n3 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n > n3) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block9;
                    int n4 = cArray.length;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 > n4) break block9;
                    RuntimeCostAccounter.recordJump();
                    if (n + n2 >= 0) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 == 0) {
                return 0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.read1:([CII)I");
            int n5 = this.read1(cArray, n, n2);
            RuntimeCostAccounter.recordJump();
            if (n5 <= 0) {
                return n5;
            }
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n5 >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.ready:()Z");
                boolean bl = this.in.ready();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.read1:([CII)I");
                int n6 = this.read1(cArray, n + n5, n2 - n5);
                RuntimeCostAccounter.recordJump();
                if (n6 <= 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                n5 += n6;
                RuntimeCostAccounter.recordJump();
            }
            return n5;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    String readLine(boolean var1_1) throws IOException {
        var2_2 = null;
        var3_3 = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (var1_1) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (this.skipLF) lbl-1000:
            // 2 sources

            {
                v0 = true;
                RuntimeCostAccounter.recordJump();
            } else {
                v0 = false;
            }
            var4_4 = v0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
                    this.fill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 != null) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.length:()I");
                        v1 = var2_2.length();
                        RuntimeCostAccounter.recordJump();
                        if (v1 > 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
                            return var2_2.toString();
                        }
                    }
                    return null;
                }
                var5_5 = false;
                var6_6 = '\u0000';
                RuntimeCostAccounter.recordJump();
                if (var4_4) {
                    v2 = this.cb[this.nextChar];
                    RuntimeCostAccounter.recordJump();
                    if (v2 == '\n') {
                        // empty if block
                    }
                }
                this.skipLF = false;
                var4_4 = false;
                var7_7 = ++this.nextChar;
                while (true) {
                    block21: {
                        block20: {
                            RuntimeCostAccounter.recordJump();
                            if (var7_7 >= this.nChars) break;
                            var6_6 = this.cb[var7_7];
                            RuntimeCostAccounter.recordJump();
                            if (var6_6 == '\n') break block20;
                            RuntimeCostAccounter.recordJump();
                            if (var6_6 != '\r') break block21;
                        }
                        var5_5 = true;
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    ++var7_7;
                    RuntimeCostAccounter.recordJump();
                }
                var8_8 = this.nextChar;
                this.nextChar = var7_7;
                RuntimeCostAccounter.recordJump();
                if (var5_5) {
                    RuntimeCostAccounter.recordJump();
                    if (var2_2 == null) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/String");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.<init>:([CII)V");
                        var9_9 = new String(this.cb, var8_8, var7_7 - var8_8);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
                        var2_2.append(this.cb, var8_8, var7_7 - var8_8);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.toString:()Ljava/lang/String;");
                        var9_9 = var2_2.toString();
                    }
                    ++this.nextChar;
                    RuntimeCostAccounter.recordJump();
                    if (var6_6 == '\r') {
                        this.skipLF = true;
                    }
                    return var9_9;
                }
                RuntimeCostAccounter.recordJump();
                if (var2_2 == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuffer");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.<init>:(I)V");
                    var2_2 = new StringBuffer(BufferedReader.defaultExpectedLineLength);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuffer.append:([CII)Ljava/lang/StringBuffer;");
                var2_2.append(this.cb, var8_8, var7_7 - var8_8);
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Throwable var10_10) {
            RuntimeCostAccounter.recordThrow();
            throw var10_10;
        }
    }

    public String readLine() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.readLine:(Z)Ljava/lang/String;");
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("skip value is negative");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            long l2 = l;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (l2 <= 0L) break;
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
                    this.fill();
                }
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (this.skipLF) {
                    this.skipLF = false;
                    char c = this.cb[this.nextChar];
                    RuntimeCostAccounter.recordJump();
                    if (c == '\n') {
                        ++this.nextChar;
                    }
                }
                long l3 = this.nChars - this.nextChar;
                RuntimeCostAccounter.recordJump();
                if (l2 <= l3) {
                    this.nextChar = (int)((long)this.nextChar + l2);
                    l2 = 0L;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                l2 -= l3;
                this.nextChar = this.nChars;
                RuntimeCostAccounter.recordJump();
            }
            return l - l2;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.skipLF) {
                RuntimeCostAccounter.recordJump();
                if (this.nextChar >= this.nChars) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.ready:()Z");
                    boolean bl = this.in.ready();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.fill:()V");
                        this.fill();
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (this.nextChar < this.nChars) {
                    char c = this.cb[this.nextChar];
                    RuntimeCostAccounter.recordJump();
                    if (c == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            RuntimeCostAccounter.recordJump();
            if (this.nextChar >= this.nChars) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.ready:()Z");
                boolean bl = this.in.ready();
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int n) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Read-ahead limit < 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            this.readAheadLimit = n;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.markedChar < 0) {
                String string;
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordJump();
                if (this.markedChar == -2) {
                    string = "Mark invalid";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = "Stream not marked";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException(string);
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordJump();
            if (this.in == null) {
                return;
            }
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/Reader.close:()V");
                this.in.close();
                this.in = null;
                this.cb = null;
            }
            catch (Throwable throwable) {
                this.in = null;
                this.cb = null;
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            RuntimeCostAccounter.recordJump();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public Stream<String> lines() {
        RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedReader$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader$1.<init>:(Ljava/io/BufferedReader;)V");
        Iterator<String> iterator = new Iterator<String>(){
            String nextLine;
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                this.nextLine = null;
            }

            @Override
            public boolean hasNext() {
                RuntimeCostAccounter.recordJump();
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    boolean bl;
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader.readLine:()Ljava/lang/String;");
                    this.nextLine = BufferedReader.this.readLine();
                    RuntimeCostAccounter.recordJump();
                    if (this.nextLine != null) {
                        bl = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                catch (IOException iOException) {
                    RuntimeCostAccounter.recordAllocation((String)"java/io/UncheckedIOException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/io/UncheckedIOException.<init>:(Ljava/io/IOException;)V");
                    UncheckedIOException uncheckedIOException = new UncheckedIOException(iOException);
                    RuntimeCostAccounter.recordThrow();
                    throw uncheckedIOException;
                }
            }

            @Override
            public String next() {
                block3: {
                    block2: {
                        RuntimeCostAccounter.recordJump();
                        if (this.nextLine != null) break block2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedReader$1.hasNext:()Z");
                        boolean bl = this.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break block3;
                    }
                    String string = this.nextLine;
                    this.nextLine = null;
                    return string;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/NoSuchElementException");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/NoSuchElementException.<init>:()V");
                NoSuchElementException noSuchElementException = new NoSuchElementException();
                RuntimeCostAccounter.recordThrow();
                throw noSuchElementException;
            }
        };
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Spliterators.spliteratorUnknownSize:(Ljava/util/Iterator;I)Ljava/util/Spliterator;");
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, 272);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.stream:(Ljava/util/Spliterator;Z)Ljava/util/stream/Stream;");
        return StreamSupport.stream(spliterator, false);
    }
}

