/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.fibers.DefaultFiberScheduler;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.strands.SuspendableCallable;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FiberUtil {
    public static <V> Future<V> toFuture(Fiber<V> fiber) {
        return fiber;
    }

    public static <V> V runInFiber(SuspendableCallable<V> target) throws ExecutionException, InterruptedException {
        return FiberUtil.runInFiber(DefaultFiberScheduler.getInstance(), target);
    }

    public static <V> V runInFiber(FiberScheduler scheduler, SuspendableCallable<V> target) throws ExecutionException, InterruptedException {
        return ((Fiber)new Fiber<V>(scheduler, target).start()).get();
    }

    public static void runInFiber(SuspendableRunnable target) throws ExecutionException, InterruptedException {
        FiberUtil.runInFiber(DefaultFiberScheduler.getInstance(), target);
    }

    public static void runInFiber(FiberScheduler scheduler, SuspendableRunnable target) throws ExecutionException, InterruptedException {
        ((Fiber)new Fiber(scheduler, target).start()).join();
    }

    public static <V> V runInFiberRuntime(SuspendableCallable<V> target) throws InterruptedException {
        return FiberUtil.runInFiberRuntime(DefaultFiberScheduler.getInstance(), target);
    }

    public static <V> V runInFiberRuntime(FiberScheduler scheduler, SuspendableCallable<V> target) throws InterruptedException {
        try {
            return ((Fiber)new Fiber<V>(scheduler, target).start()).get();
        }
        catch (ExecutionException e) {
            throw Exceptions.rethrow(e.getCause());
        }
    }

    public static void runInFiberRuntime(SuspendableRunnable target) throws InterruptedException {
        FiberUtil.runInFiberRuntime(DefaultFiberScheduler.getInstance(), target);
    }

    public static void runInFiberRuntime(FiberScheduler scheduler, SuspendableRunnable target) throws InterruptedException {
        try {
            ((Fiber)new Fiber(scheduler, target).start()).join();
        }
        catch (ExecutionException e) {
            throw Exceptions.rethrow(e.getCause());
        }
    }

    public static <V, X extends Exception> V runInFiberChecked(SuspendableCallable<V> target, Class<X> exceptionType) throws X, InterruptedException {
        return FiberUtil.runInFiberChecked(DefaultFiberScheduler.getInstance(), target, exceptionType);
    }

    public static <V, X extends Exception> V runInFiberChecked(FiberScheduler scheduler, SuspendableCallable<V> target, Class<X> exceptionType) throws X, InterruptedException {
        try {
            return ((Fiber)new Fiber<V>(scheduler, target).start()).get();
        }
        catch (ExecutionException ex) {
            throw FiberUtil.throwChecked(ex, exceptionType);
        }
    }

    public static <X extends Exception> void runInFiberChecked(SuspendableRunnable target, Class<X> exceptionType) throws X, InterruptedException {
        FiberUtil.runInFiberChecked(DefaultFiberScheduler.getInstance(), target, exceptionType);
    }

    public static <X extends Exception> void runInFiberChecked(FiberScheduler scheduler, SuspendableRunnable target, Class<X> exceptionType) throws X, InterruptedException {
        try {
            ((Fiber)new Fiber(scheduler, target).start()).join();
        }
        catch (ExecutionException ex) {
            throw FiberUtil.throwChecked(ex, exceptionType);
        }
    }

    public static <V> List<V> get(List<Fiber<V>> fibers) throws InterruptedException {
        ArrayList<V> results = new ArrayList<V>(fibers.size());
        for (Fiber<V> f : fibers) {
            try {
                results.add(f.get());
            }
            catch (ExecutionException e) {
                throw Exceptions.rethrowUnwrap(e);
            }
        }
        return Collections.unmodifiableList(results);
    }

    public static <V> List<V> get(Fiber<V> ... fibers) throws InterruptedException {
        return FiberUtil.get(Arrays.asList(fibers));
    }

    public static <V> List<V> get(long timeout, TimeUnit unit, List<Fiber<V>> fibers) throws InterruptedException, TimeoutException {
        if (unit == null) {
            return FiberUtil.get(fibers);
        }
        if (timeout < 0L) {
            timeout = 0L;
        }
        ArrayList<V> results = new ArrayList<V>(fibers.size());
        long left = unit.toNanos(timeout);
        long deadline = System.nanoTime() + left;
        try {
            for (Fiber<V> f : fibers) {
                if (left >= 0L) {
                    results.add(f.get(left, TimeUnit.NANOSECONDS));
                    left = deadline - System.nanoTime();
                    continue;
                }
                throw new TimeoutException("timed out sequencing fiber results");
            }
            return Collections.unmodifiableList(results);
        }
        catch (ExecutionException e) {
            throw Exceptions.rethrowUnwrap(e);
        }
    }

    public static <V> List<V> get(long time, TimeUnit unit, Fiber<V> ... fibers) throws InterruptedException, TimeoutException {
        return FiberUtil.get(time, unit, Arrays.asList(fibers));
    }

    private static <V, X extends Exception> RuntimeException throwChecked(ExecutionException ex, Class<X> exceptionType) throws X {
        Throwable t = Exceptions.unwrap(ex);
        if (exceptionType.isInstance(t)) {
            throw (Exception)exceptionType.cast(t);
        }
        throw Exceptions.rethrow(t);
    }

    private FiberUtil() {
    }
}

