//
// Salesforce Pub/Sub API Version 1.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.6.1
// source: pubsub_api.proto

package proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported error codes
type ErrorCode int32

const (
	ErrorCode_UNKNOWN ErrorCode = 0
	ErrorCode_PUBLISH ErrorCode = 1
)

// Enum value maps for ErrorCode.
var (
	ErrorCode_name = map[int32]string{
		0: "UNKNOWN",
		1: "PUBLISH",
	}
	ErrorCode_value = map[string]int32{
		"UNKNOWN": 0,
		"PUBLISH": 1,
	}
)

func (x ErrorCode) Enum() *ErrorCode {
	p := new(ErrorCode)
	*p = x
	return p
}

func (x ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_pubsub_api_proto_enumTypes[0].Descriptor()
}

func (ErrorCode) Type() protoreflect.EnumType {
	return &file_pubsub_api_proto_enumTypes[0]
}

func (x ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ErrorCode.Descriptor instead.
func (ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{0}
}

// Supported subscription replay start values.
// By default, the subscription will start at the tip of the stream if ReplayPreset is not specified.
type ReplayPreset int32

const (
	// Start the subscription at the tip of the stream.
	ReplayPreset_LATEST ReplayPreset = 0
	// Start the subscription at the earliest point in the stream.
	ReplayPreset_EARLIEST ReplayPreset = 1
	// Start the subscription after a custom point in the stream. This must be set with a valid replay_id in the FetchRequest.
	ReplayPreset_CUSTOM ReplayPreset = 2
)

// Enum value maps for ReplayPreset.
var (
	ReplayPreset_name = map[int32]string{
		0: "LATEST",
		1: "EARLIEST",
		2: "CUSTOM",
	}
	ReplayPreset_value = map[string]int32{
		"LATEST":   0,
		"EARLIEST": 1,
		"CUSTOM":   2,
	}
)

func (x ReplayPreset) Enum() *ReplayPreset {
	p := new(ReplayPreset)
	*p = x
	return p
}

func (x ReplayPreset) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplayPreset) Descriptor() protoreflect.EnumDescriptor {
	return file_pubsub_api_proto_enumTypes[1].Descriptor()
}

func (ReplayPreset) Type() protoreflect.EnumType {
	return &file_pubsub_api_proto_enumTypes[1]
}

func (x ReplayPreset) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplayPreset.Descriptor instead.
func (ReplayPreset) EnumDescriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{1}
}

// Contains information about a topic and uniquely identifies it. TopicInfo is returned by the GetTopic RPC method.
type TopicInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Topic name
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	// Tenant/org GUID
	TenantGuid string `protobuf:"bytes,2,opt,name=tenant_guid,json=tenantGuid,proto3" json:"tenant_guid,omitempty"`
	// Is publishing allowed?
	CanPublish bool `protobuf:"varint,3,opt,name=can_publish,json=canPublish,proto3" json:"can_publish,omitempty"`
	// Is subscription allowed?
	CanSubscribe bool `protobuf:"varint,4,opt,name=can_subscribe,json=canSubscribe,proto3" json:"can_subscribe,omitempty"`
	// ID of the current topic schema, which can be used for
	// publishing of generically serialized events.
	SchemaId string `protobuf:"bytes,5,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	// RPC ID used to trace errors.
	RpcId string `protobuf:"bytes,6,opt,name=rpc_id,json=rpcId,proto3" json:"rpc_id,omitempty"`
}

func (x *TopicInfo) Reset() {
	*x = TopicInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TopicInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopicInfo) ProtoMessage() {}

func (x *TopicInfo) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopicInfo.ProtoReflect.Descriptor instead.
func (*TopicInfo) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{0}
}

func (x *TopicInfo) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

func (x *TopicInfo) GetTenantGuid() string {
	if x != nil {
		return x.TenantGuid
	}
	return ""
}

func (x *TopicInfo) GetCanPublish() bool {
	if x != nil {
		return x.CanPublish
	}
	return false
}

func (x *TopicInfo) GetCanSubscribe() bool {
	if x != nil {
		return x.CanSubscribe
	}
	return false
}

func (x *TopicInfo) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

func (x *TopicInfo) GetRpcId() string {
	if x != nil {
		return x.RpcId
	}
	return ""
}

// A request message for GetTopic. Note that the tenant/org is not directly referenced
// in the request, but is implicitly identified by the authentication headers.
type TopicRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the topic to retrieve.
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
}

func (x *TopicRequest) Reset() {
	*x = TopicRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TopicRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TopicRequest) ProtoMessage() {}

func (x *TopicRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TopicRequest.ProtoReflect.Descriptor instead.
func (*TopicRequest) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{1}
}

func (x *TopicRequest) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

// Reserved for future use.
// Header that contains information for distributed tracing, filtering, routing, etc.
// For example, X-B3-* headers assigned by a publisher are stored with the event and
// can provide a full distributed trace of the event across its entire lifecycle.
type EventHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *EventHeader) Reset() {
	*x = EventHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventHeader) ProtoMessage() {}

func (x *EventHeader) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventHeader.ProtoReflect.Descriptor instead.
func (*EventHeader) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{2}
}

func (x *EventHeader) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *EventHeader) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

// Represents an event that an event publishing app creates.
type ProducerEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Either a user-provided ID or a system generated guid
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Schema fingerprint for this event which is hash of the schema
	SchemaId string `protobuf:"bytes,2,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	// The message data field
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// Reserved for future use. Key-value pairs of headers.
	Headers []*EventHeader `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty"`
}

func (x *ProducerEvent) Reset() {
	*x = ProducerEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProducerEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProducerEvent) ProtoMessage() {}

func (x *ProducerEvent) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProducerEvent.ProtoReflect.Descriptor instead.
func (*ProducerEvent) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{3}
}

func (x *ProducerEvent) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ProducerEvent) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

func (x *ProducerEvent) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *ProducerEvent) GetHeaders() []*EventHeader {
	if x != nil {
		return x.Headers
	}
	return nil
}

// Represents an event that is consumed in a subscriber client.
// In addition to the fields in ProducerEvent, ConsumerEvent has the replay_id field.
type ConsumerEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The event with fields identical to ProducerEvent
	Event *ProducerEvent `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// The replay ID of the event.
	// A subscriber app can store the replay ID. When the app restarts, it can resume subscription
	// starting from events in the event bus after the event with that replay ID.
	ReplayId []byte `protobuf:"bytes,2,opt,name=replay_id,json=replayId,proto3" json:"replay_id,omitempty"`
}

func (x *ConsumerEvent) Reset() {
	*x = ConsumerEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConsumerEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConsumerEvent) ProtoMessage() {}

func (x *ConsumerEvent) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConsumerEvent.ProtoReflect.Descriptor instead.
func (*ConsumerEvent) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{4}
}

func (x *ConsumerEvent) GetEvent() *ProducerEvent {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *ConsumerEvent) GetReplayId() []byte {
	if x != nil {
		return x.ReplayId
	}
	return nil
}

// Event publish result that the Publish RPC method returns. The result contains replay_id or a publish error.
type PublishResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Replay ID of the event
	ReplayId []byte `protobuf:"bytes,1,opt,name=replay_id,json=replayId,proto3" json:"replay_id,omitempty"`
	// Publish error if any
	Error *Error `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// Correlation key of the ProducerEvent
	CorrelationKey string `protobuf:"bytes,3,opt,name=correlationKey,proto3" json:"correlationKey,omitempty"`
}

func (x *PublishResult) Reset() {
	*x = PublishResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishResult) ProtoMessage() {}

func (x *PublishResult) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishResult.ProtoReflect.Descriptor instead.
func (*PublishResult) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{5}
}

func (x *PublishResult) GetReplayId() []byte {
	if x != nil {
		return x.ReplayId
	}
	return nil
}

func (x *PublishResult) GetError() *Error {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *PublishResult) GetCorrelationKey() string {
	if x != nil {
		return x.CorrelationKey
	}
	return ""
}

// Contains error information for an error that an RPC method returns.
type Error struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Error code
	Code ErrorCode `protobuf:"varint,1,opt,name=code,proto3,enum=eventbus.v1.ErrorCode" json:"code,omitempty"`
	// Error message
	Msg string `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (x *Error) Reset() {
	*x = Error{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Error) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Error) ProtoMessage() {}

func (x *Error) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Error.ProtoReflect.Descriptor instead.
func (*Error) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{6}
}

func (x *Error) GetCode() ErrorCode {
	if x != nil {
		return x.Code
	}
	return ErrorCode_UNKNOWN
}

func (x *Error) GetMsg() string {
	if x != nil {
		return x.Msg
	}
	return ""
}

// Request for the Subscribe streaming RPC method. This request is used to:
// 1. Establish the initial subscribe stream.
// 2. Request more events from the subscription stream.
// Flow Control is handled by the subscriber via num_requested.
// A client can specify a starting point for the subscription with replay_preset and replay_id combinations.
// If no replay_preset is specified, the subscription starts at LATEST (tip of the stream).
// replay_preset and replay_id values are only consumed as part of the first FetchRequest. If
// a client needs to start at another point in the stream, it must start a new subscription.
type FetchRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Identifies a topic for subscription in the very first FetchRequest of the stream. The topic cannot change
	// in subsequent FetchRequests within the same subscribe stream, but can be omitted for efficiency.
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	//
	// Subscription starting point. This is consumed only as part of the first FetchRequest
	// when the subscription is set up.
	ReplayPreset ReplayPreset `protobuf:"varint,2,opt,name=replay_preset,json=replayPreset,proto3,enum=eventbus.v1.ReplayPreset" json:"replay_preset,omitempty"`
	//
	// If replay_preset of CUSTOM is selected, specify the subscription point to start after.
	// This is consumed only as part of the first FetchRequest when the subscription is set up.
	ReplayId []byte `protobuf:"bytes,3,opt,name=replay_id,json=replayId,proto3" json:"replay_id,omitempty"`
	//
	// Number of events a client is ready to accept. Each subsequent FetchRequest informs the server
	// of additional processing capacity available on the client side. There is no guarantee of equal number of
	// FetchResponse messages to be sent back. There is not necessarily a correspondence between
	// number of requested events in FetchRequest and the number of events returned in subsequent
	// FetchResponses.
	NumRequested int32 `protobuf:"varint,4,opt,name=num_requested,json=numRequested,proto3" json:"num_requested,omitempty"`
	// For internal Salesforce use only.
	AuthRefresh string `protobuf:"bytes,5,opt,name=auth_refresh,json=authRefresh,proto3" json:"auth_refresh,omitempty"`
}

func (x *FetchRequest) Reset() {
	*x = FetchRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchRequest) ProtoMessage() {}

func (x *FetchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchRequest.ProtoReflect.Descriptor instead.
func (*FetchRequest) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{7}
}

func (x *FetchRequest) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

func (x *FetchRequest) GetReplayPreset() ReplayPreset {
	if x != nil {
		return x.ReplayPreset
	}
	return ReplayPreset_LATEST
}

func (x *FetchRequest) GetReplayId() []byte {
	if x != nil {
		return x.ReplayId
	}
	return nil
}

func (x *FetchRequest) GetNumRequested() int32 {
	if x != nil {
		return x.NumRequested
	}
	return 0
}

func (x *FetchRequest) GetAuthRefresh() string {
	if x != nil {
		return x.AuthRefresh
	}
	return ""
}

// Response for the Subscribe streaming RPC method. This returns ConsumerEvent(s).
// If there are no events to deliver, the server sends an empty batch fetch response with the latest replay ID. The
// empty fetch response is sent within 270 seconds. An empty fetch response provides a periodic keepalive from the
// server and the latest replay ID.
type FetchResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Received events for subscription for client consumption
	Events []*ConsumerEvent `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	// Latest replay ID of a subscription. Enables clients with an updated replay value so that they can keep track
	// of their last consumed replay. Clients will not have to start a subscription at a very old replay in the case where a resubscribe is necessary.
	LatestReplayId []byte `protobuf:"bytes,2,opt,name=latest_replay_id,json=latestReplayId,proto3" json:"latest_replay_id,omitempty"`
	// RPC ID used to trace errors.
	RpcId string `protobuf:"bytes,3,opt,name=rpc_id,json=rpcId,proto3" json:"rpc_id,omitempty"`
	// Number of remaining events to be delivered to the client for a Subscribe RPC call.
	PendingNumRequested int32 `protobuf:"varint,4,opt,name=pending_num_requested,json=pendingNumRequested,proto3" json:"pending_num_requested,omitempty"`
}

func (x *FetchResponse) Reset() {
	*x = FetchResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchResponse) ProtoMessage() {}

func (x *FetchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchResponse.ProtoReflect.Descriptor instead.
func (*FetchResponse) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{8}
}

func (x *FetchResponse) GetEvents() []*ConsumerEvent {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *FetchResponse) GetLatestReplayId() []byte {
	if x != nil {
		return x.LatestReplayId
	}
	return nil
}

func (x *FetchResponse) GetRpcId() string {
	if x != nil {
		return x.RpcId
	}
	return ""
}

func (x *FetchResponse) GetPendingNumRequested() int32 {
	if x != nil {
		return x.PendingNumRequested
	}
	return 0
}

// Request for the GetSchema RPC method. The schema request is based on the event schema ID.
type SchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema fingerprint for this event, which is a hash of the schema.
	SchemaId string `protobuf:"bytes,1,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
}

func (x *SchemaRequest) Reset() {
	*x = SchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaRequest) ProtoMessage() {}

func (x *SchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaRequest.ProtoReflect.Descriptor instead.
func (*SchemaRequest) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{9}
}

func (x *SchemaRequest) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

// Response for the GetSchema RPC method. This returns the schema ID and schema of an event.
type SchemaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Avro schema in JSON format
	SchemaJson string `protobuf:"bytes,1,opt,name=schema_json,json=schemaJson,proto3" json:"schema_json,omitempty"`
	// Schema fingerprint
	SchemaId string `protobuf:"bytes,2,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	// RPC ID used to trace errors.
	RpcId string `protobuf:"bytes,3,opt,name=rpc_id,json=rpcId,proto3" json:"rpc_id,omitempty"`
}

func (x *SchemaInfo) Reset() {
	*x = SchemaInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchemaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaInfo) ProtoMessage() {}

func (x *SchemaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaInfo.ProtoReflect.Descriptor instead.
func (*SchemaInfo) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{10}
}

func (x *SchemaInfo) GetSchemaJson() string {
	if x != nil {
		return x.SchemaJson
	}
	return ""
}

func (x *SchemaInfo) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

func (x *SchemaInfo) GetRpcId() string {
	if x != nil {
		return x.RpcId
	}
	return ""
}

// Request for the Publish and PublishStream RPC method.
type PublishRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Topic to publish on
	TopicName string `protobuf:"bytes,1,opt,name=topic_name,json=topicName,proto3" json:"topic_name,omitempty"`
	// Batch of ProducerEvent(s) to send
	Events []*ProducerEvent `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
	// For internal Salesforce use only.
	AuthRefresh string `protobuf:"bytes,3,opt,name=auth_refresh,json=authRefresh,proto3" json:"auth_refresh,omitempty"`
}

func (x *PublishRequest) Reset() {
	*x = PublishRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishRequest) ProtoMessage() {}

func (x *PublishRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishRequest.ProtoReflect.Descriptor instead.
func (*PublishRequest) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{11}
}

func (x *PublishRequest) GetTopicName() string {
	if x != nil {
		return x.TopicName
	}
	return ""
}

func (x *PublishRequest) GetEvents() []*ProducerEvent {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *PublishRequest) GetAuthRefresh() string {
	if x != nil {
		return x.AuthRefresh
	}
	return ""
}

// Response for the Publish and PublishStream RPC methods. This returns
// a list of PublishResults for each event that the client attempted to
// publish. PublishResult indicates if publish succeeded or not
// for each event. It also returns the schema ID that was used to create
// the ProducerEvents in the PublishRequest.
type PublishResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Publish results
	Results []*PublishResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Schema fingerprint for this event, which is a hash of the schema
	SchemaId string `protobuf:"bytes,2,opt,name=schema_id,json=schemaId,proto3" json:"schema_id,omitempty"`
	// RPC ID used to trace errors.
	RpcId string `protobuf:"bytes,3,opt,name=rpc_id,json=rpcId,proto3" json:"rpc_id,omitempty"`
}

func (x *PublishResponse) Reset() {
	*x = PublishResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pubsub_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PublishResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublishResponse) ProtoMessage() {}

func (x *PublishResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pubsub_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublishResponse.ProtoReflect.Descriptor instead.
func (*PublishResponse) Descriptor() ([]byte, []int) {
	return file_pubsub_api_proto_rawDescGZIP(), []int{12}
}

func (x *PublishResponse) GetResults() []*PublishResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *PublishResponse) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

func (x *PublishResponse) GetRpcId() string {
	if x != nil {
		return x.RpcId
	}
	return ""
}

var File_pubsub_api_proto protoreflect.FileDescriptor

var file_pubsub_api_proto_rawDesc = []byte{
	0x0a, 0x10, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x22,
	0xc5, 0x01, 0x0a, 0x09, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a,
	0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x47, 0x75, 0x69, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x63, 0x61, 0x6e, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x12, 0x23,
	0x0a, 0x0d, 0x63, 0x61, 0x6e, 0x5f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x63, 0x61, 0x6e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x62, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64,
	0x12, 0x15, 0x0a, 0x06, 0x72, 0x70, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x72, 0x70, 0x63, 0x49, 0x64, 0x22, 0x2d, 0x0a, 0x0c, 0x54, 0x6f, 0x70, 0x69, 0x63,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x35, 0x0a, 0x0b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8a, 0x01,
	0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x32, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62,
	0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22, 0x5e, 0x0a, 0x0d, 0x43, 0x6f,
	0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x05, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x49, 0x64, 0x22, 0x7e, 0x0a, 0x0d, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72,
	0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08,
	0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62,
	0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x26, 0x0a, 0x0e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x45, 0x0a, 0x05, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x2a, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x16, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x73,
	0x67, 0x22, 0xd2, 0x01, 0x0a, 0x0c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x3e, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x70, 0x72, 0x65, 0x73,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x50, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x50, 0x72, 0x65, 0x73, 0x65,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x49, 0x64, 0x12, 0x23,
	0x0a, 0x0d, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x72, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x75, 0x74, 0x68, 0x52,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x22, 0xb8, 0x01, 0x0a, 0x0d, 0x46, 0x65, 0x74, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x10,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x61, 0x79, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x70, 0x63, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x70, 0x63, 0x49, 0x64, 0x12, 0x32, 0x0a,
	0x15, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x70, 0x65,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4e, 0x75, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x22, 0x2c, 0x0a, 0x0d, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x22,
	0x61, 0x0a, 0x0a, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x72,
	0x70, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x70, 0x63,
	0x49, 0x64, 0x22, 0x86, 0x01, 0x0a, 0x0e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x6f, 0x70, 0x69, 0x63,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x61, 0x75, 0x74, 0x68, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x22, 0x7b, 0x0a, 0x0f, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x34,
	0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49,
	0x64, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x70, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x72, 0x70, 0x63, 0x49, 0x64, 0x2a, 0x25, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x10, 0x01, 0x2a,
	0x34, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x50, 0x72, 0x65, 0x73, 0x65, 0x74, 0x12,
	0x0a, 0x0a, 0x06, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x45,
	0x41, 0x52, 0x4c, 0x49, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53,
	0x54, 0x4f, 0x4d, 0x10, 0x02, 0x32, 0xe7, 0x02, 0x0a, 0x06, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62,
	0x12, 0x46, 0x0a, 0x09, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x12, 0x19, 0x2e,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x12, 0x40, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1a, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x17, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3d, 0x0a, 0x08, 0x47, 0x65,
	0x74, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x19, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x44, 0x0a, 0x07, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x12, 0x1b, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1c, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4e, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x12, 0x1b, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x28, 0x01, 0x30, 0x01, 0x42,
	0x5a, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x62, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x42, 0x0b, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x27, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46,
	0x6f, 0x72, 0x63, 0x65, 0x43, 0x4c, 0x49, 0x2f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x2f, 0x70, 0x75,
	0x62, 0x2d, 0x73, 0x75, 0x62, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_pubsub_api_proto_rawDescOnce sync.Once
	file_pubsub_api_proto_rawDescData = file_pubsub_api_proto_rawDesc
)

func file_pubsub_api_proto_rawDescGZIP() []byte {
	file_pubsub_api_proto_rawDescOnce.Do(func() {
		file_pubsub_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_pubsub_api_proto_rawDescData)
	})
	return file_pubsub_api_proto_rawDescData
}

var file_pubsub_api_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_pubsub_api_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_pubsub_api_proto_goTypes = []interface{}{
	(ErrorCode)(0),          // 0: eventbus.v1.ErrorCode
	(ReplayPreset)(0),       // 1: eventbus.v1.ReplayPreset
	(*TopicInfo)(nil),       // 2: eventbus.v1.TopicInfo
	(*TopicRequest)(nil),    // 3: eventbus.v1.TopicRequest
	(*EventHeader)(nil),     // 4: eventbus.v1.EventHeader
	(*ProducerEvent)(nil),   // 5: eventbus.v1.ProducerEvent
	(*ConsumerEvent)(nil),   // 6: eventbus.v1.ConsumerEvent
	(*PublishResult)(nil),   // 7: eventbus.v1.PublishResult
	(*Error)(nil),           // 8: eventbus.v1.Error
	(*FetchRequest)(nil),    // 9: eventbus.v1.FetchRequest
	(*FetchResponse)(nil),   // 10: eventbus.v1.FetchResponse
	(*SchemaRequest)(nil),   // 11: eventbus.v1.SchemaRequest
	(*SchemaInfo)(nil),      // 12: eventbus.v1.SchemaInfo
	(*PublishRequest)(nil),  // 13: eventbus.v1.PublishRequest
	(*PublishResponse)(nil), // 14: eventbus.v1.PublishResponse
}
var file_pubsub_api_proto_depIdxs = []int32{
	4,  // 0: eventbus.v1.ProducerEvent.headers:type_name -> eventbus.v1.EventHeader
	5,  // 1: eventbus.v1.ConsumerEvent.event:type_name -> eventbus.v1.ProducerEvent
	8,  // 2: eventbus.v1.PublishResult.error:type_name -> eventbus.v1.Error
	0,  // 3: eventbus.v1.Error.code:type_name -> eventbus.v1.ErrorCode
	1,  // 4: eventbus.v1.FetchRequest.replay_preset:type_name -> eventbus.v1.ReplayPreset
	6,  // 5: eventbus.v1.FetchResponse.events:type_name -> eventbus.v1.ConsumerEvent
	5,  // 6: eventbus.v1.PublishRequest.events:type_name -> eventbus.v1.ProducerEvent
	7,  // 7: eventbus.v1.PublishResponse.results:type_name -> eventbus.v1.PublishResult
	9,  // 8: eventbus.v1.PubSub.Subscribe:input_type -> eventbus.v1.FetchRequest
	11, // 9: eventbus.v1.PubSub.GetSchema:input_type -> eventbus.v1.SchemaRequest
	3,  // 10: eventbus.v1.PubSub.GetTopic:input_type -> eventbus.v1.TopicRequest
	13, // 11: eventbus.v1.PubSub.Publish:input_type -> eventbus.v1.PublishRequest
	13, // 12: eventbus.v1.PubSub.PublishStream:input_type -> eventbus.v1.PublishRequest
	10, // 13: eventbus.v1.PubSub.Subscribe:output_type -> eventbus.v1.FetchResponse
	12, // 14: eventbus.v1.PubSub.GetSchema:output_type -> eventbus.v1.SchemaInfo
	2,  // 15: eventbus.v1.PubSub.GetTopic:output_type -> eventbus.v1.TopicInfo
	14, // 16: eventbus.v1.PubSub.Publish:output_type -> eventbus.v1.PublishResponse
	14, // 17: eventbus.v1.PubSub.PublishStream:output_type -> eventbus.v1.PublishResponse
	13, // [13:18] is the sub-list for method output_type
	8,  // [8:13] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_pubsub_api_proto_init() }
func file_pubsub_api_proto_init() {
	if File_pubsub_api_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_pubsub_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TopicInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TopicRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProducerEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConsumerEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Error); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchemaInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pubsub_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PublishResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pubsub_api_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pubsub_api_proto_goTypes,
		DependencyIndexes: file_pubsub_api_proto_depIdxs,
		EnumInfos:         file_pubsub_api_proto_enumTypes,
		MessageInfos:      file_pubsub_api_proto_msgTypes,
	}.Build()
	File_pubsub_api_proto = out.File
	file_pubsub_api_proto_rawDesc = nil
	file_pubsub_api_proto_goTypes = nil
	file_pubsub_api_proto_depIdxs = nil
}
