/*
 * Decompiled with CFR 0.152.
 */
package stax2.wstream;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.io.Stax2FileResult;
import org.codehaus.stax2.io.Stax2FileSource;
import stax2.wstream.BaseWriterTest;

public class TestWriterConstruction
extends BaseWriterTest {
    public void testCreateWithFileSource() throws IOException, XMLStreamException {
        XMLOutputFactory2 outf = this.getOutputFactory();
        File f = this.createTempFile();
        XMLStreamWriter sw = outf.createXMLStreamWriter((Result)new Stax2FileResult(f));
        this.writeAndVerify(sw, f, "withFileSource");
    }

    public void testCreateWithFileStreamReader() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter2 sw = this.getNonRepairingWriter(strw, true);
        XMLEventWriter ew = this.getOutputFactory().createXMLEventWriter((XMLStreamWriter)sw);
        TestWriterConstruction.assertNotNull((Object)ew);
    }

    File createTempFile() throws IOException {
        File f = File.createTempFile("stax2test", null);
        f.deleteOnExit();
        return f;
    }

    private void writeAndVerify(XMLStreamWriter sw, File f, String text) throws XMLStreamException {
        sw.writeStartDocument("UTF-8", "1.0");
        sw.writeStartElement("write");
        sw.writeCharacters(text);
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        XMLInputFactory2 ifact = this.getInputFactory();
        TestWriterConstruction.setCoalescing((XMLInputFactory)ifact, true);
        XMLStreamReader sr = ifact.createXMLStreamReader((Source)new Stax2FileSource(f));
        TestWriterConstruction.assertTokenType(1, sr.next());
        TestWriterConstruction.assertEquals((String)"write", (String)sr.getLocalName());
        TestWriterConstruction.assertTokenType(4, sr.next());
        TestWriterConstruction.assertEquals((String)text, (String)TestWriterConstruction.getAndVerifyText(sr));
        TestWriterConstruction.assertTokenType(2, sr.next());
        TestWriterConstruction.assertEquals((String)"write", (String)sr.getLocalName());
        TestWriterConstruction.assertTokenType(8, sr.next());
        sr.close();
    }
}

