/*
 * Decompiled with CFR 0.152.
 */
package stax2.wstream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import stax2.wstream.BaseWriterTest;

public class TestStreamWriter
extends BaseWriterTest {
    public void testGetEncoding() throws XMLStreamException {
        String ENC = "US-ASCII";
        for (int isWriter = 0; isWriter < 2; ++isWriter) {
            for (int i = 0; i < 3; ++i) {
                ByteArrayOutputStream bos;
                XMLStreamWriter2 w;
                StringWriter strw;
                boolean ns = i > 0;
                boolean repairing = i == 2;
                XMLOutputFactory2 of = this.getFactory(ns, repairing);
                if (isWriter > 0) {
                    strw = new StringWriter();
                    w = of.createXMLStreamWriter((Writer)strw, "US-ASCII");
                } else {
                    bos = new ByteArrayOutputStream();
                    w = (XMLStreamWriter2)of.createXMLStreamWriter((OutputStream)bos, "US-ASCII");
                }
                TestStreamWriter.assertEquals((String)"US-ASCII", (String)w.getEncoding());
                w.writeEmptyElement("root");
                w.close();
                if (isWriter > 0) {
                    strw = new StringWriter();
                    w = (XMLStreamWriter2)of.createXMLStreamWriter((Writer)strw);
                    w.writeStartDocument("US-ASCII", "1.0");
                    TestStreamWriter.assertEquals((String)"US-ASCII", (String)w.getEncoding());
                } else {
                    bos = new ByteArrayOutputStream();
                    w = (XMLStreamWriter2)of.createXMLStreamWriter((OutputStream)bos);
                    w.writeStartDocument("US-ASCII", "1.0");
                    TestStreamWriter.assertEquals((String)"UTF-8", (String)w.getEncoding());
                }
                w.writeEmptyElement("root");
                w.close();
            }
        }
    }

    public void testLegacyEncodings() throws Exception {
        String[] encs = new String[]{"UTF-8", "US-ASCII", "ISO-8859-1"};
        XMLOutputFactory2 outf = this.getFactory(true, false);
        XMLInputFactory2 inf = TestStreamWriter.getNewInputFactory();
        for (int i = 0; i < encs.length; ++i) {
            String enc = encs[i];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLStreamWriter sw = outf.createXMLStreamWriter((Writer)new OutputStreamWriter((OutputStream)os, enc));
            sw.writeStartDocument("1.0");
            sw.writeEmptyElement("foo");
            sw.writeEndDocument();
            XMLStreamReader sr = inf.createXMLStreamReader((InputStream)new ByteArrayInputStream(os.toByteArray()));
            String act = sr.getCharacterEncodingScheme();
            if (enc.equals(act)) continue;
            TestStreamWriter.fail((String)("Expected encoding to be returned correctly as \"" + enc + "\", got \"" + act + "\""));
        }
    }

    public void testGetLocation() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean ns = i > 0;
            boolean repairing = i == 2;
            XMLOutputFactory2 of = this.getFactory(ns, repairing);
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 w = (XMLStreamWriter2)of.createXMLStreamWriter((Writer)strw);
            XMLStreamLocation2 loc = w.getLocation();
            TestStreamWriter.assertNotNull((Object)loc);
            w.writeEmptyElement("root");
            w.close();
        }
    }

    public void testCData() throws XMLStreamException {
        String CDATA_TEXT = "Let's test it with some ] ]> data; <tag>s and && chars and all!";
        for (int i = 0; i < 2; ++i) {
            boolean ns = i > 0;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 w = this.getNonRepairingWriter(strw, ns);
            w.writeStartDocument();
            w.writeStartElement("test");
            char[] cbuf = new char["Let's test it with some ] ]> data; <tag>s and && chars and all!".length() + 10];
            "Let's test it with some ] ]> data; <tag>s and && chars and all!".getChars(0, "Let's test it with some ] ]> data; <tag>s and && chars and all!".length(), cbuf, 3);
            w.writeCData(cbuf, 3, "Let's test it with some ] ]> data; <tag>s and && chars and all!".length());
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
            XMLStreamReader2 sr = this.constructNsStreamReader(strw.toString(), true);
            TestStreamWriter.assertTokenType(7, sr.getEventType());
            TestStreamWriter.assertTokenType(1, sr.next());
            int tt = sr.next();
            if (tt != 4 && tt != 12) {
                TestStreamWriter.assertTokenType(12, tt);
            }
            TestStreamWriter.assertFalse((boolean)sr.isWhiteSpace());
            TestStreamWriter.assertEquals((String)"Let's test it with some ] ]> data; <tag>s and && chars and all!", (String)TestStreamWriter.getAndVerifyText((XMLStreamReader)sr));
            TestStreamWriter.assertTokenType(2, sr.next());
            TestStreamWriter.assertTokenType(8, sr.next());
        }
    }

    public void testLongerComment() throws XMLStreamException {
        this.doTestLonger(5, false, false, "UTF-8");
        this.doTestLonger(5, false, false, "ISO-8859-1");
        this.doTestLonger(5, false, false, "US-ASCII");
        this.doTestLonger(5, true, false, "UTF-8");
        this.doTestLonger(5, true, false, "ISO-8859-1");
        this.doTestLonger(5, true, false, "US-ASCII");
        this.doTestLonger(5, true, true, "UTF-8");
        this.doTestLonger(5, true, true, "ISO-8859-1");
        this.doTestLonger(5, true, true, "US-ASCII");
    }

    public void testLongerPI() throws XMLStreamException {
        this.doTestLonger(3, false, false, "UTF-8");
        this.doTestLonger(3, false, false, "ISO-8859-1");
        this.doTestLonger(3, false, false, "US-ASCII");
        this.doTestLonger(3, true, false, "UTF-8");
        this.doTestLonger(3, true, false, "ISO-8859-1");
        this.doTestLonger(3, true, false, "US-ASCII");
        this.doTestLonger(3, true, true, "UTF-8");
        this.doTestLonger(3, true, true, "ISO-8859-1");
        this.doTestLonger(3, true, true, "US-ASCII");
    }

    public void testCopy() throws XMLStreamException {
        String XML = "<?xml version='1.0'?>\n<!DOCTYPE root [  <!ENTITY foo 'value'> ]>\n<root>\n<!-- comment! --><?proc instr?>Text: &amp; <leaf attr='xyz' xmlns:a='url:foo' a:xyz='1' /><![CDATA[and <> there you have it!]]></root>";
        for (int i = 0; i < 2; ++i) {
            boolean ns = i > 0;
            boolean repairing = i == 1;
            XMLStreamReader2 sr = this.constructNsStreamReader("<?xml version='1.0'?>\n<!DOCTYPE root [  <!ENTITY foo 'value'> ]>\n<root>\n<!-- comment! --><?proc instr?>Text: &amp; <leaf attr='xyz' xmlns:a='url:foo' a:xyz='1' /><![CDATA[and <> there you have it!]]></root>", ns);
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 w = repairing ? this.getRepairingWriter(strw) : this.getNonRepairingWriter(strw, ns);
            while (sr.hasNext()) {
                sr.next();
                w.copyEventFromReader(sr, false);
            }
            sr.close();
            w.close();
            String xmlOut = strw.toString();
            sr = this.constructNsStreamReader(xmlOut, ns);
            this.streamThrough((XMLStreamReader)sr);
        }
    }

    public void testRaw() throws XMLStreamException {
        String RAW2 = "<elem>foo&amp;bar</elem>";
        for (int i = 0; i < 3; ++i) {
            boolean ns = i > 0;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 w = i == 2 ? this.getRepairingWriter(strw) : this.getNonRepairingWriter(strw, ns);
            w.writeStartDocument();
            w.writeStartElement("test");
            w.writeAttribute("attr", "value");
            w.writeRaw("this or &apos;that&apos;");
            char[] cbuf = new char[RAW2.length() + 10];
            RAW2.getChars(0, RAW2.length(), cbuf, 3);
            w.writeRaw(cbuf, 3, RAW2.length());
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
            XMLStreamReader2 sr = this.constructNsStreamReader(strw.toString(), true);
            TestStreamWriter.assertTokenType(7, sr.getEventType());
            TestStreamWriter.assertTokenType(1, sr.next());
            TestStreamWriter.assertEquals((String)"test", (String)sr.getLocalName());
            TestStreamWriter.assertEquals((int)1, (int)sr.getAttributeCount());
            TestStreamWriter.assertEquals((String)"attr", (String)sr.getAttributeLocalName(0));
            TestStreamWriter.assertEquals((String)"value", (String)sr.getAttributeValue(0));
            TestStreamWriter.assertTokenType(4, sr.next());
            TestStreamWriter.assertEquals((String)"this or 'that'", (String)TestStreamWriter.getAndVerifyText((XMLStreamReader)sr));
            TestStreamWriter.assertTokenType(1, sr.next());
            TestStreamWriter.assertEquals((String)"elem", (String)sr.getLocalName());
            TestStreamWriter.assertTokenType(4, sr.next());
            TestStreamWriter.assertEquals((String)"foo&bar", (String)TestStreamWriter.getAndVerifyText((XMLStreamReader)sr));
            TestStreamWriter.assertTokenType(2, sr.next());
            TestStreamWriter.assertEquals((String)"elem", (String)sr.getLocalName());
            TestStreamWriter.assertTokenType(2, sr.next());
            TestStreamWriter.assertEquals((String)"test", (String)sr.getLocalName());
            TestStreamWriter.assertTokenType(8, sr.next());
        }
    }

    public void testAttrValueWriterSimple() throws IOException, XMLStreamException {
        String IN = "Ok, nbsp: \u00a0; and 'quotes' and \"doubles\" too; and multi-bytes too: [\u0531]";
        this.doTestAttrValueWriter("ISO-8859-1", IN);
        this.doTestAttrValueWriter("UTF-8", IN);
        this.doTestAttrValueWriter("US-ASCII", IN);
    }

    public void testAttrValueWriterTabsEtc() throws IOException, XMLStreamException {
        String IN = "How about tabs: [\t] or cr+lf [\r\n]";
        this.doTestAttrValueWriter("ISO-8859-1", IN);
        this.doTestAttrValueWriter("UTF-8", IN);
        this.doTestAttrValueWriter("US-ASCII", IN);
    }

    public XMLOutputFactory2 getFactory(boolean nsAware, boolean repairing) throws XMLStreamException {
        XMLOutputFactory2 f = this.getOutputFactory();
        f.setProperty("javax.xml.stream.isNamespaceAware", (Object)nsAware);
        f.setProperty("javax.xml.stream.isRepairingNamespaces", (Object)repairing);
        return f;
    }

    private void doTestAttrValueWriter(String enc, String IN) throws IOException, XMLStreamException {
        XMLOutputFactory2 of = this.getFactory(false, false);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, enc);
        XMLStreamWriter sw = of.createXMLStreamWriter(w);
        sw.writeStartDocument(enc, "1.0");
        sw.writeStartElement("elem");
        sw.writeAttribute("attr", IN);
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        ((Writer)w).close();
        XMLInputFactory2 ifact = this.getInputFactory();
        XMLStreamReader sr = ifact.createXMLStreamReader(new ByteArrayInputStream(out.toByteArray()), enc);
        TestStreamWriter.assertTokenType(7, sr.getEventType());
        TestStreamWriter.assertEquals((String)enc, (String)sr.getCharacterEncodingScheme());
        TestStreamWriter.assertTokenType(1, sr.next());
        TestStreamWriter.assertEquals((int)1, (int)sr.getAttributeCount());
        String attrValue = sr.getAttributeValue(0);
        if (!IN.equals(attrValue)) {
            TestStreamWriter.failStrings("Incorrect writing/reading of attribute value (encoding '" + enc + "')", IN, attrValue);
        }
        TestStreamWriter.assertTokenType(2, sr.next());
        TestStreamWriter.assertTokenType(8, sr.next());
        sr.close();
    }

    public void doTestLonger(int type, boolean ns, boolean repair, String enc) throws XMLStreamException {
        String TEXT = " Table of types of doubts\ndoubt: specific error or issue with the test case\nextension: uses an extension feature\ngray-area: the spec does not give enough precision to distinguish correct behavior on the indicated detail\nprocessor-specific: processors are required to provide a unique value (should be marked as \"manual\" compare in catalog)\nserial: processor has options regarding serialization (This doubt only used for detail issues, not general discretion about encoding.)";
        for (int i = 0; i < 2; ++i) {
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 w = repair ? this.getRepairingWriter(strw, enc) : this.getNonRepairingWriter(strw, enc, ns);
            w.writeStartDocument(enc, "1.0");
            if (type == 5) {
                w.writeComment(" Table of types of doubts\ndoubt: specific error or issue with the test case\nextension: uses an extension feature\ngray-area: the spec does not give enough precision to distinguish correct behavior on the indicated detail\nprocessor-specific: processors are required to provide a unique value (should be marked as \"manual\" compare in catalog)\nserial: processor has options regarding serialization (This doubt only used for detail issues, not general discretion about encoding.)");
            } else {
                w.writeProcessingInstruction("pi", " Table of types of doubts\ndoubt: specific error or issue with the test case\nextension: uses an extension feature\ngray-area: the spec does not give enough precision to distinguish correct behavior on the indicated detail\nprocessor-specific: processors are required to provide a unique value (should be marked as \"manual\" compare in catalog)\nserial: processor has options regarding serialization (This doubt only used for detail issues, not general discretion about encoding.)");
            }
            w.writeEmptyElement("root");
            w.writeEndDocument();
            w.close();
            XMLStreamReader2 sr = this.constructNsStreamReader(strw.toString(), true);
            TestStreamWriter.assertTokenType(7, sr.getEventType());
            if (type == 5) {
                TestStreamWriter.assertTokenType(5, sr.next());
                TestStreamWriter.assertEquals((String)" Table of types of doubts\ndoubt: specific error or issue with the test case\nextension: uses an extension feature\ngray-area: the spec does not give enough precision to distinguish correct behavior on the indicated detail\nprocessor-specific: processors are required to provide a unique value (should be marked as \"manual\" compare in catalog)\nserial: processor has options regarding serialization (This doubt only used for detail issues, not general discretion about encoding.)", (String)TestStreamWriter.getAndVerifyText((XMLStreamReader)sr));
            } else {
                TestStreamWriter.assertTokenType(3, sr.next());
                TestStreamWriter.assertEquals((String)" Table of types of doubts\ndoubt: specific error or issue with the test case\nextension: uses an extension feature\ngray-area: the spec does not give enough precision to distinguish correct behavior on the indicated detail\nprocessor-specific: processors are required to provide a unique value (should be marked as \"manual\" compare in catalog)\nserial: processor has options regarding serialization (This doubt only used for detail issues, not general discretion about encoding.)".trim(), (String)sr.getPIData().trim());
            }
            TestStreamWriter.assertTokenType(1, sr.next());
            TestStreamWriter.assertTokenType(2, sr.next());
            TestStreamWriter.assertTokenType(8, sr.next());
            sr.close();
        }
    }
}

