/*
 * Decompiled with CFR 0.152.
 */
package stax2.wstream;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import stax2.wstream.BaseWriterTest;

public class TestNamespaceCopying
extends BaseWriterTest {
    XMLInputFactory _inputFactory;
    XMLOutputFactory _outputFactory;
    XMLEventFactory _eventFactory;

    protected void setUp() throws Exception {
        this._outputFactory = this.getOutputFactory();
        TestNamespaceCopying.setRepairing(this._outputFactory, true);
        this._eventFactory = this.getEventFactory();
        this._inputFactory = this.getInputFactory();
    }

    public void testStreamXMLNSDeclaration() throws Exception {
        StringWriter stringWriter = new StringWriter();
        XMLEventWriter xmlWriter = this._outputFactory.createXMLEventWriter(stringWriter);
        xmlWriter.add(this._eventFactory.createStartDocument("UFT-8"));
        ArrayList<Namespace> l = new ArrayList<Namespace>();
        l.add(this._eventFactory.createNamespace("bar", "barNS"));
        xmlWriter.add(this._eventFactory.createStartElement("foo", "fooNS", "root", Collections.EMPTY_LIST.iterator(), l.iterator()));
        xmlWriter.add(this._eventFactory.createNamespace("baz", "bazNS"));
        xmlWriter.add(this._eventFactory.createCharacters("bar:qname"));
        xmlWriter.add(this._eventFactory.createEndElement("foo", "fooNS", "root"));
        xmlWriter.add(this._eventFactory.createEndDocument());
        Document document = this.buildDocument(stringWriter.toString());
        Element documentElement = document.getDocumentElement();
        TestNamespaceCopying.assertEquals((String)"fooNS", (String)this.getNamespaceForPrefix(documentElement, "foo"));
        TestNamespaceCopying.assertEquals((String)"barNS", (String)this.getNamespaceForPrefix(documentElement, "bar"));
        TestNamespaceCopying.assertEquals((String)"bazNS", (String)this.getNamespaceForPrefix(documentElement, "baz"));
    }

    private String getNamespaceForPrefix(Element element, String prefix) {
        return element.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
    }

    private Document buildDocument(String string) throws XMLStreamException, ParserConfigurationException {
        XMLEventReader reader = this._inputFactory.createXMLEventReader(new StringReader(string));
        DocumentBuilderFactory documentBuilder = DocumentBuilderFactory.newInstance();
        documentBuilder.setNamespaceAware(true);
        Document document = documentBuilder.newDocumentBuilder().newDocument();
        XMLEventWriter writer = this._outputFactory.createXMLEventWriter(new DOMResult(document));
        writer.add(reader);
        return document;
    }
}

