/*
 * Decompiled with CFR 0.152.
 */
package stax2.vwstream;

import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.XMLValidationException;
import stax2.vwstream.BaseOutputTest;

public class TestStructuralValidation
extends BaseOutputTest {
    final String NS_PREFIX = "ns";
    final String NS_PREFIX2 = "ns2";
    final String NS_URI = "http://ns";
    final String SIMPLE_DTD = "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n";
    final String SIMPLE_NS_DTD = "<!ELEMENT ns:root (branch*)>\n<!ELEMENT branch (#PCDATA)>\n";

    public void testInvalidRootElem() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeDTD("root", "http://foo", "public-id", "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n");
            try {
                sw.writeStartElement("branch");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when trying to write wrong root element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            try {
                sw.writeStartElement("undefined");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when trying to write an undefined root element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeDTD("root", "http://foo", "public-id", "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n");
            try {
                sw.writeEmptyElement("branch");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when trying to write wrong root element"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }

    public void testValidStructure() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeCharacters("  ");
            sw.writeStartElement("branch");
            sw.writeEndElement();
            sw.writeStartElement("branch");
            sw.writeCharacters("test");
            sw.writeComment("comment");
            sw.writeEndElement();
            sw.writeEmptyElement("branch");
            sw.writeEmptyElement("end");
            sw.writeAttribute("endAttr", "value");
            sw.writeCharacters("\n");
            sw.writeEndElement();
        }
    }

    public void testInvalidStructure() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeCharacters("  ");
            sw.writeStartElement("branch");
            sw.writeEndElement();
            sw.writeStartElement("branch");
            sw.writeCharacters("test");
            sw.writeComment("comment");
            sw.writeEndElement();
            sw.writeEmptyElement("branch");
            sw.writeCharacters("\n");
            try {
                sw.writeEndElement();
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when omitting non-optional <end> element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeCharacters("  ");
            sw.writeComment("comment");
            try {
                sw.writeEmptyElement("end");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when omitting non-optional <branch> element"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }

    public void testValidNsElem() throws XMLStreamException {
        for (int i = 0; i < 3; ++i) {
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT ns:root (branch*)>\n<!ELEMENT branch (#PCDATA)>\n", true, repairing);
            sw.writeStartElement("ns", "root", "http://ns");
            if (!repairing) {
                sw.writeNamespace("ns", "http://ns");
            }
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT ns:root (branch*)>\n<!ELEMENT branch (#PCDATA)>\n", true, repairing);
            sw.writeEmptyElement("ns", "root", "http://ns");
            if (!repairing) {
                sw.writeNamespace("ns", "http://ns");
            }
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidNsElem() throws XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT ns:root (branch*)>\n<!ELEMENT branch (#PCDATA)>\n", true, repairing);
            try {
                sw.writeStartElement("ns2", "root", "http://ns");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when passing wrong (unexpected) ns for element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT ns:root (branch*)>\n<!ELEMENT branch (#PCDATA)>\n", true, repairing);
            try {
                sw.writeEmptyElement("ns2", "http://ns", "root");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when passing wrong (unexpected) ns for element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch+, end)>\n<!ELEMENT branch (#PCDATA)>\n<!ELEMENT end EMPTY>\n<!ATTLIST end endAttr CDATA #IMPLIED>\n", true, repairing);
            try {
                sw.writeEmptyElement("ns", "http://ns", "root");
                TestStructuralValidation.fail((String)(modeDesc + " Expected a validation exception when passing wrong (unexpected) ns for element"));
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }
}

