/*
 * Decompiled with CFR 0.152.
 */
package stax2.vwstream;

import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.validation.XMLValidationException;
import stax2.vwstream.BaseOutputTest;

public class TestOutputValidation
extends BaseOutputTest {
    public void testValidMixedContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root (#PCDATA | branch)*>\n<!ELEMENT branch (branch)*>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (#PCDATA | branch)*>\n<!ELEMENT branch (branch)*>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeCharacters("Text that should be ok");
            sw.writeStartElement("branch");
            sw.writeCharacters("\t \t   \r   \n");
            sw.writeEndElement();
            sw.writeEndElement();
            sw.writeEndDocument();
        }
    }

    public void testInvalidMixedContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root (branch)>\n<!ELEMENT branch ANY>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root (branch)>\n<!ELEMENT branch ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeCharacters("Illegal text!");
                TestOutputValidation.fail((String)"Expected a validation exception for non-whitespace text output on non-mixed element content");
                continue;
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
        }
    }

    public void testValidEmptyContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeAttribute("attr", "value");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeEmptyElement("root");
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n", nsAware, repairing);
            sw.writeEmptyElement("root");
            sw.writeAttribute("attr", "otherValue");
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidEmptyContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeStartElement("leaf");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add an element into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeEmptyElement("leaf");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add an element into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeCharacters(" ");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to any text into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeCData("foo");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add CDATA into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeEntityRef("amp");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add CDATA into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeComment("comment");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add comment into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root EMPTY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeProcessingInstruction("target", "data");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add processing instruction into EMPTY content model"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
        }
    }

    public void testValidAnyContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware = i >= 1;
            boolean repairing = i == 2;
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeStartElement("leaf");
            sw.writeCharacters("whatever");
            sw.writeEndElement();
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeEmptyElement("leaf");
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            sw.writeAttribute("attr", "value");
            sw.writeStartElement("leaf");
            sw.writeEndElement();
            sw.writeEndElement();
            sw.writeEndDocument();
            sw.close();
        }
    }

    public void testInvalidAnyContent() throws XMLStreamException {
        String dtdStr = "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n";
        for (int i = 0; i < 3; ++i) {
            boolean nsAware;
            boolean repairing;
            String modeDesc;
            switch (i) {
                case 0: {
                    modeDesc = "[non-namespace-aware]";
                    repairing = false;
                    nsAware = false;
                    break;
                }
                case 1: {
                    modeDesc = "[namespace-aware, non-repairing]";
                    nsAware = true;
                    repairing = false;
                    break;
                }
                default: {
                    modeDesc = "[namespace-aware, repairing]";
                    repairing = true;
                    nsAware = true;
                }
            }
            StringWriter strw = new StringWriter();
            XMLStreamWriter2 sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeStartElement("unknown");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add an undeclared element"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
            sw = this.getDTDValidatingWriter(strw, "<!ELEMENT root ANY>\n<!ATTLIST root attr CDATA #IMPLIED>\n<!ELEMENT leaf ANY>\n", nsAware, repairing);
            sw.writeStartElement("root");
            try {
                sw.writeAttribute("unknown", "value");
                TestOutputValidation.fail((String)(modeDesc + " Expected a validation exception when trying to add an undeclared attribute"));
            }
            catch (XMLValidationException vex) {
                // empty catch block
            }
            sw.close();
        }
    }
}

