/*
 * Decompiled with CFR 0.152.
 */
package stax2.typed;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.XMLStreamWriter2;
import org.codehaus.stax2.typed.TypedXMLStreamWriter;
import stax2.BaseStax2Test;

public abstract class WriterTestBase
extends BaseStax2Test {
    static final int[] ARRAY_TEST_LENGTHS = new int[]{3, 8, 25, 120, 16, 99, 253, 1099, 37242};

    public void testSimpleBooleanElem() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getTypedWriter(bos);
        this.writeBooleanElem((TypedXMLStreamWriter)w, true);
        byte[] data = this.closeWriter((XMLStreamWriter)w, bos);
        this.checkBooleanElem(data, true);
        w = this.getTypedWriter(bos);
        this.writeBooleanElem((TypedXMLStreamWriter)w, false);
        data = this.closeWriter((XMLStreamWriter)w, bos);
        this.checkBooleanElem(data, false);
    }

    public void testSimpleBooleanAttr() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getTypedWriter(bos);
        this.writeBooleanAttr((TypedXMLStreamWriter)w, true);
        byte[] data = this.closeWriter((XMLStreamWriter)w, bos);
        this.checkBooleanAttr(data, true);
        w = this.getTypedWriter(bos);
        this.writeBooleanAttr((TypedXMLStreamWriter)w, false);
        data = this.closeWriter((XMLStreamWriter)w, bos);
        this.checkBooleanAttr(data, false);
    }

    public void testMultipleBooleanAttr() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getTypedWriter(bos);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeBooleanAttribute(null, null, "a1", true);
        w.writeBooleanAttribute(null, null, "xyz", false);
        w.writeBooleanAttribute(null, null, "_attr3", true);
        w.writeEndElement();
        w.writeEndDocument();
        byte[] data = this.closeWriter((XMLStreamWriter)w, bos);
        XMLStreamReader2 sr = this.getRootReader(data);
        WriterTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a1");
        int ix2 = sr.getAttributeIndex("", "xyz");
        int ix3 = sr.getAttributeIndex("", "_attr3");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            WriterTestBase.fail((String)("Couldn't find indexes of attributes: a1=" + ix1 + ", xyz=" + ix2 + ", _attr3=" + ix3));
        }
        WriterTestBase.assertTrue((boolean)sr.getAttributeAsBoolean(ix1));
        WriterTestBase.assertFalse((boolean)sr.getAttributeAsBoolean(ix2));
        WriterTestBase.assertTrue((boolean)sr.getAttributeAsBoolean(ix3));
        sr.close();
    }

    public void testSimpleIntElem() throws XMLStreamException {
        int[] values = new int[]{0, 3, -9, 999, -77, 1000000000, -1000000000, Integer.MIN_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            this.assertXML("<root>" + value + "</root>", this.writeIntElemDoc("root", value));
        }
    }

    public void testSimpleIntAttr() throws XMLStreamException {
        int[] values = new int[]{0, 3, -7, 123, -102, 1000000, -999999, Integer.MIN_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < values.length; ++i) {
            int value = values[i];
            this.assertXML("<a attr='" + value + "'></a>", this.writeIntAttrDoc("a", "attr", value));
        }
    }

    public void testMultipleIntAttr() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getTypedWriter(bos);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeIntAttribute(null, null, "a", 0);
        w.writeIntAttribute(null, null, "bz", Integer.MAX_VALUE);
        w.writeIntAttribute(null, null, "___", -1200300400);
        w.writeEndElement();
        w.writeEndDocument();
        byte[] data = this.closeWriter((XMLStreamWriter)w, bos);
        XMLStreamReader2 sr = this.getRootReader(data);
        WriterTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a");
        int ix2 = sr.getAttributeIndex("", "bz");
        int ix3 = sr.getAttributeIndex("", "___");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            WriterTestBase.fail((String)("Couldn't find indexes of attributes: a=" + ix1 + ", bz=" + ix2 + ", ___=" + ix3));
        }
        WriterTestBase.assertEquals((int)0, (int)sr.getAttributeAsInt(ix1));
        WriterTestBase.assertEquals((int)Integer.MAX_VALUE, (int)sr.getAttributeAsInt(ix2));
        WriterTestBase.assertEquals((int)-1200300400, (int)sr.getAttributeAsInt(ix3));
        sr.close();
    }

    public void testSimpleLongElem() throws XMLStreamException {
        long[] values = new long[]{0L, 3L, -9L, 999L, -77L, 1000000000L, -1000000000L, 123456789012345678L, -987654321098765423L, Long.MIN_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            this.assertXML("<root>" + value + "</root>", this.writeLongElemDoc("root", value));
        }
    }

    public void testSimpleLongAttr() throws XMLStreamException {
        long[] values = new long[]{0L, 3L, -9L, 999L, -77L, 1000000002L, -2000000004L, 123456789012345678L, -987654321098765423L, Long.MIN_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            this.assertXML("<a attr='" + value + "'></a>", this.writeLongAttrDoc("a", "attr", value));
        }
    }

    public void testMultipleLongAttr() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 w = this.getTypedWriter(bos);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeLongAttribute(null, null, "a", 0L);
        w.writeLongAttribute(null, null, "bz", Long.MAX_VALUE);
        w.writeLongAttribute(null, null, "___", -1200300400L);
        w.writeEndElement();
        w.writeEndDocument();
        byte[] data = this.closeWriter((XMLStreamWriter)w, bos);
        XMLStreamReader2 sr = this.getRootReader(data);
        WriterTestBase.assertEquals((int)3, (int)sr.getAttributeCount());
        int ix1 = sr.getAttributeIndex("", "a");
        int ix2 = sr.getAttributeIndex("", "bz");
        int ix3 = sr.getAttributeIndex("", "___");
        if (ix1 < 0 || ix2 < 0 || ix3 < 0) {
            WriterTestBase.fail((String)("Couldn't find indexes of attributes: a=" + ix1 + ", bz=" + ix2 + ", ___=" + ix3));
        }
        WriterTestBase.assertEquals((long)0L, (long)sr.getAttributeAsLong(ix1));
        WriterTestBase.assertEquals((long)Long.MAX_VALUE, (long)sr.getAttributeAsLong(ix2));
        WriterTestBase.assertEquals((long)-1200300400L, (long)sr.getAttributeAsLong(ix3));
        sr.close();
    }

    public void testSimpleFloatElem() throws XMLStreamException {
        float[] values = new float[]{0.0f, 10.47f, 0.33333334f, -0.25f, Float.MIN_VALUE, Float.MAX_VALUE, Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            this.assertXML("<root>" + value + "</root>", this.writeFloatElemDoc("root", value));
        }
    }

    public void testSimpleFloatAttr() throws XMLStreamException {
        float[] values = new float[]{0.0f, 10.47f, 0.33333334f, -0.25f, Float.MIN_VALUE, Float.MAX_VALUE, Float.NaN, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            this.assertXML("<a attr='" + value + "'></a>", this.writeFloatAttrDoc("a", "attr", value));
        }
    }

    public void testSimpleDoubleElem() throws XMLStreamException {
        double[] values = new double[]{0.0, 10.47f, 0.3333333333333333, -0.25, Double.MIN_VALUE, Double.MAX_VALUE, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            this.assertXML("<root>" + value + "</root>", this.writeDoubleElemDoc("root", value));
        }
    }

    public void testSimpleDoubleAttr() throws XMLStreamException {
        double[] values = new double[]{0.0, 10.47f, 0.3333333333333333, -0.25, Double.MIN_VALUE, Double.MAX_VALUE, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            this.assertXML("<a attr='" + value + "'></a>", this.writeDoubleAttrDoc("a", "attr", value));
        }
    }

    public void testBigInteger() throws XMLStreamException {
        BigInteger I = BigInteger.valueOf(3L);
        Random rnd = new Random(2L);
        for (int i = 1; i < 200; ++i) {
            this.assertXML("<root>" + I + "</root>", this.writeIntegerElemDoc("root", I));
            this.assertXML("<a attr='" + I + "'></a>", this.writeIntegerAttrDoc("a", "attr", I));
            I = I.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(rnd.nextInt() & 0xF));
        }
    }

    public void testBigDecimal() throws XMLStreamException {
        BigDecimal D = BigDecimal.valueOf(1L);
        Random rnd = new Random(9L);
        for (int i = 1; i < 200; ++i) {
            this.assertXML("<root>" + D + "</root>", this.writeDecimalElemDoc("root", D));
            this.assertXML("<a attr='" + D + "'></a>", this.writeDecimalAttrDoc("a", "attr", D));
            D = D.add(BigDecimal.valueOf(rnd.nextInt() & 0xF)).divide(BigDecimal.valueOf(10L));
        }
    }

    public void testQNameNonRepairing() throws XMLStreamException {
        this.doTestQName(false);
    }

    public void testQNameRepairing() throws XMLStreamException {
        this.doTestQName(true);
    }

    private void doTestQName(boolean repairing) throws XMLStreamException {
        String URI2 = "http://my.uri";
        QName n = new QName("http://my.uri", "elem", "ns");
        this.assertXML("<root xmlns:ns='http://my.uri'>ns:elem</root>", this.writeQNameElemDoc("root", n, repairing));
        this.assertXML("<root xmlns:ns='http://my.uri' attr='ns:elem'></root>", this.writeQNameAttrDoc("root", "attr", n, repairing));
    }

    public void testIntArraysElem() throws XMLStreamException {
        this.doTestIntArrays(false);
    }

    public void testIntArraysAttr() throws XMLStreamException {
        this.doTestIntArrays(true);
    }

    private void doTestIntArrays(boolean testAttr) throws XMLStreamException {
        for (int i = 0; i <= ARRAY_TEST_LENGTHS.length; ++i) {
            int[] data;
            if (i == 0) {
                data = new int[]{0, -139, 29, Integer.MAX_VALUE, 1, Integer.MIN_VALUE};
            } else {
                Random rnd = new Random(9L);
                int len = ARRAY_TEST_LENGTHS[i - 1];
                data = new int[len];
                for (int ix = 0; ix < len; ++ix) {
                    data[ix] = rnd.nextInt();
                }
            }
            String contents = testAttr ? this.getAttributeContent(this.writeIntArrayAttrDoc("root", "attr", data)) : this.getElementContent(this.writeIntArrayElemDoc("root", data));
            StringTokenizer st = new StringTokenizer(contents);
            int count = 0;
            while (st.hasMoreTokens()) {
                String act;
                String exp = String.valueOf(data[count]);
                if (!exp.equals(act = st.nextToken())) {
                    WriterTestBase.fail((String)("Incorrect entry #" + count + "/" + data.length + ": act = '" + act + "' (exp '" + exp + "')"));
                }
                ++count;
            }
            WriterTestBase.assertEquals((int)data.length, (int)count);
        }
    }

    public void testLongArraysElem() throws XMLStreamException {
        this.doTestLongArrays(false);
    }

    public void testLongArraysAttr() throws XMLStreamException {
        this.doTestLongArrays(true);
    }

    private void doTestLongArrays(boolean testAttr) throws XMLStreamException {
        for (int i = 0; i <= ARRAY_TEST_LENGTHS.length; ++i) {
            long[] data;
            if (i == 0) {
                data = new long[]{0L, -139L, 29L, Long.MAX_VALUE, 1L, Long.MIN_VALUE};
            } else {
                Random rnd = new Random(9L);
                int len = ARRAY_TEST_LENGTHS[i - 1];
                data = new long[len];
                for (int ix = 0; ix < len; ++ix) {
                    data[ix] = rnd.nextLong();
                }
            }
            String contents = testAttr ? this.getAttributeContent(this.writeLongArrayAttrDoc("root", "attr", data)) : this.getElementContent(this.writeLongArrayElemDoc("root", data));
            StringTokenizer st = new StringTokenizer(contents);
            int count = 0;
            while (st.hasMoreTokens()) {
                String act;
                String exp = String.valueOf(data[count]);
                if (!exp.equals(act = st.nextToken())) {
                    WriterTestBase.fail((String)("Incorrect entry #" + count + "/" + data.length + ": act = '" + act + "' (exp '" + exp + "')"));
                }
                ++count;
            }
            WriterTestBase.assertEquals((int)data.length, (int)count);
        }
    }

    public void testFloatArraysElem() throws XMLStreamException {
        this.doTestFloatArrays(false);
    }

    public void testFloatArraysAttr() throws XMLStreamException {
        this.doTestFloatArrays(true);
    }

    private void doTestFloatArrays(boolean testAttr) throws XMLStreamException {
        for (int i = 0; i <= ARRAY_TEST_LENGTHS.length; ++i) {
            float[] data;
            if (i == 0) {
                data = new float[]{0.0f, -139.0f, 29.0f, Float.MAX_VALUE, 1.0f, Float.MIN_VALUE};
            } else {
                Random rnd = new Random(9L);
                int len = ARRAY_TEST_LENGTHS[i - 1];
                data = new float[len];
                for (int ix = 0; ix < len; ++ix) {
                    float value = rnd.nextFloat();
                    if (rnd.nextBoolean()) {
                        value *= (float)rnd.nextInt();
                    }
                    if (rnd.nextBoolean()) {
                        value = -value;
                    }
                    data[ix] = value;
                }
            }
            String contents = testAttr ? this.getAttributeContent(this.writeFloatArrayAttrDoc("root", "attr", data)) : this.getElementContent(this.writeFloatArrayElemDoc("root", data));
            StringTokenizer st = new StringTokenizer(contents);
            int count = 0;
            while (st.hasMoreTokens()) {
                String act;
                String exp = String.valueOf(data[count]);
                if (!exp.equals(act = st.nextToken())) {
                    WriterTestBase.fail((String)("Incorrect entry #" + count + "/" + data.length + ": act = '" + act + "' (exp '" + exp + "')"));
                }
                ++count;
            }
            WriterTestBase.assertEquals((int)data.length, (int)count);
        }
    }

    public void testDoubleArraysElem() throws XMLStreamException {
        this.doTestDoubleArrays(false);
    }

    public void testDoubleArraysAttr() throws XMLStreamException {
        this.doTestDoubleArrays(true);
    }

    private void doTestDoubleArrays(boolean testAttr) throws XMLStreamException {
        for (int i = 0; i <= ARRAY_TEST_LENGTHS.length; ++i) {
            double[] data;
            if (i == 0) {
                data = new double[]{0.0, -139.0, 29.0, Double.MAX_VALUE, 1.0, Double.MIN_VALUE};
            } else {
                Random rnd = new Random(9L);
                int len = ARRAY_TEST_LENGTHS[i - 1];
                data = new double[len];
                for (int ix = 0; ix < len; ++ix) {
                    double value = rnd.nextDouble();
                    if (rnd.nextBoolean()) {
                        value *= (double)rnd.nextLong();
                    }
                    if (rnd.nextBoolean()) {
                        value = -value;
                    }
                    data[ix] = value;
                }
            }
            String contents = testAttr ? this.getAttributeContent(this.writeDoubleArrayAttrDoc("root", "attr", data)) : this.getElementContent(this.writeDoubleArrayElemDoc("root", data));
            StringTokenizer st = new StringTokenizer(contents);
            int count = 0;
            while (st.hasMoreTokens()) {
                String act;
                String exp = String.valueOf(data[count]);
                if (!exp.equals(act = st.nextToken())) {
                    WriterTestBase.fail((String)("Incorrect entry #" + count + "/" + data.length + ": act = '" + act + "' (exp '" + exp + "')"));
                }
                ++count;
            }
            WriterTestBase.assertEquals((int)data.length, (int)count);
        }
    }

    private void checkBooleanElem(byte[] data, boolean expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(data);
        WriterTestBase.assertEquals((boolean)expState, (boolean)sr.getElementAsBoolean());
        sr.close();
    }

    private void checkBooleanAttr(byte[] data, boolean expState) throws XMLStreamException {
        XMLStreamReader2 sr = this.getRootReader(data);
        WriterTestBase.assertEquals((boolean)expState, (boolean)sr.getAttributeAsBoolean(0));
        sr.close();
    }

    private void writeBooleanElem(TypedXMLStreamWriter sw, boolean b) throws XMLStreamException {
        sw.writeStartDocument();
        sw.writeStartElement("root");
        sw.writeBoolean(b);
        sw.writeEndElement();
        sw.writeEndDocument();
    }

    private void writeBooleanAttr(TypedXMLStreamWriter sw, boolean b) throws XMLStreamException {
        sw.writeStartDocument();
        sw.writeStartElement("root");
        sw.writeBooleanAttribute(null, null, "attr", b);
        sw.writeEndElement();
        sw.writeEndDocument();
    }

    private String writeIntElemDoc(String elem, int value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeInt(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeIntAttrDoc(String elem, String attr, int value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeIntAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeLongElemDoc(String elem, long value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeLong(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeLongAttrDoc(String elem, String attr, long value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeLongAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeFloatElemDoc(String elem, float value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeFloat(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeFloatAttrDoc(String elem, String attr, float value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeFloatAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeDoubleElemDoc(String elem, double value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeDouble(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeDoubleAttrDoc(String elem, String attr, double value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeDoubleAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeIntegerElemDoc(String elem, BigInteger value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeInteger(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeIntegerAttrDoc(String elem, String attr, BigInteger value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeIntegerAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeDecimalElemDoc(String elem, BigDecimal value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeDecimal(value);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.getUTF8((XMLStreamWriter)sw, bos);
    }

    private String writeDecimalAttrDoc(String elem, String attr, BigDecimal value) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeDecimalAttribute(null, null, attr, value);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeQNameElemDoc(String elem, QName n, boolean repairing) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos, repairing);
        sw.writeStartElement(elem);
        if (!repairing) {
            sw.writeNamespace(n.getPrefix(), n.getNamespaceURI());
        }
        sw.writeQName(n);
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private String writeQNameAttrDoc(String elem, String attr, QName n, boolean repairing) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos, repairing);
        sw.writeStartElement(elem);
        if (!repairing) {
            sw.writeNamespace(n.getPrefix(), n.getNamespaceURI());
        }
        sw.writeQNameAttribute(null, null, attr, n);
        sw.writeCharacters("");
        sw.writeEndElement();
        sw.writeEndDocument();
        String str = this.getUTF8((XMLStreamWriter)sw, bos);
        return str.replace('\"', '\'');
    }

    private byte[] writeIntArrayElemDoc(String elem, int[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        if (values.length % 2 == 1) {
            sw.writeIntArray(values, 0, values.length);
        } else {
            int offset = values.length / 2;
            sw.writeIntArray(values, 0, offset);
            sw.writeIntArray(values, offset, values.length - offset);
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeIntArrayAttrDoc(String elem, String attr, int[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeIntArrayAttribute(null, null, attr, values);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeLongArrayElemDoc(String elem, long[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        if (values.length % 2 == 1) {
            sw.writeLongArray(values, 0, values.length);
        } else {
            int offset = values.length / 2;
            sw.writeLongArray(values, 0, offset);
            sw.writeLongArray(values, offset, values.length - offset);
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeLongArrayAttrDoc(String elem, String attr, long[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeLongArrayAttribute(null, null, attr, values);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeFloatArrayElemDoc(String elem, float[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        if (values.length % 2 == 1) {
            sw.writeFloatArray(values, 0, values.length);
        } else {
            int offset = values.length / 2;
            sw.writeFloatArray(values, 0, offset);
            sw.writeFloatArray(values, offset, values.length - offset);
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeFloatArrayAttrDoc(String elem, String attr, float[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeFloatArrayAttribute(null, null, attr, values);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeDoubleArrayElemDoc(String elem, double[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        if (values.length % 2 == 1) {
            sw.writeDoubleArray(values, 0, values.length);
        } else {
            int offset = values.length / 2;
            sw.writeDoubleArray(values, 0, offset);
            sw.writeDoubleArray(values, offset, values.length - offset);
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    private byte[] writeDoubleArrayAttrDoc(String elem, String attr, double[] values) throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLStreamWriter2 sw = this.getTypedWriter(bos);
        sw.writeStartElement(elem);
        sw.writeDoubleArrayAttribute(null, null, attr, values);
        sw.writeEndElement();
        sw.writeEndDocument();
        return this.closeWriter((XMLStreamWriter)sw, bos);
    }

    protected abstract XMLStreamWriter2 getTypedWriter(ByteArrayOutputStream var1, boolean var2) throws XMLStreamException;

    protected abstract byte[] closeWriter(XMLStreamWriter var1, ByteArrayOutputStream var2) throws XMLStreamException;

    private XMLStreamWriter2 getTypedWriter(ByteArrayOutputStream out) throws XMLStreamException {
        return this.getTypedWriter(out, false);
    }

    private XMLStreamReader2 getRootReader(byte[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(data);
        WriterTestBase.assertTokenType(7, sr.getEventType());
        while (sr.next() != 1) {
        }
        WriterTestBase.assertTokenType(1, sr.getEventType());
        return sr;
    }

    private XMLStreamReader2 getReader(byte[] data) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        WriterTestBase.setCoalescing((XMLInputFactory)f, false);
        WriterTestBase.setNamespaceAware((XMLInputFactory)f, true);
        return (XMLStreamReader2)f.createXMLStreamReader(new ByteArrayInputStream(data));
    }

    private String getUTF8(XMLStreamWriter sw, ByteArrayOutputStream bos) throws XMLStreamException {
        byte[] data = this.closeWriter(sw, bos);
        try {
            return new String(data, "UTF-8");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private String getElementContent(byte[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(data);
        WriterTestBase.assertTokenType(7, sr.getEventType());
        while (sr.next() != 1) {
        }
        WriterTestBase.assertTokenType(1, sr.getEventType());
        String content = sr.getElementText();
        sr.close();
        return content;
    }

    private String getAttributeContent(byte[] data) throws XMLStreamException {
        XMLStreamReader2 sr = this.getReader(data);
        WriterTestBase.assertTokenType(7, sr.getEventType());
        while (sr.next() != 1) {
        }
        WriterTestBase.assertTokenType(1, sr.getEventType());
        WriterTestBase.assertEquals((int)1, (int)sr.getAttributeCount());
        String content = sr.getAttributeValue(0);
        sr.close();
        return content;
    }

    void assertXML(String exp, String act) {
        int ix;
        if ((act = act.trim()).startsWith("<?xml")) {
            ix = act.indexOf("?>");
            act = act.substring(ix + 2);
        }
        if (exp.equals(act)) {
            return;
        }
        ix = act.indexOf("/>");
        if (ix > 0) {
            String prefix = act.substring(0, ix).trim();
            String suffix = act.substring(ix + 2);
            ix = prefix.lastIndexOf("<");
            int ix2 = prefix.indexOf(32, ix);
            String name = ix2 < 0 ? prefix.substring(ix + 1) : prefix.substring(ix + 1, ix2);
            act = prefix + "></" + name + ">" + suffix;
        }
        WriterTestBase.assertEquals((String)exp, (String)act);
    }
}

