/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestXMLStreamReader2
extends BaseStax2Test {
    public void testPropertiesNative() throws XMLStreamException {
        this.doTestProperties(false, false);
        this.doTestProperties(true, false);
    }

    public void testPropertiesWrapped() throws XMLStreamException {
        this.doTestProperties(false, true);
        this.doTestProperties(true, true);
    }

    public void testSkipElement() throws XMLStreamException {
        this.doTestSkipElement(false);
        this.doTestSkipElement(true);
    }

    public void testGetPrefixedName() throws XMLStreamException {
        this.doTestGetPrefixedName(false);
        this.doTestGetPrefixedName(true);
    }

    public void testReportCData() throws XMLStreamException {
        this._testCData(false, false);
        this._testCData(false, true);
        this._testCData(true, false);
        this._testCData(true, true);
    }

    public void testLongerCData() throws Exception {
        String SRC_TEXT = "\r\n123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678\r\n<embededElement>Woodstox 4.0.5 does not like this embedded element.  However, if you take\r\nout one or more characters from the really long line (so that less than 500 characters come between\r\n'CDATA[' and the opening of the embeddedElement tag (including LF), then Woodstox will instead\r\ncomplain that the CDATA section wasn't ended.";
        String DST_TEXT = SRC_TEXT.replace("\r\n", "\n");
        String XML = "<?xml version='1.0' encoding='utf-8'?>\r\n<test><![CDATA[" + SRC_TEXT + "]]></test>";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(239);
        bos.write(187);
        bos.write(191);
        bos.write(XML.getBytes("UTF-8"));
        byte[] bytes = bos.toByteArray();
        XMLInputFactory2 f = this.getInputFactory();
        TestXMLStreamReader2.setCoalescing((XMLInputFactory)f, false);
        XMLStreamReader sr = f.createXMLStreamReader((InputStream)new ByteArrayInputStream(bytes));
        TestXMLStreamReader2.assertTokenType(7, sr.getEventType());
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        TestXMLStreamReader2.assertEquals((String)"test", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((String)DST_TEXT, (String)sr.getElementText());
        TestXMLStreamReader2.assertTokenType(2, sr.getEventType());
        sr.close();
    }

    public void _testCData(boolean wrapped, boolean report) throws XMLStreamException {
        String XML = "<root><![CDATA[test]]></root>";
        XMLInputFactory2 f = this.getInputFactory();
        TestXMLStreamReader2.setCoalescing((XMLInputFactory)f, false);
        f.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", (Object)new Boolean(report));
        XMLStreamReader sr = f.createXMLStreamReader((Reader)new StringReader("<root><![CDATA[test]]></root>"));
        if (wrapped) {
            sr = this.wrapWithAdapter(sr);
        }
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        int t = sr.next();
        TestXMLStreamReader2.assertEquals((String)"test", (String)TestXMLStreamReader2.getAndVerifyText(sr));
        if (report) {
            TestXMLStreamReader2.assertTokenType(12, t);
        } else {
            TestXMLStreamReader2.assertTokenType(4, t);
        }
        TestXMLStreamReader2.assertTokenType(2, sr.next());
        sr.close();
    }

    public void doTestProperties(boolean ns, boolean wrapped) throws XMLStreamException {
        String XML = "<root><child attr='123' /><child2>xxx</child2></root>";
        XMLStreamReader2 sr = this.getReader("<root><child attr='123' /><child2>xxx</child2></root>", ns);
        if (wrapped) {
            sr = this.wrapWithAdapter((XMLStreamReader)sr);
        }
        TestXMLStreamReader2.assertTokenType(7, sr.getEventType());
        TestXMLStreamReader2.assertEquals((int)0, (int)sr.getDepth());
        TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)1, (int)sr.getDepth());
        TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        TestXMLStreamReader2.assertEquals((String)"child", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)2, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertTrue((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(2, sr.next());
        TestXMLStreamReader2.assertEquals((String)"child", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)2, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        TestXMLStreamReader2.assertEquals((String)"child2", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)2, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(4, sr.next());
        TestXMLStreamReader2.assertEquals((String)"xxx", (String)TestXMLStreamReader2.getAndVerifyText((XMLStreamReader)sr));
        TestXMLStreamReader2.assertEquals((int)2, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(2, sr.next());
        TestXMLStreamReader2.assertEquals((String)"child2", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)2, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(2, sr.next());
        TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getLocalName());
        TestXMLStreamReader2.assertEquals((int)1, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
        TestXMLStreamReader2.assertTokenType(8, sr.next());
        TestXMLStreamReader2.assertEquals((int)0, (int)sr.getDepth());
        if (!wrapped) {
            TestXMLStreamReader2.assertFalse((boolean)sr.isEmptyElement());
        }
    }

    public void doTestSkipElement(boolean ns) throws XMLStreamException {
        String XML = "<root><child attr='123' /><child2>xxx</child2></root>";
        XMLStreamReader2 sr = this.getReader("<root><child attr='123' /><child2>xxx</child2></root>", ns);
        TestXMLStreamReader2.assertTokenType(7, sr.getEventType());
        TestXMLStreamReader2.assertTokenType(1, sr.next());
        TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getLocalName());
        sr.skipElement();
        TestXMLStreamReader2.assertTokenType(2, sr.getEventType());
        TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getLocalName());
        TestXMLStreamReader2.assertTokenType(8, sr.next());
    }

    public void doTestGetPrefixedName(boolean ns) throws XMLStreamException {
        String XML = "<root><xy:elem xmlns:xy='http://foo' xmlns:another='http://x'><?proc instr?>...<another:x /></xy:elem></root>";
        XMLStreamReader2 sr = this.getReader("<root><xy:elem xmlns:xy='http://foo' xmlns:another='http://x'><?proc instr?>...<another:x /></xy:elem></root>", ns);
        try {
            TestXMLStreamReader2.assertTokenType(1, sr.next());
            TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(1, sr.next());
            TestXMLStreamReader2.assertEquals((String)"xy:elem", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(3, sr.next());
            TestXMLStreamReader2.assertEquals((String)"proc", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(4, sr.next());
            TestXMLStreamReader2.assertTokenType(1, sr.next());
            TestXMLStreamReader2.assertEquals((String)"another:x", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(2, sr.next());
            TestXMLStreamReader2.assertEquals((String)"another:x", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(2, sr.next());
            TestXMLStreamReader2.assertEquals((String)"xy:elem", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(2, sr.next());
            TestXMLStreamReader2.assertEquals((String)"root", (String)sr.getPrefixedName());
            TestXMLStreamReader2.assertTokenType(8, sr.next());
        }
        catch (XMLStreamException xse) {
            TestXMLStreamReader2.fail((String)("Did not expect any problems during parsing, but got: " + xse));
        }
    }

    private XMLStreamReader2 getReader(String contents, boolean nsAware) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestXMLStreamReader2.setCoalescing((XMLInputFactory)f, true);
        TestXMLStreamReader2.setSupportDTD((XMLInputFactory)f, true);
        TestXMLStreamReader2.setNamespaceAware((XMLInputFactory)f, nsAware);
        TestXMLStreamReader2.setValidating((XMLInputFactory)f, false);
        return TestXMLStreamReader2.constructStreamReader((XMLInputFactory)f, contents);
    }
}

