/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestNamespaces
extends BaseStax2Test {
    public void testNonTransientNsCtxt() throws XMLStreamException {
        String XML = "<root xmlns:a='myurl' attr1='value' a:attr1='' xmlns:b='urlforb'><a:branch xmlns='someurl' xmlns:a='whatever' attr='value' b:foo='1' xmlns:c='yetanotherurl'><leaf xmlns='url' /></a:branch></root>";
        XMLStreamReader2 sr = this.getNsReader(XML, true);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"root", (String)sr.getLocalName());
        NamespaceContext curr = sr.getNamespaceContext();
        TestNamespaces.assertNotNull((Object)curr);
        this.checkValidityOfNs1(curr);
        NamespaceContext nc1 = sr.getNonTransientNamespaceContext();
        TestNamespaces.assertNotNull((Object)nc1);
        this.checkValidityOfNs1(nc1);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"branch", (String)sr.getLocalName());
        curr = sr.getNamespaceContext();
        TestNamespaces.assertNull((Object)curr.getPrefix("nosuchurl"));
        TestNamespaces.assertNull((Object)curr.getNamespaceURI("xyz"));
        TestNamespaces.assertEquals((String)"a", (String)curr.getPrefix("whatever"));
        TestNamespaces.assertEquals((String)"whatever", (String)curr.getNamespaceURI("a"));
        TestNamespaces.assertEquals((String)"b", (String)curr.getPrefix("urlforb"));
        TestNamespaces.assertEquals((String)"urlforb", (String)curr.getNamespaceURI("b"));
        TestNamespaces.assertEquals((String)"", (String)curr.getPrefix("someurl"));
        TestNamespaces.assertEquals((String)"c", (String)curr.getPrefix("yetanotherurl"));
        TestNamespaces.assertEquals((String)"someurl", (String)curr.getNamespaceURI(""));
        TestNamespaces.assertEquals((String)"yetanotherurl", (String)curr.getNamespaceURI("c"));
        this.checkValidityOfNs1(nc1);
        TestNamespaces.assertEquals((int)1, (int)sr.next());
        TestNamespaces.assertEquals((String)"leaf", (String)sr.getLocalName());
        this.checkValidityOfNs1(nc1);
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        TestNamespaces.assertEquals((int)2, (int)sr.next());
        this.checkValidityOfNs1(nc1);
    }

    private void checkValidityOfNs1(NamespaceContext nc) throws XMLStreamException {
        TestNamespaces.assertNull((Object)nc.getPrefix("someurl"));
        TestNamespaces.assertNull((Object)nc.getPrefix("whatever"));
        TestNamespaces.assertNull((Object)nc.getNamespaceURI("c"));
        String defNs = nc.getNamespaceURI("");
        if (defNs != null && defNs.length() > 0) {
            TestNamespaces.fail((String)("Expected default namespace to be null or empty, was '" + defNs + "'"));
        }
        TestNamespaces.assertEquals((String)"a", (String)nc.getPrefix("myurl"));
        TestNamespaces.assertEquals((String)"myurl", (String)nc.getNamespaceURI("a"));
        TestNamespaces.assertEquals((String)"b", (String)nc.getPrefix("urlforb"));
        TestNamespaces.assertEquals((String)"urlforb", (String)nc.getNamespaceURI("b"));
    }

    private XMLStreamReader2 getNsReader(String contents, boolean coalesce) throws XMLStreamException {
        XMLInputFactory2 f = this.getInputFactory();
        TestNamespaces.setNamespaceAware((XMLInputFactory)f, true);
        TestNamespaces.setCoalescing((XMLInputFactory)f, coalesce);
        TestNamespaces.setValidating((XMLInputFactory)f, false);
        return TestNamespaces.constructStreamReader((XMLInputFactory)f, contents);
    }
}

