/*
 * Decompiled with CFR 0.152.
 */
package stax2.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import stax2.BaseStax2Test;

public class TestGetElement
extends BaseStax2Test {
    public void testLargeDocCoalesce() throws XMLStreamException {
        this._testLargeDoc(true);
    }

    public void testLargeDocNonCoalesce() throws XMLStreamException {
        this._testLargeDoc(false);
    }

    public void testLongSegmentCoalesce() throws XMLStreamException {
        this._testLongSegment(true);
    }

    public void testLongSegmentNonCoalesce() throws XMLStreamException {
        this._testLongSegment(false);
    }

    private void _testLargeDoc(boolean coalesce) throws XMLStreamException {
        int LEN = 7258000;
        long SEED = 72L;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(7260000);
        int rowCount = this.generateDoc(72L, 7258000, bos);
        XMLInputFactory2 f = this.getInputFactory();
        byte[] docData = bos.toByteArray();
        TestGetElement.setCoalescing((XMLInputFactory)f, coalesce);
        XMLStreamReader sr = f.createXMLStreamReader(new ByteArrayInputStream(docData));
        TestGetElement.assertTokenType(1, sr.next());
        TestGetElement.assertEquals((String)"data", (String)sr.getLocalName());
        int actRowCount = 0;
        Random r = new Random(72L);
        while (sr.nextTag() == 1) {
            ++actRowCount;
            TestGetElement.assertEquals((String)"row", (String)sr.getLocalName());
            this.expectElemText(sr, "a", String.valueOf(r.nextInt()));
            this.expectElemText(sr, "b", String.valueOf(r.nextLong()));
            this.expectElemText(sr, "c", String.valueOf(r.nextBoolean()));
            TestGetElement.assertTokenType(2, sr.nextTag());
        }
        TestGetElement.assertEquals((int)rowCount, (int)actRowCount);
    }

    private void _testLongSegment(boolean coalesce) throws XMLStreamException {
        int LEN = 129000;
        Random r = new Random(17L);
        StringBuilder sb = new StringBuilder(131000);
        block5: while (sb.length() < 129000) {
            switch (r.nextInt() & 7) {
                case 0: {
                    sb.append("123");
                    continue block5;
                }
                case 1: {
                    sb.append("foo\nbar");
                    continue block5;
                }
                case 2: {
                    sb.append("rock & roll!");
                    continue block5;
                }
            }
            sb.append(sb.length());
        }
        String contentStr = sb.toString();
        StringWriter strw = new StringWriter(133000);
        XMLStreamWriter sw = this.getOutputFactory().createXMLStreamWriter((Writer)strw);
        sw.writeStartDocument();
        sw.writeStartElement("data");
        sw.writeCharacters(contentStr);
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        XMLInputFactory2 f = this.getInputFactory();
        TestGetElement.setCoalescing((XMLInputFactory)f, coalesce);
        XMLStreamReader sr = f.createXMLStreamReader(new StringReader(strw.toString()));
        TestGetElement.assertTokenType(1, sr.next());
        TestGetElement.assertEquals((String)"data", (String)sr.getLocalName());
        String actStr = sr.getElementText();
        TestGetElement.assertEquals((String)contentStr, (String)actStr);
        TestGetElement.assertTokenType(2, sr.getEventType());
        TestGetElement.assertTokenType(8, sr.next());
    }

    private int generateDoc(long SEED, int LEN, ByteArrayOutputStream out) throws XMLStreamException {
        XMLStreamWriter sw = this.getOutputFactory().createXMLStreamWriter((OutputStream)out, "UTF-8");
        Random r = new Random(SEED);
        sw.writeStartDocument();
        sw.writeStartElement("data");
        int rowCount = 0;
        while (out.size() < LEN) {
            sw.writeStartElement("row");
            sw.writeStartElement("a");
            sw.writeCharacters(String.valueOf(r.nextInt()));
            sw.writeEndElement();
            sw.writeStartElement("b");
            sw.writeCharacters(String.valueOf(r.nextLong()));
            sw.writeEndElement();
            sw.writeStartElement("c");
            sw.writeCharacters(String.valueOf(r.nextBoolean()));
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeEndElement();
            sw.flush();
            ++rowCount;
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
        return rowCount;
    }

    private void expectElemText(XMLStreamReader sr, String elem, String value) throws XMLStreamException {
        TestGetElement.assertTokenType(1, sr.nextTag());
        TestGetElement.assertEquals((String)elem, (String)sr.getLocalName());
        String actValue = sr.getElementText();
        if (!value.equals(actValue)) {
            TestGetElement.fail((String)("Expected value '" + value + "' (for element '" + elem + "'), got '" + actValue + "' (len " + actValue.length() + "): location " + sr.getLocation()));
        }
        TestGetElement.assertTokenType(2, sr.getEventType());
    }
}

