/*
 * Decompiled with CFR 0.152.
 */
package stax2.dtd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import stax2.BaseStax2Test;

public class TestExternalDTD
extends BaseStax2Test {
    final String EXTERNAL_FILENAME1 = "external1.xml";
    final String EXTERNAL_FILENAME2 = "external2.xml";
    static final String DTD1 = "external.dtd";
    final String EXTERNAL_XML1 = "<!DOCTYPE root SYSTEM 'external.dtd'><root>&simpleEntity;</root>";
    final String EXTERNAL_XML2 = "<!DOCTYPE root PUBLIC '//some//public//id' 'external.dtd'><root>&simpleEntity;</root>";
    final String SIMPLE_EXT_ENTITY_TEXT = "simple textual content";

    public void testStreamWithSystemId() throws IOException, XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            XMLStreamReader sr;
            String filename = i == 0 ? "external1.xml" : "external2.xml";
            String sysId = this.constructSystemId(this.resolveFile(filename));
            String XML = i == 0 ? "<!DOCTYPE root SYSTEM 'external.dtd'><root>&simpleEntity;</root>" : "<!DOCTYPE root PUBLIC '//some//public//id' 'external.dtd'><root>&simpleEntity;</root>";
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader(sysId, this.utf8StreamFromString(XML));
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct a SystemID-based stream reader: " + xse));
                return;
            }
            try {
                TestExternalDTD.assertTokenType(11, sr.next());
                TestExternalDTD.assertTokenType(1, sr.next());
                TestExternalDTD.assertTokenType(4, sr.next());
                TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText(sr));
                TestExternalDTD.assertTokenType(2, sr.next());
                continue;
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to process content using SystemID-based stream reader: " + xse));
            }
        }
    }

    public void testReaderWithSystemId() throws IOException, XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            XMLStreamReader sr;
            String filename = i == 0 ? "external1.xml" : "external2.xml";
            String sysId = this.constructSystemId(this.resolveFile(filename));
            String XML = i == 0 ? "<!DOCTYPE root SYSTEM 'external.dtd'><root>&simpleEntity;</root>" : "<!DOCTYPE root PUBLIC '//some//public//id' 'external.dtd'><root>&simpleEntity;</root>";
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader(sysId, (Reader)new StringReader(XML));
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct a SystemID-based String reader: " + xse));
                return;
            }
            try {
                TestExternalDTD.assertTokenType(11, sr.next());
                TestExternalDTD.assertTokenType(1, sr.next());
                TestExternalDTD.assertTokenType(4, sr.next());
                TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText(sr));
                TestExternalDTD.assertTokenType(2, sr.next());
                continue;
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to process content using SystemID-based String reader: " + xse));
            }
        }
    }

    public void testStreamWithStreamSource() throws IOException, XMLStreamException {
        String filename;
        int i;
        for (i = 0; i < 2; ++i) {
            XMLStreamReader sr;
            filename = i == 0 ? "external1.xml" : "external2.xml";
            String sysId = this.constructSystemId(this.resolveFile(filename));
            String XML = i == 0 ? "<!DOCTYPE root SYSTEM 'external.dtd'><root>&simpleEntity;</root>" : "<!DOCTYPE root PUBLIC '//some//public//id' 'external.dtd'><root>&simpleEntity;</root>";
            StreamSource src = new StreamSource(this.utf8StreamFromString(XML), sysId);
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader((Source)src);
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct a StreamSource-based stream reader: " + xse));
                return;
            }
            try {
                TestExternalDTD.assertTokenType(11, sr.next());
                TestExternalDTD.assertTokenType(1, sr.next());
                TestExternalDTD.assertTokenType(4, sr.next());
                TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText(sr));
                TestExternalDTD.assertTokenType(2, sr.next());
                continue;
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to process content using StreamSource-based stream reader: " + xse));
            }
        }
        for (i = 0; i < 2; ++i) {
            XMLStreamReader sr;
            filename = i == 0 ? "external1.xml" : "external2.xml";
            File file = this.resolveFile(filename);
            StreamSource src = new StreamSource(file);
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader((Source)src);
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct a StreamSource/file-based stream reader: " + xse));
                return;
            }
            try {
                TestExternalDTD.assertTokenType(11, sr.next());
                TestExternalDTD.assertTokenType(1, sr.next());
                TestExternalDTD.assertTokenType(4, sr.next());
                TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText(sr));
                TestExternalDTD.assertTokenType(2, sr.next());
                continue;
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to process content using StreamSource/file-based stream reader: " + xse));
            }
        }
    }

    public void testURL() throws IOException, XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            XMLStreamReader2 sr;
            String filename = i == 0 ? "external1.xml" : "external2.xml";
            URL src = this.resolveFile(filename).toURL();
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader(src);
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct an URL-based stream reader: " + xse));
                return;
            }
            TestExternalDTD.assertTokenType(11, sr.next());
            TestExternalDTD.assertTokenType(1, sr.next());
            TestExternalDTD.assertTokenType(4, sr.next());
            TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText((XMLStreamReader)sr));
            TestExternalDTD.assertTokenType(2, sr.next());
        }
    }

    public void testFile() throws IOException, XMLStreamException {
        for (int i = 0; i < 2; ++i) {
            XMLStreamReader2 sr;
            String filename = i == 0 ? "external1.xml" : "external2.xml";
            File file = this.resolveFile(filename);
            XMLInputFactory2 f = this.getFactory();
            try {
                sr = f.createXMLStreamReader(file);
            }
            catch (XMLStreamException xse) {
                TestExternalDTD.fail((String)("Failed to construct a file-based stream reader: " + xse));
                return;
            }
            TestExternalDTD.assertTokenType(11, sr.next());
            TestExternalDTD.assertTokenType(1, sr.next());
            TestExternalDTD.assertTokenType(4, sr.next());
            TestExternalDTD.assertEquals((String)"simple textual content", (String)TestExternalDTD.getAndVerifyText((XMLStreamReader)sr));
            TestExternalDTD.assertTokenType(2, sr.next());
        }
    }

    private XMLInputFactory2 getFactory() throws XMLStreamException {
        XMLInputFactory2 f = TestExternalDTD.getNewInputFactory();
        TestExternalDTD.setReplaceEntities((XMLInputFactory)f, true);
        TestExternalDTD.setSupportExternalEntities((XMLInputFactory)f, true);
        TestExternalDTD.setSupportDTD((XMLInputFactory)f, true);
        TestExternalDTD.setValidating((XMLInputFactory)f, false);
        TestExternalDTD.setCoalescing((XMLInputFactory)f, true);
        return f;
    }

    private File resolveFile(String relName) throws IOException {
        File f = new File("src");
        f = new File(f, "test");
        f = new File(f, "stax2");
        f = new File(f, "stream");
        f = new File(f, relName);
        return f.getAbsoluteFile();
    }

    private String constructSystemId(File f) {
        return f.getAbsolutePath();
    }

    private InputStream utf8StreamFromString(String str) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }
}

