/*
 * Decompiled with CFR 0.152.
 */
package stax2.dom;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import stax2.BaseStax2Test;

public class TestDomNamespaces
extends BaseStax2Test {
    private String xml = "<ns2:root xmlns:ns2='http://testnamespace/'><arg0><obj xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ns2:mycomplextype\"><a>321</a></obj></arg0></ns2:root>";

    public void testDOMSource() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource source = new InputSource(new StringReader(this.xml));
        Document doc = builder.parse(source);
        XMLStreamReader reader = this.getInputFactory().createXMLStreamReader((Source)new DOMSource(doc));
        reader.next();
        TestDomNamespaces.assertEquals((int)0, (int)reader.getAttributeCount());
        TestDomNamespaces.assertEquals((int)1, (int)reader.getNamespaceCount());
        TestDomNamespaces.assertEquals((String)"http://testnamespace/", (String)reader.getNamespaceURI());
        TestDomNamespaces.assertEquals((String)"ns2", (String)reader.getPrefix());
        TestDomNamespaces.assertEquals((String)"root", (String)reader.getLocalName());
        reader.next();
        reader.next();
        TestDomNamespaces.assertEquals((String)"obj", (String)reader.getLocalName());
        TestDomNamespaces.assertEquals((String)"ns2:mycomplextype", (String)reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type"));
        TestDomNamespaces.assertEquals((String)"http://testnamespace/", (String)reader.getNamespaceURI("ns2"));
        TestDomNamespaces.assertEquals((String)"http://testnamespace/", (String)reader.getNamespaceContext().getNamespaceURI("ns2"));
        TestDomNamespaces.assertEquals((String)"ns2", (String)reader.getNamespaceContext().getPrefix("http://testnamespace/"));
    }
}

