/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.wstream;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax.test.wstream.BaseWriterTest;

public class TestSimpleWriter
extends BaseWriterTest {
    final String ISO_LATIN_ENCODING = "ISO-8859-1";

    public void testProlog() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        w.writeStartDocument();
        w.writeCharacters("\r\n  ");
        w.writeEmptyElement("test");
        w.writeCharacters("  \r");
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString(), true);
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        int type = sr.next();
        if (type != 1) {
            TestSimpleWriter.assertTokenType(6, type);
            TestSimpleWriter.assertEquals((String)"\n  ", (String)TestSimpleWriter.getAndVerifyText(sr));
            TestSimpleWriter.assertTokenType(1, sr.next());
        }
        TestSimpleWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"test", (String)sr.getLocalName());
        type = sr.next();
        if (type != 8) {
            TestSimpleWriter.assertTokenType(6, type);
            TestSimpleWriter.assertEquals((String)"  \n", (String)TestSimpleWriter.getAndVerifyText(sr));
            TestSimpleWriter.assertTokenType(8, sr.next());
        }
    }

    public void testCData() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String CDATA_TEXT = "Let's test it with some ]] ]> data; <tag>s and && chars and all!";
        w.writeStartDocument();
        w.writeStartElement("test");
        w.writeCData("Let's test it with some ]] ]> data; <tag>s and && chars and all!");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString(), true);
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(1, sr.next());
        int tt = sr.next();
        if (tt != 4 && tt != 12) {
            TestSimpleWriter.assertTokenType(12, tt);
        }
        TestSimpleWriter.assertFalse((boolean)sr.isWhiteSpace());
        TestSimpleWriter.assertEquals((String)"Let's test it with some ]] ]> data; <tag>s and && chars and all!", (String)TestSimpleWriter.getAndVerifyText(sr));
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testCharacters() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String TEXT = "Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n";
        w.writeStartDocument();
        w.writeStartElement("test");
        w.writeCharacters("Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n");
        w.writeStartElement("leaf");
        char[] tmp = new char["Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n".length() + 4];
        "Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n".getChars(0, "Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n".length(), tmp, 2);
        w.writeCharacters(tmp, 2, "Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n".length());
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString(), true);
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertFalse((boolean)sr.isWhiteSpace());
        TestSimpleWriter.assertEquals((String)"Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n", (String)TestSimpleWriter.getAndVerifyText(sr));
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertFalse((boolean)sr.isWhiteSpace());
        TestSimpleWriter.assertEquals((String)"Ok; some content\nwith linefeeds and stuff (let's leave encoding as is though, no entities)\n", (String)TestSimpleWriter.getAndVerifyText(sr));
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testComment() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String COMMENT1 = "comments are cool";
        String COMMENT2 = "  some more\ncomments & other stuff";
        String COMMENT3 = "Hah: <tag> </tag>";
        String COMMENT4 = "  - - - \t   - -   \t";
        w.writeStartDocument();
        w.writeComment("comments are cool");
        w.writeStartElement("root");
        w.writeCharacters(" ");
        w.writeComment("  some more\ncomments & other stuff");
        w.writeStartElement("branch");
        w.writeEndElement();
        w.writeStartElement("branch");
        w.writeComment("Hah: <tag> </tag>");
        w.writeEndElement();
        w.writeEndElement();
        w.writeComment("  - - - \t   - -   \t");
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(5, sr.next());
        TestSimpleWriter.assertEquals((String)"comments are cool", (String)sr.getText());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        int tt = sr.next();
        if (tt != 4 && tt != 6) {
            TestSimpleWriter.fail((String)("Expected a single space (CHARACTERS or SPACE), got " + TestSimpleWriter.tokenTypeDesc(tt)));
        }
        TestSimpleWriter.assertTokenType(5, sr.next());
        TestSimpleWriter.assertEquals((String)"  some more\ncomments & other stuff", (String)sr.getText());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(5, sr.next());
        TestSimpleWriter.assertEquals((String)"Hah: <tag> </tag>", (String)sr.getText());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(5, sr.next());
        TestSimpleWriter.assertEquals((String)"  - - - \t   - -   \t", (String)sr.getText());
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testDTD() throws IOException, XMLStreamException {
    }

    public void testElements() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String URL_P1 = "http://p1.org";
        String URL_P2 = "http://ns.p2.net/yeehaw.html";
        String URL_DEF = "urn:default";
        String TEXT = "  some text\n";
        w.writeStartDocument();
        w.setPrefix("p1", "http://p1.org");
        w.writeStartElement("test");
        w.writeNamespace("p1", "http://p1.org");
        w.setDefaultNamespace("urn:default");
        w.setPrefix("p2", "http://ns.p2.net/yeehaw.html");
        w.writeStartElement("", "branch", "urn:default");
        w.writeDefaultNamespace("urn:default");
        w.writeNamespace("p2", "http://ns.p2.net/yeehaw.html");
        w.setDefaultNamespace("");
        w.writeStartElement("", "leaf", "");
        w.writeDefaultNamespace("");
        w.writeCharacters("  some text\n");
        w.writeEndElement();
        w.writeEmptyElement("http://p1.org", "leaf");
        w.writeEndElement();
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestSimpleWriter.assertEquals((String)"p1", (String)sr.getNamespacePrefix(0));
        TestSimpleWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI(0));
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertEquals((int)2, (int)sr.getNamespaceCount());
        TestSimpleWriter.assertNoPrefix(sr);
        TestSimpleWriter.assertEquals((String)"urn:default", (String)sr.getNamespaceURI());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertEquals((int)1, (int)sr.getNamespaceCount());
        TestSimpleWriter.assertNoPrefix(sr);
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertEquals((String)"  some text\n", (String)TestSimpleWriter.getAllText(sr));
        TestSimpleWriter.assertTokenType(2, sr.getEventType());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertEquals((int)0, (int)sr.getNamespaceCount());
        TestSimpleWriter.assertEquals((String)"p1", (String)sr.getPrefix());
        TestSimpleWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertEquals((String)"p1", (String)sr.getPrefix());
        TestSimpleWriter.assertEquals((String)"http://p1.org", (String)sr.getNamespaceURI());
        try {
            TestSimpleWriter.assertTokenType(2, sr.next());
        }
        catch (XMLStreamException sex) {
            TestSimpleWriter.fail((String)("Failed when trying to match </p1> (input '" + strw + "'): " + sex));
        }
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefix(sr);
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"test", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testNonNsElements() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String TEXT = "Just some text...";
        String TEXT_SPACE = "\n  ";
        w.writeStartDocument();
        w.writeStartElement("doc");
        w.writeCharacters("Just some text...");
        w.writeStartElement("branch");
        w.writeEndElement();
        w.writeCharacters("\n  ");
        w.writeStartElement("branch.2");
        w.writeCData("Just some text...");
        w.writeEndElement();
        w.writeEmptyElement("_empty");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"doc", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertEquals((String)"Just some text...", (String)TestSimpleWriter.getAllText(sr));
        TestSimpleWriter.assertTokenType(1, sr.getEventType());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertEquals((String)"\n  ", (String)TestSimpleWriter.getAllText(sr));
        TestSimpleWriter.assertTokenType(1, sr.getEventType());
        TestSimpleWriter.assertEquals((String)"branch.2", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTextualTokenType(sr.next());
        TestSimpleWriter.assertEquals((String)"Just some text...", (String)TestSimpleWriter.getAllText(sr));
        TestSimpleWriter.assertTokenType(2, sr.getEventType());
        TestSimpleWriter.assertEquals((String)"branch.2", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"_empty", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"_empty", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        try {
            TestSimpleWriter.assertTokenType(2, sr.next());
        }
        catch (XMLStreamException sex) {
            TestSimpleWriter.fail((String)("Failed when trying to match </doc> (input '" + strw + "'): " + sex));
        }
        TestSimpleWriter.assertEquals((String)"doc", (String)sr.getLocalName());
        TestSimpleWriter.assertNoPrefixOrNs(sr);
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testEmptyElements() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        w.writeStartDocument();
        w.writeStartElement("root");
        w.writeStartElement("branch");
        w.writeEmptyElement("leaf");
        w.writeEndElement();
        w.writeComment("comment");
        w.writeEndElement();
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"leaf", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(5, sr.next());
        TestSimpleWriter.assertEquals((String)"comment", (String)TestSimpleWriter.getAndVerifyText(sr));
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testEntityRef() throws IOException, XMLStreamException {
    }

    public void testProcInstr() throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        String LONG_DATA = "content & spaces <cool!>...  \t  ";
        String LONG_DATA2 = "? >? ? >  ";
        w.writeStartDocument();
        w.writeProcessingInstruction("my_target");
        w.writeStartElement("root");
        w.writeCharacters("x");
        w.writeProcessingInstruction("target", "data");
        w.writeStartElement("branch");
        w.writeEndElement();
        w.writeStartElement("branch");
        w.writeProcessingInstruction("t", "content & spaces <cool!>...  \t  ");
        w.writeEndElement();
        w.writeEndElement();
        w.writeProcessingInstruction("xxx", "? >? ? >  ");
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        TestSimpleWriter.assertTokenType(3, sr.next());
        TestSimpleWriter.assertEquals((String)"my_target", (String)sr.getPITarget());
        String data = sr.getPIData();
        if (data != null && data.length() > 0) {
            TestSimpleWriter.fail((String)("Expected empty (or null) data; got '" + data + "'"));
        }
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(4, sr.next());
        TestSimpleWriter.assertEquals((String)"x", (String)sr.getText());
        TestSimpleWriter.assertTokenType(3, sr.next());
        TestSimpleWriter.assertEquals((String)"target", (String)sr.getPITarget());
        TestSimpleWriter.assertEquals((String)"data", (String)sr.getPIData());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(1, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(3, sr.next());
        TestSimpleWriter.assertEquals((String)"t", (String)sr.getPITarget());
        TestSimpleWriter.assertEquals((String)"content & spaces <cool!>...  \t  ", (String)sr.getPIData());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"branch", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(2, sr.next());
        TestSimpleWriter.assertEquals((String)"root", (String)sr.getLocalName());
        TestSimpleWriter.assertTokenType(3, sr.next());
        TestSimpleWriter.assertEquals((String)"xxx", (String)sr.getPITarget());
        TestSimpleWriter.assertEquals((String)"? >? ? >  ", (String)sr.getPIData());
        TestSimpleWriter.assertTokenType(8, sr.next());
    }

    public void testXmlDeclImplicit() throws IOException, XMLStreamException {
        this.doTextXmlDecl(3);
    }

    public void testXmlDecl0args() throws IOException, XMLStreamException {
        this.doTextXmlDecl(0);
    }

    public void testXmlDecl1arg() throws IOException, XMLStreamException {
        this.doTextXmlDecl(1);
    }

    public void testXmlDecl2args() throws IOException, XMLStreamException {
        this.doTextXmlDecl(2);
    }

    public void testExplicitNsPrefixes() throws XMLStreamException {
        XMLStreamWriter writer = this.getNonRepairingWriter(new StringWriter());
        String NS1 = "http://foo.com";
        String NS2 = "http://bar.com";
        writer.writeStartDocument();
        writer.writeStartElement("root");
        writer.writeStartElement("branch1");
        writer.setPrefix("ns", "http://foo.com");
        writer.setDefaultNamespace("http://bar.com");
        TestSimpleWriter.assertEquals((String)"ns", (String)writer.getPrefix("http://foo.com"));
        TestSimpleWriter.assertEquals((String)"", (String)writer.getPrefix("http://bar.com"));
        TestSimpleWriter.assertNull((Object)writer.getPrefix("ns"));
        TestSimpleWriter.assertNull((Object)writer.getPrefix("nosuchPrefix"));
        writer.writeEndElement();
        TestSimpleWriter.assertNull((Object)writer.getPrefix("http://foo.com"));
        TestSimpleWriter.assertNull((Object)writer.getPrefix("http://bar.com"));
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void testImplicitNsPrefixes() throws XMLStreamException {
        XMLStreamWriter writer = this.getNonRepairingWriter(new StringWriter());
        String NS1 = "http://foo.com";
        String NS2 = "http://bar.com";
        writer.writeStartDocument();
        writer.writeStartElement("root");
        writer.writeNamespace("ns", "http://bar.com");
        writer.writeDefaultNamespace("http://foo.com");
        TestSimpleWriter.assertEquals((String)"", (String)writer.getPrefix("http://foo.com"));
        TestSimpleWriter.assertEquals((String)"ns", (String)writer.getPrefix("http://bar.com"));
        writer.writeEndElement();
        TestSimpleWriter.assertNull((Object)writer.getPrefix("http://foo.com"));
        TestSimpleWriter.assertNull((Object)writer.getPrefix("http://bar.com"));
        writer.writeEndDocument();
    }

    private void doTextXmlDecl(int i) throws IOException, XMLStreamException {
        StringWriter strw = new StringWriter();
        XMLStreamWriter w = this.getNonRepairingWriter(strw);
        switch (i) {
            case 0: {
                w.writeStartDocument();
                break;
            }
            case 1: {
                w.writeStartDocument("1.0");
                break;
            }
            case 2: {
                w.writeStartDocument("ISO-8859-1", "1.0");
                break;
            }
        }
        w.writeEmptyElement("root");
        w.writeEndDocument();
        w.close();
        XMLStreamReader sr = this.constructNsStreamReader(strw.toString());
        TestSimpleWriter.assertTokenType(7, sr.getEventType());
        if (i == 3) {
            String ver = sr.getVersion();
            if (ver != null && ver.length() > 0) {
                TestSimpleWriter.fail((String)("Non-null/empty version ('" + ver + "') when no START_DOCUMENT written explicitly"));
            }
        } else {
            TestSimpleWriter.assertEquals((String)"1.0", (String)sr.getVersion());
        }
        String enc = sr.getCharacterEncodingScheme();
        switch (i) {
            case 0: {
                if ("utf-8".equals(enc) || "UTF-8".equals(enc)) break;
                TestSimpleWriter.fail((String)("Expected either 'UTF-8' (xml specs) or 'utf-8' (stax specs) as the encoding output with no-arg 'writeStartDocument()' call (result doc = '" + strw.toString() + "')"));
                break;
            }
            case 1: {
                TestSimpleWriter.assertNull((Object)enc);
                break;
            }
            case 2: {
                TestSimpleWriter.assertEquals((String)"ISO-8859-1", (String)enc);
                break;
            }
            case 3: {
                TestSimpleWriter.assertNull((Object)enc);
            }
        }
        TestSimpleWriter.assertFalse((String)"XMLStreamReader.standalonSet() should return false if pseudo-attr not found", (boolean)sr.standaloneSet());
        sr.close();
    }
}

