/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestNmTokenAttrRead
extends BaseVStreamTest {
    public void testValidNmTokenAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name NMTOKEN #IMPLIED\n    names NMTOKENS #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidNmTokenAttrDecl() throws XMLStreamException {
    }

    public void testValidNmTokenAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem name NMTOKEN #IMPLIED>\n<!ATTLIST elem names NMTOKENS #IMPLIED>\n]>\n<elem name='some-Name'> <elem names='a few names1' /> </elem>";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidNmTokenAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem name NMTOKEN #IMPLIED>\n]>\n<elem name='?foo'/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "invalid char ('?') in NMTOKEN");
        XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem name NMTOKEN #IMPLIED>\n]>\n<elem name='foo foo/bar'/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "invalid char ('/') in NMTOKENS");
    }

    public void testNmTokenAttrNormalization() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*, elem2?, elem3?)>\n<!ATTLIST elem name NMTOKEN #IMPLIED>\n<!ATTLIST elem names NMTOKENS #IMPLIED>\n<!ELEMENT elem2 EMPTY>\n<!ATTLIST elem2 name NMTOKEN 'somename  '>\n<!ELEMENT elem3 EMPTY>\n<!ATTLIST elem3 names NMTOKENS 'name1\tname2   name3  '>\n]><elem name='nmToken  '><elem name='  name' /><elem names='first_name  \tsecond last' /><elem2 /><elem3 /></elem>";
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestNmTokenAttrRead.assertTokenType(11, sr.next());
        TestNmTokenAttrRead.assertTokenType(1, sr.next());
        TestNmTokenAttrRead.assertEquals((String)"elem", (String)sr.getLocalName());
        TestNmTokenAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNmTokenAttrRead.assertEquals((String)"nmToken", (String)sr.getAttributeValue(0));
        TestNmTokenAttrRead.assertTokenType(1, sr.next());
        TestNmTokenAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNmTokenAttrRead.assertEquals((String)"name", (String)sr.getAttributeValue(0));
        TestNmTokenAttrRead.assertTokenType(2, sr.next());
        TestNmTokenAttrRead.assertTokenType(1, sr.next());
        TestNmTokenAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNmTokenAttrRead.assertEquals((String)"first_name second last", (String)sr.getAttributeValue(0));
        TestNmTokenAttrRead.assertTokenType(2, sr.next());
        TestNmTokenAttrRead.assertTokenType(1, sr.next());
        TestNmTokenAttrRead.assertEquals((String)"elem2", (String)sr.getLocalName());
        TestNmTokenAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNmTokenAttrRead.assertEquals((String)"name", (String)sr.getAttributeLocalName(0));
        TestNmTokenAttrRead.assertEquals((String)"somename", (String)sr.getAttributeValue(0));
        TestNmTokenAttrRead.assertTokenType(2, sr.next());
        TestNmTokenAttrRead.assertTokenType(1, sr.next());
        TestNmTokenAttrRead.assertEquals((String)"elem3", (String)sr.getLocalName());
        TestNmTokenAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestNmTokenAttrRead.assertEquals((String)"names", (String)sr.getAttributeLocalName(0));
        TestNmTokenAttrRead.assertEquals((String)"name1 name2 name3", (String)sr.getAttributeValue(0));
        TestNmTokenAttrRead.assertTokenType(2, sr.next());
        TestNmTokenAttrRead.assertTokenType(2, sr.next());
    }
}

