/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestIdAttrRead
extends BaseVStreamTest {
    public TestIdAttrRead(String name) {
        super(name);
    }

    public void testValidIdAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name ID #IMPLIED\n    ref IDREF #IMPLIED>\n<!ATTLIST root refs IDREFS #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidIdAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name ID 'defId'>\n]>\n<root />";
        XMLStreamReader sr = this.getValidatingReader(XML);
        this.streamThroughFailing(sr, "invalid attribute id (default value not allowed)");
        sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name ID #FIXED 'fixedId'>\n]>\n<root />");
        this.streamThroughFailing(sr, "invalid id attribute (fixed value not allowed)");
        sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name ID #IMPLIED name2 ID #IMPLIED>\n]>\n<root />");
        this.streamThroughFailing(sr, "more than one attribute id per element");
    }

    public void testInvalidIdRefAttrDecl() throws XMLStreamException {
        XMLStreamReader sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name IDREF 'foo#bar'>\n]>\n<root />");
        this.streamThroughFailing(sr, "invalid IDREF default value ('#' not allowed)");
        sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name IDREF ''>\n]>\n<root />");
        this.streamThroughFailing(sr, "invalid (missing) IDREF default value");
        sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name IDREF 'foo b?'>\n]>\n<root />");
        this.streamThroughFailing(sr, "invalid IDREFS default value ('?' not allowed)");
        sr = this.getValidatingReader("<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ATTLIST root name IDREF ''>\n]>\n<root />");
        this.streamThroughFailing(sr, "invalid (missing) IDREFS default value");
    }

    public void testValidIdAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem ref IDREF #IMPLIED>\n]>\n<elem ref='someId'>   <elem id='someId' /> </elem>";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidIdAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem ref IDREF #IMPLIED>\n]>\n<elem ref='someId'/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "undefined id reference for 'someId'");
        XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem ref IDREF #IMPLIED>\n]>\n<elem ref=''/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "empty IDREF value");
    }

    public void testValidIdAttrsUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem refs IDREFS #IMPLIED>\n]>\n<elem id='someId1'>\n<elem id='someId2' refs='someId1  someId2  '  />\n</elem>";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidIdAttrsUse() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem refs IDREFS #IMPLIED>\n]>\n<elem refs='someId'/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "undefined id reference for 'someId'");
        XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem refs IDREFS #IMPLIED>\n]>\n<elem refs=''/>";
        this.streamThroughFailing(this.getValidatingReader(XML), "empty IDREFS value");
    }

    public void testIdAttrNormalization() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem refs IDREFS #IMPLIED>\n]><elem id='someId  '><elem id='   otherId' /></elem>";
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestIdAttrRead.assertTokenType(11, sr.next());
        TestIdAttrRead.assertTokenType(1, sr.next());
        TestIdAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestIdAttrRead.assertEquals((String)"someId", (String)sr.getAttributeValue(0));
        TestIdAttrRead.assertTokenType(1, sr.next());
        TestIdAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestIdAttrRead.assertEquals((String)"otherId", (String)sr.getAttributeValue(0));
        TestIdAttrRead.assertTokenType(2, sr.next());
        TestIdAttrRead.assertTokenType(2, sr.next());
    }

    public void testIdRefAttrNormalization() throws XMLStreamException {
        String XML = "<!DOCTYPE elem [\n<!ELEMENT elem (elem*)>\n<!ATTLIST elem id ID #IMPLIED>\n<!ATTLIST elem ref IDREF #IMPLIED>\n<!ATTLIST elem refs IDREFS #IMPLIED>\n]><elem id='someId'><elem id='id2  ' ref='  someId  ' /><elem refs='  id2\tsomeId' /></elem>";
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestIdAttrRead.assertTokenType(11, sr.next());
        TestIdAttrRead.assertTokenType(1, sr.next());
        TestIdAttrRead.assertTokenType(1, sr.next());
        TestIdAttrRead.assertEquals((int)2, (int)sr.getAttributeCount());
        TestIdAttrRead.assertEquals((String)"id2", (String)sr.getAttributeValue(0));
        TestIdAttrRead.assertEquals((String)"someId", (String)sr.getAttributeValue(1));
        TestIdAttrRead.assertTokenType(2, sr.next());
        TestIdAttrRead.assertTokenType(1, sr.next());
        TestIdAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestIdAttrRead.assertEquals((String)"id2 someId", (String)sr.getAttributeValue(0));
        TestIdAttrRead.assertTokenType(2, sr.next());
        TestIdAttrRead.assertTokenType(2, sr.next());
    }
}

