/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestEntityAttrRead
extends BaseVStreamTest {
    public void testValidEntityAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITY #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITY 'unpEnt'>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testValidUnorderedEntityAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!ATTLIST root attr ENTITY #IMPLIED>\n]>\n<root />";
        try {
            this.streamThrough(this.getValidatingReader(XML));
        }
        catch (XMLStreamException e) {
            TestEntityAttrRead.fail((String)("Entity declaration order should not matter, but failed due to: " + e.getMessage()));
        }
    }

    public void testValidEntitiesAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITIES #IMPLIED>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!NOTATION not2 PUBLIC 'public-notation-id2'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ENTITY unpEnt2 SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITIES 'unpEnt   unpEnt2  '>\n<!ATTLIST root ent2 ENTITIES '  unpEnt  '>\n]>\n<root />";
        this.streamThrough(this.getValidatingReader(XML));
    }

    public void testInvalidEntityAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION notX PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITY #IMPLIED>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "undeclared notation for ENTITY attribute");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION notX PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA notX>\n<!ATTLIST root ent ENTITY 'foobar'>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "undeclared entity for ENTITY default value");
    }

    public void testInvalidEntitiesAttrDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION notX PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ATTLIST root ent ENTITIES #IMPLIED>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "undeclared notation for ENTITIES attribute");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION notX PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA notX>\n<!ATTLIST root ent ENTITIES 'foobar'>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "undeclared entity for ENTITIES default value");
        XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION notX PUBLIC 'public-notation-id'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA notX>\n<!ATTLIST root ent ENTITIES 'unpEnt  notDeclEnt'>\n]>\n<root />";
        this.streamThroughFailing(this.getValidatingReader(XML), "undeclared entity for ENTITIES default value");
    }

    public void testValidEntityAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!NOTATION not2 PUBLIC 'public-notation-id2'>\n<!ENTITY unpEnt SYSTEM 'system-ent-id' NDATA not1>\n<!ENTITY unpEnt2 SYSTEM 'system-ent-id' NDATA not2>\n<!ATTLIST root ent ENTITY #REQUIRED>\n]><root ent='  unpEnt2  '/>";
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestEntityAttrRead.assertTokenType(11, sr.next());
        TestEntityAttrRead.assertTokenType(1, sr.next());
        TestEntityAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEntityAttrRead.assertEquals((String)"unpEnt2", (String)sr.getAttributeValue(0));
    }

    public void testValidEntitiesAttrUse() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root EMPTY>\n<!NOTATION not1 PUBLIC 'public-notation-id'>\n<!NOTATION not2 PUBLIC 'public-notation-id2'>\n<!NOTATION not3 PUBLIC 'public-notation-id3'>\n<!ENTITY unpEnt1 SYSTEM 'system-ent-id' NDATA not1>\n<!ENTITY unpEnt2 SYSTEM 'system-ent-id' NDATA not2>\n<!ENTITY unpEnt3 SYSTEM 'system-ent-id' NDATA not3>\n<!ATTLIST root ent ENTITIES #REQUIRED>\n]><root ent='unpEnt2\tunpEnt3   \r \nunpEnt1 '/>";
        this.streamThrough(this.getValidatingReader(XML));
        XMLStreamReader sr = this.getValidatingReader(XML);
        TestEntityAttrRead.assertTokenType(11, sr.next());
        TestEntityAttrRead.assertTokenType(1, sr.next());
        TestEntityAttrRead.assertEquals((int)1, (int)sr.getAttributeCount());
        TestEntityAttrRead.assertEquals((String)"unpEnt2 unpEnt3 unpEnt1", (String)sr.getAttributeValue(0));
    }
}

