/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.vstream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.vstream.BaseVStreamTest;

public class TestDTDElemRead
extends BaseVStreamTest {
    public TestDTDElemRead(String name) {
        super(name);
    }

    public void testValidElementDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root (node*)>\n]>\n<root />";
        this.streamThrough(this.getVReader(XML));
    }

    public void testInvalidElementDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!ELEMENT root (node*)>\n<!ELEMENT node EMPTY>\n<!ELEMENT root (node*)>\n]>\n<root />";
        try {
            this.streamThrough(this.getVReader(XML));
            TestDTDElemRead.fail((String)"Expected an exception for duplicate ELEMENT declaration.");
        }
        catch (XMLStreamException ex) {
        }
        catch (RuntimeException ex2) {
        }
        catch (Throwable t) {
            TestDTDElemRead.fail((String)("Expected an XMLStreamException or RuntimeException for duplicate ELEMENT declaration, not: " + t));
        }
    }

    public void testValidNotationDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!NOTATION not1 SYSTEM 'url:dummy'>\n<!NOTATION not2 PUBLIC 'public-id'>\n<!ELEMENT root EMPTY>\n]><root />";
        this.streamThrough(this.getVReader(XML));
    }

    public void testInvalidDupNotationDecl() throws XMLStreamException {
        String XML = "<!DOCTYPE root [\n<!NOTATION dup SYSTEM 'url:dummy'>\n<!NOTATION dup PUBLIC 'public-id'>\n<!ELEMENT root EMPTY>\n]><root />";
        try {
            this.streamThrough(this.getVReader(XML));
            TestDTDElemRead.fail((String)"Expected an exception for duplicate NOTATION declaration.");
        }
        catch (XMLStreamException ex) {
        }
        catch (RuntimeException ex2) {
        }
        catch (Throwable t) {
            TestDTDElemRead.fail((String)("Expected an XMLStreamException or RuntimeException for duplicate NOTATION declaration, not: " + t));
        }
    }

    private XMLStreamReader getVReader(String contents) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestDTDElemRead.setCoalescing(f, false);
        TestDTDElemRead.setSupportDTD(f, true);
        TestDTDElemRead.setValidating(f, true);
        return TestDTDElemRead.constructStreamReader(f, contents);
    }
}

