/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax.test.stream;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax.test.stream.BaseStreamTest;
import org.codehaus.stax.test.stream.BlockingStream;

public class TestStreaming
extends BaseStreamTest {
    public TestStreaming(String name) {
        super(name);
    }

    public void testAscii() throws XMLStreamException, UnsupportedEncodingException {
        this.testWith("US-ASCII");
    }

    public void testISOLatin() throws XMLStreamException, UnsupportedEncodingException {
        this.testWith("ISO-8859-1");
    }

    public void testUTF8() throws XMLStreamException, UnsupportedEncodingException {
        this.testWith("UTF-8");
    }

    private void testWith(String enc) throws XMLStreamException, UnsupportedEncodingException {
        BlockingStream bs = this.getStream(enc);
        XMLStreamReader sr = this.getReader(bs);
        TestStreaming.assertTokenType(1, sr.next());
        if (bs.hasBlocked()) {
            TestStreaming.fail((String)"Stream reader causes blocking before returning START_ELEMENT event that should be parsed before blocking");
        }
    }

    private BlockingStream getStream(String enc) throws XMLStreamException, UnsupportedEncodingException {
        String contents = "<?xml version='1.0' encoding='" + enc + "'?><root>Some test</root><!-- comment -->";
        byte[] data = contents.getBytes(enc);
        return new BlockingStream(new ByteArrayInputStream(data));
    }

    private XMLStreamReader getReader(BlockingStream in) throws XMLStreamException {
        XMLInputFactory f = this.getInputFactory();
        TestStreaming.setValidating(f, false);
        return f.createXMLStreamReader(in);
    }
}

